/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.HighlighterList;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectProcedure;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorGutterComponentImpl
extends EditorGutterComponentEx
implements MouseListener,
MouseMotionListener {
    private static final Logger LOG;
    private static final int START_ICON_AREA_WIDTH = 15;
    private static final int FREE_PAINTERS_AREA_WIDTH = 3;
    private static final int GAP_BETWEEN_ICONS = 3;
    private static final TooltipGroup GUTTER_TOOLTIP_GROUP;
    private final EditorImpl myEditor;
    private int myLineMarkerAreaWidth = 18;
    private int myIconsAreaWidth = 15;
    private int myLineNumberAreaWidth = 0;
    private FoldRegion myActiveFoldRegion;
    private boolean myPopupInvokedOnPressed;
    private int myTextAnnotationGuttersSize = 0;
    private TIntArrayList myTextAnnotationGutterSizes = new TIntArrayList();
    private ArrayList<TextAnnotationGutterProvider> myTextAnnotationGutters = new ArrayList();
    private final Map<TextAnnotationGutterProvider, EditorGutterAction> myProviderToListener = new HashMap();
    private static final int GAP_BETWEEN_ANNOTATIONS = 6;
    private Color myBackgroundColor = null;
    private GutterDraggableObject myGutterDraggableObject;
    private String myLastGutterTooltip = null;
    private TIntObjectHashMap<ArrayList<GutterIconRenderer>> myLineToGutterRenderers;
    private static final DataFlavor[] FLAVORS;

    public EditorGutterComponentImpl(EditorImpl editor) {
        this.myEditor = editor;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new DropTarget(this, new MyDropTargetListener());
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 3, new MyDragGestureListener());
        }
        this.setOpaque(true);
    }

    private void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.getLineNumberAreaWidth() + this.getLineMarkerAreaWidth() + this.getFoldingAreaWidth() + this.getAnnotationsAreaWidth();
        return new Dimension(w, this.myEditor.getPreferredSize().height);
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.reinitSettings();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.reinitSettings();
    }

    public void reinitSettings() {
        this.myBackgroundColor = null;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
        try {
            Rectangle clip = g.getClipBounds();
            if (clip.height < 0) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform old = g2.getTransform();
            if (this.isMirrored()) {
                AffineTransform transform = new AffineTransform(old);
                transform.scale(-1.0, 1.0);
                transform.translate(-this.getWidth(), 0.0);
                g2.setTransform(transform);
            }
            UISettings.setupAntialiasing((Graphics)g);
            this.paintLineNumbers(g, clip);
            this.paintAnnotations(g, clip);
            Object antialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            try {
                this.paintFoldingBackground(g);
                this.paintLineMarkers(g, clip);
                this.paintFoldingTree(g, clip);
            }
            finally {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
            }
            g2.setTransform(old);
        }
        finally {
            ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
        }
    }

    private void processClose(MouseEvent e) {
        IdeEventQueue queue = IdeEventQueue.getInstance();
        if (this.isLineNumbersShown() && e.getX() >= this.getLineNumberAreaOffset() && this.getLineNumberAreaOffset() + this.getLineNumberAreaWidth() >= e.getX()) {
            queue.blockNextEvents(e);
            this.myEditor.getSettings().setLineNumbersShown(false);
            e.consume();
            return;
        }
        if (this.getGutterRenderer(e) != null) {
            return;
        }
        int x = this.getAnnotationsAreaOffset();
        for (int i = 0; i < this.myTextAnnotationGutters.size(); ++i) {
            int size = this.myTextAnnotationGutterSizes.get(i);
            if (x <= e.getX() && e.getX() <= x + size + 6) {
                queue.blockNextEvents(e);
                this.closeAllAnnotations();
                e.consume();
                break;
            }
            x += size + 6;
        }
    }

    private void paintAnnotations(Graphics g, Rectangle clip) {
        this.paintBackground(g, clip, this.getAnnotationsAreaOffset(), this.getAnnotationsAreaWidth());
        int x = this.getAnnotationsAreaOffset();
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.ANNOTATIONS_COLOR);
        g.setColor(color != null ? color : Color.blue);
        g.setFont(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        for (int i = 0; i < this.myTextAnnotationGutters.size(); ++i) {
            TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(i);
            int lineHeight = this.myEditor.getLineHeight();
            int startLineNumber = clip.y / lineHeight;
            int endLineNumber = (clip.y + clip.height) / lineHeight + 1;
            int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)Math.max((int)0, (int)(this.myEditor.getDocument().getLineCount() - 1)), (int)0)).line;
            if (startLineNumber >= (endLineNumber = Math.min(endLineNumber, lastLine + 1))) {
                return;
            }
            for (int j = startLineNumber; j < endLineNumber; ++j) {
                int logLine = this.myEditor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)j, (int)0)).line;
                String s = gutterProvider.getLineText(logLine, (Editor)this.myEditor);
                EditorFontType style = gutterProvider.getStyle(logLine, (Editor)this.myEditor);
                Color bg = gutterProvider.getBgColor(logLine, (Editor)this.myEditor);
                if (bg != null) {
                    g.setColor(bg);
                    g.fillRect(x, j * lineHeight, this.getAnnotationsAreaWidth(), lineHeight);
                }
                g.setColor(this.myEditor.getColorsScheme().getColor(gutterProvider.getColor(logLine, (Editor)this.myEditor)));
                g.setFont(this.myEditor.getColorsScheme().getFont(style));
                if (s == null) continue;
                g.drawString(s, x, (j + 1) * lineHeight - this.myEditor.getDescent());
            }
            x += this.myTextAnnotationGutterSizes.get(i);
        }
    }

    private void paintFoldingTree(Graphics g, Rectangle clip) {
        if (this.isFoldingOutlineShown()) {
            this.paintFoldingTree((Graphics2D)g);
        } else {
            g.setColor(Color.white);
            int x = this.getWhitespaceSeparatorOffset() - 1;
            UIUtil.drawVDottedLine((Graphics2D)((Graphics2D)g), (int)x, (int)clip.y, (int)(clip.y + clip.height), (Color)this.myEditor.getBackroundColor(), (Color)this.getFoldingColor(false));
        }
    }

    private void paintLineMarkers(Graphics g, Rectangle clip) {
        if (this.isLineMarkersShown()) {
            this.paintBackground(g, clip, this.getLineMarkerAreaOffset(), this.getLineMarkerAreaWidth());
            this.paintGutterRenderers(g);
        }
    }

    private void paintBackground(Graphics g, Rectangle clip, int x, int width) {
        g.setColor(this.getBackground());
        g.fillRect(x, clip.y, width, clip.height);
        this.paintCaretRowBackground(g, x, width);
    }

    private void paintCaretRowBackground(Graphics g, int x, int width) {
        VisualPosition visCaret = this.myEditor.getCaretModel().getVisualPosition();
        Color caretRowColor = this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
        if (caretRowColor != null) {
            g.setColor(caretRowColor);
            Point caretPoint = this.myEditor.visualPositionToXY(visCaret);
            g.fillRect(x, caretPoint.y, width, this.myEditor.getLineHeight());
        }
    }

    private void paintLineNumbers(Graphics g, Rectangle clip) {
        if (this.isLineNumbersShown()) {
            this.paintBackground(g, clip, this.getLineNumberAreaOffset(), this.getLineNumberAreaWidth());
            g.setColor(Color.white);
            int x = this.getLineNumberAreaOffset() + this.getLineNumberAreaWidth() - 2;
            UIUtil.drawLine((Graphics)g, (int)x, (int)clip.y, (int)x, (int)(clip.y + clip.height));
            this.paintLineNumbers(g);
        }
    }

    @Override
    public Color getBackground() {
        if (this.myBackgroundColor == null) {
            LafManager lafManager;
            Color userDefinedColor = this.myEditor.getColorsScheme().getColor(EditorColors.LEFT_GUTTER_BACKGROUND);
            this.myBackgroundColor = userDefinedColor != null ? userDefinedColor : ((lafManager = LafManager.getInstance()) != null && lafManager.isUnderAquaLookAndFeel() ? new Color(0xF0F0F0) : super.getBackground());
        }
        return this.myBackgroundColor;
    }

    private void paintLineNumbers(Graphics g) {
        if (!this.isLineNumbersShown()) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        int lineHeight = this.myEditor.getLineHeight();
        int startLineNumber = clip.y / lineHeight;
        int endLineNumber = (clip.y + clip.height) / lineHeight + 1;
        int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)Math.max((int)0, (int)(this.myEditor.getDocument().getLineCount() - 1)), (int)0)).line;
        if (startLineNumber >= (endLineNumber = Math.min(endLineNumber, lastLine + 1))) {
            return;
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR);
        g.setColor(color != null ? color : Color.blue);
        g.setFont(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform old = g2.getTransform();
        if (this.isMirrored()) {
            AffineTransform originalTransform = new AffineTransform(old);
            originalTransform.scale(-1.0, 1.0);
            originalTransform.translate(-this.getLineNumberAreaWidth() + 2, 0.0);
            g2.setTransform(originalTransform);
        }
        for (int i = startLineNumber; i < endLineNumber; ++i) {
            int logLine = this.myEditor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)i, (int)0)).line;
            String s = String.valueOf(logLine + 1);
            g.drawString(s, this.getLineNumberAreaOffset() + this.getLineNumberAreaWidth() - this.myEditor.getFontMetrics(0).stringWidth(s) - 4, (i + 1) * lineHeight - this.myEditor.getDescent());
        }
        g2.setTransform(old);
    }

    private void processRangeHighlighters(RangeHighlighterProcessor p, int startOffset, int endOffset) {
        MarkupModelEx docMarkup = (MarkupModelEx)this.myEditor.getDocument().getMarkupModel(this.myEditor.getProject());
        HighlighterList docList = docMarkup.getHighlighterList();
        Iterator<RangeHighlighterImpl> docHighlighters = docList != null ? docList.getHighlighterIterator() : null;
        MarkupModelEx editorMarkup = (MarkupModelEx)this.myEditor.getMarkupModel();
        HighlighterList editorList = editorMarkup.getHighlighterList();
        Iterator<RangeHighlighterImpl> editorHighlighters = editorList != null ? editorList.getHighlighterIterator() : null;
        RangeHighlighterImpl lastDocHighlighter = null;
        RangeHighlighterImpl lastEditorHighlighter = null;
        while (true) {
            int endLineIndex;
            int startLineIndex;
            RangeHighlighterImpl lowerHighlighter;
            if (lastDocHighlighter == null && docHighlighters != null && docHighlighters.hasNext()) {
                lastDocHighlighter = docHighlighters.next();
                if (!lastDocHighlighter.isValid() || lastDocHighlighter.getAffectedAreaStartOffset() > endOffset) {
                    lastDocHighlighter = null;
                    continue;
                }
                if (lastDocHighlighter.getAffectedAreaEndOffset() < startOffset) {
                    lastDocHighlighter = null;
                    continue;
                }
            }
            if (lastEditorHighlighter == null && editorHighlighters != null && editorHighlighters.hasNext()) {
                lastEditorHighlighter = editorHighlighters.next();
                if (!lastEditorHighlighter.isValid() || lastEditorHighlighter.getAffectedAreaStartOffset() > endOffset) {
                    lastEditorHighlighter = null;
                    continue;
                }
                if (lastEditorHighlighter.getAffectedAreaEndOffset() < startOffset) {
                    lastEditorHighlighter = null;
                    continue;
                }
            }
            if (lastDocHighlighter == null && lastEditorHighlighter == null) {
                return;
            }
            if (EditorGutterComponentImpl.less(lastDocHighlighter, lastEditorHighlighter)) {
                lowerHighlighter = lastDocHighlighter;
                lastDocHighlighter = null;
            } else {
                lowerHighlighter = lastEditorHighlighter;
                lastEditorHighlighter = null;
            }
            assert (lowerHighlighter != null);
            if (!lowerHighlighter.isValid() || (startLineIndex = lowerHighlighter.getDocument().getLineNumber(startOffset)) < 0 || startLineIndex >= this.myEditor.getDocument().getLineCount() || (endLineIndex = lowerHighlighter.getDocument().getLineNumber(endOffset)) < 0 || endLineIndex >= this.myEditor.getDocument().getLineCount() || !lowerHighlighter.getEditorFilter().avaliableIn((Editor)this.myEditor)) continue;
            p.process(lowerHighlighter);
        }
    }

    private static boolean less(RangeHighlighter h1, RangeHighlighter h2) {
        return h1 != null && (h2 == null || h1.getStartOffset() < h2.getStartOffset());
    }

    @Override
    public void revalidateMarkup() {
        this.updateSize();
    }

    public void updateSize() {
        int oldIconsWidth = this.myLineMarkerAreaWidth;
        int oldAnnotationsWidth = this.myTextAnnotationGuttersSize;
        this.calcIconAreaWidth();
        this.calcAnnotationsSize();
        if (oldIconsWidth != this.myLineMarkerAreaWidth || oldAnnotationsWidth != this.myTextAnnotationGuttersSize) {
            this.fireResized();
        }
        this.repaint();
    }

    private void calcAnnotationsSize() {
        this.myTextAnnotationGuttersSize = 0;
        FontMetrics fontMetrics = this.myEditor.getFontMetrics(0);
        int lineCount = this.myEditor.getDocument().getLineCount();
        for (int j = 0; j < this.myTextAnnotationGutters.size(); ++j) {
            TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(j);
            int gutterSize = 0;
            for (int i = 0; i < lineCount; ++i) {
                String lineText = gutterProvider.getLineText(i, (Editor)this.myEditor);
                if (lineText == null) continue;
                gutterSize = Math.max(gutterSize, fontMetrics.stringWidth(lineText));
            }
            if (gutterSize > 0) {
                gutterSize += 6;
            }
            this.myTextAnnotationGutterSizes.set(j, gutterSize);
            this.myTextAnnotationGuttersSize += gutterSize;
        }
    }

    private void calcIconAreaWidth() {
        this.myLineToGutterRenderers = new TIntObjectHashMap();
        this.processRangeHighlighters(new RangeHighlighterProcessor(){

            @Override
            public void process(RangeHighlighter highlighter) {
                GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
                if (renderer == null || !highlighter.getEditorFilter().avaliableIn((Editor)EditorGutterComponentImpl.this.myEditor)) {
                    return;
                }
                int startOffset = highlighter.getStartOffset();
                int line = EditorGutterComponentImpl.this.myEditor.getDocument().getLineNumber(startOffset);
                ArrayList<GutterIconRenderer> renderers = (ArrayList<GutterIconRenderer>)EditorGutterComponentImpl.this.myLineToGutterRenderers.get(line);
                if (renderers == null) {
                    renderers = new ArrayList<GutterIconRenderer>();
                    EditorGutterComponentImpl.this.myLineToGutterRenderers.put(line, renderers);
                }
                if (renderers.size() < 5) {
                    renderers.add(renderer);
                }
            }
        }, 0, this.myEditor.getDocument().getTextLength());
        this.myIconsAreaWidth = 15;
        this.myLineToGutterRenderers.forEachValue((TObjectProcedure)new TObjectProcedure<ArrayList<GutterIconRenderer>>(){

            public boolean execute(ArrayList<GutterIconRenderer> renderers) {
                int width = 1;
                for (int i = 0; i < renderers.size(); ++i) {
                    GutterIconRenderer renderer = renderers.get(i);
                    width += renderer.getIcon().getIconWidth();
                    if (i <= 0) continue;
                    width += 3;
                }
                if (EditorGutterComponentImpl.this.myIconsAreaWidth < width) {
                    EditorGutterComponentImpl.this.myIconsAreaWidth = width;
                }
                return true;
            }
        });
        this.myLineMarkerAreaWidth = this.myIconsAreaWidth + 3 + (this.isFoldingOutlineShown() ? 0 : this.getFoldingAnchorWidth() / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintGutterRenderers(final Graphics g) {
        Rectangle clip = g.getClipBounds();
        int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
        int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
        Graphics2D g2 = (Graphics2D)g;
        Object antialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            this.processRangeHighlighters(new RangeHighlighterProcessor(){

                @Override
                public void process(RangeHighlighter highlighter) {
                    EditorGutterComponentImpl.this.paintLineMarkerRenderer(highlighter, g);
                }
            }, firstVisibleOffset, lastVisibleOffset);
        }
        finally {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        }
        int firstVisibleLine = this.myEditor.getDocument().getLineNumber(firstVisibleOffset);
        int lastVisibleLine = this.myEditor.getDocument().getLineNumber(lastVisibleOffset);
        this.paintIcons(firstVisibleLine, lastVisibleLine, g);
    }

    private void paintIcons(final int firstVisibleLine, final int lastVisibleLine, final Graphics g) {
        this.myLineToGutterRenderers.forEachKey(new TIntProcedure(){

            public boolean execute(int line) {
                if (firstVisibleLine > line || lastVisibleLine < line) {
                    return true;
                }
                if (EditorGutterComponentImpl.this.isLineCollapsed(line)) {
                    return true;
                }
                ArrayList renderers = (ArrayList)EditorGutterComponentImpl.this.myLineToGutterRenderers.get(line);
                EditorGutterComponentImpl.this.paintIconRow(line, renderers, g);
                return true;
            }
        });
    }

    private boolean isLineCollapsed(int line) {
        int startOffset = this.myEditor.getDocument().getLineStartOffset(line);
        FoldRegion region = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        return region != null && region.getEndOffset() >= this.myEditor.getDocument().getLineEndOffset(line);
    }

    private void paintIconRow(int line, ArrayList<GutterIconRenderer> row, final Graphics g) {
        this.processIconsRow(line, row, new LineGutterIconRendererProcessor(){

            @Override
            public void process(int x, int y, GutterIconRenderer renderer) {
                renderer.getIcon().paintIcon(EditorGutterComponentImpl.this, g, x, y);
            }
        });
    }

    private void paintLineMarkerRenderer(RangeHighlighter highlighter, Graphics g) {
        Rectangle rect = this.getLineRendererRect(highlighter);
        if (rect != null) {
            LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
            assert (lineMarkerRenderer != null);
            lineMarkerRenderer.paint((Editor)this.myEditor, g, rect);
        }
    }

    private Rectangle getLineRendererRect(RangeHighlighter highlighter) {
        LineMarkerRenderer renderer = highlighter.getLineMarkerRenderer();
        if (renderer == null) {
            return null;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(startOffset) && this.myEditor.getFoldingModel().isOffsetCollapsed(endOffset)) {
            return null;
        }
        int startY = this.myEditor.visualPositionToXY((VisualPosition)this.myEditor.offsetToVisualPosition((int)startOffset)).y;
        int endY = this.myEditor.visualPositionToXY((VisualPosition)this.myEditor.offsetToVisualPosition((int)endOffset)).y;
        int height = endY - startY;
        int w = 3;
        int x = this.getLineMarkerAreaOffset() + this.myIconsAreaWidth;
        return new Rectangle(x, startY, w, height);
    }

    private void processIconsRow(int line, ArrayList<GutterIconRenderer> row, LineGutterIconRendererProcessor processor) {
        Icon icon;
        int middleCount = 0;
        int middleSize = 0;
        int x = this.getLineMarkerAreaOffset() + 1;
        int y = this.myEditor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
        for (GutterIconRenderer r : row) {
            GutterIconRenderer.Alignment alignment = r.getAlignment();
            icon = r.getIcon();
            if (alignment == GutterIconRenderer.Alignment.LEFT) {
                processor.process(x, y + this.getTextAlignmentShift(icon), r);
                x += icon.getIconWidth() + 3;
                continue;
            }
            if (alignment != GutterIconRenderer.Alignment.CENTER) continue;
            ++middleCount;
            middleSize += icon.getIconWidth() + 3;
        }
        int leftSize = x - this.getLineMarkerAreaOffset();
        x = this.getLineMarkerAreaOffset() + this.myIconsAreaWidth;
        for (GutterIconRenderer r : row) {
            if (r.getAlignment() != GutterIconRenderer.Alignment.RIGHT) continue;
            icon = r.getIcon();
            processor.process(x -= icon.getIconWidth(), y + this.getTextAlignmentShift(icon), r);
            x -= 3;
        }
        int rightSize = this.myIconsAreaWidth + this.getLineMarkerAreaOffset() - x;
        if (middleCount > 0) {
            x = this.getLineMarkerAreaOffset() + leftSize + (this.myIconsAreaWidth - leftSize - rightSize - (middleSize -= 3)) / 2;
            for (GutterIconRenderer r : row) {
                if (r.getAlignment() != GutterIconRenderer.Alignment.CENTER) continue;
                Icon icon2 = r.getIcon();
                processor.process(x, y + this.getTextAlignmentShift(icon2), r);
                x += icon2.getIconWidth() + 3;
            }
        }
    }

    private int getTextAlignmentShift(Icon icon) {
        return (this.myEditor.getLineHeight() - icon.getIconHeight()) / 2;
    }

    @Override
    public Color getFoldingColor(boolean isActive) {
        ColorKey key = isActive ? EditorColors.SELECTED_FOLDING_TREE_COLOR : EditorColors.FOLDING_TREE_COLOR;
        Color color = this.myEditor.getColorsScheme().getColor(key);
        return color != null ? color : Color.black;
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorGutterComponentImpl.registerTextAnnotation must not be null");
        }
        this.myTextAnnotationGutters.add(provider);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider, @NotNull EditorGutterAction action) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorGutterComponentImpl.registerTextAnnotation must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorGutterComponentImpl.registerTextAnnotation must not be null");
        }
        this.myTextAnnotationGutters.add(provider);
        this.myProviderToListener.put(provider, action);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    private VisualPosition offsetToLineStartPosition(int offset) {
        int line = this.myEditor.getDocument().getLineNumber(offset);
        return this.myEditor.logicalToVisualPosition(new LogicalPosition(line, 0));
    }

    private void paintFoldingTree(Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        int anchorX = this.getFoldingAreaOffset();
        int width = this.getFoldingAnchorWidth();
        FoldRegion[] visibleFoldRegions = ((FoldingModelImpl)this.myEditor.getFoldingModel()).fetchVisible();
        int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
        int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
        for (FoldRegion visibleFoldRegion : visibleFoldRegions) {
            if (!visibleFoldRegion.isValid() || visibleFoldRegion.getStartOffset() > lastVisibleOffset || this.getEndOffset(visibleFoldRegion) < firstVisibleOffset) continue;
            this.drawAnchor(visibleFoldRegion, width, clip, g, anchorX, false, false);
        }
        if (this.myActiveFoldRegion != null) {
            this.drawAnchor(this.myActiveFoldRegion, width, clip, g, anchorX, true, true);
            this.drawAnchor(this.myActiveFoldRegion, width, clip, g, anchorX, true, false);
        }
    }

    private void paintFoldingBackground(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int lineX = this.getWhitespaceSeparatorOffset();
        this.paintBackground(g, clip, this.getFoldingAreaOffset(), this.getFoldingAreaWidth());
        g.setColor(this.myEditor.getBackroundColor());
        g.fillRect(lineX, clip.y, this.getFoldingAreaWidth(), clip.height);
        this.paintCaretRowBackground(g, lineX, this.getFoldingAnchorWidth());
        this.paintFoldingBoxBacgrounds((Graphics2D)g);
    }

    private void paintFoldingBoxBacgrounds(Graphics2D g) {
        if (!this.isFoldingOutlineShown()) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        UIUtil.drawVDottedLine((Graphics2D)g, (int)this.getWhitespaceSeparatorOffset(), (int)clip.y, (int)(clip.y + clip.height), (Color)this.myEditor.getBackroundColor(), (Color)this.getFoldingColor(false));
        int anchorX = this.getFoldingAreaOffset();
        int width = this.getFoldingAnchorWidth();
        FoldRegion[] visibleFoldRegions = ((FoldingModelImpl)this.myEditor.getFoldingModel()).fetchVisible();
        int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
        int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
        if (this.myActiveFoldRegion != null) {
            this.drawFoldingLines(this.myActiveFoldRegion, clip, width, anchorX, g);
        }
        for (FoldRegion visibleFoldRegion : visibleFoldRegions) {
            if (!visibleFoldRegion.isValid() || visibleFoldRegion.getStartOffset() > lastVisibleOffset || this.getEndOffset(visibleFoldRegion) < firstVisibleOffset) continue;
            this.drawAnchor(visibleFoldRegion, width, clip, g, anchorX, false, true);
        }
    }

    @Override
    public int getWhitespaceSeparatorOffset() {
        return this.getFoldingAreaOffset() + this.getFoldingAnchorWidth() / 2;
    }

    public void setActiveFoldRegion(FoldRegion activeFoldRegion) {
        if (this.myActiveFoldRegion != activeFoldRegion) {
            this.myActiveFoldRegion = activeFoldRegion;
            this.repaint();
        }
    }

    public int getHeadCenterY(FoldRegion foldRange) {
        int width = this.getFoldingAnchorWidth();
        VisualPosition foldStart = this.offsetToLineStartPosition(foldRange.getStartOffset());
        return this.myEditor.visibleLineNumberToYPosition(foldStart.line) + this.myEditor.getLineHeight() - this.myEditor.getDescent() - width / 2;
    }

    private void drawAnchor(FoldRegion foldRange, int width, Rectangle clip, Graphics2D g, int anchorX, boolean active, boolean paintBackground) {
        boolean drawTop;
        if (!foldRange.isValid()) {
            return;
        }
        VisualPosition foldStart = this.offsetToLineStartPosition(foldRange.getStartOffset());
        int endOffset = this.getEndOffset(foldRange);
        VisualPosition foldEnd = this.offsetToLineStartPosition(endOffset);
        Document document = this.myEditor.getDocument();
        if (document.getLineNumber(foldRange.getStartOffset()) == document.getLineNumber(endOffset)) {
            return;
        }
        int y = this.myEditor.visibleLineNumberToYPosition(foldStart.line) + this.myEditor.getLineHeight() - this.myEditor.getDescent() - width;
        int height = width + 2;
        FoldingGroup group = foldRange.getGroup();
        boolean bl = drawTop = group == null || ((FoldingModelImpl)this.myEditor.getFoldingModel()).getFirstRegion(group) == foldRange;
        if (!foldRange.isExpanded()) {
            if (y <= clip.y + clip.height && y + height >= clip.y && drawTop) {
                this.drawSquareWithPlus(g, anchorX, y, width, active, paintBackground);
            }
        } else {
            int endY = this.myEditor.visibleLineNumberToYPosition(foldEnd.line) + this.myEditor.getLineHeight() - this.myEditor.getDescent();
            if (y <= clip.y + clip.height && y + height >= clip.y && drawTop) {
                this.drawDirectedBox(g, anchorX, y, width, height, width - 2, active, paintBackground);
            }
            if (endY - height <= clip.y + clip.height && endY >= clip.y) {
                this.drawDirectedBox(g, anchorX, endY, width, -height, -width + 2, active, paintBackground);
            }
        }
    }

    private int getEndOffset(FoldRegion foldRange) {
        LOG.assertTrue(foldRange.isValid(), (Object)foldRange);
        FoldingGroup group = foldRange.getGroup();
        return group == null ? foldRange.getEndOffset() : ((FoldingModelImpl)this.myEditor.getFoldingModel()).getEndOffset(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawDirectedBox(Graphics2D g, int anchorX, int y, int width, int height, int baseHeight, boolean active, boolean paintBackground) {
        Object antialiasing = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (SystemInfo.isMac && SystemInfo.JAVA_VERSION.startsWith("1.4.1")) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        try {
            int[] xPoints = new int[]{anchorX, anchorX + width, anchorX + width, anchorX + width / 2, anchorX};
            int[] yPoints = new int[]{y, y, y + baseHeight, y + height, y + baseHeight};
            if (paintBackground) {
                g.setColor(this.myEditor.getBackroundColor());
                g.fillPolygon(xPoints, yPoints, 5);
            } else {
                g.setColor(this.getFoldingColor(active));
                g.drawPolygon(xPoints, yPoints, 5);
                int minusHeight = y + baseHeight / 2 + (height - baseHeight) / 4;
                UIUtil.drawLine((Graphics)g, (int)(anchorX + 2), (int)minusHeight, (int)(anchorX + width - 2), (int)minusHeight);
            }
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        }
    }

    private void drawSquareWithPlus(Graphics2D g, int anchorX, int y, int width, boolean active, boolean paintBackground) {
        this.drawSquareWithMinus(g, anchorX, y, width, active, paintBackground);
        UIUtil.drawLine((Graphics)g, (int)(anchorX + width / 2), (int)(y + 2), (int)(anchorX + width / 2), (int)(y + width - 2));
    }

    private void drawSquareWithMinus(Graphics2D g, int anchorX, int y, int width, boolean active, boolean paintBackground) {
        if (paintBackground) {
            g.setColor(this.myEditor.getBackroundColor());
            g.fillRect(anchorX, y, width, width);
        } else {
            g.setColor(this.getFoldingColor(active));
            g.drawRect(anchorX, y, width, width);
            if (!active) {
                g.setColor(this.getFoldingColor(true));
            }
            UIUtil.drawLine((Graphics)g, (int)(anchorX + 2), (int)(y + width / 2), (int)(anchorX + width - 2), (int)(y + width / 2));
        }
    }

    private void drawFoldingLines(FoldRegion foldRange, Rectangle clip, int width, int anchorX, Graphics2D g) {
        if (foldRange.isExpanded() && foldRange.isValid()) {
            VisualPosition foldStart = this.offsetToLineStartPosition(foldRange.getStartOffset());
            VisualPosition foldEnd = this.offsetToLineStartPosition(this.getEndOffset(foldRange));
            int startY = this.myEditor.visibleLineNumberToYPosition(foldStart.line + 1) - this.myEditor.getDescent();
            int endY = this.myEditor.visibleLineNumberToYPosition(foldEnd.line) + this.myEditor.getLineHeight() - this.myEditor.getDescent();
            if (startY > clip.y + clip.height || endY + 1 + this.myEditor.getDescent() < clip.y) {
                return;
            }
            int lineX = anchorX + width / 2;
            g.setColor(this.getFoldingColor(true));
            UIUtil.drawLine((Graphics)g, (int)lineX, (int)startY, (int)lineX, (int)endY);
        }
    }

    private int getFoldingAnchorWidth() {
        return Math.min(4, this.myEditor.getLineHeight() / 2 - 2) * 2;
    }

    public int getFoldingAreaOffset() {
        return this.getLineMarkerAreaOffset() + this.getLineMarkerAreaWidth();
    }

    public int getFoldingAreaWidth() {
        return this.isFoldingOutlineShown() ? this.getFoldingAnchorWidth() + 2 : (this.isLineNumbersShown() ? this.getFoldingAnchorWidth() / 2 : 0);
    }

    @Override
    public boolean isLineMarkersShown() {
        return this.myEditor.getSettings().isLineMarkerAreaShown();
    }

    public boolean isLineNumbersShown() {
        return this.myEditor.getSettings().isLineNumbersShown();
    }

    @Override
    public boolean isFoldingOutlineShown() {
        return this.myEditor.getSettings().isFoldingOutlineShown() && ((FoldingModelEx)this.myEditor.getFoldingModel()).isFoldingEnabled();
    }

    public int getLineNumberAreaWidth() {
        return this.isLineNumbersShown() ? this.myLineNumberAreaWidth : 0;
    }

    public int getLineMarkerAreaWidth() {
        return this.isLineMarkersShown() ? this.myLineMarkerAreaWidth : 0;
    }

    public void setLineNumberAreaWidth(int lineNumberAriaWidth) {
        if (this.myLineNumberAreaWidth != lineNumberAriaWidth) {
            this.myLineNumberAreaWidth = lineNumberAriaWidth;
            this.fireResized();
        }
    }

    public int getLineNumberAreaOffset() {
        return 0;
    }

    public int getAnnotationsAreaOffset() {
        return this.getLineNumberAreaOffset() + this.getLineNumberAreaWidth();
    }

    public int getAnnotationsAreaWidth() {
        return this.myTextAnnotationGuttersSize;
    }

    @Override
    public int getLineMarkerAreaOffset() {
        return this.getAnnotationsAreaOffset() + this.getAnnotationsAreaWidth();
    }

    @Override
    public int getIconsAreaWidth() {
        return this.myIconsAreaWidth;
    }

    private boolean isMirrored() {
        return this.myEditor.getVerticalScrollbarOrientation() != 1;
    }

    @Override
    public FoldRegion findFoldingAnchorAt(int x, int y) {
        FoldRegion[] visibleRanges;
        if (!this.myEditor.getSettings().isFoldingOutlineShown()) {
            return null;
        }
        int anchorX = this.getFoldingAreaOffset();
        int anchorWidth = this.getFoldingAnchorWidth();
        for (FoldRegion foldRange : visibleRanges = ((FoldingModelImpl)this.myEditor.getFoldingModel()).fetchVisible()) {
            FoldingGroup group;
            if (!foldRange.isValid() || (group = foldRange.getGroup()) != null && ((FoldingModelImpl)this.myEditor.getFoldingModel()).getFirstRegion(group) != foldRange) continue;
            VisualPosition foldStart = this.offsetToLineStartPosition(foldRange.getStartOffset());
            int endOffset = this.getEndOffset(foldRange);
            VisualPosition foldEnd = this.offsetToLineStartPosition(endOffset);
            Document document = this.myEditor.getDocument();
            if (document.getLineNumber(foldRange.getStartOffset()) == document.getLineNumber(endOffset)) continue;
            if (this.rectByFoldOffset(foldStart, anchorWidth, anchorX).contains(x, y)) {
                return foldRange;
            }
            if (group != null && !foldRange.isExpanded() || !this.rectByFoldOffset(foldEnd, anchorWidth, anchorX).contains(x, y)) continue;
            return foldRange;
        }
        return null;
    }

    private Rectangle rectByFoldOffset(VisualPosition foldStart, int anchorWidth, int anchorX) {
        int anchorY = this.myEditor.visibleLineNumberToYPosition(foldStart.line) + this.myEditor.getLineHeight() - this.myEditor.getDescent() - anchorWidth;
        return new Rectangle(anchorX, anchorY, anchorWidth, anchorWidth);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TooltipController.getInstance().cancelTooltips();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        String tooltip = null;
        GutterIconRenderer renderer = this.getGutterRenderer(e);
        TooltipController controller = TooltipController.getInstance();
        if (renderer != null) {
            tooltip = renderer.getTooltipText();
            if (renderer.isNavigateAction()) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                TextAnnotationGutterProvider provider = this.getProviderAtPoint(e.getPoint());
                if (provider != null) {
                    EditorGutterAction action;
                    int line = this.getLineNumAtPoint(e.getPoint());
                    tooltip = provider.getToolTip(line, (Editor)this.myEditor);
                    if (!Comparing.equal((String)tooltip, (String)this.myLastGutterTooltip)) {
                        controller.cancelTooltip(GUTTER_TOOLTIP_GROUP);
                        this.myLastGutterTooltip = tooltip;
                    }
                    if (this.myProviderToListener.containsKey(provider) && (action = this.myProviderToListener.get(provider)) != null) {
                        this.setCursor(action.getCursor(line));
                    }
                }
            }
        }
        if (tooltip != null && tooltip.length() != 0) {
            controller.showTooltipByMouseMove(this.myEditor, e, ((EditorMarkupModel)this.myEditor.getMarkupModel()).getErrorStripTooltipRendererProvider().calcTooltipRenderer(tooltip), false, GUTTER_TOOLTIP_GROUP);
        } else {
            controller.cancelTooltip(GUTTER_TOOLTIP_GROUP);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
        }
    }

    private void fireEventToTextAnnotationListeners(MouseEvent e) {
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            int line;
            Point clickPoint = e.getPoint();
            TextAnnotationGutterProvider provider = this.getProviderAtPoint(clickPoint);
            if (provider == null) {
                return;
            }
            if (this.myProviderToListener.containsKey(provider) && (line = this.getLineNumAtPoint(clickPoint)) >= 0 && UIUtil.isActionClick((MouseEvent)e, (int)502)) {
                this.myProviderToListener.get(provider).doAction(line);
            }
        }
    }

    private int getLineNumAtPoint(Point clickPoint) {
        return this.myEditor.xyToLogicalPosition((Point)new Point((int)0, (int)clickPoint.y)).line;
    }

    private TextAnnotationGutterProvider getProviderAtPoint(Point clickPoint) {
        int current = this.getAnnotationsAreaOffset();
        if (clickPoint.x < current) {
            return null;
        }
        for (int i = 0; i < this.myTextAnnotationGutterSizes.size(); ++i) {
            if (clickPoint.x > (current += this.myTextAnnotationGutterSizes.get(i))) continue;
            return this.myTextAnnotationGutters.get(i);
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
            this.myPopupInvokedOnPressed = true;
        } else if (UIUtil.isCloseClick((MouseEvent)e)) {
            this.processClose(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
            return;
        }
        if (this.myPopupInvokedOnPressed) {
            this.myPopupInvokedOnPressed = false;
            return;
        }
        GutterIconRenderer renderer = this.getGutterRenderer(e);
        AnAction clickAction = null;
        if (renderer != null) {
            AnAction anAction = clickAction = (8 & e.getModifiers()) > 0 ? renderer.getMiddleButtonClickAction() : renderer.getClickAction();
        }
        if (clickAction != null) {
            clickAction.actionPerformed(new AnActionEvent((InputEvent)e, this.myEditor.getDataContext(), "ICON_NAVIGATION", clickAction.getTemplatePresentation(), ActionManager.getInstance(), e.getModifiers()));
            e.consume();
            this.repaint();
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                lineRenderer.doAction((Editor)this.myEditor, e);
            } else {
                this.fireEventToTextAnnotationListeners(e);
            }
        }
    }

    private ActiveGutterRenderer getActiveRendererByMouseEvent(final MouseEvent e) {
        final ActiveGutterRenderer[] gutterRenderer = new ActiveGutterRenderer[]{null};
        if (this.findFoldingAnchorAt(e.getX(), e.getY()) == null && !e.isConsumed() && e.getX() <= this.getWhitespaceSeparatorOffset()) {
            Rectangle clip = this.myEditor.getScrollingModel().getVisibleArea();
            int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
            int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
            this.processRangeHighlighters(new RangeHighlighterProcessor(){

                @Override
                public void process(RangeHighlighter highlighter) {
                    LineMarkerRenderer renderer;
                    if (gutterRenderer[0] != null) {
                        return;
                    }
                    Rectangle rect = EditorGutterComponentImpl.this.getLineRendererRect(highlighter);
                    if (rect == null) {
                        return;
                    }
                    int startY = rect.y;
                    int endY = startY + rect.height;
                    if (startY == endY) {
                        endY += EditorGutterComponentImpl.this.myEditor.getLineHeight();
                    }
                    if (startY < e.getY() && e.getY() <= endY && (renderer = highlighter.getLineMarkerRenderer()) instanceof ActiveGutterRenderer && ((ActiveGutterRenderer)renderer).canDoAction(e)) {
                        gutterRenderer[0] = (ActiveGutterRenderer)renderer;
                    }
                }
            }, firstVisibleOffset, lastVisibleOffset);
        }
        return gutterRenderer[0];
    }

    public void closeAllAnnotations() {
        for (TextAnnotationGutterProvider provider : this.myTextAnnotationGutters) {
            provider.gutterClosed();
        }
        this.revalidateSizes();
    }

    private void revalidateSizes() {
        this.myTextAnnotationGutters = new ArrayList();
        this.myTextAnnotationGutterSizes = new TIntArrayList();
        this.updateSize();
    }

    private void invokePopup(MouseEvent e) {
        ActionManager actionManager = ActionManager.getInstance();
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            DefaultActionGroup actionGroup = new DefaultActionGroup(EditorBundle.message((String)"editor.annotations.action.group.name", (Object[])new Object[0]), true);
            actionGroup.add((AnAction)new CloseAnnotationsAction());
            ArrayList<AnAction> addActions = new ArrayList<AnAction>();
            for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
                List list = gutterProvider.getPopupActions((Editor)this.myEditor);
                if (list == null) continue;
                for (AnAction action : list) {
                    if (addActions.contains(action)) continue;
                    addActions.add(action);
                }
            }
            for (AnAction addAction : addActions) {
                actionGroup.add(addAction);
            }
            JPopupMenu menu = actionManager.createActionPopupMenu("", (ActionGroup)actionGroup).getComponent();
            menu.show(this, e.getX(), e.getY());
        } else {
            GutterIconRenderer renderer = this.getGutterRenderer(e);
            if (renderer != null) {
                ActionGroup actionGroup = renderer.getPopupMenuActions();
                if (actionGroup != null) {
                    ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", actionGroup);
                    popupMenu.getComponent().show(this, e.getX(), e.getY());
                    e.consume();
                }
            } else {
                ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", (ActionGroup)actionManager.getAction("EditorGutterPopupMenu"));
                popupMenu.getComponent().show(this, e.getX(), e.getY());
                e.consume();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        TooltipController.getInstance().cancelTooltip(GUTTER_TOOLTIP_GROUP);
    }

    @Nullable
    private GutterIconRenderer getGutterRenderer(final Point p) {
        final int ex = this.convertX((int)p.getX());
        int line = this.myEditor.xyToLogicalPosition((Point)new Point((int)0, (int)((int)p.getY()))).line;
        if (line >= this.myEditor.getDocument().getLineCount()) {
            return null;
        }
        int startOffset = this.myEditor.getDocument().getLineStartOffset(line);
        FoldRegion region = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (region != null && (line = this.myEditor.getDocument().getLineNumber(region.getEndOffset())) >= this.myEditor.getDocument().getLineCount()) {
            return null;
        }
        ArrayList renderers = (ArrayList)this.myLineToGutterRenderers.get(line);
        if (renderers == null) {
            return null;
        }
        final GutterIconRenderer[] result = new GutterIconRenderer[]{null};
        this.processIconsRow(line, renderers, new LineGutterIconRendererProcessor(){

            @Override
            public void process(int x, int y, GutterIconRenderer renderer) {
                Icon icon = renderer.getIcon();
                if (x <= ex && ex <= x + icon.getIconWidth() && (double)y <= p.getY() && p.getY() <= (double)(y + icon.getIconHeight())) {
                    result[0] = renderer;
                }
            }
        });
        return result[0];
    }

    @Nullable
    private GutterIconRenderer getGutterRenderer(MouseEvent e) {
        return this.getGutterRenderer(e.getPoint());
    }

    public int convertX(int x) {
        if (!this.isMirrored()) {
            return x;
        }
        return this.getWidth() - x;
    }

    public void dispose() {
        for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
            gutterProvider.gutterClosed();
        }
        this.myProviderToListener.clear();
    }

    static {
        DataFlavor[] flavors;
        LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorGutterComponentImpl");
        GUTTER_TOOLTIP_GROUP = new TooltipGroup("GUTTER_TOOLTIP_GROUP", 0);
        try {
            Class<EditorGutterComponentImpl> aClass = EditorGutterComponentImpl.class;
            flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=" + aClass.getName(), "GutterTransferable", aClass.getClassLoader())};
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
            flavors = new DataFlavor[]{};
        }
        FLAVORS = flavors;
    }

    private class MyDropTargetListener
    extends DropTargetAdapter {
        private MyDropTargetListener() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            int dropAction;
            if (EditorGutterComponentImpl.this.myGutterDraggableObject != null && ((dropAction = dtde.getDropAction()) & 2) != 0) {
                int line = ((EditorGutterComponentImpl)EditorGutterComponentImpl.this).myEditor.xyToLogicalPosition((Point)new Point((int)0, (int)((int)dtde.getLocation().getY()))).line;
                dtde.dropComplete(EditorGutterComponentImpl.this.myGutterDraggableObject.copy(line));
                return;
            }
            dtde.rejectDrop();
        }
    }

    private class MyDragSourceListener
    extends DragSourceAdapter {
        private MyDragSourceListener() {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            this.updateCursor(dsde);
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
            this.updateCursor(dsde);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            dsde.getDragSourceContext().setCursor(null);
        }

        private void updateCursor(DragSourceDragEvent dsde) {
            DragSourceContext context = dsde.getDragSourceContext();
            Point screenPoint = dsde.getLocation();
            if (screenPoint != null) {
                Point gutterPoint = new Point(screenPoint);
                SwingUtilities.convertPointFromScreen(gutterPoint, EditorGutterComponentImpl.this);
                if (EditorGutterComponentImpl.this.contains(gutterPoint)) {
                    Point editorPoint = new Point(screenPoint);
                    SwingUtilities.convertPointFromScreen(editorPoint, EditorGutterComponentImpl.this.myEditor.getContentComponent());
                    int line = ((EditorGutterComponentImpl)EditorGutterComponentImpl.this).myEditor.xyToLogicalPosition((Point)new Point((int)0, (int)((int)editorPoint.getY()))).line;
                    Cursor cursor = EditorGutterComponentImpl.this.myGutterDraggableObject.getCursor(line);
                    context.setCursor(cursor);
                    return;
                }
            }
            context.setCursor(null);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!dsde.getDropSuccess()) {
                return;
            }
            if (dsde.getDropAction() == 2) {
                EditorGutterComponentImpl.this.myGutterDraggableObject.removeSelf();
            }
        }
    }

    private class MyDragGestureListener
    implements DragGestureListener {
        private MyDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            GutterDraggableObject draggableObject;
            if ((dge.getDragAction() & 2) == 0) {
                return;
            }
            GutterIconRenderer renderer = EditorGutterComponentImpl.this.getGutterRenderer(dge.getDragOrigin());
            if (renderer != null && (draggableObject = renderer.getDraggableObject()) != null) {
                try {
                    EditorGutterComponentImpl.this.myGutterDraggableObject = draggableObject;
                    MyDragSourceListener dragSourceListener = new MyDragSourceListener();
                    dge.startDrag(DragSource.DefaultMoveNoDrop, new Transferable(){

                        @Override
                        public DataFlavor[] getTransferDataFlavors() {
                            return FLAVORS;
                        }

                        @Override
                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            DataFlavor[] flavors;
                            for (DataFlavor flavor1 : flavors = this.getTransferDataFlavors()) {
                                if (!flavor.equals(flavor1)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public Object getTransferData(DataFlavor flavor) {
                            return null;
                        }
                    }, dragSourceListener);
                }
                catch (InvalidDnDOperationException idoe) {
                    // empty catch block
                }
            }
        }
    }

    private class CloseAnnotationsAction
    extends AnAction {
        public CloseAnnotationsAction() {
            super(EditorBundle.message((String)"close.editor.annotations.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            EditorGutterComponentImpl.this.closeAllAnnotations();
        }
    }

    private static interface LineGutterIconRendererProcessor {
        public void process(int var1, int var2, GutterIconRenderer var3);
    }

    private static interface RangeHighlighterProcessor {
        public void process(RangeHighlighter var1);
    }
}

