/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateAction;
import com.intellij.openapi.updateSettings.impl.LabelTextReplacingUtil;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ListUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class UpdateSettingsConfigurable
extends BaseConfigurable
implements SearchableConfigurable {
    private UpdatesSettingsPanel myUpdatesSettingsPanel;
    private boolean myCheckNowEnabled = true;

    public JComponent createComponent() {
        this.myUpdatesSettingsPanel = new UpdatesSettingsPanel();
        return this.myUpdatesSettingsPanel.myPanel;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"updates.settings.title", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.updates";
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableUpdates.png");
    }

    public static UpdateSettingsConfigurable getInstance() {
        return (UpdateSettingsConfigurable)ShowSettingsUtil.getInstance().findApplicationConfigurable(UpdateSettingsConfigurable.class);
    }

    public void setCheckNowEnabled(boolean enabled) {
        this.myCheckNowEnabled = enabled;
    }

    public void apply() throws ConfigurationException {
        UpdateSettings settings = UpdateSettings.getInstance();
        settings.CHECK_NEEDED = this.myUpdatesSettingsPanel.myCbCheckForUpdates.isSelected();
        settings.myPluginHosts.clear();
        settings.myPluginHosts.addAll(this.myUpdatesSettingsPanel.getPluginsHosts());
    }

    public void reset() {
        UpdateSettings settings = UpdateSettings.getInstance();
        this.myUpdatesSettingsPanel.myCbCheckForUpdates.setSelected(settings.CHECK_NEEDED);
        this.myUpdatesSettingsPanel.updateLastCheckedLabel();
        this.myUpdatesSettingsPanel.setPluginHosts((List<String>)settings.myPluginHosts);
    }

    public boolean isModified() {
        UpdateSettings settings = UpdateSettings.getInstance();
        if (!settings.myPluginHosts.equals(this.myUpdatesSettingsPanel.getPluginsHosts())) {
            return true;
        }
        return settings.CHECK_NEEDED != this.myUpdatesSettingsPanel.myCbCheckForUpdates.isSelected();
    }

    public void disposeUIResources() {
        this.myUpdatesSettingsPanel = null;
    }

    public List<String> getPluginHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        if (this.myUpdatesSettingsPanel != null) {
            hosts.addAll(this.myUpdatesSettingsPanel.getPluginsHosts());
        } else {
            hosts.addAll((Collection<String>)UpdateSettings.getInstance().myPluginHosts);
        }
        String pluginHosts = System.getProperty("idea.plugin.hosts");
        if (pluginHosts != null) {
            hosts.addAll(Arrays.asList(pluginHosts.split(";")));
        }
        return hosts;
    }

    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    public static class HostMessages
    extends Messages {

        public static class InputHostDialog
        extends Messages.InputDialog {
            private final Component myParentComponent;

            public InputHostDialog(Component parentComponent, String message, String title, Icon icon, String initialValue, InputValidator validator) {
                super(parentComponent, message, title, icon, initialValue, validator);
                this.myParentComponent = parentComponent;
            }

            protected Action[] createActions() {
                Object[] actions = super.createActions();
                return (Action[])ArrayUtil.append((Object[])actions, (Object)new AbstractAction("Check Now"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            if (UpdateChecker.checkPluginsHost(InputHostDialog.this.getTextField().getText(), new ArrayList<PluginDownloader>())) {
                                Messages.showInfoMessage((Component)InputHostDialog.this.myParentComponent, (String)"Plugins Host was sucessfully checked", (String)"Check Plugins Host");
                            } else {
                                Messages.showErrorDialog((Component)InputHostDialog.this.myParentComponent, (String)"Plugin descriptions contain some errors. Please, check idea.log for details.");
                            }
                        }
                        catch (Exception e1) {
                            Messages.showErrorDialog((Component)InputHostDialog.this.myParentComponent, (String)("Connection failed: " + e1.getMessage()));
                        }
                    }
                });
            }
        }
    }

    private class UpdatesSettingsPanel {
        private JPanel myPanel;
        private JButton myBtnCheckNow;
        private JCheckBox myCbCheckForUpdates;
        private JLabel myBuildNumber;
        private JLabel myVersionNumber;
        private JLabel myLastCheckedDate;
        private JButton myAddButton;
        private JButton myDeleteButton;
        private JList myUrlsList;
        private JButton myEditButton;

        public UpdatesSettingsPanel() {
            this.$$$setupUI$$$();
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            String majorVersion = appInfo.getMajorVersion();
            String versionNumber = "";
            if (majorVersion != null && majorVersion.trim().length() > 0) {
                String minorVersion = appInfo.getMinorVersion();
                versionNumber = minorVersion != null && minorVersion.trim().length() > 0 ? majorVersion + "." + minorVersion : majorVersion + ".0";
            }
            this.myVersionNumber.setText(appInfo.getVersionName() + " " + versionNumber);
            this.myBuildNumber.setText(appInfo.getBuild().asString());
            this.myBtnCheckNow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckForUpdateAction.actionPerformed(false);
                    UpdatesSettingsPanel.this.updateLastCheckedLabel();
                }
            });
            this.myBtnCheckNow.setEnabled(UpdateSettingsConfigurable.this.myCheckNowEnabled);
            LabelTextReplacingUtil.replaceText(this.myPanel);
            this.myUrlsList.setModel(new DefaultListModel());
            this.myUrlsList.setSelectionMode(0);
            this.myUrlsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    UpdatesSettingsPanel.this.myDeleteButton.setEnabled(ListUtil.canRemoveSelectedItems((JList)UpdatesSettingsPanel.this.myUrlsList));
                    UpdatesSettingsPanel.this.myEditButton.setEnabled(ListUtil.canRemoveSelectedItems((JList)UpdatesSettingsPanel.this.myUrlsList));
                }
            });
            this.myAddButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HostMessages.InputHostDialog dlg = new HostMessages.InputHostDialog(UpdatesSettingsPanel.this.myPanel, IdeBundle.message((String)"update.plugin.host.url.message", (Object[])new Object[0]), IdeBundle.message((String)"update.add.new.plugin.host.title", (Object[])new Object[0]), Messages.getQuestionIcon(), "", (InputValidator)new NonEmptyInputValidator());
                    dlg.show();
                    String input = dlg.getInputString();
                    if (input != null) {
                        ((DefaultListModel)UpdatesSettingsPanel.this.myUrlsList.getModel()).addElement(input);
                    }
                }
            });
            this.myEditButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HostMessages.InputHostDialog dlg = new HostMessages.InputHostDialog(UpdatesSettingsPanel.this.myPanel, IdeBundle.message((String)"update.plugin.host.url.message", (Object[])new Object[0]), IdeBundle.message((String)"update.edit.plugin.host.title", (Object[])new Object[0]), Messages.getQuestionIcon(), (String)UpdatesSettingsPanel.this.myUrlsList.getSelectedValue(), new InputValidator(){

                        public boolean checkInput(String inputString) {
                            return inputString.length() > 0;
                        }

                        public boolean canClose(String inputString) {
                            return this.checkInput(inputString);
                        }
                    });
                    dlg.show();
                    String input = dlg.getInputString();
                    if (input != null) {
                        ((DefaultListModel)UpdatesSettingsPanel.this.myUrlsList.getModel()).set(UpdatesSettingsPanel.this.myUrlsList.getSelectedIndex(), input);
                    }
                }
            });
            this.myDeleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListUtil.removeSelectedItems((JList)UpdatesSettingsPanel.this.myUrlsList);
                }
            });
            this.myEditButton.setEnabled(false);
            this.myDeleteButton.setEnabled(false);
        }

        private void updateLastCheckedLabel() {
            DateFormat dateFormat = DateFormat.getDateInstance(0);
            long lastChecked = UpdateSettings.getInstance().LAST_TIME_CHECKED;
            this.myLastCheckedDate.setText(lastChecked == 0L ? IdeBundle.message((String)"updates.last.check.never", (Object[])new Object[0]) : dateFormat.format(new Date(lastChecked)));
        }

        public List<String> getPluginsHosts() {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.myUrlsList.getModel().getSize(); ++i) {
                result.add((String)this.myUrlsList.getModel().getElementAt(i));
            }
            return result;
        }

        public void setPluginHosts(List<String> pluginHosts) {
            DefaultListModel model = (DefaultListModel)this.myUrlsList.getModel();
            model.clear();
            for (String host : pluginHosts) {
                model.addElement(host);
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JButton jButton3;
            JList jList;
            JButton jButton4;
            JCheckBox jCheckBox;
            JLabel jLabel;
            JLabel jLabel2;
            JLabel jLabel3;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, new Dimension(0, -1), new Dimension(0, -1), new Dimension(0, -1)));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 5, new Insets(10, 10, 10, 10), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.last.check"));
            jPanel2.add((Component)jLabel4, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel5 = new JLabel();
            this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.current.version"));
            jPanel2.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myVersionNumber = jLabel3 = new JLabel();
            jLabel3.setText("4.5.4");
            jPanel2.add((Component)jLabel3, new GridConstraints(5, 1, 1, 1, 8, 1, 0, 0, null, null, null));
            this.myBuildNumber = jLabel2 = new JLabel();
            jLabel2.setText("3352");
            jPanel2.add((Component)jLabel2, new GridConstraints(5, 4, 1, 1, 8, 1, 0, 0, null, null, null));
            JLabel jLabel6 = new JLabel();
            this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.build.number"));
            jPanel2.add((Component)jLabel6, new GridConstraints(5, 3, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myLastCheckedDate = jLabel = new JLabel();
            jLabel.setText("01.05.2005");
            jPanel2.add((Component)jLabel, new GridConstraints(6, 1, 1, 4, 8, 1, 0, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel2.add((Component)spacer3, new GridConstraints(2, 4, 1, 1, 0, 2, 1, 2, new Dimension(-1, 20), new Dimension(-1, 20), new Dimension(-1, 20)));
            JLabel jLabel7 = new JLabel();
            this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.caption.1"));
            jPanel2.add((Component)jLabel7, new GridConstraints(0, 0, 1, 5, 8, 0, 1, 0, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(10, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 5, 0, 3, 3, 3, null, null, null));
            this.myCbCheckForUpdates = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.checkbox"));
            jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer4 = new Spacer();
            jPanel3.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myBtnCheckNow = jButton4 = new JButton();
            this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.check.now.button"));
            jButton4.setHorizontalAlignment(4);
            jPanel3.add((Component)jButton4, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel4, new GridConstraints(3, 0, 1, 5, 0, 3, 3, 3, null, null, null));
            jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/IdeBundle").getString("update.plugin.hosts.title"), 0, 0, null, null));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel4.add((Component)jScrollPane, new GridConstraints(0, 0, 4, 1, 0, 3, 7, 7, null, null, null));
            this.myUrlsList = jList = new JList();
            jScrollPane.setViewportView(jList);
            this.myAddButton = jButton3 = new JButton();
            this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/IdeBundle").getString("button.add"));
            jPanel4.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myDeleteButton = jButton2 = new JButton();
            this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/IdeBundle").getString("button.remove"));
            jPanel4.add((Component)jButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            Spacer spacer5 = new Spacer();
            jPanel4.add((Component)spacer5, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myEditButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("button.edit"));
            jPanel4.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            Spacer spacer6 = new Spacer();
            jPanel2.add((Component)spacer6, new GridConstraints(4, 4, 1, 1, 0, 2, 1, 2, new Dimension(-1, 40), new Dimension(-1, 40), new Dimension(-1, 40)));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

