/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanPropertyElement
extends FakePsiElement
implements PsiMetaOwner,
PsiPresentableMetaData {
    private final PsiMethod myMethod;
    private final String myName;

    public BeanPropertyElement(PsiMethod method, String name) {
        this.myMethod = method;
        this.myName = name;
    }

    @Nullable
    public PsiType getPropertyType() {
        return PropertyUtil.getPropertyType((PsiMember)this.myMethod);
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/BeanPropertyElement.getMethod must not return null");
        }
        return psiMethod;
    }

    @Override
    public PsiElement getNavigationElement() {
        return this.myMethod;
    }

    @Override
    public PsiManager getManager() {
        return this.myMethod.getManager();
    }

    public PsiElement getDeclaration() {
        return this;
    }

    @NonNls
    public String getName(PsiElement context) {
        return this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/BeanPropertyElement.getName must not return null");
        }
        return string;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @Nullable
    public Icon getIcon(boolean flags) {
        return BeanProperty.ICON;
    }

    public PsiElement getParent() {
        return this.myMethod;
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return this;
    }

    public String getTypeName() {
        return IdeBundle.message((String)"bean.property", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return this.getIcon(0);
    }

    @Override
    public TextRange getTextRange() {
        return TextRange.from((int)0, (int)0);
    }
}

