/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotatedPackagesSearcher
implements QueryExecutor<PsiPackage, AnnotatedPackagesSearch.Parameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.AnnotatedPackagesSearcher");

    public boolean execute(AnnotatedPackagesSearch.Parameters p, final Processor<PsiPackage> consumer) {
        final PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated packages search";
        final String annotationFQN = annClass.getQualifiedName();
        assert (annotationFQN != null);
        final PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance((Project)annClass.getProject());
        SearchScope useScope = p.getScope();
        String annotationShortName = annClass.getName();
        assert (annotationShortName != null);
        GlobalSearchScope scope = useScope instanceof GlobalSearchScope ? (GlobalSearchScope)useScope : null;
        Collection<PsiAnnotation> annotations = JavaAnnotationIndex.getInstance().get(annotationShortName, annClass.getProject(), scope);
        for (PsiAnnotation annotation : annotations) {
            String qname;
            PsiClass candidate;
            PsiModifierList modlist = (PsiModifierList)annotation.getParent();
            PsiElement owner = modlist.getParent();
            if (!(owner instanceof PsiClass) || !"package-info".equals((candidate = (PsiClass)owner).getName())) continue;
            LOG.assertTrue(candidate.isValid());
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            if (ref == null || !psiManager.areElementsEquivalent(ref.resolve(), (PsiElement)annClass) || useScope instanceof GlobalSearchScope && !((GlobalSearchScope)useScope).contains(candidate.getContainingFile().getVirtualFile()) || (qname = candidate.getQualifiedName()) == null || consumer.process((Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(qname.substring(0, qname.lastIndexOf(46))))) continue;
            return false;
        }
        PsiSearchHelper helper = psiManager.getSearchHelper();
        PackageInfoFilesOnly infoFilesFilter = new PackageInfoFilesOnly();
        PackageInfoFilesOnly infoFiles = useScope instanceof GlobalSearchScope ? ((GlobalSearchScope)useScope).intersectWith((GlobalSearchScope)infoFilesFilter) : infoFilesFilter;
        final boolean[] wantmore = new boolean[]{true};
        helper.processAllFilesWithWord(annotationShortName, (GlobalSearchScope)infoFiles, (Processor)new Processor<PsiFile>(){

            public boolean process(PsiFile psiFile) {
                PsiPackageStatement stmt = (PsiPackageStatement)PsiTreeUtil.getChildOfType((PsiElement)psiFile, PsiPackageStatement.class);
                if (stmt == null) {
                    return true;
                }
                PsiModifierList annotations = stmt.getAnnotationList();
                if (annotations == null) {
                    return true;
                }
                PsiAnnotation ann = annotations.findAnnotation(annotationFQN);
                if (ann == null) {
                    return true;
                }
                PsiJavaCodeReferenceElement ref = ann.getNameReferenceElement();
                if (ref == null) {
                    return true;
                }
                if (!psiManager.areElementsEquivalent(ref.resolve(), (PsiElement)annClass)) {
                    return true;
                }
                wantmore[0] = consumer.process((Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(stmt.getPackageName()));
                return wantmore[0];
            }
        }, true);
        return wantmore[0];
    }

    private static class PackageInfoFilesOnly
    extends GlobalSearchScope {
        private PackageInfoFilesOnly() {
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        public boolean contains(VirtualFile file) {
            return "package-info.java".equals(file.getName());
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/AnnotatedPackagesSearcher$PackageInfoFilesOnly.isSearchInModuleContent must not be null");
            }
            return true;
        }
    }
}

