/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.caches.FileContent;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.cache.impl.CacheUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.PsiElementArrayConstructor;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PatchedSoftReference;
import com.intellij.util.PatchedWeakReference;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFileImpl
extends ElementBase
implements PsiFileEx,
PsiFileWithStubSupport,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiFileImpl");
    private IElementType myElementType;
    protected IElementType myContentElementType;
    protected PsiFile myOriginalFile;
    private final FileViewProvider myViewProvider;
    private static final Key<Document> HARD_REFERENCE_TO_DOCUMENT = new Key("HARD_REFERENCE_TO_DOCUMENT");
    private final Object myStubLock;
    private SoftReference<StubTree> myStub;
    protected final PsiManagerEx myManager;
    private volatile Object myTreeElementPointer;
    public static final Key<Boolean> BUILDING_STUB = new Key("Don't use stubs mark!");
    private static final Key<StubTree> STUB_TREE_IN_PARSED_TREE = new Key("STUB_TREE_IN_PARSED_TREE");

    protected PsiFileImpl(@NotNull IElementType elementType, IElementType contentElementType, @NotNull FileViewProvider provider) {
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.<init> must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.<init> must not be null");
        }
        this(provider);
        this.init(elementType, contentElementType);
    }

    protected PsiFileImpl(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.<init> must not be null");
        }
        this.myOriginalFile = null;
        this.myStubLock = new String("file's stub lock");
        this.myManager = (PsiManagerEx)provider.getManager();
        this.myViewProvider = provider;
    }

    public void setContentElementType(IElementType contentElementType) {
        this.myContentElementType = contentElementType;
    }

    public IElementType getContentElementType() {
        return this.myContentElementType;
    }

    protected void init(@NotNull IElementType elementType, IElementType contentElementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.init must not be null");
        }
        this.myElementType = elementType;
        this.myContentElementType = contentElementType;
    }

    public TreeElement createContentLeafElement(CharSequence leafText) {
        if (this.myContentElementType instanceof ILazyParseableElementType) {
            return ASTFactory.lazy((ILazyParseableElementType)this.myContentElementType, leafText);
        }
        return ASTFactory.leaf(this.myContentElementType, leafText);
    }

    public boolean isDirectory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileElement getTreeElement() {
        FileElement noLockAttempt = (FileElement)this._getTreeElement();
        if (noLockAttempt != null) {
            return noLockAttempt;
        }
        Object object = this.myStubLock;
        synchronized (object) {
            return this.getTreeElementNoLock();
        }
    }

    public FileElement getTreeElementNoLock() {
        if (!this.getViewProvider().isPhysical() && this._getTreeElement() == null) {
            this.setTreeElement(this.loadTreeElement());
        }
        return (FileElement)this._getTreeElement();
    }

    protected boolean isKeepTreeElementByHardReference() {
        return !this.getViewProvider().isEventSystemEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASTNode _getTreeElement() {
        Object pointer = this.myTreeElementPointer;
        if (pointer instanceof FileElement) {
            return (FileElement)pointer;
        }
        if (pointer instanceof Reference) {
            FileElement treeElement = (FileElement)((Reference)pointer).get();
            if (treeElement != null) {
                return treeElement;
            }
            Object object = this.myStubLock;
            synchronized (object) {
                if (this.myTreeElementPointer == pointer) {
                    this.myTreeElementPointer = null;
                }
            }
        }
        return null;
    }

    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    public boolean isValid() {
        VirtualFile vFile = this.getViewProvider().getVirtualFile();
        if (!vFile.isValid()) {
            return false;
        }
        if (!this.getViewProvider().isPhysical()) {
            return true;
        }
        return this.isPsiUpToDate(vFile);
    }

    protected boolean isPsiUpToDate(VirtualFile vFile) {
        FileViewProvider provider = this.myManager.findViewProvider(vFile);
        return provider.getPsi(this.getLanguage()) == this || provider.getPsi(provider.getBaseLanguage()) == this;
    }

    @Override
    public boolean isContentsLoaded() {
        return this._getTreeElement() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileElement loadTreeElement() {
        FileElement treeElement;
        Object object = this.myStubLock;
        synchronized (object) {
            treeElement = (FileElement)this._getTreeElement();
            if (treeElement != null) {
                return treeElement;
            }
            FileViewProvider viewProvider = this.getViewProvider();
            if (viewProvider.isPhysical() && this.myManager.isAssertOnFileLoading(viewProvider.getVirtualFile())) {
                LOG.error("Access to tree elements not allowed in tests. path='" + viewProvider.getVirtualFile().getPresentableUrl() + "'");
            }
            Document document = viewProvider.isEventSystemEnabled() ? viewProvider.getDocument() : null;
            treeElement = this.createFileElement(viewProvider.getContents());
            if (document != null) {
                treeElement.putUserData(HARD_REFERENCE_TO_DOCUMENT, document);
            }
            treeElement.setPsi((PsiElement)this);
            StubTree stub = this.derefStub();
            if (stub != null) {
                Iterator<StubElement<?>> stubs = stub.getPlainList().iterator();
                stubs.next();
                this.switchFromStubToAST(treeElement, stubs);
                this.myStub = null;
            }
            this.setTreeElement(treeElement);
            if (LOG.isDebugEnabled() && this.getViewProvider().isPhysical()) {
                LOG.debug("Loaded text for file " + this.getViewProvider().getVirtualFile().getPresentableUrl());
            }
        }
        if (this.getViewProvider().isEventSystemEnabled()) {
            ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)this.myManager.getProject())).contentsLoaded(this);
        }
        return treeElement;
    }

    @Override
    public ASTNode findTreeForStub(StubTree tree, StubElement<?> stub) {
        Iterator<StubElement<?>> stubs = tree.getPlainList().iterator();
        StubElement<?> root = stubs.next();
        CompositeElement ast = this.calcTreeElement();
        if (root == stub) {
            return ast;
        }
        return PsiFileImpl.findTreeForStub(ast, stubs, stub);
    }

    private static ASTNode findTreeForStub(ASTNode tree, Iterator<StubElement<?>> stubs, StubElement stub) {
        StubElement<?> curStub;
        IElementType type = tree.getElementType();
        if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(tree) && (curStub = stubs.next()) == stub) {
            return tree;
        }
        for (ASTNode node : tree.getChildren(null)) {
            ASTNode treeForStub = PsiFileImpl.findTreeForStub(node, stubs, stub);
            if (treeForStub == null) continue;
            return treeForStub;
        }
        return null;
    }

    private void switchFromStubToAST(ASTNode root, final Iterator<StubElement<?>> stubs) {
        ((TreeElement)root).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement tree) {
                IElementType type = tree.getElementType();
                if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub((ASTNode)tree)) {
                    StubElement stub;
                    if (!stubs.hasNext()) {
                        LOG.error("Stub list in" + this + " " + PsiFileImpl.this.getName() + " has fewer elements than PSI. Last AST element: " + tree.getElementType() + " " + tree);
                    }
                    if ((stub = (StubElement)stubs.next()).getStubType() != tree.getElementType()) {
                        PsiFileImpl.this.rebuildStub();
                        LOG.error("Stub and PSI element type mismatch in " + PsiFileImpl.this.getName() + ": stub " + stub + ", AST " + tree.getElementType() + "; " + tree);
                    }
                    PsiElement psi = stub.getPsi();
                    ((CompositeElement)tree).setPsi(psi);
                    StubBasedPsiElementBase base = (StubBasedPsiElementBase)psi;
                    base.setNode(tree);
                    base.setStub(null);
                }
                super.visitNode(tree);
            }
        });
    }

    protected FileElement createFileElement(CharSequence docText) {
        FileElement treeElement;
        TreeElement contentLeaf = this.createContentLeafElement(docText);
        if (contentLeaf instanceof FileElement) {
            treeElement = (FileElement)contentLeaf;
        } else {
            CompositeElement xxx = ASTFactory.composite(this.myElementType);
            assert (xxx instanceof FileElement) : "BUMM";
            treeElement = (FileElement)xxx;
            treeElement.rawAddChildren(contentLeaf);
        }
        if (CacheUtil.isCopy(this)) {
            treeElement.setCharTable(IdentityCharTable.INSTANCE);
        }
        return treeElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadContent() {
        LOG.assertTrue(this.getTreeElement() != null);
        this.clearCaches();
        this.myViewProvider.beforeContentsSynchronized();
        this.setTreeElement(null);
        Object object = this.myStubLock;
        synchronized (object) {
            this.myStub = null;
        }
    }

    public void clearCaches() {
    }

    public String getText() {
        return ((Object)this.getViewProvider().getContents()).toString();
    }

    public int getTextLength() {
        ASTNode tree = this._getTreeElement();
        if (tree != null) {
            return tree.getTextLength();
        }
        return this.getViewProvider().getContents().length();
    }

    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling((PsiElement)this);
    }

    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling((PsiElement)this);
    }

    public long getModificationStamp() {
        return this.getViewProvider().getModificationStamp();
    }

    public void subtreeChanged() {
        this.doClearCaches();
        this.getViewProvider().rootChanged((PsiFile)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClearCaches() {
        FileElement tree = this.getTreeElement();
        if (tree != null) {
            this.myTreeElementPointer = tree;
            tree.clearCaches();
        }
        Object object = this.myStubLock;
        synchronized (object) {
            this.myStub = null;
            if (tree != null) {
                tree.putUserData(STUB_TREE_IN_PARSED_TREE, null);
            }
        }
        this.clearCaches();
    }

    protected PsiFileImpl clone() {
        PsiFileImpl clone;
        FileViewProvider provider = this.getViewProvider().clone();
        Language language = this.getLanguage();
        PsiFileImpl psiFileImpl = clone = provider != null ? (PsiFileImpl)provider.getPsi(language) : null;
        assert (clone != null) : "Cannot find psi file with language:" + language + " from viewprovider:" + provider + " virtual file:" + this.getVirtualFile();
        this.copyCopyableDataTo((UserDataHolderBase)clone);
        if (this.getTreeElement() != null) {
            FileElement treeClone = (FileElement)this.calcTreeElement().clone();
            clone.myTreeElementPointer = treeClone;
            treeClone.setPsi((PsiElement)clone);
        }
        if (this.getViewProvider().isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        return clone;
    }

    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getName must not return null");
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.setName must not be null");
        }
        this.checkSetName(name);
        this.doClearCaches();
        return PsiFileImplUtil.setName(this, name);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable() && !CacheUtil.isCopy(this);
    }

    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getViewProvider().getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    public PsiFile getContainingFile() {
        return this;
    }

    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFileImpl psiFileImpl = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (psiFileImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getOriginalFile must not return null");
        }
        return psiFileImpl;
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.setOriginalFile must not be null");
        }
        this.myOriginalFile = originalFile.getOriginalFile();
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        FileViewProvider viewProvider = this.getViewProvider();
        Set languages = viewProvider.getLanguages();
        PsiFile[] roots = new PsiFile[languages.size()];
        int i = 0;
        for (Language language : languages) {
            PsiFile psi = viewProvider.getPsi(language);
            if (psi == null) {
                LOG.error("PSI is null for " + language + "; in file: " + this);
            }
            roots[i++] = psi;
        }
        if (roots == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getPsiRoots must not return null");
        }
        return roots;
    }

    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getLanguage must not return null");
        }
        return language;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getViewProvider must not return null");
        }
        return fileViewProvider;
    }

    public void setTreeElementPointer(FileElement element) {
        this.myTreeElementPointer = element;
    }

    public PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset);
    }

    public PsiReference findReferenceAt(int offset) {
        return this.getViewProvider().findReferenceAt(offset);
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequenceStrict((CharSequence)this.getViewProvider().getContents());
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.textToCharArray must not return null");
        }
        return cArray;
    }

    @NotNull
    protected <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            result.add(child);
        }
        Object[] objectArray = result.toArray((Object[])Array.newInstance(aClass, result.size()));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.findChildrenByClass must not return null");
        }
        return objectArray;
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public boolean isTemplateDataFile() {
        return false;
    }

    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void onContentReload() {
        this.subtreeChanged();
        if (this.isContentsLoaded()) {
            this.unloadContent();
        }
    }

    @Override
    public PsiFile cacheCopy(FileContent content) {
        CharSequence text;
        if (this.isContentsLoaded()) {
            return this;
        }
        if (content == null) {
            Document document = FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
            text = document.getCharsSequence();
        } else {
            text = CacheUtil.getContentText(content);
        }
        FileType fileType = this.getFileType();
        String name = this.getName();
        PsiFile fileCopy = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(name, fileType, text, this.getModificationStamp(), false, false);
        fileCopy.putUserData(CacheUtil.CACHE_COPY_KEY, (Object)Boolean.TRUE);
        ((PsiFileImpl)fileCopy).setOriginalFile(this);
        return fileCopy;
    }

    @Nullable
    public StubElement getStub() {
        StubTree stubHolder = this.getStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (Boolean.TRUE.equals(this.getUserData(BUILDING_STUB))) {
            return null;
        }
        StubTree derefd = this.derefStub();
        if (derefd != null) {
            return derefd;
        }
        if (this.getTreeElementNoLock() != null) {
            return null;
        }
        VirtualFile vFile = this.getVirtualFile();
        if (!(vFile instanceof VirtualFileWithId)) {
            return null;
        }
        StubTree stubHolder = StubTree.readOrBuild(this.getProject(), vFile);
        if (stubHolder == null) {
            return null;
        }
        Object object = this.myStubLock;
        synchronized (object) {
            if (this.getTreeElementNoLock() != null) {
                return null;
            }
            StubTree derefdOnLock = this.derefStub();
            if (derefdOnLock != null) {
                return derefdOnLock;
            }
            this.setStubTree(stubHolder);
            return this.derefStub();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStubTree(StubTree stubHolder) {
        Object object = this.myStubLock;
        synchronized (object) {
            assert (this.getTreeElementNoLock() == null);
            this.myStub = new SoftReference((Object)stubHolder);
            StubBase base = (StubBase)stubHolder.getRoot();
            base.setPsi((PsiElement)this);
            base.putUserData(STUB_TREE_IN_PARSED_TREE, (Object)stubHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private StubTree derefStub() {
        Object object = this.myStubLock;
        synchronized (object) {
            return this.myStub != null ? (StubTree)this.myStub.get() : null;
        }
    }

    protected PsiFileImpl cloneImpl(FileElement treeElementClone) {
        PsiFileImpl clone = (PsiFileImpl)super.clone();
        clone.myTreeElementPointer = treeElementClone;
        treeElementClone.setPsi((PsiElement)clone);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTreeElement(ASTNode treeElement) {
        Object newPointer = treeElement == null ? null : (this.isKeepTreeElementByHardReference() ? treeElement : (this.myManager.isBatchFilesProcessingMode() ? new PatchedWeakReference<ASTNode>(treeElement) : new PatchedSoftReference<ASTNode>(treeElement)));
        Object object = this.myStubLock;
        synchronized (object) {
            this.myTreeElementPointer = newPointer;
        }
    }

    public Object getStubLock() {
        return this.myStubLock;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompositeElement calcTreeElement() {
        FileElement treeElement = this.getTreeElement();
        if (treeElement != null) {
            return treeElement;
        }
        Object object = this.myStubLock;
        synchronized (object) {
            treeElement = this.getTreeElement();
            if (treeElement != null) {
                return treeElement;
            }
            return this.loadTreeElement();
        }
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.calcTreeElement().getChildrenAsPsiElements(null, PsiElementArrayConstructor.PSI_ELEMENT_ARRAY_CONSTRUCTOR);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.calcTreeElement());
    }

    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.calcTreeElement());
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.acceptChildren must not be null");
        }
        SharedImplUtil.acceptChildren(visitor, this.calcTreeElement());
    }

    public int getStartOffsetInParent() {
        return this.calcTreeElement().getStartOffsetInParent();
    }

    public int getTextOffset() {
        return this.calcTreeElement().getTextOffset();
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.textMatches must not be null");
        }
        return this.calcTreeElement().textMatches(text);
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.textMatches must not be null");
        }
        return this.calcTreeElement().textMatches(element);
    }

    public boolean textContains(char c) {
        return this.calcTreeElement().textContains(c);
    }

    public final PsiElement copy() {
        return this.clone();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.add must not be null");
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.addBefore must not be null");
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.addAfter must not be null");
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.checkAdd must not be null");
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, null, null);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.addRangeBefore must not be null");
        }
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        if (first == null) {
            LOG.assertTrue(last == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        CompositeElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren(treeElement, firstElement, lastElement);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.replace must not be null");
        }
        CompositeElement treeElement = this.calcTreeElement();
        LOG.assertTrue(treeElement.getTreeParent() != null);
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        treeElement.getTreeParent().replaceChildInternal(treeElement, elementCopy);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public PsiReference getReference() {
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.processDeclarations must not be null");
        }
        return true;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ((PsiManagerEx)this.getManager()).getFileManager().getResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ((PsiManagerEx)this.getManager()).getFileManager().getUseScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return PsiFileImpl.this.getName();
            }

            public String getLocationString() {
                PsiDirectory psiDirectory = PsiFileImpl.this.getParent();
                if (psiDirectory != null) {
                    return psiDirectory.getVirtualFile().getPresentableUrl();
                }
                return null;
            }

            public Icon getIcon(boolean open) {
                return PsiFileImpl.this.getIcon(open ? 4 : 8);
            }

            public TextAttributesKey getTextAttributesKey() {
                return null;
            }
        };
    }

    public void navigate(boolean requestFocus) {
        EditSourceUtil.getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return EditSourceUtil.canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public FileStatus getFileStatus() {
        if (!this.isPhysical()) {
            return FileStatus.NOT_CHANGED;
        }
        PsiFile contFile = this.getContainingFile();
        if (contFile == null) {
            return FileStatus.NOT_CHANGED;
        }
        VirtualFile vFile = contFile.getVirtualFile();
        return vFile != null ? FileStatusManager.getInstance((Project)this.getProject()).getStatus(vFile) : FileStatus.NOT_CHANGED;
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getProject must not return null");
        }
        return project;
    }

    public ASTNode getNode() {
        return this.calcTreeElement();
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubTree calcStubTree() {
        Object object = this.myStubLock;
        synchronized (object) {
            FileElement fileElement = (FileElement)this.calcTreeElement();
            StubTree tree = (StubTree)fileElement.getUserData(STUB_TREE_IN_PARSED_TREE);
            if (tree == null) {
                StubElement currentStubTree = ((IStubFileElementType)this.getContentElementType()).getBuilder().buildStubTree((PsiFile)this);
                tree = new StubTree((PsiFileStub)currentStubTree);
                this.bindFakeStubsToTree(tree);
                fileElement.putUserData(STUB_TREE_IN_PARSED_TREE, tree);
            }
            return tree;
        }
    }

    private void bindFakeStubsToTree(StubTree stubTree) {
        PsiFileImpl file = this;
        Iterator<StubElement<?>> stubs = stubTree.getPlainList().iterator();
        stubs.next();
        FileElement fileRoot = file.getTreeElement();
        assert (fileRoot != null);
        this.bindStubs(fileRoot, stubs);
    }

    @Nullable
    private StubElement bindStubs(ASTNode tree, Iterator<StubElement<?>> stubs) {
        IElementType type = tree.getElementType();
        if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(tree)) {
            StubElement<?> stub = stubs.next();
            if (stub.getStubType() != tree.getElementType()) {
                this.rebuildStub();
                assert (false) : "Stub and PSI element type mismatch:  stub " + stub + ", AST " + tree.getElementType();
            }
            ((StubBase)stub).setPsi(tree.getPsi());
        }
        for (ASTNode node : tree.getChildren(null)) {
            StubElement res = this.bindStubs(node, stubs);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private void rebuildStub() {
        final VirtualFile vFile = this.getVirtualFile();
        if (vFile != null && vFile.isValid()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                    if (doc != null) {
                        FileDocumentManager.getInstance().saveDocument(doc);
                    }
                }
            }, ModalityState.NON_MODAL);
            FileBasedIndex.getInstance().requestReindex(vFile);
        }
    }

    public void putInfo(Map<String, String> info) {
        PsiFileImpl.putInfo(this, info);
    }

    public static void putInfo(PsiFile psiFile, Map<String, String> info) {
        info.put("fileName", psiFile.getName());
        info.put("fileType", psiFile.getFileType().toString());
    }
}

