/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PsiImmediateClassType
extends PsiClassType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiImmediateClassType");
    private final PsiClass myClass;
    private final PsiSubstitutor mySubstitutor;
    private final PsiManager myManager;
    private String myCanonicalText;
    private String myPresentableText;
    private String myInternalCanonicalText;
    private final PsiClassType.ClassResolveResult myClassResolveResult = new PsiClassType.ClassResolveResult(){

        public PsiClass getElement() {
            return PsiImmediateClassType.this.myClass;
        }

        public PsiSubstitutor getSubstitutor() {
            return PsiImmediateClassType.this.mySubstitutor;
        }

        public boolean isValidResult() {
            return true;
        }

        public boolean isAccessible() {
            return true;
        }

        public boolean isStaticsScopeCorrect() {
            return true;
        }

        public PsiElement getCurrentFileResolveScope() {
            return null;
        }

        public boolean isPackagePrefixPackageReference() {
            return false;
        }
    };

    public PsiImmediateClassType(PsiClass aClass, PsiSubstitutor substitutor) {
        this(aClass, substitutor, null);
    }

    public PsiImmediateClassType(PsiClass aClass, PsiSubstitutor substitutor, LanguageLevel languageLevel) {
        this(aClass, substitutor, languageLevel, PsiAnnotation.EMPTY_ARRAY);
    }

    public PsiImmediateClassType(PsiClass aClass, PsiSubstitutor substitutor, LanguageLevel languageLevel, PsiAnnotation[] annotations) {
        super(languageLevel, annotations);
        this.myClass = aClass;
        this.myManager = aClass.getManager();
        this.mySubstitutor = substitutor;
        LOG.assertTrue(this.mySubstitutor != null);
    }

    public PsiClass resolve() {
        return this.myClass;
    }

    public String getClassName() {
        return this.myClass.getName();
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiTypeParameter[] parameters;
        ArrayList<PsiType> lst = new ArrayList<PsiType>();
        for (PsiTypeParameter parameter : parameters = this.myClass.getTypeParameters()) {
            lst.add(this.mySubstitutor.substitute(parameter));
        }
        PsiType[] psiTypeArray = lst.toArray(new PsiType[lst.size()]);
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImmediateClassType.getParameters must not return null");
        }
        return psiTypeArray;
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiClassType.ClassResolveResult classResolveResult = this.myClassResolveResult;
        if (classResolveResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImmediateClassType.resolveGenerics must not return null");
        }
        return classResolveResult;
    }

    @NotNull
    public PsiClassType rawType() {
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory().createType(this.myClass);
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImmediateClassType.rawType must not return null");
        }
        return psiClassType;
    }

    public String getPresentableText() {
        if (this.myPresentableText == null) {
            StringBuilder buffer = new StringBuilder();
            this.buildText(this.myClass, buffer, false, false);
            this.myPresentableText = buffer.toString();
        }
        return this.myPresentableText;
    }

    public String getCanonicalText() {
        if (this.myCanonicalText == null) {
            StringBuilder buffer = new StringBuilder();
            this.buildText(this.myClass, buffer, true, false);
            this.myCanonicalText = buffer.toString();
        }
        return this.myCanonicalText;
    }

    public String getInternalCanonicalText() {
        if (this.myInternalCanonicalText == null) {
            StringBuilder buffer = new StringBuilder();
            this.buildText(this.myClass, buffer, true, true);
            this.myInternalCanonicalText = buffer.toString();
        }
        return this.myInternalCanonicalText;
    }

    private void buildText(PsiClass aClass, StringBuilder buffer, boolean canonical, boolean internal) {
        PsiElement parent;
        PsiSubstitutor substitutor = this.mySubstitutor;
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType.ClassResolveResult baseResolveResult = ((PsiAnonymousClass)aClass).getBaseClassType().resolveGenerics();
            aClass = baseResolveResult.getElement();
            substitutor = baseResolveResult.getSubstitutor();
            if (aClass == null) {
                return;
            }
        }
        PsiClass parentClass = null;
        if (!aClass.hasModifierProperty("static") && (parent = aClass.getParent()) instanceof PsiClass) {
            parentClass = (PsiClass)parent;
        }
        buffer.append(this.getAnnotationsTextPrefix());
        if (parentClass != null) {
            this.buildText(parentClass, buffer, canonical, false);
            buffer.append('.');
            buffer.append(aClass.getName());
        } else {
            String qualifiedName;
            String name = !canonical ? aClass.getName() : ((qualifiedName = aClass.getQualifiedName()) != null ? qualifiedName : aClass.getName());
            buffer.append(name);
        }
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        if (typeParameters.length > 0) {
            StringBuilder pineBuffer = new StringBuilder();
            pineBuffer.append('<');
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiType substitutionResult;
                PsiTypeParameter typeParameter = typeParameters[i];
                if (i > 0) {
                    pineBuffer.append(',');
                }
                if ((substitutionResult = substitutor.substitute(typeParameter)) == null) {
                    pineBuffer = null;
                    break;
                }
                if (!canonical) {
                    pineBuffer.append(substitutionResult.getPresentableText());
                    continue;
                }
                if (internal) {
                    pineBuffer.append(substitutionResult.getInternalCanonicalText());
                    continue;
                }
                pineBuffer.append(substitutionResult.getCanonicalText());
            }
            if (pineBuffer != null) {
                buffer.append((CharSequence)pineBuffer);
                buffer.append('>');
            }
        }
    }

    public boolean isValid() {
        return this.myClass.isValid() && this.mySubstitutor.isValid();
    }

    public boolean equalsToText(String text) {
        PsiType patternType;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        try {
            patternType = factory.createTypeFromText(text, (PsiElement)this.myClass);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return this.equals(patternType);
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myClass.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImmediateClassType.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel;
        if (this.myLanguageLevel != null) {
            languageLevel = this.myLanguageLevel;
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImmediateClassType.getLanguageLevel must not return null");
            return languageLevel;
        }
        languageLevel = PsiUtil.getLanguageLevel((PsiElement)this.myClass);
        if (languageLevel != null) return languageLevel;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImmediateClassType.getLanguageLevel must not return null");
    }

    public PsiClassType setLanguageLevel(LanguageLevel languageLevel) {
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            return this;
        }
        return new PsiImmediateClassType(this.myClass, this.mySubstitutor, languageLevel, this.getAnnotations());
    }
}

