/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.QuickFixProvider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReference
implements FileReferenceOwner,
PsiPolyVariantReference,
QuickFixProvider<FileReference>,
LocalQuickFixProvider,
EmptyResolveMessageProvider,
BindablePsiReference {
    public static final FileReference[] EMPTY = new FileReference[0];
    private final int myIndex;
    private TextRange myRange;
    private final String myText;
    @NotNull
    private final FileReferenceSet myFileReferenceSet;

    public FileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.<init> must not be null");
        }
        this.myFileReferenceSet = fileReferenceSet;
        this.myIndex = index;
        this.myRange = range;
        this.myText = text;
    }

    public FileReference(FileReference original) {
        this(original.myFileReferenceSet, original.myRange, original.myIndex, original.myText);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected Collection<PsiFileSystemItem> getContexts() {
        Collection<PsiFileSystemItem> collection;
        FileReference contextRef = this.getContextReference();
        if (contextRef == null) {
            collection = this.myFileReferenceSet.getDefaultContexts();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.getContexts must not return null");
            return collection;
        }
        ResolveResult[] resolveResults = contextRef.multiResolve(false);
        ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
        for (ResolveResult resolveResult : resolveResults) {
            if (resolveResult.getElement() == null) continue;
            result.add((PsiFileSystemItem)resolveResult.getElement());
        }
        collection = result;
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.getContexts must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray;
        PsiManager manager = this.getElement().getManager();
        if (manager instanceof PsiManagerImpl) {
            resolveResultArray = ((PsiManagerImpl)manager).getResolveCache().resolveWithCaching(this, MyResolver.INSTANCE, false, false);
            if (resolveResultArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.multiResolve must not return null");
            return resolveResultArray;
        }
        resolveResultArray = this.innerResolve();
        if (resolveResultArray != null) return resolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.multiResolve must not return null");
    }

    protected ResolveResult[] innerResolve() {
        return this.innerResolve(this.getFileReferenceSet().isCaseSensitive());
    }

    protected ResolveResult[] innerResolve(boolean caseSensitive) {
        PsiElement element;
        String s;
        String referenceText = this.getText();
        TextRange range = this.getRangeInElement();
        if (range.isEmpty() && (s = (element = this.getElement()).getText()).length() > range.getEndOffset() && s.charAt(range.getEndOffset()) == '#') {
            return new ResolveResult[]{new PsiElementResolveResult((PsiElement)element.getContainingFile())};
        }
        Collection<PsiFileSystemItem> contexts = this.getContexts();
        HashSet<ResolveResult> result = new HashSet<ResolveResult>(contexts.size());
        for (PsiFileSystemItem context : contexts) {
            if (context == null) continue;
            this.innerResolveInContext(referenceText, context, result, caseSensitive);
        }
        int resultCount = result.size();
        return resultCount > 0 ? result.toArray(new ResolveResult[resultCount]) : ResolveResult.EMPTY_ARRAY;
    }

    protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, final Collection<ResolveResult> result, final boolean caseSensitive) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.innerResolveInContext must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.innerResolveInContext must not be null");
        }
        if (this.isAllowedEmptyPath(text) || ".".equals(text) || "/".equals(text)) {
            result.add((ResolveResult)new PsiElementResolveResult((PsiElement)context));
        } else if ("..".equals(text)) {
            PsiFileSystemItem resolved = context.getParent();
            if (resolved != null) {
                result.add((ResolveResult)new PsiElementResolveResult((PsiElement)resolved));
            }
        } else {
            int separatorIndex = text.indexOf(47);
            if (separatorIndex >= 0) {
                ArrayList<ResolveResult> resolvedContexts = new ArrayList<ResolveResult>();
                if (separatorIndex == 0 && "/".equals(context.getName())) {
                    resolvedContexts.add((ResolveResult)new PsiElementResolveResult((PsiElement)context));
                } else {
                    this.innerResolveInContext(text.substring(0, separatorIndex), context, resolvedContexts, caseSensitive);
                }
                String restOfText = text.substring(separatorIndex + 1);
                for (ResolveResult contextVariant : resolvedContexts) {
                    PsiFileSystemItem item = (PsiFileSystemItem)contextVariant.getElement();
                    if (item == null) continue;
                    this.innerResolveInContext(restOfText, item, result, caseSensitive);
                }
            } else {
                final String decoded = this.decode(text);
                if (decoded != null) {
                    FileReference.processVariants(context, new PsiFileSystemItemProcessor(){

                        @Override
                        public boolean acceptItem(String name, boolean isDirectory) {
                            return caseSensitive ? decoded.equals(name) : decoded.compareToIgnoreCase(name) == 0;
                        }

                        public boolean execute(PsiFileSystemItem element) {
                            result.add(new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile(element)));
                            return false;
                        }
                    });
                }
            }
        }
    }

    private boolean isAllowedEmptyPath(String text) {
        return text.length() == 0 && this.isLast() && (StringUtil.isEmpty((String)this.myFileReferenceSet.getPathString()) && this.myFileReferenceSet.isEmptyPathAllowed() || !this.myFileReferenceSet.isEndingSlashNotAllowed() && this.myIndex > 0);
    }

    @Nullable
    private String decode(String text) {
        String _text = text;
        if (text.indexOf(63) >= 0) {
            _text = text.substring(0, text.lastIndexOf(63));
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            try {
                return new URI(_text).getPath();
            }
            catch (Exception e) {
                return text;
            }
        }
        return _text;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        int i;
        Object[] objectArray;
        String s = this.getText();
        if (s != null && s.equals("/")) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.getVariants must not return null");
            return objectArray;
        }
        final CommonProcessors.CollectUniquesProcessor collector = new CommonProcessors.CollectUniquesProcessor();
        PsiElementProcessor<PsiFileSystemItem> processor = new PsiElementProcessor<PsiFileSystemItem>(){

            public boolean execute(PsiFileSystemItem fileSystemItem) {
                return new FilteringProcessor(FileReference.this.myFileReferenceSet.createCondition(), (Processor)collector).process((Object)FileReference.getOriginalFile(fileSystemItem));
            }
        };
        for (PsiFileSystemItem context : this.getContexts()) {
            for (PsiElement child : context.getChildren()) {
                if (!(child instanceof PsiFileSystemItem)) continue;
                processor.execute((PsiElement)((PsiFileSystemItem)child));
            }
        }
        THashSet set = new THashSet(collector.getResults(), (TObjectHashingStrategy)new TObjectHashingStrategy<PsiElement>(){

            public int computeHashCode(PsiElement object) {
                String name;
                if (object instanceof PsiNamedElement && (name = ((PsiNamedElement)object).getName()) != null) {
                    return name.hashCode();
                }
                return object.hashCode();
            }

            public boolean equals(PsiElement o1, PsiElement o2) {
                if (o1 instanceof PsiNamedElement && o2 instanceof PsiNamedElement) {
                    return Comparing.equal((String)((PsiNamedElement)o1).getName(), (String)((PsiNamedElement)o2).getName());
                }
                return o1.equals(o2);
            }
        });
        PsiElement[] candidates = (PsiElement[])set.toArray((Object[])new PsiElement[set.size()]);
        Object[] variants = new Object[candidates.length];
        for (i = 0; i < candidates.length; ++i) {
            variants[i] = this.createLookupItem(candidates[i]);
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            for (i = 0; i < candidates.length; ++i) {
                PsiNamedElement psiElement;
                String name;
                String encoded;
                PsiElement element = candidates[i];
                if (!(element instanceof PsiNamedElement) || (encoded = FileReference.encode(name = (psiElement = (PsiNamedElement)element).getName())).equals(name)) continue;
                Icon icon = psiElement.getIcon(3);
                variants[i] = FileInfoManager.getFileLookupItem(candidates[i], encoded, icon);
            }
        }
        objectArray = variants;
        if (variants != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.getVariants must not return null");
    }

    protected Object createLookupItem(PsiElement candidate) {
        return FileInfoManager.getFileLookupItem(candidate);
    }

    protected static PsiFileSystemItem getOriginalFile(PsiFileSystemItem fileSystemItem) {
        PsiFile psiFile;
        PsiManager psiManager;
        VirtualFile file = fileSystemItem.getVirtualFile();
        if (file != null && !file.isDirectory() && (psiManager = fileSystemItem.getManager()) != null && (psiFile = psiManager.findFile(file)) != null) {
            fileSystemItem = psiFile;
        }
        return fileSystemItem;
    }

    private static String encode(String name) {
        try {
            return new URI(null, null, name, null).toString();
        }
        catch (Exception e) {
            return name;
        }
    }

    protected static void processVariants(PsiFileSystemItem context, PsiFileSystemItemProcessor processor) {
        context.processChildren((PsiElementProcessor)processor);
    }

    @Nullable
    private FileReference getContextReference() {
        return this.myIndex > 0 ? this.myFileReferenceSet.getReference(this.myIndex - 1) : null;
    }

    public PsiElement getElement() {
        return this.myFileReferenceSet.getElement();
    }

    public PsiFileSystemItem resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? (PsiFileSystemItem)resolveResults[0].getElement() : null;
    }

    @Nullable
    public PsiFileSystemItem innerSingleResolve(boolean caseSensitive) {
        ResolveResult[] resolveResults = this.innerResolve(caseSensitive);
        return resolveResults.length == 1 ? (PsiFileSystemItem)resolveResults[0].getElement() : null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiFileSystemItem)) {
            return false;
        }
        PsiFileSystemItem item = this.resolve();
        return item != null && FileReferenceHelperRegistrar.areElementsEquivalent(item, (PsiFileSystemItem)element);
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    public String getCanonicalText() {
        return this.myText;
    }

    public String getText() {
        return this.myText;
    }

    public boolean isSoft() {
        return this.myFileReferenceSet.isSoft();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator<PsiElement> manipulator = CachingReference.getManipulator(this.getElement());
        if (manipulator != null) {
            this.myFileReferenceSet.setElement(manipulator.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName));
            int delta = newElementName.length() - this.myRange.getLength();
            this.myRange = new TextRange(this.getRangeInElement().getStartOffset(), this.getRangeInElement().getStartOffset() + newElementName.length());
            FileReference[] references = this.myFileReferenceSet.getAllReferences();
            for (int idx = this.myIndex + 1; idx < references.length; ++idx) {
                references[idx].myRange = references[idx].myRange.shiftRight(delta);
            }
            return this.myFileReferenceSet.getElement();
        }
        throw new IncorrectOperationException("Manipulator for this element is not defined: " + this.getElement());
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        String newName;
        VirtualFile curVFile;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.bindToElement must not be null");
        }
        if (!(element instanceof PsiFileSystemItem)) {
            throw new IncorrectOperationException("Cannot bind to element, should be instanceof PsiFileSystemItem: " + element);
        }
        PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
        VirtualFile dstVFile = fileSystemItem.getVirtualFile();
        if (dstVFile == null) {
            throw new IncorrectOperationException("Cannot bind to non-physical element:" + element);
        }
        PsiFile file = this.getElement().getContainingFile();
        if (file.getContext() != null) {
            file = file.getContext().getContainingFile();
        }
        if ((curVFile = file.getVirtualFile()) == null) {
            throw new IncorrectOperationException("Cannot bind from non-physical element:" + file);
        }
        Project project = element.getProject();
        if (absolute) {
            PsiFileSystemItem root = null;
            PsiFileSystemItem dstItem = null;
            for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
                PsiFileSystemItem _root;
                PsiFileSystemItem _dstItem;
                if (!helper.isMine(project, dstVFile) || (_dstItem = helper.getPsiFileSystemItem(project, dstVFile)) == null || (_root = helper.findRoot(project, dstVFile)) == null) continue;
                root = _root;
                dstItem = _dstItem;
                break;
            }
            if (root == null) {
                return element;
            }
            String relativePath = PsiFileSystemItemUtil.getRelativePath(root, dstItem);
            if (relativePath == null) {
                return element;
            }
            newName = this.myFileReferenceSet.absoluteUrlNeedsStartSlash() ? "/" + relativePath : relativePath;
        } else {
            Object curItem = null;
            PsiFileSystemItem dstItem = null;
            FileReferenceHelper helper = FileReferenceHelperRegistrar.getNotNullHelper(file);
            Collection<PsiFileSystemItem> contexts = helper.getContexts(project, curVFile);
            switch (contexts.size()) {
                case 0: {
                    break;
                }
                default: {
                    for (PsiFileSystemItem context : contexts) {
                        String path;
                        VirtualFile contextFile = context.getVirtualFile();
                        assert (contextFile != null);
                        if (!VfsUtil.isAncestor((VirtualFile)contextFile, (VirtualFile)dstVFile, (boolean)true) || (path = VfsUtil.getRelativePath((VirtualFile)dstVFile, (VirtualFile)contextFile, (char)'/')) == null) continue;
                        return this.rename(path);
                    }
                }
                case 1: {
                    PsiFileSystemItem _dstItem = helper.getPsiFileSystemItem(project, dstVFile);
                    PsiFileSystemItem _curItem = helper.getPsiFileSystemItem(project, curVFile);
                    if (_dstItem == null || _curItem == null) break;
                    curItem = _curItem;
                    dstItem = _dstItem;
                }
            }
            if (curItem == null) {
                throw new IncorrectOperationException("Cannot find path between files; src = " + curVFile.getPresentableUrl() + "; " + "dst = " + dstVFile.getPresentableUrl() + "; " + "Contexts: " + contexts);
            }
            if (curItem.equals(dstItem)) {
                if (this.getCanonicalText().equals(dstItem.getName())) {
                    return this.getElement();
                }
                return ElementManipulators.getManipulator((PsiElement)this.getElement()).handleContentChange(this.getElement(), this.getRangeInElement(), file.getName());
            }
            newName = PsiFileSystemItemUtil.getRelativePath((PsiFileSystemItem)curItem, dstItem);
            if (newName == null) {
                return element;
            }
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            newName = FileReference.encode(newName);
        }
        return this.rename(newName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.bindToElement must not be null");
        }
        return this.bindToElement(element, this.myFileReferenceSet.isAbsolutePathReference());
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        TextRange range = new TextRange(this.myFileReferenceSet.getStartInElement(), this.getRangeInElement().getEndOffset());
        ElementManipulator<PsiElement> manipulator = CachingReference.getManipulator(this.getElement());
        if (manipulator == null) {
            throw new IncorrectOperationException("Manipulator not defined for: " + this.getElement());
        }
        return manipulator.handleContentChange(this.getElement(), range, newName);
    }

    @Override
    public void registerQuickfix(HighlightInfo info, FileReference reference) {
        for (FileReferenceHelper helper : FileReference.getHelpers()) {
            helper.registerFixes(info, reference);
        }
    }

    protected static FileReferenceHelper[] getHelpers() {
        return FileReferenceHelperRegistrar.getHelpers();
    }

    public int getIndex() {
        return this.myIndex;
    }

    public String getUnresolvedMessagePattern() {
        StringBuilder builder = new StringBuilder(LangBundle.message("error.cannot.resolve", new Object[0]));
        builder.append(" ").append(this.isLast() ? LangBundle.message("terms.file", new Object[0]) : LangBundle.message("terms.directory", new Object[0]));
        builder.append(" ''{0}''");
        return builder.toString();
    }

    public final boolean isLast() {
        return this.myIndex == this.myFileReferenceSet.getAllReferences().length - 1;
    }

    @NotNull
    public FileReferenceSet getFileReferenceSet() {
        FileReferenceSet fileReferenceSet = this.myFileReferenceSet;
        if (fileReferenceSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference.getFileReferenceSet must not return null");
        }
        return fileReferenceSet;
    }

    public LocalQuickFix[] getQuickFixes() {
        ArrayList<? extends LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        for (FileReferenceHelper helper : FileReference.getHelpers()) {
            result.addAll(helper.registerFixes(null, this));
        }
        return result.toArray(new LocalQuickFix[result.size()]);
    }

    @Override
    public FileReference getLastFileReference() {
        return this.myFileReferenceSet.getLastReference();
    }

    static class MyResolver
    implements ResolveCache.PolyVariantResolver<FileReference> {
        static final MyResolver INSTANCE = new MyResolver();

        MyResolver() {
        }

        @Override
        public ResolveResult[] resolve(FileReference ref, boolean incompleteCode) {
            return ref.innerResolve(ref.getFileReferenceSet().isCaseSensitive());
        }
    }
}

