/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceHelperRegistrar {
    private FileReferenceHelperRegistrar() {
    }

    public static FileReferenceHelper[] getHelpers() {
        return (FileReferenceHelper[])Extensions.getExtensions(FileReferenceHelper.EP_NAME);
    }

    @NotNull
    public static <T extends PsiFileSystemItem> FileReferenceHelper getNotNullHelper(@NotNull T psiFileSystemItem) {
        if (psiFileSystemItem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar.getNotNullHelper must not be null");
        }
        FileReferenceHelper helper = FileReferenceHelperRegistrar.getHelper(psiFileSystemItem);
        FileReferenceHelper fileReferenceHelper = helper == null ? new NullFileReferenceHelper() : helper;
        if (fileReferenceHelper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar.getNotNullHelper must not return null");
        }
        return fileReferenceHelper;
    }

    @Nullable
    public static <T extends PsiFileSystemItem> FileReferenceHelper getHelper(@NotNull T psiFileSystemItem) {
        if (psiFileSystemItem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar.getHelper must not be null");
        }
        final VirtualFile file = psiFileSystemItem.getVirtualFile();
        if (file == null) {
            return null;
        }
        final Project project = psiFileSystemItem.getProject();
        return (FileReferenceHelper)ContainerUtil.find((Object[])FileReferenceHelperRegistrar.getHelpers(), (Condition)new Condition<FileReferenceHelper>(){

            public boolean value(FileReferenceHelper fileReferenceHelper) {
                return fileReferenceHelper.isMine(project, file);
            }
        });
    }

    public static boolean areElementsEquivalent(@NotNull PsiFileSystemItem element1, @NotNull PsiFileSystemItem element2) {
        if (element1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar.areElementsEquivalent must not be null");
        }
        if (element2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar.areElementsEquivalent must not be null");
        }
        return element2.getManager().areElementsEquivalent((PsiElement)element1, (PsiElement)element2);
    }

    private static class NullFileReferenceHelper
    extends FileReferenceHelper {
        private NullFileReferenceHelper() {
        }

        @Override
        public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar$NullFileReferenceHelper.findRoot must not be null");
            }
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile contentRootForFile = index.getContentRootForFile(file);
            return contentRootForFile != null ? PsiManager.getInstance((Project)project).findDirectory(contentRootForFile) : null;
        }

        @Override
        @NotNull
        public Collection<PsiFileSystemItem> getRoots(final @NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar$NullFileReferenceHelper.getRoots must not be null");
            }
            List list = ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots(), (Function)new Function<VirtualFile, PsiFileSystemItem>(){

                public PsiFileSystemItem fun(VirtualFile virtualFile) {
                    return PsiManager.getInstance((Project)module.getProject()).findDirectory(virtualFile);
                }
            });
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar$NullFileReferenceHelper.getRoots must not return null");
            }
            return list;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
            Collection<PsiFileSystemItem> collection;
            PsiFileSystemItem parent;
            if (file == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar$NullFileReferenceHelper.getContexts must not be null");
            }
            PsiFileSystemItem item = this.getPsiFileSystemItem(project, file);
            if (item != null && (parent = item.getParent()) != null) {
                collection = Collections.singleton(parent);
                if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar$NullFileReferenceHelper.getContexts must not return null");
                return collection;
            }
            collection = Collections.emptyList();
            if (collection != null) return collection;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar$NullFileReferenceHelper.getContexts must not return null");
        }

        @Override
        public boolean isMine(Project project, @NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar$NullFileReferenceHelper.isMine must not be null");
            }
            return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file);
        }
    }
}

