/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;

public class EnumConstantsUtil {
    private EnumConstantsUtil() {
    }

    public static boolean isSuitableForEnumConstant(PsiType constantType, PsiClass enumClass) {
        if (enumClass != null && enumClass.isEnum()) {
            for (PsiMethod constructor : enumClass.getConstructors()) {
                PsiParameter[] parameters = constructor.getParameterList().getParameters();
                if (parameters.length != 1 || !TypeConversionUtil.isAssignable((PsiType)parameters[0].getType(), (PsiType)constantType)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiEnumConstant createEnumConstant(PsiClass enumClass, String constantName, PsiExpression initializerExpr) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)enumClass.getProject()).getElementFactory();
        String enumConstantText = initializerExpr != null ? constantName + "(" + initializerExpr.getText() + ")" : constantName;
        return elementFactory.createEnumConstantFromText(enumConstantText, (PsiElement)enumClass);
    }

    public static PsiEnumConstant createEnumConstant(PsiClass enumClass, PsiLocalVariable local, String fieldName) throws IncorrectOperationException {
        return EnumConstantsUtil.createEnumConstant(enumClass, fieldName, local.getInitializer());
    }
}

