/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.testFramework.builders.EmptyModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class AbstractVcsTestCase {
    protected Project myProject;
    protected VirtualFile myWorkingCopyDir;
    protected File myClientBinaryPath;
    protected IdeaProjectTestFixture myProjectFixture;
    protected boolean myInitChangeListManager = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProcessOutput runClient(String exeName, @Nullable String stdin, @Nullable File workingDir, String[] commandLine) throws IOException {
        CapturingProcessHandler handler;
        ProcessOutput result;
        ArrayList<String> arguments = new ArrayList<String>();
        if (SystemInfo.isWindows) {
            arguments.add(new File(this.myClientBinaryPath, exeName).toString());
        } else {
            arguments.add(exeName);
        }
        Collections.addAll(arguments, commandLine);
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(arguments);
        if (workingDir != null) {
            builder.directory(workingDir);
        }
        Process clientProcess = builder.start();
        if (stdin != null) {
            OutputStream outputStream = clientProcess.getOutputStream();
            try {
                byte[] bytes = stdin.getBytes();
                outputStream.write(bytes);
            }
            finally {
                outputStream.close();
            }
        }
        if ((result = (handler = new CapturingProcessHandler(clientProcess, CharsetToolkit.getDefaultSystemCharset())).runProcess(60000)).isTimeout()) {
            throw new RuntimeException("Timeout waiting for VCS client to finish execution");
        }
        return result;
    }

    protected static ProcessOutput runArbitrary(String command, String[] args) throws IOException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        Collections.addAll(arguments, args);
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(arguments);
        Process clientProcess = builder.start();
        CapturingProcessHandler handler = new CapturingProcessHandler(clientProcess, CharsetToolkit.getDefaultSystemCharset());
        ProcessOutput result = handler.runProcess(60000);
        if (result.isTimeout()) {
            throw new RuntimeException("Timeout waiting for VCS client to finish execution");
        }
        return result;
    }

    protected void initProject(final File clientRoot) throws Exception {
        TestFixtureBuilder<IdeaProjectTestFixture> testFixtureBuilder = IdeaTestFixtureFactory.getFixtureFactory().createFixtureBuilder();
        this.myProjectFixture = testFixtureBuilder.getFixture();
        testFixtureBuilder.addModule(EmptyModuleFixtureBuilder.class).addContentRoot(clientRoot.toString());
        this.myProjectFixture.setUp();
        this.myProject = this.myProjectFixture.getProject();
        if (this.myInitChangeListManager) {
            ((ProjectComponent)ChangeListManager.getInstance((Project)this.myProject)).projectOpened();
        }
        ((ProjectComponent)VcsDirtyScopeManager.getInstance((Project)this.myProject)).projectOpened();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                AbstractVcsTestCase.this.myWorkingCopyDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(clientRoot);
                assert (AbstractVcsTestCase.this.myWorkingCopyDir != null);
            }
        });
    }

    protected void activateVCS(String vcsName) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        vcsManager.setDirectoryMapping(this.myWorkingCopyDir.getPath(), vcsName);
        vcsManager.updateActiveVcss();
        AbstractVcs vcs = vcsManager.findVcsByName(vcsName);
        Assert.assertEquals((long)1L, (long)vcsManager.getRootsUnderVcs(vcs).length);
    }

    protected VirtualFile createFileInCommand(String name, @Nullable String content) {
        return this.createFileInCommand(this.myWorkingCopyDir, name, content);
    }

    protected VirtualFile createFileInCommand(final VirtualFile parent, final String name, final @Nullable String content) {
        final Ref result = new Ref();
        new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

            protected void run() throws Throwable {
                try {
                    VirtualFile file = parent.createChildData((Object)this, name);
                    if (content != null) {
                        file.setBinaryContent(CharsetToolkit.getUtf8Bytes((String)content));
                    }
                    result.set((Object)file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }.execute();
        return (VirtualFile)result.get();
    }

    protected VirtualFile createDirInCommand(final VirtualFile parent, final String name) {
        final Ref result = new Ref();
        new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

            protected void run() throws Throwable {
                try {
                    VirtualFile dir = parent.createChildDirectory((Object)this, name);
                    result.set((Object)dir);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }.execute();
        return (VirtualFile)result.get();
    }

    protected void tearDownProject() throws Exception {
        if (this.myProject != null) {
            ((ProjectComponent)VcsDirtyScopeManager.getInstance((Project)this.myProject)).projectClosed();
            ((ProjectComponent)ChangeListManager.getInstance((Project)this.myProject)).projectClosed();
            ((ProjectComponent)ProjectLevelVcsManager.getInstance((Project)this.myProject)).projectClosed();
            this.myProject = null;
        }
        if (this.myProjectFixture != null) {
            this.myProjectFixture.tearDown();
            this.myProjectFixture = null;
        }
    }

    protected void setStandardConfirmation(String vcsName, VcsConfiguration.StandardConfirmation op, VcsShowConfirmationOption.Value value) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        AbstractVcs vcs = vcsManager.findVcsByName(vcsName);
        VcsShowConfirmationOption option = vcsManager.getStandardConfirmation(op, vcs);
        option.setValue(value);
    }

    protected static void verify(ProcessOutput runResult) {
        Assert.assertEquals((String)runResult.getStderr(), (long)0L, (long)runResult.getExitCode());
    }

    protected static void verify(ProcessOutput runResult, String ... stdoutLines) {
        AbstractVcsTestCase.verify(runResult, false, stdoutLines);
    }

    protected static void verifySorted(ProcessOutput runResult, String ... stdoutLines) {
        AbstractVcsTestCase.verify(runResult, true, stdoutLines);
    }

    private static void verify(ProcessOutput runResult, boolean sorted, String ... stdoutLines) {
        AbstractVcsTestCase.verify(runResult);
        Object[] lines = new LineTokenizer(runResult.getStdout()).execute();
        if (sorted) {
            Arrays.sort(lines);
        }
        Assert.assertEquals((String)runResult.getStdout(), (long)stdoutLines.length, (long)lines.length);
        for (int i = 0; i < stdoutLines.length; ++i) {
            Assert.assertEquals((Object)stdoutLines[i], (Object)AbstractVcsTestCase.compressWhitespace((String)lines[i]));
        }
    }

    private static String compressWhitespace(String line) {
        while (line.indexOf("  ") > 0) {
            line = line.replace("  ", " ");
        }
        return line.trim();
    }

    protected VcsDirtyScope getAllDirtyScope() {
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        dirtyScopeManager.markEverythingDirty();
        List scopes = dirtyScopeManager.retrieveScopes().getScopes();
        Assert.assertEquals((long)1L, (long)scopes.size());
        return (VcsDirtyScope)scopes.get(0);
    }

    protected VcsDirtyScope getDirtyScopeForFile(VirtualFile file) {
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        dirtyScopeManager.retrieveScopes();
        dirtyScopeManager.fileDirty(file);
        List scopes = dirtyScopeManager.retrieveScopes().getScopes();
        Assert.assertEquals((long)1L, (long)scopes.size());
        return (VcsDirtyScope)scopes.get(0);
    }

    protected void renameFileInCommand(VirtualFile file, String newName) {
        AbstractVcsTestCase.renameFileInCommand(this.myProject, file, newName);
    }

    public static void renameFileInCommand(Project project, final VirtualFile file, final String newName) {
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                try {
                    file.rename((Object)this, newName);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }.execute();
    }

    protected void renamePsiInCommand(final PsiNamedElement element, final String newName) {
        new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

            protected void run() throws Throwable {
                try {
                    element.setName(newName);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }.execute();
    }

    protected void deleteFileInCommand(VirtualFile file) {
        AbstractVcsTestCase.deleteFileInCommand(this.myProject, file);
    }

    public static void deleteFileInCommand(Project project, final VirtualFile file) {
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                try {
                    file.delete((Object)this);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }.execute();
    }

    public static void editFileInCommand(Project project, final VirtualFile file, final String newContent) {
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                try {
                    file.setBinaryContent(newContent.getBytes());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }.execute();
    }

    protected void copyFileInCommand(final VirtualFile file, final String toName) {
        new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

            protected void run() throws Throwable {
                try {
                    file.copy((Object)this, file.getParent(), toName);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }.execute();
    }

    protected void moveFileInCommand(VirtualFile file, VirtualFile newParent) {
        AbstractVcsTestCase.moveFileInCommand(this.myProject, file, newParent);
    }

    public static void moveFileInCommand(Project project, final VirtualFile file, final VirtualFile newParent) {
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                try {
                    file.move((Object)this, newParent);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }.execute();
    }

    protected void verifyChange(Change c, String beforePath, String afterPath) {
        if (beforePath == null) {
            Assert.assertNull((Object)c.getBeforeRevision());
        } else {
            this.verifyRevision(c.getBeforeRevision(), beforePath);
        }
        if (afterPath == null) {
            Assert.assertNull((Object)c.getAfterRevision());
        } else {
            this.verifyRevision(c.getAfterRevision(), afterPath);
        }
    }

    private void verifyRevision(ContentRevision beforeRevision, String beforePath) {
        File beforeFile = new File(this.myWorkingCopyDir.getPath(), beforePath);
        String beforeFullPath = FileUtil.toSystemIndependentName((String)beforeFile.getPath());
        String beforeRevPath = FileUtil.toSystemIndependentName((String)beforeRevision.getFile().getPath());
        Assert.assertTrue((boolean)beforeFullPath.equalsIgnoreCase(beforeRevPath));
    }

    public static void sortChanges(List<Change> changes) {
        Collections.sort(changes, new Comparator<Change>(){

            @Override
            public int compare(Change o1, Change o2) {
                String p1 = FileUtil.toSystemIndependentName((String)ChangesUtil.getFilePath((Change)o1).getPath());
                String p2 = FileUtil.toSystemIndependentName((String)ChangesUtil.getFilePath((Change)o2).getPath());
                return p1.compareTo(p2);
            }
        });
    }
}

