/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointTypeDialogState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointManagerImpl
implements XBreakpointManager,
PersistentStateComponent<BreakpointManagerState> {
    private final MultiValuesMap<XBreakpointType, XBreakpointBase<?, ?, ?>> myBreakpoints = new MultiValuesMap(true);
    private final Map<XBreakpointType, EventDispatcher<XBreakpointListener>> myDispatchers = new HashMap<XBreakpointType, EventDispatcher<XBreakpointListener>>();
    private final Map<XBreakpointType<?, ?>, XBreakpointTypeDialogState> myBreakpointsDialogSettings = new HashMap();
    private final EventDispatcher<XBreakpointListener> myAllBreakpointsDispatcher;
    private final XLineBreakpointManager myLineBreakpointManager;
    private final Project myProject;
    private final XDebuggerManagerImpl myDebuggerManager;
    private final XDependentBreakpointManager myDependentBreakpointManager;

    public XBreakpointManagerImpl(Project project, XDebuggerManagerImpl debuggerManager, StartupManager startupManager) {
        this.myProject = project;
        this.myDebuggerManager = debuggerManager;
        this.myAllBreakpointsDispatcher = EventDispatcher.create(XBreakpointListener.class);
        this.myDependentBreakpointManager = new XDependentBreakpointManager(this);
        this.myLineBreakpointManager = new XLineBreakpointManager(project, this.myDependentBreakpointManager, startupManager);
        if (!project.isDefault()) {
            HttpVirtualFileListener httpVirtualFileListener = new HttpVirtualFileListener(){

                public void fileDownloaded(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl$1.fileDownloaded must not be null");
                    }
                    XBreakpointManagerImpl.this.updateBreakpointInFile(file);
                }
            };
            HttpFileSystem.getInstance().addFileListener(httpVirtualFileListener, (Disposable)project);
        }
    }

    private void updateBreakpointInFile(final VirtualFile file) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                XBreakpointBase<?, ?, ?>[] breakpoints;
                for (XBreakpointBase<?, ?, ?> breakpoint : breakpoints = XBreakpointManagerImpl.this.getAllBreakpoints()) {
                    XSourcePosition position = breakpoint.getSourcePosition();
                    if (position == null || position.getFile() != file) continue;
                    XBreakpointManagerImpl.this.fireBreakpointChanged(breakpoint);
                }
            }
        });
    }

    public XLineBreakpointManager getLineBreakpointManager() {
        return this.myLineBreakpointManager;
    }

    public XDependentBreakpointManager getDependentBreakpointManager() {
        return this.myDependentBreakpointManager;
    }

    public XDebuggerManagerImpl getDebuggerManager() {
        return this.myDebuggerManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XBreakpointBase.BreakpointState state = new XBreakpointBase.BreakpointState(true, type.getId());
        XBreakpointBase breakpoint = new XBreakpointBase(type, this, properties, state);
        this.addBreakpoint(breakpoint, true);
        XBreakpointBase xBreakpointBase = breakpoint;
        if (xBreakpointBase == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.addBreakpoint must not return null");
        }
        return xBreakpointBase;
    }

    private <T extends XBreakpointProperties> void addBreakpoint(XBreakpointBase<?, T, ?> breakpoint, boolean initUI) {
        EventDispatcher<XBreakpointListener> dispatcher;
        XBreakpointType<?, T> type = breakpoint.getType();
        this.myBreakpoints.put(type, breakpoint);
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.registerBreakpoint((XLineBreakpointImpl)breakpoint, initUI);
        }
        if ((dispatcher = this.myDispatchers.get(type)) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointAdded(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointAdded(breakpoint);
    }

    private XBreakpointListener<XBreakpoint<?>> getBreakpointDispatcherMulticaster() {
        return (XBreakpointListener)this.myAllBreakpointsDispatcher.getMulticaster();
    }

    public void fireBreakpointChanged(XBreakpointBase<?, ?, ?> breakpoint) {
        EventDispatcher<XBreakpointListener> dispatcher;
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.breakpointChanged((XLineBreakpointImpl)breakpoint);
        }
        if ((dispatcher = this.myDispatchers.get(breakpoint.getType())) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointChanged(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointChanged(breakpoint);
    }

    public void removeBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.removeBreakpoint must not be null");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XBreakpointType type = breakpoint.getType();
        XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
        this.myBreakpoints.remove((Object)type, (Object)breakpointBase);
        if (breakpointBase instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.unregisterBreakpoint((XLineBreakpointImpl)breakpointBase);
        }
        breakpointBase.dispose();
        EventDispatcher<XBreakpointListener> dispatcher = this.myDispatchers.get(type);
        if (dispatcher != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointRemoved(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointRemoved(breakpoint);
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties) {
        if (fileUrl == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.addLineBreakpoint must not be null");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XLineBreakpointImpl<T> breakpoint = new XLineBreakpointImpl<T>(type, this, fileUrl, line, properties);
        this.addBreakpoint(breakpoint, true);
        XLineBreakpointImpl<T> xLineBreakpointImpl = breakpoint;
        if (xLineBreakpointImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.addLineBreakpoint must not return null");
        }
        return xLineBreakpointImpl;
    }

    @NotNull
    public XBreakpointBase<?, ?, ?>[] getAllBreakpoints() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection breakpoints = this.myBreakpoints.values();
        XBreakpointBase[] xBreakpointBaseArray = breakpoints.toArray(new XBreakpointBase[breakpoints.size()]);
        if (xBreakpointBaseArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.getAllBreakpoints must not return null");
        }
        return xBreakpointBaseArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull XBreakpointType<B, ?> type) {
        Collection collection;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.getBreakpoints must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection breakpoints = this.myBreakpoints.get(type);
        if (breakpoints == null) {
            collection = Collections.emptyList();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.getBreakpoints must not return null");
            return collection;
        }
        collection = Collections.unmodifiableCollection(breakpoints);
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.getBreakpoints must not return null");
    }

    @Nullable
    public <P extends XBreakpointProperties> XLineBreakpoint<P> findBreakpointAtLine(@NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file, int line) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.findBreakpointAtLine must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.findBreakpointAtLine must not be null");
        }
        Collection breakpoints = this.myBreakpoints.get(type);
        if (breakpoints == null) {
            return null;
        }
        for (XBreakpointBase breakpoint : breakpoints) {
            XLineBreakpoint lineBreakpoint = (XLineBreakpoint)breakpoint;
            if (!lineBreakpoint.getFileUrl().equals(file.getUrl()) || lineBreakpoint.getLine() != line) continue;
            return lineBreakpoint;
        }
        return null;
    }

    private <T extends XBreakpointProperties> EventDispatcher<XBreakpointListener> getOrCreateDispatcher(XBreakpointType<?, T> type) {
        EventDispatcher dispatcher = this.myDispatchers.get(type);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(XBreakpointListener.class);
            this.myDispatchers.put(type, (EventDispatcher<XBreakpointListener>)dispatcher);
        }
        return dispatcher;
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.addBreakpointListener must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.addBreakpointListener must not be null");
        }
        this.getOrCreateDispatcher(type).addListener(listener);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void removeBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.removeBreakpointListener must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.removeBreakpointListener must not be null");
        }
        this.getOrCreateDispatcher(type).removeListener(listener);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener, Disposable parentDisposable) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.addBreakpointListener must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.addBreakpointListener must not be null");
        }
        this.getOrCreateDispatcher(type).addListener(listener, parentDisposable);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.addBreakpointListener must not be null");
        }
        this.myAllBreakpointsDispatcher.addListener(listener);
    }

    public void removeBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.removeBreakpointListener must not be null");
        }
        this.myAllBreakpointsDispatcher.removeListener(listener);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.addBreakpointListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.addBreakpointListener must not be null");
        }
        this.myAllBreakpointsDispatcher.addListener(listener, parentDisposable);
    }

    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon, @Nullable String errorMessage) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.updateBreakpointPresentation must not be null");
        }
        CustomizedBreakpointPresentation presentation = new CustomizedBreakpointPresentation();
        presentation.setErrorMessage(errorMessage);
        presentation.setIcon(icon);
        ((XLineBreakpointImpl)breakpoint).setCustomizedPresentation(presentation);
        this.myLineBreakpointManager.queueBreakpointUpdate((XBreakpoint<?>)breakpoint);
    }

    public BreakpointManagerState getState() {
        this.myDependentBreakpointManager.saveState();
        BreakpointManagerState state = new BreakpointManagerState();
        for (XBreakpointBase xBreakpointBase : this.myBreakpoints.values()) {
            state.getBreakpoints().add((XBreakpointBase.BreakpointState)xBreakpointBase.getState());
        }
        for (Map.Entry entry : this.myBreakpointsDialogSettings.entrySet()) {
            state.getBreakpointTypeDialogProperties().put(((XBreakpointType)entry.getKey()).getId(), (XBreakpointTypeDialogState)entry.getValue());
        }
        return state;
    }

    public void loadState(BreakpointManagerState state) {
        this.myBreakpointsDialogSettings.clear();
        for (Map.Entry<String, XBreakpointTypeDialogState> entry : state.getBreakpointTypeDialogProperties().entrySet()) {
            XBreakpointType<?, ?> type = XBreakpointUtil.findType(entry.getKey());
            if (type == null) continue;
            this.myBreakpointsDialogSettings.put(type, entry.getValue());
        }
        this.removeAllBreakpoints();
        for (XBreakpointBase.BreakpointState breakpointState : state.getBreakpoints()) {
            XBreakpointBase<?, ?, ?> breakpoint = this.createBreakpoint(breakpointState);
            if (breakpoint == null) continue;
            this.addBreakpoint(breakpoint, false);
        }
        this.myDependentBreakpointManager.loadState();
        this.myLineBreakpointManager.updateBreakpointsUI();
    }

    @Nullable
    public XBreakpointTypeDialogState getDialogState(@NotNull XBreakpointType<?, ?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.getDialogState must not be null");
        }
        return this.myBreakpointsDialogSettings.get(type);
    }

    public void putDialogState(@NotNull XBreakpointType<?, ?> type, XBreakpointTypeDialogState dialogState) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl.putDialogState must not be null");
        }
        this.myBreakpointsDialogSettings.put(type, dialogState);
    }

    private void removeAllBreakpoints() {
        for (XBreakpointBase breakpoint : this.myBreakpoints.values()) {
            this.removeBreakpoint(breakpoint);
        }
    }

    @Nullable
    private XBreakpointBase<?, ?, ?> createBreakpoint(XBreakpointBase.BreakpointState breakpointState) {
        XBreakpointType<?, ?> type = XBreakpointUtil.findType(breakpointState.getTypeId());
        if (type == null) {
            return null;
        }
        return breakpointState.createBreakpoint(type, this);
    }

    @Tag(value="breakpoint-manager")
    public static class BreakpointManagerState {
        private List<XBreakpointBase.BreakpointState> myBreakpoints = new ArrayList<XBreakpointBase.BreakpointState>();
        private Map<String, XBreakpointTypeDialogState> myBreakpointTypeDialogProperties = new HashMap<String, XBreakpointTypeDialogState>();

        @Tag(value="breakpoints")
        @AbstractCollection(surroundWithTag=false, elementTypes={XBreakpointBase.BreakpointState.class, XLineBreakpointImpl.LineBreakpointState.class})
        public List<XBreakpointBase.BreakpointState> getBreakpoints() {
            return this.myBreakpoints;
        }

        @Tag(value="dialog-properties")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, keyAttributeName="type-id", entryTagName="breakpoints-dialog")
        public Map<String, XBreakpointTypeDialogState> getBreakpointTypeDialogProperties() {
            return this.myBreakpointTypeDialogProperties;
        }

        public void setBreakpoints(List<XBreakpointBase.BreakpointState> breakpoints) {
            this.myBreakpoints = breakpoints;
        }

        public void setBreakpointTypeDialogProperties(Map<String, XBreakpointTypeDialogState> breakpointTypeDialogProperties) {
            this.myBreakpointTypeDialogProperties = breakpointTypeDialogProperties;
        }
    }
}

