/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerNodeLink;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueNodeImpl
extends XValueContainerNode<XValue>
implements XValueNode,
XCompositeNode {
    private String myName;
    private String myType;
    private String myValue;
    private XFullValueEvaluator myFullValueEvaluator;
    private String mySeparator;
    private boolean myChanged;

    public XValueNodeImpl(XDebuggerTree tree, XDebuggerTreeNode parent, XValue value) {
        super(tree, parent, value);
        this.myText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
        value.computePresentation((XValueNode)this);
    }

    public void setPresentation(@NotNull String name, @Nullable Icon icon, @Nullable String type, @NotNull String value, boolean hasChildren) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl.setPresentation must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl.setPresentation must not be null");
        }
        this.setPresentation(name, icon, type, " = ", value, hasChildren);
    }

    public void setPresentation(final @NonNls @NotNull String name, final @Nullable Icon icon, final @NonNls @Nullable String type, final @NonNls @NotNull String separator, final @NonNls @NotNull String value, final boolean hasChildren) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl.setPresentation must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl.setPresentation must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl.setPresentation must not be null");
        }
        DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

            @Override
            public void run() {
                XValueNodeImpl.this.setIcon(icon);
                XValueNodeImpl.this.myName = name;
                XValueNodeImpl.this.myValue = value;
                XValueNodeImpl.this.mySeparator = separator;
                XValueNodeImpl.this.myType = type;
                XValueNodeImpl.this.updateText();
                XValueNodeImpl.this.setLeaf(!hasChildren);
                XValueNodeImpl.this.fireNodeChanged();
                XValueNodeImpl.this.myTree.nodeLoaded(XValueNodeImpl.this, name, value);
            }
        });
    }

    public void setFullValueEvaluator(final @NotNull XFullValueEvaluator fullValueEvaluator) {
        if (fullValueEvaluator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl.setFullValueEvaluator must not be null");
        }
        DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

            @Override
            public void run() {
                XValueNodeImpl.this.myFullValueEvaluator = fullValueEvaluator;
                XValueNodeImpl.this.fireNodeChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText() {
        String value;
        this.myText.clear();
        this.myText.append(this.myName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        this.myText.append(this.mySeparator, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myType != null) {
            this.myText.append("{" + this.myType + "} ", XDebuggerUIConstants.TYPE_ATTRIBUTES);
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            StringUtil.escapeStringCharacters((int)this.myValue.length(), (String)this.myValue, null, (StringBuilder)builder);
            value = builder.toString();
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
        this.myText.append(value, this.myChanged ? XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public void markChanged() {
        if (this.myChanged) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myChanged = true;
        if (this.myName != null && this.myValue != null) {
            this.updateText();
            this.fireNodeChanged();
        }
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Override
    public XDebuggerNodeLink getLink() {
        if (this.myFullValueEvaluator != null) {
            return new XDebuggerNodeLink(this.myFullValueEvaluator.getLinkText()){

                @Override
                public void onClick(MouseEvent event) {
                    DebuggerUIUtil.showValuePopup(XValueNodeImpl.this.myFullValueEvaluator, event, XValueNodeImpl.this.myTree.getProject());
                }
            };
        }
        return null;
    }

    @Nullable
    public String getValue() {
        return this.myValue;
    }

    public void setValueModificationStarted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myValue = null;
        this.myText.clear();
        this.myText.append(this.myName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        this.myText.append(this.mySeparator, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myText.append(XDebuggerUIConstants.MODIFYING_VALUE_MESSAGE, XDebuggerUIConstants.MODIFYING_VALUE_HIGHLIGHT_ATTRIBUTES);
        this.setLeaf(true);
        this.fireNodeChildrenChanged();
    }
}

