/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNSDescriptorSequence
implements XmlNSDescriptor {
    final List<XmlNSDescriptor> sequence = new ArrayList<XmlNSDescriptor>();

    public XmlNSDescriptorSequence() {
    }

    public XmlNSDescriptorSequence(XmlNSDescriptor[] descriptors) {
        for (int i = 0; i < descriptors.length; ++i) {
            XmlNSDescriptor descriptor = descriptors[i];
            this.add(descriptor);
        }
    }

    public void add(XmlNSDescriptor descriptor) {
        this.sequence.add(descriptor);
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlNSDescriptorSequence.getElementDescriptor must not be null");
        }
        for (XmlNSDescriptor descriptor : this.sequence) {
            XmlElementDescriptor elementDescriptor = descriptor.getElementDescriptor(tag);
            if (elementDescriptor == null) continue;
            return elementDescriptor;
        }
        return null;
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        ArrayList<XmlElementDescriptor> descriptors = new ArrayList<XmlElementDescriptor>();
        for (XmlNSDescriptor descriptor : this.sequence) {
            descriptors.addAll(Arrays.asList(descriptor.getRootElementsDescriptors(document)));
        }
        XmlElementDescriptor[] xmlElementDescriptorArray = descriptors.toArray(new XmlElementDescriptor[descriptors.size()]);
        if (xmlElementDescriptorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/XmlNSDescriptorSequence.getRootElementsDescriptors must not return null");
        }
        return xmlElementDescriptorArray;
    }

    public XmlFile getDescriptorFile() {
        for (XmlNSDescriptor descriptor : this.sequence) {
            XmlFile file = descriptor.getDescriptorFile();
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public List<XmlNSDescriptor> getSequence() {
        return this.sequence;
    }

    public boolean isHierarhyEnabled() {
        for (XmlNSDescriptor descriptor : this.sequence) {
            if (!descriptor.isHierarhyEnabled()) continue;
            return true;
        }
        return false;
    }

    public PsiElement getDeclaration() {
        for (XmlNSDescriptor descriptor : this.sequence) {
            PsiElement declaration = descriptor.getDeclaration();
            if (declaration == null) continue;
            return declaration;
        }
        return null;
    }

    public String getName(PsiElement context) {
        for (XmlNSDescriptor descriptor : this.sequence) {
            String name = descriptor.getName(context);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public String getName() {
        for (XmlNSDescriptor descriptor : this.sequence) {
            String name = descriptor.getName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public void init(PsiElement element) {
        for (XmlNSDescriptor descriptor : this.sequence) {
            descriptor.init(element);
        }
    }

    public Object[] getDependences() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (XmlNSDescriptor descriptor : this.sequence) {
            ret.addAll(Arrays.asList(descriptor.getDependences()));
        }
        return ret.toArray();
    }
}

