/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationListener;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.text.SyncDateFormat;
import git4idea.GitRevisionNumber;
import git4idea.actions.GitShowAllSubmittedFilesAction;
import git4idea.i18n.GitBundle;
import java.awt.Cursor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitFileAnnotation
implements FileAnnotation {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.annotate.GitFileAnnotation");
    private static final SyncDateFormat DATE_FORMAT = new SyncDateFormat(SimpleDateFormat.getDateInstance(3));
    private final StringBuffer myContentBuffer;
    private final ArrayList<LineInfo> myLines;
    private final Project myProject;
    private final EventDispatcher<AnnotationListener> myListeners;
    private final Map<VcsRevisionNumber, VcsFileRevision> myRevisionMap;
    private final VirtualFileAdapter myFileListener;
    private final MyFileStatusListener myFileStatusListener;
    private final VirtualFile myFile;
    private final boolean myMonitorFlag;
    private final LineAnnotationAspect DATE_ASPECT;
    private final LineAnnotationAspect REVISION_ASPECT;
    private final LineAnnotationAspect AUTHOR_ASPECT;

    public GitFileAnnotation(@NotNull Project project, @NotNull VirtualFile file, boolean monitorFlag) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/annotate/GitFileAnnotation.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/annotate/GitFileAnnotation.<init> must not be null");
        }
        this.myContentBuffer = new StringBuffer();
        this.myLines = new ArrayList();
        this.myListeners = EventDispatcher.create(AnnotationListener.class);
        this.myRevisionMap = new HashMap<VcsRevisionNumber, VcsFileRevision>();
        this.DATE_ASPECT = new LineAnnotationAspectAdapter(){

            public String getValue(int lineNumber) {
                if (GitFileAnnotation.this.myLines.size() <= lineNumber || lineNumber < 0 || GitFileAnnotation.this.myLines.get(lineNumber) == null) {
                    return "";
                }
                Date date = ((LineInfo)GitFileAnnotation.this.myLines.get(lineNumber)).getDate();
                return date == null ? "" : DATE_FORMAT.format(date);
            }
        };
        this.REVISION_ASPECT = new RevisionAnnotationAspect();
        this.AUTHOR_ASPECT = new LineAnnotationAspectAdapter(){

            public String getValue(int lineNumber) {
                if (GitFileAnnotation.this.myLines.size() <= lineNumber || lineNumber < 0 || GitFileAnnotation.this.myLines.get(lineNumber) == null) {
                    return "";
                }
                String author = ((LineInfo)GitFileAnnotation.this.myLines.get(lineNumber)).getAuthor();
                return author == null ? "" : author;
            }
        };
        this.myProject = project;
        this.myFile = file;
        this.myMonitorFlag = monitorFlag;
        if (this.myMonitorFlag) {
            this.myFileListener = new VirtualFileAdapter(){

                public void contentsChanged(VirtualFileEvent event) {
                    if (GitFileAnnotation.this.myFile != event.getFile()) {
                        return;
                    }
                    if (!event.isFromRefresh()) {
                        return;
                    }
                    GitFileAnnotation.this.fireAnnotationChanged();
                }
            };
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myFileListener);
            this.myFileStatusListener = new MyFileStatusListener();
            FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener((FileStatusListener)this.myFileStatusListener);
        } else {
            this.myFileListener = null;
            this.myFileStatusListener = null;
        }
    }

    public void addLogEntries(List<VcsFileRevision> revisions) {
        for (VcsFileRevision vcsFileRevision : revisions) {
            this.myRevisionMap.put(vcsFileRevision.getRevisionNumber(), vcsFileRevision);
        }
    }

    private void fireAnnotationChanged() {
        ((AnnotationListener)this.myListeners.getMulticaster()).onAnnotationChanged();
    }

    public void addListener(AnnotationListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void removeListener(AnnotationListener listener) {
        this.myListeners.removeListener((EventListener)listener);
    }

    public void dispose() {
        if (this.myMonitorFlag) {
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myFileListener);
            FileStatusManager.getInstance((Project)this.myProject).removeFileStatusListener((FileStatusListener)this.myFileStatusListener);
        }
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    public String getToolTip(int lineNumber) {
        if (this.myLines.size() <= lineNumber || lineNumber < 0) {
            return "";
        }
        LineInfo info = this.myLines.get(lineNumber);
        if (info == null) {
            return "";
        }
        VcsFileRevision fileRevision = this.myRevisionMap.get(info.getRevision());
        if (fileRevision != null) {
            return GitBundle.message("annotation.tool.tip", info.getRevision().asString(), fileRevision.getAuthor(), fileRevision.getRevisionDate(), fileRevision.getCommitMessage());
        }
        return "";
    }

    public String getAnnotatedContent() {
        return this.myContentBuffer.toString();
    }

    public List<VcsFileRevision> getRevisions() {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>(this.myRevisionMap.values());
        Collections.sort(result, new Comparator<VcsFileRevision>(){

            @Override
            public int compare(VcsFileRevision o1, VcsFileRevision o2) {
                return -1 * o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber());
            }
        });
        return result;
    }

    public boolean revisionsNotEmpty() {
        return !this.myRevisionMap.isEmpty();
    }

    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        return null;
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        if (this.myLines.size() <= lineNumber || lineNumber < 0 || this.myLines.get(lineNumber) == null) {
            return null;
        }
        LineInfo lineInfo = this.myLines.get(lineNumber);
        return lineInfo == null ? null : lineInfo.getRevision();
    }

    public VcsRevisionNumber originalRevision(int lineNumber) {
        return this.getLineRevisionNumber(lineNumber);
    }

    public void appendLineInfo(Date date, GitRevisionNumber revision, String author, String line, long lineNumber) throws VcsException {
        int expectedLineNo = this.myLines.size() + 1;
        if (lineNumber != (long)expectedLineNo) {
            throw new VcsException("Adding for info for line " + lineNumber + " but we are expecting it to be for " + expectedLineNo);
        }
        this.myLines.add(new LineInfo(date, revision, author));
        this.myContentBuffer.append(line);
    }

    private class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/annotate/GitFileAnnotation$MyFileStatusListener.fileStatusChanged must not be null");
            }
            if (GitFileAnnotation.this.myFile.equals(virtualFile)) {
                this.checkAndFire();
            }
        }

        private void checkAndFire() {
            if (FileStatus.NOT_CHANGED.equals(FileStatusManager.getInstance((Project)GitFileAnnotation.this.myProject).getStatus(GitFileAnnotation.this.myFile))) {
                GitFileAnnotation.this.fireAnnotationChanged();
            }
        }
    }

    static class LineInfo {
        private final Date myDate;
        private final GitRevisionNumber myRevision;
        private final String myAuthor;

        public LineInfo(Date date, GitRevisionNumber revision, String author) {
            this.myDate = date;
            this.myRevision = revision;
            this.myAuthor = author;
        }

        public Date getDate() {
            return this.myDate;
        }

        public GitRevisionNumber getRevision() {
            return this.myRevision;
        }

        public String getAuthor() {
            return this.myAuthor;
        }
    }

    private class RevisionAnnotationAspect
    extends LineAnnotationAspectAdapter
    implements EditorGutterAction {
        private RevisionAnnotationAspect() {
        }

        public String getValue(int lineNumber) {
            if (GitFileAnnotation.this.myLines.size() <= lineNumber || lineNumber < 0 || GitFileAnnotation.this.myLines.get(lineNumber) == null) {
                return "";
            }
            GitRevisionNumber revision = ((LineInfo)GitFileAnnotation.this.myLines.get(lineNumber)).getRevision();
            return revision == null ? "" : String.valueOf(revision.getShortRev());
        }

        public Cursor getCursor(int lineNum) {
            return Cursor.getPredefinedCursor(12);
        }

        public void doAction(int lineNum) {
            if (lineNum >= 0 && lineNum < GitFileAnnotation.this.myLines.size()) {
                LineInfo info = (LineInfo)GitFileAnnotation.this.myLines.get(lineNum);
                VcsFileRevision revision = (VcsFileRevision)GitFileAnnotation.this.myRevisionMap.get(info.getRevision());
                if (revision != null) {
                    GitShowAllSubmittedFilesAction.showSubmittedFiles(GitFileAnnotation.this.myProject, revision, GitFileAnnotation.this.myFile);
                }
            }
        }
    }
}

