/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class Comparing {
    private Comparing() {
    }

    public static <T> boolean equal(T arg1, T arg2) {
        if (arg1 == null || arg2 == null) {
            return arg1 == arg2;
        }
        if (arg1 instanceof Object[] && arg2 instanceof Object[]) {
            Object[] arr1 = (Object[])arg1;
            Object[] arr2 = (Object[])arg2;
            return Arrays.equals(arr1, arr2);
        }
        if (arg1 instanceof CharSequence && arg2 instanceof CharSequence) {
            return Comparing.equal((CharSequence)arg1, (CharSequence)arg2, true);
        }
        return arg1.equals(arg2);
    }

    public static <T> boolean equal(T[] arr1, T[] arr2) {
        if (arr1 == null || arr2 == null) {
            return arr1 == arr2;
        }
        return Arrays.equals(arr1, arr2);
    }

    public static boolean equal(CharSequence s1, CharSequence s2) {
        return Comparing.equal(s1, s2, true);
    }

    public static boolean equal(String arg1, String arg2) {
        return Comparing.equal(arg1, arg2, true);
    }

    public static boolean equal(CharSequence s1, CharSequence s2, boolean caseSensitive) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        int to = 0;
        int po = 0;
        if (s1.length() != s2.length()) {
            return false;
        }
        int len = s1.length();
        while (len-- > 0) {
            char c2;
            char c1;
            if ((c1 = s1.charAt(to++)) == (c2 = s2.charAt(po++)) || !caseSensitive && StringUtil.charsEqualIgnoreCase(c1, c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(String arg1, String arg2, boolean caseSensitive) {
        if (arg1 == null || arg2 == null) {
            return arg1 == arg2;
        }
        return caseSensitive ? arg1.equals(arg2) : arg1.equalsIgnoreCase(arg2);
    }

    public static boolean strEqual(String arg1, String arg2) {
        return Comparing.strEqual(arg1, arg2, true);
    }

    public static boolean strEqual(String arg1, String arg2, boolean caseSensitive) {
        return Comparing.equal(arg1 == null ? "" : arg1, arg2 == null ? "" : arg2, caseSensitive);
    }

    public static <T> boolean haveEqualElements(Collection<T> a, Collection<T> b) {
        if (a.size() != b.size()) {
            return false;
        }
        HashSet<T> aSet = new HashSet<T>(a);
        for (T t : b) {
            if (aSet.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean haveEqualElements(T[] a, T[] b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length != b.length) {
            return false;
        }
        HashSet<T> aSet = new HashSet<T>(Arrays.asList(a));
        for (T t : b) {
            if (aSet.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static int hashcode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static int hashcode(Object obj1, Object obj2) {
        return Comparing.hashcode(obj1) ^ Comparing.hashcode(obj2);
    }

    public static int compare(int name1, int name2) {
        return name1 < name2 ? -1 : (name1 == name2 ? 0 : 1);
    }

    public static <T extends Comparable<T>> int compare(T name1, T name2) {
        if (name1 == null) {
            return name2 == null ? 0 : -1;
        }
        if (name2 == null) {
            return 1;
        }
        return name1.compareTo(name2);
    }
}

