/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.FileIndexImplUtil;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.profile.ProjectProfileManager;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.analysis.AnalysisScope");
    public static final DataKey<AnalysisScope> KEY = DataKey.create("analysisScope");
    public static final int PROJECT = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE = 3;
    public static final int MODULE = 4;
    public static final int INVALID = 6;
    public static final int MODULES = 7;
    public static final int CUSTOM = 8;
    public static final int VIRTUAL_FILES = 9;
    public static int UNCOMMITED_FILES = 10;
    private final Project myProject;
    protected List<Module> myModules;
    protected Module myModule;
    protected PsiElement myElement;
    private final SearchScope myScope;
    private boolean mySearchInLibraries;
    protected int myType;
    protected HashSet<VirtualFile> myFilesSet;
    protected boolean myIncludeTestSource;

    public AnalysisScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/AnalysisScope.<init> must not be null");
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myType = 1;
    }

    public AnalysisScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/AnalysisScope.<init> must not be null");
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = null;
        this.myElement = null;
        this.myModules = null;
        this.myScope = null;
        this.myModule = module;
        this.myType = 4;
    }

    public AnalysisScope(@NotNull Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/AnalysisScope.<init> must not be null");
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myModules = Arrays.asList(modules);
        this.myModule = null;
        this.myProject = null;
        this.myElement = null;
        this.myScope = null;
        this.myType = 7;
    }

    public AnalysisScope(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/AnalysisScope.<init> must not be null");
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myElement = psiDirectory;
        this.myType = 2;
    }

    public AnalysisScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/AnalysisScope.<init> must not be null");
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = null;
        this.myElement = psiFile;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myType = 3;
    }

    public AnalysisScope(@NotNull SearchScope scope, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/AnalysisScope.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/analysis/AnalysisScope.<init> must not be null");
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = scope;
        this.myType = 8;
        this.mySearchInLibraries = scope instanceof GlobalSearchScope && ((GlobalSearchScope)scope).isSearchInLibraries();
    }

    public AnalysisScope(@NotNull Project project, @NotNull Collection<VirtualFile> virtualFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/AnalysisScope.<init> must not be null");
        }
        if (virtualFiles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/analysis/AnalysisScope.<init> must not be null");
        }
        this.mySearchInLibraries = false;
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myFilesSet = new HashSet<VirtualFile>(virtualFiles);
        this.myType = 9;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        this.mySearchInLibraries = searchInLibraries;
    }

    public void setIncludeTestSource(boolean includeTestSource) {
        this.myIncludeTestSource = includeTestSource;
    }

    protected PsiElementVisitor createFileSearcher() {
        final FileIndex fileIndex = this.myModule != null ? ModuleRootManager.getInstance(this.myModule).getFileIndex() : (this.myModules != null && !this.myModules.isEmpty() ? ProjectRootManager.getInstance(this.myModules.get(0).getProject()).getFileIndex() : (this.myElement != null ? ProjectRootManager.getInstance(this.myElement.getProject()).getFileIndex() : (this.myProject != null ? ProjectRootManager.getInstance(this.myProject).getFileIndex() : null)));
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return new PsiRecursiveElementVisitor(){

            @Override
            public void visitFile(PsiFile file) {
                if (AnalysisScope.this.mySearchInLibraries || !(file instanceof PsiCompiledElement)) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile == null) {
                        return;
                    }
                    if (!AnalysisScope.this.myIncludeTestSource && (fileIndex == null || fileIndex.isInTestSourceContent(virtualFile))) {
                        return;
                    }
                    AnalysisScope.this.myFilesSet.add(virtualFile);
                    if (indicator != null) {
                        indicator.setText(AnalysisScopeBundle.message("scanning.scope.progress.title", new Object[0]));
                        indicator.setText2(ProjectUtil.calcRelativeToProjectPath(virtualFile, file.getProject()));
                    }
                }
            }
        };
    }

    public boolean contains(PsiElement psiElement) {
        return this.contains(psiElement.getContainingFile().getVirtualFile());
    }

    public boolean contains(VirtualFile file) {
        if (this.myFilesSet == null) {
            if (this.myType == 8) {
                if (this.myScope instanceof GlobalSearchScope) {
                    return ((GlobalSearchScope)this.myScope).contains(file);
                }
                if (this.myScope instanceof LocalSearchScope) {
                    return ((LocalSearchScope)this.myScope).isInScope(file);
                }
            }
            if (this.myType == 1) {
                ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                return index.isInContent(file) && (this.myIncludeTestSource || !index.isInTestSourceContent(file));
            }
            this.initFilesSet();
        }
        return this.myFilesSet.contains(file);
    }

    protected void initFilesSet() {
        if (this.myType == 3) {
            this.myFilesSet = new HashSet(1);
            this.myFilesSet.add(((PsiFileSystemItem)this.myElement).getVirtualFile());
        } else if (this.myType == 2 || this.myType == 1 || this.myType == 7 || this.myType == 4 || this.myType == 8) {
            this.myFilesSet = new HashSet();
            this.accept(this.createFileSearcher());
        }
    }

    public void accept(PsiElementVisitor visitor) {
        this.accept(visitor, !ApplicationManager.getApplication().isReadAccessAllowed());
    }

    protected void accept(final PsiElementVisitor visitor, final boolean needReadAction) {
        if (this.myType == 9) {
            PsiManager psiManager = PsiManager.getInstance(this.myProject);
            for (VirtualFile file : this.myFilesSet) {
                if (AnalysisScope.processFile(file, visitor, psiManager, needReadAction)) continue;
                return;
            }
        } else if (this.myScope instanceof GlobalSearchScope) {
            final PsiManager psiManager = PsiManager.getInstance(this.myProject);
            final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            ContentIterator contentIterator = new ContentIterator(){

                @Override
                public boolean processFile(final VirtualFile fileOrDir) {
                    if (fileOrDir.isDirectory()) {
                        return true;
                    }
                    boolean isInScope = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                        public Boolean compute() {
                            return ((GlobalSearchScope)AnalysisScope.this.myScope).contains(fileOrDir);
                        }
                    });
                    if (isInScope && (AnalysisScope.this.myIncludeTestSource || !projectFileIndex.isInTestSourceContent(fileOrDir))) {
                        return AnalysisScope.processFile(fileOrDir, visitor, psiManager, needReadAction);
                    }
                    return true;
                }
            };
            projectFileIndex.iterateContent(contentIterator);
            if (this.mySearchInLibraries) {
                VirtualFile[] libraryRoots;
                for (VirtualFile libraryRoot : libraryRoots = LibraryUtil.getLibraryRoots(this.myProject, false, false)) {
                    FileIndexImplUtil.iterateRecursively(libraryRoot, VirtualFileFilter.ALL, contentIterator);
                }
            }
        } else if (this.myScope instanceof LocalSearchScope) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiElement[] psiElements;
                    for (PsiElement element : psiElements = ((LocalSearchScope)AnalysisScope.this.myScope).getScope()) {
                        element.accept(visitor);
                    }
                }
            });
        } else if (this.myModule != null) {
            final ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(this.myModule).getFileIndex();
            final PsiManager psiManager = PsiManager.getInstance(this.myModule.getProject());
            moduleFileIndex.iterateContent(new ContentIterator(){

                @Override
                public boolean processFile(VirtualFile fileOrDir) {
                    return AnalysisScope.this.processFile(fileOrDir, visitor, moduleFileIndex, psiManager, needReadAction);
                }
            });
        } else if (this.myModules != null) {
            for (Module module : this.myModules) {
                final PsiManager psiManager = PsiManager.getInstance(module.getProject());
                final ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
                moduleFileIndex.iterateContent(new ContentIterator(){

                    @Override
                    public boolean processFile(VirtualFile fileOrDir) {
                        return AnalysisScope.this.processFile(fileOrDir, visitor, moduleFileIndex, psiManager, needReadAction);
                    }
                });
            }
        } else if (this.myElement instanceof PsiDirectory) {
            this.accept((PsiDirectory)this.myElement, visitor, needReadAction);
        } else if (this.myElement != null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    AnalysisScope.this.myElement.accept(visitor);
                }
            });
        } else if (this.myProject != null) {
            final PsiManager psiManager = PsiManager.getInstance(this.myProject);
            final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            projectFileIndex.iterateContent(new ContentIterator(){

                @Override
                public boolean processFile(VirtualFile fileOrDir) {
                    return AnalysisScope.this.processFile(fileOrDir, visitor, projectFileIndex, psiManager, needReadAction);
                }
            });
        }
    }

    private boolean processFile(VirtualFile fileOrDir, PsiElementVisitor visitor, FileIndex projectFileIndex, PsiManager psiManager, boolean needReadAction) {
        if (fileOrDir.isDirectory()) {
            return true;
        }
        if (projectFileIndex.isInContent(fileOrDir) && (this.myIncludeTestSource || !projectFileIndex.isInTestSourceContent(fileOrDir))) {
            return AnalysisScope.processFile(fileOrDir, visitor, psiManager, needReadAction);
        }
        return true;
    }

    private static boolean processFile(VirtualFile fileOrDir, final PsiElementVisitor visitor, final PsiManager psiManager, boolean needReadAction) {
        if (!fileOrDir.isValid()) {
            return false;
        }
        final PsiFile file = AnalysisScope.getPsiFileInReadAction(psiManager, fileOrDir);
        if (file == null) {
            return true;
        }
        if (needReadAction) {
            PsiDocumentManager.getInstance(psiManager.getProject()).commitAndRunReadAction(new Runnable(){

                @Override
                public void run() {
                    file.accept(visitor);
                    psiManager.dropResolveCaches();
                }
            });
        } else {
            file.accept(visitor);
            psiManager.dropResolveCaches();
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return indicator == null || !indicator.isCanceled();
    }

    protected void accept(@NotNull PsiDirectory dir, final @NotNull PsiElementVisitor visitor, final boolean needReadAction) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/AnalysisScope.accept must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/analysis/AnalysisScope.accept must not be null");
        }
        Project project = dir.getProject();
        final PsiManager psiManager = PsiManager.getInstance(project);
        final ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
        index.iterateContentUnderDirectory(dir.getVirtualFile(), new ContentIterator(){

            @Override
            public boolean processFile(VirtualFile fileOrDir) {
                if (!AnalysisScope.this.myIncludeTestSource && index.isInTestSourceContent(fileOrDir)) {
                    return true;
                }
                if (!fileOrDir.isDirectory()) {
                    return AnalysisScope.processFile(fileOrDir, visitor, psiManager, needReadAction);
                }
                return true;
            }
        });
    }

    public boolean isValid() {
        if (this.myProject != null) {
            return true;
        }
        if (this.myModule != null && !this.myModule.isDisposed()) {
            return true;
        }
        if (this.myModules != null) {
            for (Module module : this.myModules) {
                if (!module.isDisposed()) continue;
                return false;
            }
            return true;
        }
        return this.myType == 9 || this.myType == 8 || this.myElement != null && this.myElement.isValid();
    }

    public int getScopeType() {
        return this.myType;
    }

    public String getDisplayName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", AnalysisScope.pathToName(this.myModule.getModuleFilePath()));
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, (Function)new Function<Module, String>(){

                    public String fun(Module module) {
                        return AnalysisScope.pathToName(module.getModuleFilePath());
                    }
                }, (String)", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", AnalysisScope.pathToName(this.myProject.getPresentableUrl()));
            }
            case 3: {
                VirtualFile virtualFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                LOG.assertTrue(virtualFile != null);
                return AnalysisScopeBundle.message("scope.file", virtualFile.getPresentableUrl());
            }
            case 2: {
                return AnalysisScopeBundle.message("scope.directory", ((PsiFileSystemItem)this.myElement).getVirtualFile().getPresentableUrl());
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.virtual.files", new Object[0]);
            }
        }
        return "";
    }

    public String getShortenName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", this.myModule.getName());
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, (Function)new Function<Module, String>(){

                    public String fun(Module module) {
                        return module.getName();
                    }
                }, (String)", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", this.myProject.getName());
            }
            case 3: {
                return AnalysisScopeBundle.message("scope.file", ProjectUtil.calcRelativeToProjectPath(((PsiFileSystemItem)this.myElement).getVirtualFile(), this.myElement.getProject()));
            }
            case 2: {
                return AnalysisScopeBundle.message("scope.directory", ProjectUtil.calcRelativeToProjectPath(((PsiFileSystemItem)this.myElement).getVirtualFile(), this.myElement.getProject()));
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.selected.files", new Object[0]);
            }
        }
        return "";
    }

    private static String pathToName(String path) {
        String name = path;
        if (path != null) {
            File file = new File(path);
            name = FileUtil.getNameWithoutExtension((File)file);
        }
        return name;
    }

    public int getFileCount() {
        ProgressIndicator indicator;
        if (this.myFilesSet == null) {
            this.initFilesSet();
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText("");
            indicator.setText2("");
        }
        return this.myFilesSet.size();
    }

    public void invalidate() {
        if (this.myType != 9) {
            this.myFilesSet = null;
        } else {
            Iterator<VirtualFile> i = this.myFilesSet.iterator();
            while (i.hasNext()) {
                VirtualFile virtualFile = i.next();
                if (virtualFile != null && virtualFile.isValid()) continue;
                i.remove();
            }
        }
    }

    private static PsiFile getPsiFileInReadAction(final PsiManager psiManager, final VirtualFile file) {
        return ApplicationManager.getApplication().runReadAction(new Computable<PsiFile>(){

            @Nullable
            public PsiFile compute() {
                PsiFile psiFile = psiManager.findFile(file);
                return psiFile != null && psiFile.isValid() ? psiFile : null;
            }
        });
    }

    protected static void processDirectories(PsiDirectory[] psiDirectories, Set<String> result, ProjectProfileManager profileManager) {
        for (final PsiDirectory directory : psiDirectories) {
            PsiFile[] psiFiles;
            for (PsiFile file : psiFiles = ApplicationManager.getApplication().runReadAction(new Computable<PsiFile[]>(){

                public PsiFile[] compute() {
                    return directory.getFiles();
                }
            })) {
                result.add(profileManager.getProfileName());
            }
            AnalysisScope.processDirectories(ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory[]>(){

                public PsiDirectory[] compute() {
                    return directory.getSubdirectories();
                }
            }), result, profileManager);
        }
    }

    private static void processModule(Set<String> result, Module module) {
        Project project = module.getProject();
        ProjectProfileManager profileManager = ProjectProfileManager.getProjectProfileManager(project, "INSPECTION");
        LOG.assertTrue(profileManager != null);
        VirtualFile[] files = ModuleRootManager.getInstance(module).getContentRoots();
        PsiDirectory[] dirs = new PsiDirectory[files.length];
        final PsiManager psiManager = PsiManager.getInstance(project);
        int i = 0;
        for (final VirtualFile file : files) {
            dirs[i++] = ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory>(){

                @Nullable
                public PsiDirectory compute() {
                    return psiManager.findDirectory(file);
                }
            });
        }
        AnalysisScope.processDirectories(dirs, result, profileManager);
    }

    public boolean containsSources(boolean isTest) {
        if (this.myElement != null) {
            VirtualFile file;
            Project project = this.myElement.getProject();
            ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
            if (this.myElement instanceof PsiDirectory) {
                VirtualFile directory = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                if (index.isInSourceContent(directory)) {
                    return isTest ? index.isInTestSourceContent(directory) : !index.isInTestSourceContent(directory);
                }
            } else if (this.myElement instanceof PsiFile && (file = ((PsiFileSystemItem)this.myElement).getVirtualFile()) != null) {
                return isTest ? index.isInTestSourceContent(file) : !index.isInTestSourceContent(file);
            }
        }
        return true;
    }

    public AnalysisScope[] getNarrowedComplementaryScope(Project defaultProject) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(defaultProject).getFileIndex();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myType == 3) {
            VirtualFile vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 2) {
            VirtualFile vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 4) {
            modules.add(this.myModule);
        } else if (this.myType == 7) {
            modules.addAll(this.myModules);
        }
        return AnalysisScope.collectScopes(defaultProject, modules);
    }

    protected static AnalysisScope[] collectScopes(Project defaultProject, HashSet<Module> modules) {
        if (modules.isEmpty()) {
            return new AnalysisScope[]{new AnalysisScope(defaultProject)};
        }
        HashSet<AnalysisScope> result = new HashSet<AnalysisScope>();
        Module[] allModules = ModuleManager.getInstance(defaultProject).getModules();
        for (Module module : modules) {
            Set<Module> modulesToAnalyze = AnalysisScope.getDirectBackwardDependencies(module, allModules);
            modulesToAnalyze.addAll(AnalysisScope.getExportBackwardDependencies(module, allModules));
            modulesToAnalyze.add(module);
            result.add(new AnalysisScope(modulesToAnalyze.toArray(new Module[modulesToAnalyze.size()])));
        }
        return result.toArray(new AnalysisScope[result.size()]);
    }

    private static Set<Module> getExportBackwardDependencies(Module fromModule, Module[] allModules) {
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : allModules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof ModuleOrderEntry) || !((ExportableOrderEntry)orderEntry).isExported() || fromModule != ((ModuleOrderEntry)orderEntry).getModule()) continue;
                result.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            }
        }
        return result;
    }

    private static Set<Module> getDirectBackwardDependencies(Module module, Module[] allModules) {
        HashSet<Module> result = new HashSet<Module>();
        for (Module dependency : allModules) {
            if (ArrayUtil.find((Object[])ModuleRootManager.getInstance(dependency).getDependencies(), (Object)module) <= -1) continue;
            result.add(dependency);
        }
        return result;
    }

    protected static HashSet<Module> getAllInterestingModules(ProjectFileIndex fileIndex, VirtualFile vFile) {
        HashSet<Module> modules = new HashSet<Module>();
        if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(vFile)) {
                modules.add(orderEntry.getOwnerModule());
            }
        } else {
            modules.add(fileIndex.getModuleForFile(vFile));
        }
        return modules;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public SearchScope toSearchScope() {
        SearchScope searchScope;
        block10: {
            switch (this.myType) {
                case 8: {
                    searchScope = this.myScope;
                    if (searchScope == null) break;
                    return searchScope;
                }
                case 2: 
                case 3: {
                    searchScope = new LocalSearchScope(this.myElement);
                    if (searchScope == null) break;
                    return searchScope;
                }
                case 6: {
                    searchScope = LocalSearchScope.EMPTY;
                    if (searchScope == null) break;
                    return searchScope;
                }
                case 4: {
                    GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope(this.myModule);
                    searchScope = this.myIncludeTestSource ? moduleScope : GlobalSearchScope.notScope(GlobalSearchScope.projectTestScope(this.myModule.getProject())).intersectWith(moduleScope);
                    if (searchScope == null) break;
                    return searchScope;
                }
                case 7: {
                    void var2_3;
                    GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                    for (Module module : this.myModules) {
                        SearchScope searchScope2 = var2_3.union(GlobalSearchScope.moduleScope(module));
                    }
                    searchScope = var2_3;
                    if (searchScope == null) break;
                    return searchScope;
                }
                case 1: {
                    searchScope = this.myIncludeTestSource ? GlobalSearchScope.projectScope(this.myProject) : GlobalSearchScope.projectProductionScope(this.myProject);
                    if (searchScope == null) break;
                    return searchScope;
                }
                case 9: {
                    searchScope = new GlobalSearchScope(){

                        @Override
                        public boolean contains(VirtualFile file) {
                            return AnalysisScope.this.myFilesSet.contains(file);
                        }

                        @Override
                        public int compare(VirtualFile file1, VirtualFile file2) {
                            return 0;
                        }

                        @Override
                        public boolean isSearchInModuleContent(@NotNull Module aModule) {
                            if (aModule == null) {
                                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/AnalysisScope$16.isSearchInModuleContent must not be null");
                            }
                            return false;
                        }

                        @Override
                        public boolean isSearchInLibraries() {
                            return false;
                        }
                    };
                    if (searchScope == null) break;
                    return searchScope;
                }
                default: {
                    LOG.error("invalid type " + this.myType);
                    searchScope = GlobalSearchScope.EMPTY_SCOPE;
                    if (searchScope != null) break block10;
                }
            }
            throw new IllegalStateException("@NotNull method com/intellij/analysis/AnalysisScope.toSearchScope must not return null");
        }
        return searchScope;
    }

    public boolean isAnalyzeTestsByDefault() {
        switch (this.myType) {
            case 2: {
                return ProjectRootManager.getInstance(this.myElement.getProject()).getFileIndex().isInTestSourceContent(((PsiDirectory)this.myElement).getVirtualFile());
            }
            case 3: {
                PsiFile containingFile = this.myElement.getContainingFile();
                return ProjectRootManager.getInstance(this.myElement.getProject()).getFileIndex().isInTestSourceContent(containingFile.getVirtualFile());
            }
            case 4: {
                return AnalysisScope.isTestOnly(this.myModule);
            }
            case 7: {
                for (Module module : this.myModules) {
                    if (AnalysisScope.isTestOnly(module)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isTestOnly(Module module) {
        ContentEntry[] contentEntries;
        for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance(module).getContentEntries()) {
            for (SourceFolder folder : contentEntry.getSourceFolders()) {
                if (folder.isTestSource()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isIncludeTestSource() {
        return this.myIncludeTestSource;
    }
}

