/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.statistics.impl.StatisticsManagerImpl;
import com.intellij.testFramework.LightCodeInsightTestCase;
import java.util.Arrays;

public abstract class LightCompletionTestCase
extends LightCodeInsightTestCase {
    protected String myPrefix;
    protected LookupElement[] myItems;
    private CompletionType myType = CompletionType.BASIC;

    protected void setUp() throws Exception {
        super.setUp();
        ((StatisticsManagerImpl)StatisticsManager.getInstance()).clearStatistics();
    }

    protected void tearDown() throws Exception {
        LookupManager.getInstance((Project)LightCompletionTestCase.getProject()).hideActiveLookup();
        super.tearDown();
    }

    protected void configureByFile(String filePath) throws Exception {
        super.configureByFile(filePath);
        this.complete();
    }

    protected void configureByFileNoComplete(String filePath) throws Exception {
        super.configureByFile(filePath);
    }

    protected void complete() {
        this.complete(1);
    }

    protected void complete(int time) {
        new CodeCompletionHandlerBase(this.myType).invokeCompletion(LightCompletionTestCase.getProject(), LightCompletionTestCase.getEditor(), LightCompletionTestCase.getFile(), time);
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)myEditor);
        this.myItems = lookup == null ? null : lookup.getItems().toArray(LookupElement.EMPTY_ARRAY);
        this.myPrefix = lookup == null ? null : ((LookupElement)((Object)lookup.getItems().get(0))).getPrefixMatcher().getPrefix();
    }

    public void setType(CompletionType type) {
        this.myType = type;
    }

    protected void selectItem(LookupElement item) {
        this.selectItem(item, '\u0000');
    }

    protected void selectItem(LookupElement item, char completionChar) {
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance((Project)LightCompletionTestCase.getProject()).getActiveLookup();
        lookup.setCurrentItem(item);
        if (completionChar == '\u0000' || completionChar == '\n' || completionChar == '\t') {
            lookup.finishLookup(completionChar);
        } else {
            LightCompletionTestCase.type((char)completionChar);
        }
    }

    protected void testByCount(int finalCount, String ... values) {
        if (this.myItems == null) {
            LightCompletionTestCase.assertEquals((int)finalCount, (int)0);
            return;
        }
        int index = 0;
        block0: for (LookupElement myItem : this.myItems) {
            for (String value : values) {
                if (value == null) {
                    LightCompletionTestCase.assertFalse((String)("Unacceptable value reached: " + myItem.getLookupString()), (boolean)true);
                }
                if (!value.equals(myItem.getLookupString())) continue;
                ++index;
                continue block0;
            }
        }
        LightCompletionTestCase.assertEquals((int)finalCount, (int)index);
    }

    protected void assertStringItems(String ... items) {
        LightCompletionTestCase.assertEquals((String)Arrays.asList(this.myItems).toString(), (int)items.length, (int)this.myItems.length);
        for (int i = 0; i < this.myItems.length; ++i) {
            LookupElement item = this.myItems[i];
            LightCompletionTestCase.assertEquals((String)items[i], (String)item.getLookupString());
        }
    }

    protected static LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup((Editor)myEditor);
    }
}

