/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaExecutionUtil {
    private JavaExecutionUtil() {
    }

    public static boolean executeRun(@NotNull Project project, String contentName, Icon icon, DataContext dataContext) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/JavaExecutionUtil.executeRun must not be null");
        }
        return JavaExecutionUtil.executeRun(project, contentName, icon, dataContext, null);
    }

    public static boolean executeRun(@NotNull Project project, String contentName, Icon icon, DataContext dataContext, Filter[] filters) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/JavaExecutionUtil.executeRun must not be null");
        }
        JavaParameters cmdLine = JavaParameters.JAVA_PARAMETERS.getData(dataContext);
        DefaultRunProfile profile = new DefaultRunProfile(project, cmdLine, contentName, icon, filters);
        ProgramRunner runner = RunnerRegistry.getInstance().getRunner(DefaultRunExecutor.EXECUTOR_ID, profile);
        if (runner != null) {
            runner.execute(DefaultRunExecutor.getRunExecutorInstance(), new ExecutionEnvironment(profile, dataContext));
            return true;
        }
        return false;
    }

    @Nullable
    public static String getRuntimeQualifiedName(PsiClass aClass) {
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null) {
            String parentName = JavaExecutionUtil.getRuntimeQualifiedName(containingClass);
            return parentName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    @Nullable
    public static String getPresentableClassName(String rtClassName, JavaRunConfigurationModule configurationModule) {
        PsiClass psiClass = configurationModule.findClass(rtClassName);
        if (psiClass != null) {
            return psiClass.getName();
        }
        int lastDot = rtClassName.lastIndexOf(46);
        if (lastDot == -1 || lastDot == rtClassName.length() - 1) {
            return rtClassName;
        }
        return rtClassName.substring(lastDot + 1, rtClassName.length());
    }

    public static Module findModule(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/JavaExecutionUtil.findModule must not be null");
        }
        return ModuleUtil.findModuleForPsiElement(psiClass);
    }

    @Nullable
    public static PsiClass findMainClass(Module module, String mainClassName) {
        return JavaExecutionUtil.findMainClass(module.getProject(), mainClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module));
    }

    @Nullable
    public static PsiClass findMainClass(Project project, String mainClassName, GlobalSearchScope scope) {
        PsiManager psiManager = PsiManager.getInstance(project);
        String shortName = StringUtil.getShortName((String)mainClassName);
        String packageName = StringUtil.getPackageName((String)mainClassName);
        return JavaPsiFacade.getInstance(psiManager.getProject()).findClass(StringUtil.getQualifiedName((String)packageName, (String)shortName.replace('$', '.')), scope);
    }

    public static boolean isNewName(String name) {
        return name == null || name.startsWith(ExecutionBundle.message("run.configuration.unnamed.name.prefix", new Object[0]));
    }

    public static Location stepIntoSingleClass(Location location) {
        PsiClassOwner psiFile;
        PsiClass[] classes;
        Object element = location.getPsiElement();
        if (!(element instanceof PsiClassOwner)) {
            if (PsiTreeUtil.getParentOfType(element, PsiClass.class) != null) {
                return location;
            }
            if ((element = PsiTreeUtil.getParentOfType(element, PsiClassOwner.class)) == null) {
                return location;
            }
        }
        if ((classes = (psiFile = (PsiClassOwner)element).getClasses()).length != 1) {
            return location;
        }
        return PsiLocation.fromPsiElement(classes[0]);
    }

    public static String getShortClassName(String fqName) {
        if (fqName == null) {
            return "";
        }
        int dotIndex = fqName.lastIndexOf(46);
        if (dotIndex == fqName.length() - 1) {
            return "";
        }
        if (dotIndex < 0) {
            return fqName;
        }
        return fqName.substring(dotIndex + 1, fqName.length());
    }

    public static void showExecutionErrorMessage(ExecutionException e, String title, Project project) {
        ExecutionErrorDialog.show(e, title, project);
    }

    public static boolean isRunnableClass(PsiClass aClass) {
        return PsiClassUtil.isRunnableClass(aClass, true);
    }

    private static final class DefaultRunProfile
    implements RunProfile {
        private final JavaParameters myParameters;
        private final String myContentName;
        private final Filter[] myFilters;
        private final Project myProject;
        private Icon myIcon;

        public DefaultRunProfile(Project project, JavaParameters parameters, String contentName, Icon icon, Filter[] filters) {
            this.myProject = project;
            this.myParameters = parameters;
            this.myContentName = contentName;
            this.myFilters = filters;
            this.myIcon = icon;
        }

        @Override
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/JavaExecutionUtil$DefaultRunProfile.getState must not be null");
            }
            if (env == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/JavaExecutionUtil$DefaultRunProfile.getState must not be null");
            }
            JavaCommandLineState state = new JavaCommandLineState(env){

                @Override
                protected JavaParameters createJavaParameters() {
                    return DefaultRunProfile.this.myParameters;
                }
            };
            TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
            if (this.myFilters != null) {
                for (Filter myFilter : this.myFilters) {
                    builder.addFilter(myFilter);
                }
            }
            state.setConsoleBuilder(builder);
            return state;
        }

        @Override
        public String getName() {
            return this.myContentName;
        }

        @Override
        public void checkConfiguration() {
        }
    }
}

