/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class ConsoleViewContentType {
    private final String myName;
    private final TextAttributes myTextAttributes;
    private final TextAttributesKey myTextAttributesKey;
    private static final Map<Key, ConsoleViewContentType> ourRegisteredTypes = new HashMap();
    public static final ColorKey CONSOLE_BACKGROUND_KEY = ColorKey.createColorKey("CONSOLE_BACKGROUND_KEY");
    public static final TextAttributesKey NORMAL_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey("CONSOLE_NORMAL_OUTPUT");
    public static final TextAttributesKey ERROR_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey("CONSOLE_ERROR_OUTPUT");
    public static final TextAttributesKey USER_INPUT_KEY = TextAttributesKey.createTextAttributesKey("CONSOLE_USER_INPUT");
    public static final TextAttributesKey SYSTEM_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey("CONSOLE_SYSTEM_OUTPUT");
    public static final ConsoleViewContentType NORMAL_OUTPUT = new ConsoleViewContentType("NORMAL_OUTPUT", NORMAL_OUTPUT_KEY);
    public static final ConsoleViewContentType ERROR_OUTPUT = new ConsoleViewContentType("ERROR_OUTPUT", ERROR_OUTPUT_KEY);
    public static final ConsoleViewContentType USER_INPUT = new ConsoleViewContentType("USER_OUTPUT", USER_INPUT_KEY);
    public static final ConsoleViewContentType SYSTEM_OUTPUT = new ConsoleViewContentType("SYSTEM_OUTPUT", SYSTEM_OUTPUT_KEY);

    public ConsoleViewContentType(@NonNls String name, TextAttributes textAttributes) {
        this.myName = name;
        this.myTextAttributes = textAttributes;
        this.myTextAttributesKey = null;
    }

    public ConsoleViewContentType(@NonNls String name, TextAttributesKey textAttributesKey) {
        this.myName = name;
        this.myTextAttributes = null;
        this.myTextAttributesKey = textAttributesKey;
    }

    public String toString() {
        return this.myName;
    }

    public TextAttributes getAttributes() {
        if (this.myTextAttributesKey != null) {
            return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(this.myTextAttributesKey);
        }
        return this.myTextAttributes;
    }

    public static synchronized void registerNewConsoleViewType(Key processOutputType, ConsoleViewContentType attributes) {
        ourRegisteredTypes.put(processOutputType, attributes);
    }

    public static synchronized ConsoleViewContentType getConsoleViewType(Key processOutputType) {
        if (ourRegisteredTypes.containsKey(processOutputType)) {
            return ourRegisteredTypes.get(processOutputType);
        }
        return SYSTEM_OUTPUT;
    }

    static {
        ourRegisteredTypes.put(ProcessOutputTypes.SYSTEM, SYSTEM_OUTPUT);
        ourRegisteredTypes.put(ProcessOutputTypes.STDOUT, NORMAL_OUTPUT);
        ourRegisteredTypes.put(ProcessOutputTypes.STDERR, ERROR_OUTPUT);
    }
}

