/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.PropertyUtil");

    private PropertyUtil() {
    }

    public static boolean isSimplePropertyGetter(PsiMethod method) {
        return PropertyUtil.hasGetterName(method) && method.getParameterList().getParametersCount() == 0;
    }

    public static boolean hasGetterName(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        PsiType returnType = method.getReturnType();
        if (methodName.startsWith("get") && methodName.length() > "get".length()) {
            if (Character.isLowerCase(methodName.charAt("get".length())) && (methodName.length() == "get".length() + 1 || Character.isLowerCase(methodName.charAt("get".length() + 1)))) {
                return false;
            }
            return returnType == null || !PsiType.VOID.equals(returnType);
        }
        if (methodName.startsWith("is")) {
            return PropertyUtil.isBoolean(returnType);
        }
        return false;
    }

    public static boolean isSimplePropertySetter(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        if (!methodName.startsWith("set") || methodName.length() <= "set".length()) {
            return false;
        }
        if (Character.isLowerCase(methodName.charAt("set".length())) && (methodName.length() == "set".length() + 1 || Character.isLowerCase(methodName.charAt("set".length() + 1)))) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (returnType == null || PsiType.VOID.equals(returnType)) {
            return true;
        }
        return Comparing.equal((Object)PsiUtil.resolveClassInType(returnType), (Object)method.getContainingClass());
    }

    @Nullable
    public static String getPropertyName(PsiMethod method) {
        if (PropertyUtil.isSimplePropertyGetter(method)) {
            return PropertyUtil.getPropertyNameByGetter(method);
        }
        if (PropertyUtil.isSimplePropertySetter(method)) {
            return PropertyUtil.getPropertyNameBySetter(method);
        }
        return null;
    }

    @NotNull
    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        String methodName = getterMethod.getName();
        String string = methodName.startsWith("get") ? StringUtil.decapitalize((String)methodName.substring(3)) : StringUtil.decapitalize((String)methodName.substring(2));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PropertyUtil.getPropertyNameByGetter must not return null");
        }
        return string;
    }

    @NotNull
    public static String getPropertyNameBySetter(PsiMethod setterMethod) {
        String methodName = setterMethod.getName();
        String string = Introspector.decapitalize(methodName.substring(3));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PropertyUtil.getPropertyNameBySetter must not return null");
        }
        return string;
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PropertyUtil.getAllProperties must not be null");
        }
        Map<String, PsiMethod> map = PropertyUtil.getAllProperties(psiClass, acceptSetters, acceptGetters, true);
        if (map == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PropertyUtil.getAllProperties must not return null");
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters, boolean includeSuperClass) {
        PsiMethod[] methods;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PropertyUtil.getAllProperties must not be null");
        }
        HashMap<String, PsiMethod> map = new HashMap<String, PsiMethod>();
        for (PsiMethod method : methods = includeSuperClass ? psiClass.getAllMethods() : psiClass.getMethods()) {
            if (PropertyUtil.filterMethods(method) || (!acceptSetters || !PropertyUtil.isSimplePropertySetter(method)) && (!acceptGetters || !PropertyUtil.isSimplePropertyGetter(method))) continue;
            map.put(PropertyUtil.getPropertyName(method), method);
        }
        HashMap<String, PsiMethod> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PropertyUtil.getAllProperties must not return null");
        }
        return hashMap;
    }

    private static boolean filterMethods(PsiMethod method) {
        if (method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
            return true;
        }
        String className = method.getContainingClass().getQualifiedName();
        return className != null && className.equals("java.lang.Object");
    }

    @NotNull
    public static List<PsiMethod> getSetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PropertyUtil.getSetters must not be null");
        }
        String setterName = PropertyUtil.suggestSetterName(propertyName);
        PsiMethod[] psiMethods = psiClass.findMethodsByName(setterName, true);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>(psiMethods.length);
        for (PsiMethod method : psiMethods) {
            if (PropertyUtil.filterMethods(method) || !PropertyUtil.isSimplePropertySetter(method)) continue;
            list.add(method);
        }
        ArrayList<PsiMethod> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PropertyUtil.getSetters must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getGetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PropertyUtil.getGetters must not be null");
        }
        String[] names = PropertyUtil.suggestGetterNames(propertyName);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        for (String name : names) {
            PsiMethod[] psiMethods;
            for (PsiMethod method : psiMethods = psiClass.findMethodsByName(name, true)) {
                if (PropertyUtil.filterMethods(method) || !PropertyUtil.isSimplePropertyGetter(method)) continue;
                list.add(method);
            }
        }
        ArrayList<PsiMethod> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PropertyUtil.getGetters must not return null");
        }
        return arrayList;
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertyGetter(method) || !PropertyUtil.getPropertyNameByGetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertyGetterWithType(String propertyName, boolean isStatic, PsiType type, Iterator<PsiMethod> methods) {
        while (methods.hasNext()) {
            PsiMethod method = methods.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertyGetter(method) || !PropertyUtil.getPropertyNameByGetter(method).equals(propertyName) || !type.equals(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return PropertyUtil.isSimplePropertyGetter(method) || PropertyUtil.isSimplePropertySetter(method);
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertySetter(method) || !PropertyUtil.getPropertyNameBySetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertySetterWithType(String propertyName, boolean isStatic, PsiType type, Iterator<PsiMethod> methods) {
        while (methods.hasNext()) {
            PsiType methodType;
            PsiMethod method = methods.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertySetter(method) || !PropertyUtil.getPropertyNameBySetter(method).equals(propertyName) || !type.equals(methodType = method.getParameterList().getParameters()[0].getType())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyField(Project project, PsiClass aClass, String propertyName, boolean isStatic) {
        PsiField[] fields;
        for (PsiField field : fields = aClass.getAllFields()) {
            if (field.hasModifierProperty("static") != isStatic || !propertyName.equals(PropertyUtil.suggestPropertyName(project, field))) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyFieldWithType(Project project, String propertyName, boolean isStatic, PsiType type, Iterator<PsiField> fields) {
        while (fields.hasNext()) {
            PsiField field = fields.next();
            if (field.hasModifierProperty("static") != isStatic || !propertyName.equals(PropertyUtil.suggestPropertyName(project, field)) || !type.equals(field.getType())) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static String getPropertyName(@NonNls String methodName) {
        return StringUtil.getPropertyName((String)methodName);
    }

    public static String suggestGetterName(@NonNls @NotNull String propertyName, @Nullable PsiType propertyType) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PropertyUtil.suggestGetterName must not be null");
        }
        return PropertyUtil.suggestGetterName(propertyName, propertyType, null);
    }

    public static String suggestGetterName(@NotNull String propertyName, @Nullable PsiType propertyType, @NonNls String existingGetterName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PropertyUtil.suggestGetterName must not be null");
        }
        StringBuffer name = new StringBuffer(StringUtil.capitalizeWithJavaBeanConvention((String)propertyName));
        if (PropertyUtil.isBoolean(propertyType)) {
            if (existingGetterName == null || !existingGetterName.startsWith("get")) {
                name.insert(0, "is");
            } else {
                name.insert(0, "get");
            }
        } else {
            name.insert(0, "get");
        }
        return name.toString();
    }

    private static boolean isBoolean(@Nullable PsiType propertyType) {
        return PsiType.BOOLEAN.equals(propertyType);
    }

    @NonNls
    public static String[] suggestGetterNames(String propertyName) {
        String str = StringUtil.capitalizeWithJavaBeanConvention((String)propertyName);
        return new String[]{"is" + str, "get" + str};
    }

    public static String suggestSetterName(@NonNls String propertyName) {
        StringBuffer name = new StringBuffer(StringUtil.capitalizeWithJavaBeanConvention((String)propertyName));
        name.insert(0, "set");
        return name.toString();
    }

    public static String[] getReadableProperties(PsiClass aClass, boolean includeSuperClass) {
        ArrayList<String> result = new ArrayList<String>();
        PsiMethod[] methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtil.isSimplePropertyGetter(method)) continue;
            result.add(PropertyUtil.getPropertyName(method));
        }
        return ArrayUtil.toStringArray(result);
    }

    public static String[] getWritableProperties(PsiClass aClass, boolean includeSuperClass) {
        ArrayList<String> result = new ArrayList<String>();
        PsiMethod[] methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtil.isSimplePropertySetter(method)) continue;
            result.add(PropertyUtil.getPropertyName(method));
        }
        return ArrayUtil.toStringArray(result);
    }

    public static PsiMethod generateGetterPrototype(PsiField field) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(field.getProject()).getElementFactory();
        Project project = field.getProject();
        String name = field.getName();
        String getName = PropertyUtil.suggestGetterName(project, field);
        try {
            PsiMethod getMethod = factory.createMethod(getName, field.getType());
            PsiUtil.setModifierProperty(getMethod, "public", true);
            if (field.hasModifierProperty("static")) {
                PsiUtil.setModifierProperty(getMethod, "static", true);
            }
            PropertyUtil.annotateWithNullableStuff(field, factory, getMethod);
            PsiCodeBlock body = factory.createCodeBlockFromText("{\nreturn " + name + ";\n}", null);
            getMethod.getBody().replace(body);
            getMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(getMethod);
            return getMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static PsiMethod generateSetterPrototype(PsiField field) {
        return PropertyUtil.generateSetterPrototype(field, field.getContainingClass());
    }

    public static PsiMethod generateSetterPrototype(PsiField field, PsiClass containingClass) {
        return PropertyUtil.generateSetterPrototype(field, containingClass, false);
    }

    public static PsiMethod generateSetterPrototype(PsiField field, PsiClass containingClass, boolean returnSelf) {
        Project project = field.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
        PsiElementFactory factory = JavaPsiFacade.getInstance(field.getProject()).getElementFactory();
        String name = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String propertyName = codeStyleManager.variableNameToPropertyName(name, kind);
        String setName = PropertyUtil.suggestSetterName(project, field);
        try {
            PsiMethod setMethod = factory.createMethod(setName, returnSelf ? factory.createType(containingClass) : PsiType.VOID);
            String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            PsiParameter param = factory.createParameter(parameterName, field.getType());
            PropertyUtil.annotateWithNullableStuff(field, factory, param);
            setMethod.getParameterList().add(param);
            PsiUtil.setModifierProperty(setMethod, "public", true);
            PsiUtil.setModifierProperty(setMethod, "static", isStatic);
            StringBuffer buffer = new StringBuffer();
            buffer.append("{\n");
            if (name.equals(parameterName)) {
                if (!isStatic) {
                    buffer.append("this.");
                } else {
                    String className = containingClass.getName();
                    if (className != null) {
                        buffer.append(className);
                        buffer.append(".");
                    }
                }
            }
            buffer.append(name);
            buffer.append("=");
            buffer.append(parameterName);
            buffer.append(";\n");
            if (returnSelf) {
                buffer.append("return this;\n");
            }
            buffer.append("}");
            PsiCodeBlock body = factory.createCodeBlockFromText(buffer.toString(), null);
            setMethod.getBody().replace(body);
            setMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(setMethod);
            return setMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static void annotateWithNullableStuff(PsiModifierListOwner field, PsiElementFactory factory, PsiModifierListOwner listOwner) throws IncorrectOperationException {
        if (AnnotationUtil.isAnnotated(field, "org.jetbrains.annotations.NotNull", false)) {
            PropertyUtil.annotate(factory, listOwner, "org.jetbrains.annotations.NotNull");
        } else if (AnnotationUtil.isAnnotated(field, "org.jetbrains.annotations.Nullable", false)) {
            PropertyUtil.annotate(factory, listOwner, "org.jetbrains.annotations.Nullable");
        }
    }

    private static void annotate(PsiElementFactory factory, PsiModifierListOwner listOwner, String annotationQName) throws IncorrectOperationException {
        PsiModifierList modifierList = listOwner.getModifierList();
        LOG.assertTrue(modifierList != null);
        modifierList.addAfter(factory.createAnnotationFromText("@" + annotationQName, listOwner), null);
    }

    public static String suggestPropertyName(Project project, PsiField field) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
        VariableKind kind = codeStyleManager.getVariableKind(field);
        return codeStyleManager.variableNameToPropertyName(field.getName(), kind);
    }

    public static String suggestGetterName(Project project, PsiField field) {
        String propertyName = PropertyUtil.suggestPropertyName(project, field);
        return PropertyUtil.suggestGetterName(propertyName, field.getType());
    }

    public static String suggestSetterName(Project project, PsiField field) {
        String propertyName = PropertyUtil.suggestPropertyName(project, field);
        return PropertyUtil.suggestSetterName(propertyName);
    }

    @Nullable
    public static String suggestPropertyAccessor(String name, PsiMethod accessorTemplate) {
        if (PropertyUtil.isSimplePropertyGetter(accessorTemplate)) {
            PsiType type = accessorTemplate.getReturnType();
            return PropertyUtil.suggestGetterName(name, type, accessorTemplate.getName());
        }
        if (PropertyUtil.isSimplePropertySetter(accessorTemplate)) {
            return PropertyUtil.suggestSetterName(name);
        }
        return null;
    }

    @Nullable
    public static String getPropertyName(PsiMember member) {
        if (member instanceof PsiMethod) {
            return PropertyUtil.getPropertyName((PsiMethod)member);
        }
        if (member instanceof PsiField) {
            return member.getName();
        }
        return null;
    }

    @Nullable
    public static PsiType getPropertyType(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getType();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnType();
            }
            if (PropertyUtil.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getType();
            }
        }
        return null;
    }

    @Nullable
    public static PsiTypeElement getPropertyTypeElement(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getTypeElement();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnTypeElement();
            }
            if (PropertyUtil.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getTypeElement();
            }
        }
        return null;
    }

    @Nullable
    public static PsiIdentifier getPropertyNameIdentifier(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getNameIdentifier();
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).getNameIdentifier();
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyFieldByMember(PsiMember psiMember) {
        if (psiMember instanceof PsiField) {
            return (PsiField)psiMember;
        }
        if (psiMember instanceof PsiMethod) {
            PsiElement resolved;
            PsiExpression target;
            PsiStatement statement;
            PsiMethod psiMethod = (PsiMethod)psiMember;
            PsiType returnType = psiMethod.getReturnType();
            if (returnType == null) {
                return null;
            }
            PsiCodeBlock body = psiMethod.getBody();
            PsiStatement[] statements = body == null ? null : body.getStatements();
            PsiStatement psiStatement = statement = statements == null || statements.length != 1 ? null : statements[0];
            if (PsiType.VOID.equals(returnType)) {
                PsiExpression expression = statement instanceof PsiExpressionStatement ? ((PsiExpressionStatement)statement).getExpression() : null;
                target = expression instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)expression).getLExpression() : null;
            } else {
                target = statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
            }
            PsiElement psiElement = resolved = target instanceof PsiReferenceExpression ? ((PsiReferenceExpression)target).resolve() : null;
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                if (psiMember.getContainingClass() == field.getContainingClass() || psiMember.getContainingClass().isInheritor(field.getContainingClass(), true)) {
                    return field;
                }
            }
        }
        return null;
    }
}

