/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomJavaUtil {
    private DomJavaUtil() {
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull PsiFile file, @Nullable Module module, @Nullable GlobalSearchScope searchScope) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/DomJavaUtil.findClass must not be null");
        }
        if (name == null) {
            return null;
        }
        if (name.indexOf(36) >= 0) {
            name = name.replace('$', '.');
        }
        GlobalSearchScope scope = searchScope == null ? (module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module) : file.getResolveScope()) : searchScope;
        PsiClass aClass = JavaPsiFacade.getInstance(file.getProject()).findClass(name, scope);
        if (aClass != null) assert (aClass.isValid()) : name;
        return aClass;
    }

    public static PsiClass findClass(String name, @NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/DomJavaUtil.findClass must not be null");
        }
        XmlElement xmlElement = element.getXmlElement();
        if (xmlElement != null) {
            return DomJavaUtil.findClass(name, (XmlFile)xmlElement.getContainingFile(), element.getModule(), element.getResolveScope());
        }
        return null;
    }
}

