/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import com.siyeh.ig.ui.RemoveAction;
import com.siyeh.ig.ui.TreeClassChooserAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IOResourceInspection
extends ResourceInspection {
    @NonNls
    public String ignoredTypesString = "java.io.ByteArrayOutputStream,java.io.ByteArrayInputStream,java.io.StringBufferInputStream,java.io.CharArrayWriter,java.io.CharArrayReader,java.io.StringWriter,java.io.StringReader";
    final List<String> ignoredTypes = new ArrayList<String>();

    public IOResourceInspection() {
        IOResourceInspection.parseString(this.ignoredTypesString, this.ignoredTypes);
    }

    @NotNull
    public String getID() {
        if ("IOResourceOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/IOResourceInspection.getID must not return null");
        }
        return "IOResourceOpenedButNotSafelyClosed";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("i.o.resource.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/IOResourceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("resource.opened.not.closed.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/IOResourceInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        IGTable table = new IGTable(new ListWrappingTableModel(this.ignoredTypes, "ignored io resource types"));
        JScrollPane scrollPane = new JScrollPane((Component)((Object)table));
        panel.add((Component)scrollPane, constraints);
        constraints.gridx = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 1;
        constraints.fill = 2;
        JButton addButton = new JButton(new TreeClassChooserAction(table, "Choose io resource type to ignore"));
        panel.add((Component)addButton, constraints);
        constraints.gridy = 1;
        JButton removeButton = new JButton(new RemoveAction(table));
        panel.add((Component)removeButton, constraints);
        return panel;
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        IOResourceInspection.parseString(this.ignoredTypesString, this.ignoredTypes);
    }

    public void writeSettings(Element element) throws WriteExternalException {
        this.ignoredTypesString = IOResourceInspection.formatString(this.ignoredTypes);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IOResourceVisitor();
    }

    public boolean isIOResource(PsiExpression expression) {
        return TypeUtils.expressionHasTypeOrSubtype(expression, "java.io.InputStream", "java.io.Writer", "java.io.Reader", "java.io.RandomAccessFile", "java.io.OutputStream") != null && !this.isIgnoredType(expression);
    }

    private boolean isIgnoredType(PsiExpression expression) {
        return TypeUtils.expressionHasTypeOrSubtype(expression, this.ignoredTypes);
    }

    private boolean isArgumentOfResourceCreation(PsiVariable boundVariable, PsiElement scope) {
        UsedAsIOResourceArgumentVisitor visitor = new UsedAsIOResourceArgumentVisitor(boundVariable);
        scope.accept((PsiElementVisitor)visitor);
        return visitor.usedAsArgumentToResourceCreation();
    }

    private class UsedAsIOResourceArgumentVisitor
    extends JavaRecursiveElementVisitor {
        private boolean usedAsArgToResourceCreation = false;
        private final PsiVariable ioResource;

        private UsedAsIOResourceArgumentVisitor(PsiVariable ioResource) {
            this.ioResource = ioResource;
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/IOResourceInspection$UsedAsIOResourceArgumentVisitor.visitNewExpression must not be null");
            }
            if (this.usedAsArgToResourceCreation) {
                return;
            }
            super.visitNewExpression(expression);
            if (!IOResourceInspection.this.isIOResource((PsiExpression)expression)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (argument == null || !(argument instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)argument).resolve();
            if (referent == null || !referent.equals(this.ioResource)) {
                return;
            }
            this.usedAsArgToResourceCreation = true;
        }

        public boolean usedAsArgumentToResourceCreation() {
            return this.usedAsArgToResourceCreation;
        }
    }

    private class IOResourceVisitor
    extends BaseInspectionVisitor {
        private IOResourceVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/IOResourceInspection$IOResourceVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(expression);
            if (!IOResourceInspection.this.isIOResource((PsiExpression)expression)) {
                return;
            }
            PsiElement parent = ResourceInspection.getExpressionParent((PsiExpression)expression);
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            if (parent instanceof PsiExpressionList) {
                PsiElement grandParent = parent.getParent();
                if (grandParent instanceof PsiAnonymousClass) {
                    grandParent = grandParent.getParent();
                }
                if (grandParent instanceof PsiNewExpression && IOResourceInspection.this.isIOResource((PsiExpression)((PsiNewExpression)grandParent))) {
                    return;
                }
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(parent);
            PsiElement containingBlock = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiCodeBlock.class);
            if (containingBlock == null) {
                return;
            }
            if (IOResourceInspection.this.isArgumentOfResourceCreation(boundVariable, containingBlock)) {
                return;
            }
            if (ResourceInspection.isSafelyClosed(boundVariable, (PsiExpression)expression)) {
                return;
            }
            if (ResourceInspection.isResourceEscapedFromMethod(boundVariable, (PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }
    }
}

