/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class CleanupWorker {
    private final VirtualFile[] myRoots;
    private final Project myProject;
    private final String myTitleKey;

    public CleanupWorker(VirtualFile[] roots, Project project, String titleKey) {
        this.myRoots = roots;
        this.myProject = project;
        this.myTitleKey = titleKey;
    }

    public void execute() {
        ApplicationManager.getApplication().saveAll();
        final LinkedList exceptions = new LinkedList();
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        final SVNWCClient wcClient = vcs.createWCClient();
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, SvnBundle.message(this.myTitleKey, new Object[0]), false, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/actions/CleanupWorker$1.run must not be null");
                }
                indicator.setIndeterminate(true);
                VirtualFile[] arr$ = CleanupWorker.this.myRoots;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    VirtualFile root;
                    VirtualFile currentRoot = root = arr$[i$];
                    try {
                        String path = root.getPath();
                        indicator.setText(SvnBundle.message("action.Subversion.cleanup.progress.text", path));
                        wcClient.doCleanup(new File(path));
                        continue;
                    }
                    catch (SVNException ex) {
                        exceptions.add(new Pair((Object)ex, (Object)currentRoot));
                    }
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                if (this.myProject.isDisposed()) {
                    return;
                }
                VcsDirtyScopeManager manager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                if (myProject.isDisposed()) {
                                    return;
                                }
                                for (VirtualFile root : CleanupWorker.this.myRoots) {
                                    root.refresh(false, true);
                                }
                            }
                        });
                    }
                });
                for (VirtualFile root : CleanupWorker.this.myRoots) {
                    manager.fileDirty(root);
                }
                if (!exceptions.isEmpty()) {
                    LinkedList<VcsException> vcsExceptions = new LinkedList<VcsException>();
                    for (Pair pair : exceptions) {
                        SVNException exception = (SVNException)((Object)pair.first);
                        vcsExceptions.add(new VcsException(SvnBundle.message("action.Subversion.cleanup.error.message", FileUtil.toSystemDependentName((String)((VirtualFile)pair.second).getPath()), exception == null ? "" : exception.getMessage())));
                    }
                    AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
                    helper.showErrors(vcsExceptions, SvnBundle.message(CleanupWorker.this.myTitleKey, new Object[0]));
                }
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }
}

