/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.StreamLoader;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileLoader
implements Loader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.FileLoader");
    private final String url;
    private final String name;

    public FileLoader(String url, String name) {
        this.url = url;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/FileLoader.load must not be null");
        }
        File file = new File(this.url);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            StreamLoader loader = new StreamLoader(stream, file.getName());
            loader.load(consumer);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ignored) {}
        }
    }
}

