/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileRef;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.Attributes;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Demo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Throwable {
        Action action = Action.valueOf(stringArray[0]);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (action == Action.create) {
            hashMap.put("createNew", true);
        }
        if (action == Action.tlist || action == Action.twalk) {
            hashMap.put("buildDirTree", true);
        }
        try (FileSystem fileSystem = FileSystems.newFileSystem(URI.create("zip" + Paths.get((String)stringArray[1]).toUri().toString().substring(4)), hashMap, null);){
            boolean bl = false;
            switch (action) {
                case rename: {
                    Path path = fileSystem.getPath(stringArray[2]);
                    Path path2 = fileSystem.getPath(stringArray[3]);
                    path.moveTo(path2, new CopyOption[0]);
                    return;
                }
                case moveout: {
                    Path path = fileSystem.getPath(stringArray[2]);
                    Path path3 = Paths.get((String)stringArray[3]);
                    path.moveTo(path3, new CopyOption[0]);
                    return;
                }
                case movein: {
                    Path path = Paths.get((String)stringArray[2]);
                    Path path4 = fileSystem.getPath(stringArray[3]);
                    path.moveTo(path4, new CopyOption[0]);
                    return;
                }
                case copy: {
                    Path path = fileSystem.getPath(stringArray[2]);
                    Path path5 = fileSystem.getPath(stringArray[3]);
                    path.copyTo(path5, new CopyOption[0]);
                    return;
                }
                case copyout: {
                    Path path = fileSystem.getPath(stringArray[2]);
                    Path path6 = Paths.get((String)stringArray[3]);
                    path.copyTo(path6, new CopyOption[0]);
                    return;
                }
                case copyin: {
                    Path path = Paths.get((String)stringArray[2]);
                    Path path7 = fileSystem.getPath(stringArray[3]);
                    path.copyTo(path7, new CopyOption[0]);
                    return;
                }
                case copyin_attrs: {
                    Path path = Paths.get((String)stringArray[2]);
                    Path path8 = fileSystem.getPath(stringArray[3]);
                    path.copyTo(path8, new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES});
                    return;
                }
                case copyout_attrs: {
                    Path path = fileSystem.getPath(stringArray[2]);
                    Path path9 = Paths.get((String)stringArray[3]);
                    path.copyTo(path9, new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES});
                    return;
                }
                case zzmove: {
                    FileSystem fileSystem2 = FileSystems.newFileSystem(URI.create("zip" + Paths.get((String)stringArray[2]).toUri().toString().substring(4)), hashMap, null);
                    Demo.z2zmove(fileSystem, fileSystem2, stringArray[3]);
                    fileSystem2.close();
                    return;
                }
                case zzcopy: {
                    FileSystem fileSystem3 = FileSystems.newFileSystem(URI.create("zip" + Paths.get((String)stringArray[2]).toUri().toString().substring(4)), hashMap, null);
                    Demo.z2zcopy(fileSystem, fileSystem3, stringArray[3]);
                    fileSystem3.close();
                    return;
                }
                case attrs: {
                    int n = 2;
                    while (n < stringArray.length) {
                        Path path = fileSystem.getPath(stringArray[n]);
                        System.out.println(path);
                        System.out.println(Attributes.readBasicFileAttributes((FileRef)path, (LinkOption[])new LinkOption[0]).toString());
                        ++n;
                    }
                    return;
                }
                case setmtime: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy-HH:mm:ss");
                    Date date = simpleDateFormat.parse(stringArray[2]);
                    int n = 3;
                    while (n < stringArray.length) {
                        Path path = fileSystem.getPath(stringArray[n]);
                        path.setAttribute("lastModifiedTime", FileTime.fromMillis(date.getTime()), new LinkOption[0]);
                        System.out.println(Attributes.readBasicFileAttributes((FileRef)path, (LinkOption[])new LinkOption[0]).toString());
                        ++n;
                    }
                    return;
                }
                case setctime: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy-HH:mm:ss");
                    Date date = simpleDateFormat.parse(stringArray[2]);
                    int n = 3;
                    while (n < stringArray.length) {
                        Path path = fileSystem.getPath(stringArray[n]);
                        path.setAttribute("creationTime", FileTime.fromMillis(date.getTime()), new LinkOption[0]);
                        System.out.println(Attributes.readBasicFileAttributes((FileRef)path, (LinkOption[])new LinkOption[0]).toString());
                        ++n;
                    }
                    return;
                }
                case setatime: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy-HH:mm:ss");
                    Date date = simpleDateFormat.parse(stringArray[2]);
                    int n = 3;
                    while (n < stringArray.length) {
                        Path path = fileSystem.getPath(stringArray[n]);
                        path.setAttribute("lastAccessTime", FileTime.fromMillis(date.getTime()), new LinkOption[0]);
                        System.out.println(Attributes.readBasicFileAttributes((FileRef)path, (LinkOption[])new LinkOption[0]).toString());
                        ++n;
                    }
                    return;
                }
                case attrsspace: {
                    Path path = fileSystem.getPath("/");
                    FileStore fileStore = path.getFileStore();
                    System.out.printf("filestore[%s]%n", fileStore.name());
                    System.out.printf("    totalSpace: %d%n", (Long)fileStore.getAttribute("space:totalSpace"));
                    System.out.printf("   usableSpace: %d%n", (Long)fileStore.getAttribute("space:usableSpace"));
                    System.out.printf("  unallocSpace: %d%n", (Long)fileStore.getAttribute("space:unallocatedSpace"));
                    return;
                }
                case list: 
                case tlist: {
                    if (stringArray.length < 3) {
                        Demo.list(fileSystem.getPath("/"), false);
                        return;
                    }
                    Demo.list(fileSystem.getPath(stringArray[2]), false);
                    return;
                }
                case vlist: {
                    if (stringArray.length < 3) {
                        Demo.list(fileSystem.getPath("/"), true);
                        return;
                    }
                    Demo.list(fileSystem.getPath(stringArray[2]), true);
                    return;
                }
                case twalk: 
                case walk: {
                    Demo.walk(fileSystem.getPath(stringArray.length > 2 ? stringArray[2] : "/"));
                    return;
                }
                case extract: {
                    if (stringArray.length == 2) {
                        Demo.extract(fileSystem, "/");
                        return;
                    }
                    int n = 2;
                    while (n < stringArray.length) {
                        Demo.extract(fileSystem, stringArray[n]);
                        ++n;
                    }
                    return;
                }
                case delete: {
                    int n = 2;
                    while (n < stringArray.length) {
                        fileSystem.getPath(stringArray[n]).delete();
                        ++n;
                    }
                    return;
                }
                case create: 
                case add: 
                case update: {
                    int n = 2;
                    while (n < stringArray.length) {
                        Demo.update(fileSystem, stringArray[n]);
                        ++n;
                    }
                    return;
                }
                case lsdir: {
                    Path path = fileSystem.getPath(stringArray[2]);
                    final String string = stringArray.length > 3 ? stringArray[3] : "";
                    DirectoryStream directoryStream = path.newDirectoryStream(new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path path) {
                            return path.toString().contains(string);
                        }
                    });
                    Iterator iterator = directoryStream.iterator();
                    while (iterator.hasNext()) {
                        Path path10 = (Path)iterator.next();
                        System.out.println(path10);
                    }
                    return;
                }
                case mkdir: {
                    fileSystem.getPath(stringArray[2]).createDirectory(new FileAttribute[0]);
                    return;
                }
                case mkdirs: {
                    Demo.mkdirs(fileSystem.getPath(stringArray[2]));
                    return;
                }
                case attrs2: {
                    int n = 2;
                    while (n < stringArray.length) {
                        Path path = fileSystem.getPath(stringArray[n]);
                        System.out.printf("%n%s%n", path);
                        System.out.println("-------(1)---------");
                        System.out.println(Attributes.readBasicFileAttributes((FileRef)path, (LinkOption[])new LinkOption[0]).toString());
                        System.out.println("-------(2)---------");
                        Map map = path.readAttributes("zip:*", new LinkOption[0]);
                        for (Map.Entry entry : map.entrySet()) {
                            System.out.printf("    %s : %s%n", entry.getKey(), entry.getValue());
                        }
                        System.out.println("-------(3)---------");
                        map = path.readAttributes("size,lastModifiedTime,isDirectory", new LinkOption[0]);
                        for (Map.Entry entry : map.entrySet()) {
                            System.out.printf("    %s : %s%n", entry.getKey(), entry.getValue());
                        }
                        ++n;
                    }
                    return;
                }
                case prof: {
                    Demo.list(fileSystem.getPath("/"), false);
                    while (true) {
                        Thread.sleep(10000L);
                        System.out.println("sleeping...");
                    }
                }
            }
            return;
        }
    }

    private static byte[] getBytes(String string) {
        return string.getBytes();
    }

    private static String getString(byte[] byArray) {
        return new String(byArray);
    }

    private static void walk(Path path) throws IOException {
        Files.walkFileTree((Path)path, (FileVisitor)new SimpleFileVisitor<Path>(){
            private int indent = 0;

            private void indent() {
                int n = 0;
                while (n++ < this.indent) {
                    System.out.printf(" ", new Object[0]);
                }
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                this.indent();
                System.out.printf("%s%n", path.getName().toString());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                this.indent();
                System.out.printf("[%s]%n", path.toString());
                this.indent += 2;
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
                this.indent -= 2;
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void update(FileSystem fileSystem, String string) throws Throwable {
        Path path = FileSystems.getDefault().getPath(string);
        if (Boolean.TRUE.equals(path.getAttribute("isDirectory", new LinkOption[0]))) {
            DirectoryStream directoryStream = path.newDirectoryStream();
            for (Path path2 : directoryStream) {
                Demo.update(fileSystem, path2.toString());
            }
            directoryStream.close();
        } else {
            Path path3 = fileSystem.getPath(string);
            Path path4 = path3.getParent();
            if (path4 != null && path4.notExists()) {
                Demo.mkdirs(path4);
            }
            path.copyTo(path3, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
    }

    private static void extract(FileSystem fileSystem, String string) throws Throwable {
        Path path = fileSystem.getPath(string);
        if (Boolean.TRUE.equals(path.getAttribute("isDirectory", new LinkOption[0]))) {
            DirectoryStream directoryStream = path.newDirectoryStream();
            for (Path path2 : directoryStream) {
                Demo.extract(fileSystem, path2.toString());
            }
            directoryStream.close();
        } else {
            Path path3;
            Path path4;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if ((path4 = (path3 = FileSystems.getDefault().getPath(string)).getParent()).notExists()) {
                Demo.mkdirs(path4);
            }
            path.copyTo(path3, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
    }

    private static void z2zcopy(FileSystem fileSystem, FileSystem fileSystem2, String string) throws IOException {
        Path path = fileSystem.getPath(string);
        Path path2 = fileSystem2.getPath(string);
        if (Boolean.TRUE.equals(path.getAttribute("isDirectory", new LinkOption[0]))) {
            if (!path2.exists()) {
                try {
                    Demo.mkdirs(path2);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    // empty catch block
                }
            }
            DirectoryStream directoryStream = path.newDirectoryStream();
            for (Path path3 : directoryStream) {
                Demo.z2zcopy(fileSystem, fileSystem2, string + (string.endsWith("/") ? "" : "/") + path3.getName());
            }
            directoryStream.close();
        } else {
            path.copyTo(path2, new CopyOption[0]);
        }
    }

    private static void z2zmove(FileSystem fileSystem, FileSystem fileSystem2, String string) throws IOException {
        final Path path = fileSystem.getPath(string).toAbsolutePath();
        final Path path2 = fileSystem2.getPath(string).toAbsolutePath();
        Files.walkFileTree((Path)path, (FileVisitor)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path4, BasicFileAttributes basicFileAttributes) {
                Path path22 = path.relativize(path4);
                path22 = path2.resolve(path22);
                try {
                    Path path3 = path2.getParent();
                    if (path3 != null && path3.notExists()) {
                        Demo.mkdirs(path3);
                    }
                    path4.moveTo(path22, new CopyOption[0]);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path path3, BasicFileAttributes basicFileAttributes) {
                Path path22 = path.relativize(path3);
                path22 = path2.resolve(path22);
                try {
                    if (path22.notExists()) {
                        Demo.mkdirs(path22);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path3, IOException iOException) throws IOException {
                try {
                    path3.delete();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void mkdirs(Path path) throws IOException {
        Path path2 = (path = path.toAbsolutePath()).getParent();
        if (path2 != null && path2.notExists()) {
            Demo.mkdirs(path2);
        }
        path.createDirectory(new FileAttribute[0]);
    }

    private static void rmdirs(Path path) throws IOException {
        while (path != null && path.getNameCount() != 0) {
            path.delete();
            path = path.getParent();
        }
    }

    private static void list(Path path, boolean bl) throws IOException {
        if (!"/".equals(path.toString())) {
            System.out.printf("  %s%n", path.toString());
            if (bl) {
                System.out.println(Attributes.readBasicFileAttributes((FileRef)path, (LinkOption[])new LinkOption[0]).toString());
            }
        }
        if (path.notExists()) {
            return;
        }
        if (Attributes.readBasicFileAttributes((FileRef)path, (LinkOption[])new LinkOption[0]).isDirectory()) {
            DirectoryStream directoryStream = path.newDirectoryStream();
            for (Path path2 : directoryStream) {
                Demo.list(path2, bl);
            }
            directoryStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkEqual(Path path, Path path2) throws IOException {
        InputStream inputStream = path.newInputStream(new OpenOption[0]);
        InputStream inputStream2 = path2.newInputStream(new OpenOption[0]);
        byte[] byArray = new byte[8192];
        byte[] byArray2 = new byte[8192];
        try {
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                int n2;
                for (int i = 0; i < n; i += n2) {
                    n2 = inputStream2.read(byArray2, i, n - i);
                    if (n2 != -1) continue;
                    System.out.printf("checking <%s> vs <%s>...%n", path.toString(), path2.toString());
                    throw new RuntimeException("CHECK FAILED!");
                }
                while (--n >= 0) {
                    if (byArray[n] != byArray2[n]) {
                        System.out.printf("checking <%s> vs <%s>...%n", path.toString(), path2.toString());
                        throw new RuntimeException("CHECK FAILED!");
                    }
                    --n;
                }
            }
        }
        finally {
            inputStream.close();
            inputStream2.close();
        }
        SeekableByteChannel seekableByteChannel = path.newByteChannel(new OpenOption[0]);
        SeekableByteChannel seekableByteChannel2 = path2.newByteChannel(new OpenOption[0]);
        if (seekableByteChannel.size() != seekableByteChannel2.size()) {
            System.out.printf("src[%s].size=%d, dst[%s].size=%d%n", seekableByteChannel.toString(), seekableByteChannel.size(), seekableByteChannel2.toString(), seekableByteChannel2.size());
            throw new RuntimeException("CHECK FAILED!");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(8192);
        try {
            int n = 0;
            while ((n = seekableByteChannel.read(byteBuffer)) != -1) {
                int n3 = seekableByteChannel2.read(byteBuffer2);
                if (n != n3) {
                    System.out.printf("checking <%s> vs <%s>...%n", path.toString(), path2.toString());
                    throw new RuntimeException("CHECK FAILED!");
                }
                while (--n >= 0) {
                    if (byteBuffer.get(n) != byteBuffer2.get(n)) {
                        System.out.printf("checking <%s> vs <%s>...%n", path.toString(), path2.toString());
                        throw new RuntimeException("CHECK FAILED!");
                    }
                    --n;
                }
                byteBuffer.flip();
                byteBuffer2.flip();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            seekableByteChannel.close();
            seekableByteChannel2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fchCopy(Path path, Path path2) throws IOException {
        HashSet<StandardOpenOption> hashSet = new HashSet<StandardOpenOption>();
        hashSet.add(StandardOpenOption.READ);
        HashSet<StandardOpenOption> hashSet2 = new HashSet<StandardOpenOption>();
        hashSet2.add(StandardOpenOption.CREATE_NEW);
        hashSet2.add(StandardOpenOption.WRITE);
        FileChannel fileChannel = path.getFileSystem().provider().newFileChannel(path, hashSet, new FileAttribute[0]);
        FileChannel fileChannel2 = path2.getFileSystem().provider().newFileChannel(path2, hashSet2, new FileAttribute[0]);
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
            while (fileChannel.read(byteBuffer) >= 0) {
                byteBuffer.flip();
                fileChannel2.write(byteBuffer);
                byteBuffer.clear();
            }
        }
        finally {
            fileChannel.close();
            fileChannel2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void chCopy(Path path, Path path2) throws IOException {
        HashSet<StandardOpenOption> hashSet = new HashSet<StandardOpenOption>();
        hashSet.add(StandardOpenOption.READ);
        HashSet<StandardOpenOption> hashSet2 = new HashSet<StandardOpenOption>();
        hashSet2.add(StandardOpenOption.CREATE_NEW);
        hashSet2.add(StandardOpenOption.WRITE);
        SeekableByteChannel seekableByteChannel = path.newByteChannel(hashSet, new FileAttribute[0]);
        SeekableByteChannel seekableByteChannel2 = path2.newByteChannel(hashSet2, new FileAttribute[0]);
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
            while (seekableByteChannel.read(byteBuffer) >= 0) {
                byteBuffer.flip();
                seekableByteChannel2.write(byteBuffer);
                byteBuffer.clear();
            }
        }
        finally {
            seekableByteChannel.close();
            seekableByteChannel2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void streamCopy(Path path, Path path2) throws IOException {
        InputStream inputStream = path.newInputStream(new OpenOption[0]);
        OutputStream outputStream = path2.newOutputStream(new OpenOption[0]);
        byte[] byArray = new byte[8192];
        try {
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    static enum Action {
        rename,
        movein,
        moveout,
        copy,
        copyin,
        copyin_attrs,
        copyout,
        copyout_attrs,
        zzmove,
        zzcopy,
        attrs,
        attrsspace,
        setmtime,
        setatime,
        setctime,
        lsdir,
        mkdir,
        mkdirs,
        rmdirs,
        list,
        tlist,
        vlist,
        walk,
        twalk,
        extract,
        update,
        delete,
        add,
        create,
        attrs2,
        prof;

    }
}

