/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.net.URLStreamHandlerFactory;
import sun.misc.URLClassPath;
import sun.misc.VM;

public abstract class BootClassLoaderHook {
    private static BootClassLoaderHook bootLoaderHook = null;

    public static synchronized BootClassLoaderHook getHook() {
        return bootLoaderHook;
    }

    public static synchronized void setHook(BootClassLoaderHook bootClassLoaderHook) {
        if (!VM.isBooted()) {
            throw new InternalError("hook can only be set after VM is booted");
        }
        if (bootLoaderHook != null) {
            throw new InternalError("hook should not be reinitialized");
        }
        bootLoaderHook = bootClassLoaderHook;
    }

    protected BootClassLoaderHook() {
    }

    public static void preLoadClass(String string) {
        BootClassLoaderHook bootClassLoaderHook = BootClassLoaderHook.getHook();
        if (bootClassLoaderHook != null) {
            bootClassLoaderHook.loadBootstrapClass(string);
        }
    }

    public static void preLoadResource(String string) {
        BootClassLoaderHook bootClassLoaderHook = BootClassLoaderHook.getHook();
        if (bootClassLoaderHook != null) {
            bootClassLoaderHook.getBootstrapResource(string);
        }
    }

    public static void preLoadLibrary(String string) {
        BootClassLoaderHook bootClassLoaderHook = BootClassLoaderHook.getHook();
        if (bootClassLoaderHook != null) {
            bootClassLoaderHook.loadLibrary(string);
        }
    }

    public abstract String loadBootstrapClass(String var1);

    public abstract String getBootstrapResource(String var1);

    public abstract boolean loadLibrary(String var1);

    public abstract URLClassPath getBootstrapClassPath(URLClassPath var1, URLStreamHandlerFactory var2);

    public abstract boolean isCurrentThreadPrefetching();

    public abstract boolean prefetchFile(String var1);
}

