/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SingleLeafTreeSelectionModel;
import com.sun.tools.example.debug.gui.SourceListener;
import com.sun.tools.example.debug.gui.SourceManager;
import com.sun.tools.example.debug.gui.SourcepathChangedEvent;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SourceTreeTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private SourceManager sourceManager;
    private ClassManager classManager;
    private JTree tree;
    private SourceTreeNode root;
    private SearchPath sourcePath;
    private CommandInterpreter interpreter;
    private static String HEADING = "SOURCES";
    private static FilenameFilter filter = new SourceOrDirectoryFilter();

    public SourceTreeTool(Environment environment) {
        super(new BorderLayout());
        this.env = environment;
        this.runtime = environment.getExecutionManager();
        this.sourceManager = environment.getSourceManager();
        this.interpreter = new CommandInterpreter(environment);
        this.sourcePath = this.sourceManager.getSourcePath();
        this.root = this.createDirectoryTree(HEADING);
        this.tree = new JTree(new DefaultTreeModel(this.root));
        this.tree.setSelectionModel(new SingleLeafTreeSelectionModel());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SourceTreeNode sourceTreeNode;
                int n = SourceTreeTool.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = SourceTreeTool.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && (sourceTreeNode = (SourceTreeNode)treePath.getLastPathComponent()).isLeaf()) {
                    SourceTreeTool.this.tree.setSelectionPath(treePath);
                    SourceTreeTool.this.interpreter.executeCommand("view " + sourceTreeNode.getRelativePath());
                }
            }
        };
        this.tree.addMouseListener(mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add(jScrollPane);
        SourceTreeToolListener sourceTreeToolListener = new SourceTreeToolListener();
        this.sourceManager.addSourceListener(sourceTreeToolListener);
    }

    SourceTreeNode createDirectoryTree(String string) {
        try {
            return new SourceTreeNode(string, null, "", true);
        }
        catch (SecurityException securityException) {
            this.env.failure("Cannot access source file or directory");
            return null;
        }
    }

    class SourceTreeNode
    implements TreeNode {
        private String name;
        private boolean isDirectory;
        private SourceTreeNode parent;
        private SourceTreeNode[] children;
        private String relativePath;
        private boolean isExpanded;

        private SourceTreeNode(String string, SourceTreeNode sourceTreeNode, String string2, boolean bl) {
            this.name = string;
            this.relativePath = string2;
            this.parent = sourceTreeNode;
            this.isDirectory = bl;
        }

        public String toString() {
            return this.name;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        private void expandIfNeeded() {
            try {
                if (!this.isExpanded && this.isDirectory) {
                    String[] stringArray = SourceTreeTool.this.sourcePath.children(this.relativePath, filter);
                    this.children = new SourceTreeNode[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = this.relativePath.equals("") ? stringArray[i] : this.relativePath + File.separator + stringArray[i];
                        File file = SourceTreeTool.this.sourcePath.resolve(string);
                        boolean bl = file != null && file.isDirectory();
                        this.children[i] = new SourceTreeNode(stringArray[i], this, string, bl);
                    }
                }
                this.isExpanded = true;
            }
            catch (SecurityException securityException) {
                this.children = null;
                SourceTreeTool.this.env.failure("Cannot access source file or directory");
            }
        }

        @Override
        public TreeNode getChildAt(int n) {
            this.expandIfNeeded();
            return this.children[n];
        }

        @Override
        public int getChildCount() {
            this.expandIfNeeded();
            return this.children.length;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            this.expandIfNeeded();
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] != treeNode) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return this.isDirectory;
        }

        @Override
        public boolean isLeaf() {
            this.expandIfNeeded();
            return !this.isDirectory;
        }

        public Enumeration children() {
            this.expandIfNeeded();
            return new Enumeration(){
                int i = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.i < SourceTreeNode.this.children.length;
                }

                public Object nextElement() throws NoSuchElementException {
                    if (this.i >= SourceTreeNode.this.children.length) {
                        throw new NoSuchElementException();
                    }
                    return SourceTreeNode.this.children[this.i++];
                }
            };
        }
    }

    private static class SourceOrDirectoryFilter
    implements FilenameFilter {
        private SourceOrDirectoryFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(".java") || new File(file, string).isDirectory();
        }
    }

    private class SourceTreeToolListener
    implements SourceListener {
        private SourceTreeToolListener() {
        }

        @Override
        public void sourcepathChanged(SourcepathChangedEvent sourcepathChangedEvent) {
            SourceTreeTool.this.sourcePath = SourceTreeTool.this.sourceManager.getSourcePath();
            SourceTreeTool.this.root = SourceTreeTool.this.createDirectoryTree(HEADING);
            SourceTreeTool.this.tree.setModel(new DefaultTreeModel(SourceTreeTool.this.root));
        }
    }
}

