/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeCommand
extends Command {
    protected List<OsmPrimitive> toPurge;
    protected Storage<PrimitiveData> makeIncompleteData;
    protected Map<PrimitiveId, PrimitiveData> makeIncompleteData_byPrimId;
    protected final DataSet ds;

    public PurgeCommand(OsmDataLayer layer, Collection<OsmPrimitive> toPurge, Collection<OsmPrimitive> makeIncomplete) {
        super(layer);
        this.ds = layer.data;
        this.toPurge = PurgeCommand.topoSort(toPurge);
        this.saveIncomplete(makeIncomplete);
    }

    protected void saveIncomplete(Collection<OsmPrimitive> makeIncomplete) {
        this.makeIncompleteData = new Storage<PrimitiveData>(new Hash<PrimitiveData, PrimitiveData>(){

            @Override
            public int getHashCode(PrimitiveData k) {
                return (int)k.getUniqueId();
            }

            @Override
            public boolean equals(PrimitiveData k, PrimitiveData t) {
                return k.getUniqueId() == t.getUniqueId() && k.getType() == t.getType();
            }
        });
        this.makeIncompleteData_byPrimId = this.makeIncompleteData.foreignKey(new Hash<PrimitiveId, PrimitiveData>(){

            @Override
            public int getHashCode(PrimitiveId k) {
                return (int)k.getUniqueId();
            }

            @Override
            public boolean equals(PrimitiveId k, PrimitiveData t) {
                return k.getUniqueId() == t.getUniqueId() && k.getType() == t.getType();
            }
        });
        for (OsmPrimitive osm : makeIncomplete) {
            this.makeIncompleteData.add(osm.save());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand() {
        this.ds.beginUpdate();
        try {
            for (int i = this.toPurge.size() - 1; i >= 0; --i) {
                OsmPrimitive osm = this.toPurge.get(i);
                if (this.makeIncompleteData_byPrimId.containsKey(osm)) {
                    PrimitiveData empty;
                    switch (osm.getType()) {
                        case NODE: {
                            empty = new NodeData();
                            break;
                        }
                        case WAY: {
                            empty = new WayData();
                            break;
                        }
                        case RELATION: {
                            empty = new RelationData();
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    empty.setId(osm.getUniqueId());
                    empty.setIncomplete(true);
                    osm.load(empty);
                    continue;
                }
                this.ds.removePrimitive(osm);
            }
        }
        finally {
            this.ds.endUpdate();
        }
        return true;
    }

    @Override
    public void undoCommand() {
        if (this.ds == null) {
            return;
        }
        for (OsmPrimitive osm : this.toPurge) {
            PrimitiveData data = this.makeIncompleteData_byPrimId.get(osm);
            if (data != null) {
                if (this.ds.getPrimitiveById(osm) != osm) {
                    throw new AssertionError((Object)String.format("Primitive %s has been made incomplete when purging, but it cannot be found on undo.", osm));
                }
                osm.load(data);
                continue;
            }
            if (this.ds.getPrimitiveById(osm) != null) {
                throw new AssertionError((Object)String.format("Primitive %s was removed when purging, but is still there on undo", osm));
            }
            this.ds.addPrimitive(osm);
        }
    }

    public static List<OsmPrimitive> topoSort(Collection<OsmPrimitive> sel) {
        OsmPrimitive u;
        HashSet<OsmPrimitive> in = new HashSet<OsmPrimitive>(sel);
        ArrayList<OsmPrimitive> out = new ArrayList<OsmPrimitive>(in.size());
        Iterator it = in.iterator();
        block0: while (it.hasNext()) {
            u = (OsmPrimitive)it.next();
            if (!(u instanceof Node)) continue;
            Node n = (Node)u;
            for (OsmPrimitive ref : n.getReferrers()) {
                if (!(ref instanceof Way) || !in.contains(ref)) continue;
                continue block0;
            }
            it.remove();
            out.add(n);
        }
        block2: while (!in.isEmpty()) {
            it = in.iterator();
            while (it.hasNext()) {
                u = (OsmPrimitive)it.next();
                if (!(u instanceof Way)) continue;
                Way w = (Way)u;
                it.remove();
                for (Node n : w.getNodes()) {
                    if (!in.contains(n)) continue;
                    in.remove(n);
                    out.add(n);
                }
                out.add(w);
                continue block2;
            }
            break block2;
        }
        HashSet<OsmPrimitive> inR = in;
        HashSet<Relation> childlessR = new HashSet<Relation>();
        ArrayList<Relation> outR = new ArrayList<Relation>(inR.size());
        HashMap<Relation, Integer> numChilds = new HashMap<Relation, Integer>();
        for (Relation relation : inR) {
            numChilds.put(relation, 0);
        }
        for (Relation relation : inR) {
            for (OsmPrimitive parent : relation.getReferrers()) {
                if (!(parent instanceof Relation)) {
                    throw new AssertionError();
                }
                Integer i = (Integer)numChilds.get(parent);
                if (i == null) continue;
                numChilds.put((Relation)parent, i + 1);
            }
        }
        for (Relation relation : inR) {
            if (!((Integer)numChilds.get(relation)).equals(0)) continue;
            childlessR.add(relation);
        }
        while (!childlessR.isEmpty()) {
            Iterator it2 = childlessR.iterator();
            Relation relation = (Relation)it2.next();
            it2.remove();
            outR.add(relation);
            for (OsmPrimitive parentPrim : relation.getReferrers()) {
                Relation parent = (Relation)parentPrim;
                Integer i = (Integer)numChilds.get(parent);
                if (i == null) continue;
                numChilds.put(parent, i - 1);
                if (i - 1 != 0) continue;
                childlessR.add(parent);
            }
        }
        if (outR.size() != inR.size()) {
            throw new AssertionError((Object)"topo sort algorithm failed");
        }
        out.addAll(outR);
        return out;
    }

    @Override
    public Object getDescription() {
        return new JLabel(I18n.trn("Purged {0} object", "Purged {0} objects", this.toPurge.size(), this.toPurge.size()), ImageProvider.get("data", "purge"), 0);
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.toPurge;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }
}

