/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableGpxTrackSegment
implements GpxTrackSegment {
    private final Collection<WayPoint> wayPoints;
    private final Bounds bounds;
    private final double length;

    public ImmutableGpxTrackSegment(Collection<WayPoint> wayPoints) {
        this.wayPoints = Collections.unmodifiableCollection(new ArrayList<WayPoint>(wayPoints));
        this.bounds = this.calculateBounds();
        this.length = this.calculateLength();
    }

    private Bounds calculateBounds() {
        Bounds result = null;
        for (WayPoint wpt : this.wayPoints) {
            if (result == null) {
                result = new Bounds(wpt.getCoor());
                continue;
            }
            result.extend(wpt.getCoor());
        }
        return result;
    }

    private double calculateLength() {
        double result = 0.0;
        WayPoint last = null;
        for (WayPoint tpt : this.wayPoints) {
            Double d;
            if (last != null && !(d = Double.valueOf(last.getCoor().greatCircleDistance(tpt.getCoor()))).isNaN() && !d.isInfinite()) {
                result += d.doubleValue();
            }
            last = tpt;
        }
        return result;
    }

    @Override
    public Bounds getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return new Bounds(this.bounds);
    }

    @Override
    public Collection<WayPoint> getWayPoints() {
        return this.wayPoints;
    }

    @Override
    public double length() {
        return this.length;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }
}

