/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import java.util.Date;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.tools.PrimaryDateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WayPoint
extends WithAttributes
implements Comparable<WayPoint> {
    private static ThreadLocal<PrimaryDateParser> dateParser = new ThreadLocal<PrimaryDateParser>(){

        @Override
        protected PrimaryDateParser initialValue() {
            return new PrimaryDateParser();
        }
    };
    public double time;
    public Color customColoring;
    public boolean drawLine;
    public int dir;
    private final CachedLatLon coor;

    public WayPoint(LatLon ll) {
        this.coor = new CachedLatLon(ll);
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final EastNorth getEastNorth() {
        return this.coor.getEastNorth();
    }

    public String toString() {
        return "WayPoint (" + (this.attr.containsKey("name") ? this.attr.get("name") + ", " : "") + this.coor.toString() + ", " + this.attr + ")";
    }

    public void setTime() {
        if (this.attr.containsKey("time")) {
            try {
                this.time = (double)dateParser.get().parse(this.attr.get("time").toString()).getTime() / 1000.0;
            }
            catch (Exception e) {
                this.time = 0.0;
            }
        }
    }

    @Override
    public int compareTo(WayPoint w) {
        return Double.compare(this.time, w.time);
    }

    public Date getTime() {
        return new Date((long)(this.time * 1000.0));
    }
}

