/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class RelationMemberData
implements PrimitiveId {
    private final String role;
    private final long memberId;
    private final OsmPrimitiveType memberType;

    public RelationMemberData(String role, OsmPrimitiveType type, long id) {
        this.role = role == null ? "" : role;
        this.memberType = type;
        this.memberId = id;
    }

    public RelationMemberData(String role, PrimitiveId primitive) {
        this(role, primitive.getType(), primitive.getUniqueId());
    }

    public long getMemberId() {
        return this.memberId;
    }

    public String getRole() {
        return this.role;
    }

    public OsmPrimitiveType getMemberType() {
        return this.memberType;
    }

    public boolean hasRole() {
        return !"".equals(this.role);
    }

    public String toString() {
        return this.memberType.getAPIName() + " " + this.memberId;
    }

    public OsmPrimitiveType getType() {
        return this.memberType;
    }

    public long getUniqueId() {
        return this.memberId;
    }

    public boolean isNew() {
        return this.memberId <= 0L;
    }
}

