/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.ModifiedConflictResolveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.VersionConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.nodes.NodeListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.nodes.NodeListMerger;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMerger;
import org.openstreetmap.josm.gui.conflict.pair.relation.RelationMemberListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.relation.RelationMemberMerger;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMerger;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictResolver
extends JPanel
implements PropertyChangeListener {
    public static final String RESOLVED_COMPLETELY_PROP = ConflictResolver.class.getName() + ".resolvedCompletely";
    public static final String MY_PRIMITIVE_PROP = ConflictResolver.class.getName() + ".myPrimitive";
    public static final String THEIR_PRIMITIVE_PROP = ConflictResolver.class.getName() + ".theirPrimitive";
    private JTabbedPane tabbedPane = null;
    private TagMerger tagMerger;
    private NodeListMerger nodeListMerger;
    private RelationMemberMerger relationMemberMerger;
    private PropertiesMerger propertiesMerger;
    private final List<IConflictResolver> conflictResolvers = new ArrayList<IConflictResolver>();
    private OsmPrimitive my;
    private OsmPrimitive their;
    private Conflict<? extends OsmPrimitive> conflict;
    private ImageIcon mergeComplete;
    private ImageIcon mergeIncomplete;
    private boolean resolvedCompletely = false;

    protected void loadIcons() {
        this.mergeComplete = ImageProvider.get("dialogs/conflict", "mergecomplete.png");
        this.mergeIncomplete = ImageProvider.get("dialogs/conflict", "mergeincomplete.png");
    }

    protected void build() {
        this.tabbedPane = new JTabbedPane();
        this.propertiesMerger = new PropertiesMerger();
        this.propertiesMerger.setName("panel.propertiesmerger");
        this.propertiesMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Properties"), this.propertiesMerger);
        this.tagMerger = new TagMerger();
        this.tagMerger.setName("panel.tagmerger");
        this.tagMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Tags"), this.tagMerger);
        this.nodeListMerger = new NodeListMerger();
        this.nodeListMerger.setName("panel.nodelistmerger");
        this.nodeListMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Nodes"), this.nodeListMerger);
        this.relationMemberMerger = new RelationMemberMerger();
        this.relationMemberMerger.setName("panel.relationmembermerger");
        this.relationMemberMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Members"), this.relationMemberMerger);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.conflictResolvers.add(this.propertiesMerger);
        this.conflictResolvers.add(this.tagMerger);
        this.conflictResolvers.add(this.nodeListMerger);
        this.conflictResolvers.add(this.relationMemberMerger);
    }

    public ConflictResolver() {
        this.build();
        this.loadIcons();
    }

    protected void setMy(OsmPrimitive my) {
        OsmPrimitive old = this.my;
        this.my = my;
        if (old != this.my) {
            this.firePropertyChange(MY_PRIMITIVE_PROP, old, this.my);
        }
    }

    protected void setTheir(OsmPrimitive their) {
        OsmPrimitive old = this.their;
        this.their = their;
        if (old != this.their) {
            this.firePropertyChange(THEIR_PRIMITIVE_PROP, old, this.their);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(TagMergeModel.PROP_NUM_UNDECIDED_TAGS)) {
            int newValue = (Integer)evt.getNewValue();
            if (newValue == 0) {
                this.tabbedPane.setTitleAt(1, I18n.tr("Tags"));
                this.tabbedPane.setToolTipTextAt(1, I18n.tr("No pending tag conflicts to be resolved"));
                this.tabbedPane.setIconAt(1, this.mergeComplete);
            } else {
                this.tabbedPane.setTitleAt(1, I18n.trn("Tags({0} conflict)", "Tags({0} conflicts)", newValue, newValue));
                this.tabbedPane.setToolTipTextAt(1, I18n.trn("{0} pending tag conflict to be resolved", "{0} pending tag conflicts to be resolved", newValue, newValue));
                this.tabbedPane.setIconAt(1, this.mergeIncomplete);
            }
            this.updateResolvedCompletely();
        } else if (evt.getPropertyName().equals(ListMergeModel.FROZEN_PROP)) {
            boolean frozen = (Boolean)evt.getNewValue();
            if (evt.getSource() == this.nodeListMerger.getModel() && this.my instanceof Way) {
                if (frozen) {
                    this.tabbedPane.setTitleAt(2, I18n.tr("Nodes(resolved)"));
                    this.tabbedPane.setToolTipTextAt(2, I18n.tr("Merged node list frozen. No pending conflicts in the node list of this way"));
                    this.tabbedPane.setIconAt(2, this.mergeComplete);
                } else {
                    this.tabbedPane.setTitleAt(2, I18n.tr("Nodes(with conflicts)"));
                    this.tabbedPane.setToolTipTextAt(2, I18n.tr("Pending conflicts in the node list of this way"));
                    this.tabbedPane.setIconAt(2, this.mergeIncomplete);
                }
            } else if (evt.getSource() == this.relationMemberMerger.getModel() && this.my instanceof Relation) {
                if (frozen) {
                    this.tabbedPane.setTitleAt(3, I18n.tr("Members(resolved)"));
                    this.tabbedPane.setToolTipTextAt(3, I18n.tr("Merged member list frozen. No pending conflicts in the member list of this relation"));
                    this.tabbedPane.setIconAt(3, this.mergeComplete);
                } else {
                    this.tabbedPane.setTitleAt(3, I18n.tr("Members(with conflicts)"));
                    this.tabbedPane.setToolTipTextAt(3, I18n.tr("Pending conflicts in the member list of this relation"));
                    this.tabbedPane.setIconAt(3, this.mergeIncomplete);
                }
            }
            this.updateResolvedCompletely();
        } else if (evt.getPropertyName().equals(PropertiesMergeModel.RESOLVED_COMPLETELY_PROP)) {
            boolean resolved = (Boolean)evt.getNewValue();
            if (resolved) {
                this.tabbedPane.setTitleAt(0, I18n.tr("Properties"));
                this.tabbedPane.setToolTipTextAt(0, I18n.tr("No pending property conflicts"));
                this.tabbedPane.setIconAt(0, this.mergeComplete);
            } else {
                this.tabbedPane.setTitleAt(0, I18n.tr("Properties(with conflicts)"));
                this.tabbedPane.setToolTipTextAt(0, I18n.tr("Pending property conflicts to be resolved"));
                this.tabbedPane.setIconAt(0, this.mergeIncomplete);
            }
            this.updateResolvedCompletely();
        } else if (PropertiesMergeModel.DELETE_PRIMITIVE_PROP.equals(evt.getPropertyName())) {
            for (IConflictResolver resolver : this.conflictResolvers) {
                resolver.deletePrimitive((Boolean)evt.getNewValue());
            }
        }
    }

    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.setMy(conflict.getMy());
        this.setTheir(conflict.getTheir());
        this.conflict = conflict;
        this.propertiesMerger.populate(conflict);
        this.tabbedPane.setEnabledAt(0, true);
        this.tagMerger.populate(conflict);
        this.tabbedPane.setEnabledAt(1, true);
        if (this.my instanceof Node) {
            this.tabbedPane.setEnabledAt(2, false);
            this.tabbedPane.setEnabledAt(3, false);
        } else if (this.my instanceof Way) {
            this.nodeListMerger.populate(conflict);
            this.tabbedPane.setEnabledAt(2, true);
            this.tabbedPane.setEnabledAt(3, false);
            this.tabbedPane.setTitleAt(3, I18n.tr("Members"));
            this.tabbedPane.setIconAt(3, null);
        } else if (this.my instanceof Relation) {
            this.relationMemberMerger.populate(conflict);
            this.tabbedPane.setEnabledAt(2, false);
            this.tabbedPane.setTitleAt(2, I18n.tr("Nodes"));
            this.tabbedPane.setIconAt(2, null);
            this.tabbedPane.setEnabledAt(3, true);
        }
        this.updateResolvedCompletely();
    }

    public Command buildResolveCommand() {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (this.tagMerger.getModel().getNumResolvedConflicts() > 0) {
            commands.add(this.tagMerger.getModel().buildResolveCommand(this.conflict));
        }
        commands.addAll(this.propertiesMerger.getModel().buildResolveCommand(this.conflict));
        if (this.my instanceof Way && this.nodeListMerger.getModel().isFrozen()) {
            NodeListMergeModel model = (NodeListMergeModel)this.nodeListMerger.getModel();
            commands.add(model.buildResolveCommand(this.conflict));
        } else if (this.my instanceof Relation && this.relationMemberMerger.getModel().isFrozen()) {
            RelationMemberListMergeModel model = (RelationMemberListMergeModel)this.relationMemberMerger.getModel();
            commands.add(model.buildResolveCommand((Relation)this.my, (Relation)this.their));
        }
        if (this.isResolvedCompletely()) {
            commands.add(new VersionConflictResolveCommand(this.conflict));
            commands.add(new ModifiedConflictResolveCommand(this.conflict));
        }
        return new SequenceCommand(I18n.tr("Conflict Resolution"), commands);
    }

    protected void updateResolvedCompletely() {
        boolean oldValueResolvedCompletely = this.resolvedCompletely;
        if (this.my instanceof Node) {
            this.resolvedCompletely = this.tagMerger.getModel().isResolvedCompletely() && this.propertiesMerger.getModel().isResolvedCompletely();
        } else if (this.my instanceof Way) {
            this.resolvedCompletely = this.tagMerger.getModel().isResolvedCompletely() && this.propertiesMerger.getModel().isResolvedCompletely() && this.nodeListMerger.getModel().isFrozen();
        } else if (this.my instanceof Relation) {
            boolean bl = this.resolvedCompletely = this.tagMerger.getModel().isResolvedCompletely() && this.propertiesMerger.getModel().isResolvedCompletely() && this.relationMemberMerger.getModel().isFrozen();
        }
        if (this.resolvedCompletely != oldValueResolvedCompletely) {
            this.firePropertyChange(RESOLVED_COMPLETELY_PROP, oldValueResolvedCompletely, this.resolvedCompletely);
        }
    }

    public boolean isResolvedCompletely() {
        return this.resolvedCompletely;
    }
}

