/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationTreeModel
implements TreeModel {
    private Relation root;
    private CopyOnWriteArrayList<TreeModelListener> listeners;

    public RelationTreeModel() {
        this.root = null;
        this.listeners = new CopyOnWriteArrayList();
    }

    public RelationTreeModel(Relation root) {
        this.root = root;
        this.listeners = new CopyOnWriteArrayList();
    }

    public RelationTreeModel(List<RelationMember> members) {
        if (members == null) {
            return;
        }
        Relation root = new Relation();
        root.setMembers(members);
        this.root = root;
        this.listeners = new CopyOnWriteArrayList();
    }

    protected int getNumRelationChildren(Relation parent) {
        if (parent == null) {
            return 0;
        }
        int count = 0;
        for (RelationMember member : parent.getMembers()) {
            if (!member.isRelation()) continue;
            ++count;
        }
        return count;
    }

    protected Relation getRelationChildByIdx(Relation parent, int idx) {
        if (parent == null) {
            return null;
        }
        int count = 0;
        for (RelationMember member : parent.getMembers()) {
            if (!member.isRelation()) continue;
            if (count == idx) {
                return member.getRelation();
            }
            ++count;
        }
        return null;
    }

    protected int getIndexForRelationChild(Relation parent, Relation child) {
        if (parent == null || child == null) {
            return -1;
        }
        int idx = 0;
        for (RelationMember member : parent.getMembers()) {
            if (!member.isRelation()) continue;
            if (member.getMember() == child) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public void populate(Relation root) {
        if (root == null) {
            root = new Relation();
        }
        this.root = root;
        this.fireRootReplacedEvent();
    }

    public void populate(List<RelationMember> members) {
        if (members == null) {
            return;
        }
        Relation r = new Relation();
        r.setMembers(members);
        this.root = r;
        this.fireRootReplacedEvent();
    }

    protected void fireRootReplacedEvent() {
        TreeModelEvent e = new TreeModelEvent((Object)this, new TreePath(this.root));
        for (TreeModelListener l : this.listeners) {
            l.treeStructureChanged(e);
        }
    }

    protected void fireRefreshNode(TreePath path) {
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        for (TreeModelListener l : this.listeners) {
            l.treeStructureChanged(e);
        }
    }

    public void refreshNode(TreePath pathToNode) {
        this.fireRefreshNode(pathToNode);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.getRelationChildByIdx((Relation)parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.getNumRelationChildren((Relation)parent);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getIndexForRelationChild((Relation)parent, (Relation)child);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        Relation r = (Relation)node;
        if (r.isIncomplete()) {
            return false;
        }
        return this.getNumRelationChildren(r) == 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (l != null) {
            this.listeners.addIfAbsent(l);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

