/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.RelationMember;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_NOT_IN_OPPOSITE = new Color(255, 197, 197);
    public static final Color BGCOLOR_IN_OPPOSITE = new Color(255, 234, 213);
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private HashMap<OsmPrimitiveType, ImageIcon> icons;

    public RelationMemberListTableCellRenderer() {
        this.setOpaque(true);
        this.icons = new HashMap();
        this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
        this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
        this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
    }

    protected void renderIcon(RelationMember member) {
        if (member == null) {
            this.setIcon(null);
        } else {
            this.setIcon(this.icons.get((Object)member.getPrimitiveType()));
        }
    }

    protected void renderRole(HistoryBrowserModel.RelationMemberTableModel model, RelationMember member, int row, boolean isSelected) {
        String text = "";
        Color bgColor = Color.WHITE;
        if (member == null) {
            bgColor = BGCOLOR_EMPTY_ROW;
        } else {
            text = member.getRole();
            bgColor = model.isSameInOppositeWay(row) ? Color.WHITE : (model.isInOppositeWay(row) ? BGCOLOR_IN_OPPOSITE : BGCOLOR_NOT_IN_OPPOSITE);
        }
        this.setText(text);
        this.setToolTipText(text);
        this.setBackground(bgColor);
    }

    protected void renderPrimitive(HistoryBrowserModel.RelationMemberTableModel model, RelationMember member, int row, boolean isSelected) {
        String text = "";
        Color bgColor = Color.WHITE;
        if (member == null) {
            bgColor = BGCOLOR_EMPTY_ROW;
        } else {
            text = "";
            switch (member.getPrimitiveType()) {
                case NODE: {
                    text = I18n.tr("Node {0}", member.getPrimitiveId());
                    break;
                }
                case WAY: {
                    text = I18n.tr("Way {0}", member.getPrimitiveId());
                    break;
                }
                case RELATION: {
                    text = I18n.tr("Relation {0}", member.getPrimitiveId());
                }
            }
            bgColor = model.isSameInOppositeWay(row) ? Color.WHITE : (model.isInOppositeWay(row) ? BGCOLOR_IN_OPPOSITE : BGCOLOR_NOT_IN_OPPOSITE);
        }
        this.setText(text);
        this.setToolTipText(text);
        this.setBackground(bgColor);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        HistoryBrowserModel.RelationMemberTableModel model = this.gteRelationMemberTableModel(table);
        RelationMember member = (RelationMember)value;
        this.renderIcon(member);
        switch (column) {
            case 0: {
                this.renderRole(model, member, row, isSelected);
                break;
            }
            case 1: {
                this.renderPrimitive(model, member, row, isSelected);
            }
        }
        return this;
    }

    protected HistoryBrowserModel.RelationMemberTableModel gteRelationMemberTableModel(JTable table) {
        return (HistoryBrowserModel.RelationMemberTableModel)table.getModel();
    }
}

