/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UrlLabel;

public class VersionInfoPanel
extends JPanel
implements Observer {
    private static final Logger logger = Logger.getLogger(VersionInfoPanel.class.getName());
    private PointInTimeType pointInTimeType;
    private HistoryBrowserModel model;
    private JMultilineLabel lblInfo;
    private UrlLabel lblUser;
    private UrlLabel lblChangeset;
    private JPanel pnlUserAndChangeset;

    protected void build() {
        JPanel pnl1 = new JPanel();
        pnl1.setLayout(new BorderLayout());
        this.lblInfo = new JMultilineLabel("");
        pnl1.add((Component)this.lblInfo, "Center");
        this.pnlUserAndChangeset = new JPanel();
        this.pnlUserAndChangeset.setLayout(new FlowLayout(0));
        this.lblUser = new UrlLabel();
        this.pnlUserAndChangeset.add(new JLabel(I18n.tr("User")));
        this.pnlUserAndChangeset.add(this.lblUser);
        this.pnlUserAndChangeset.add(new JLabel(I18n.tr("Changeset")));
        this.lblChangeset = new UrlLabel();
        this.pnlUserAndChangeset.add(this.lblChangeset);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.add((Component)pnl1, gc);
        gc.gridy = 1;
        gc.weighty = 0.0;
        this.add((Component)this.pnlUserAndChangeset, gc);
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected OsmDataLayer getEditLayer() {
        try {
            return Main.map.mapView.getEditLayer();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected String getInfoText() {
        HistoryOsmPrimitive primitive = this.getPrimitive();
        if (primitive == null) {
            return "";
        }
        String text = this.model.isLatest(primitive) ? I18n.tr("<html>Version <strong>{0}</strong> currently edited in layer ''{1}''</html>", Long.toString(primitive.getVersion()), this.getEditLayer() == null ? I18n.tr("unknown") : this.getEditLayer().getName()) : I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong></html>", Long.toString(primitive.getVersion()), new SimpleDateFormat().format(primitive.getTimestamp()));
        return text;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel model, PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        CheckParameterUtil.ensureParameterNotNull(model, "model");
        this.model = model;
        this.pointInTimeType = pointInTimeType;
        model.addObserver(this);
        this.build();
    }

    public void update(Observable o, Object arg) {
        this.lblInfo.setText(this.getInfoText());
        if (!this.model.isLatest(this.getPrimitive())) {
            String url = AbstractInfoAction.getBaseBrowseUrl() + "/changeset/" + this.getPrimitive().getChangesetId();
            this.lblChangeset.setUrl(url);
            this.lblChangeset.setDescription(Long.toString(this.getPrimitive().getChangesetId()));
            try {
                if (this.getPrimitive().getUid() != -1L) {
                    url = AbstractInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(this.getPrimitive().getUser(), "UTF-8").replaceAll("\\+", "%20");
                    this.lblUser.setUrl(url);
                } else {
                    this.lblUser.setUrl(null);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                this.lblUser.setUrl(null);
            }
            String username = this.getPrimitive().getUser();
            this.lblUser.setDescription(username);
        } else {
            String user = Main.pref.get("osm-server.username");
            if (user == null) {
                this.lblUser.setDescription(I18n.tr("anonymous"));
            } else {
                try {
                    String url = AbstractInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(user, "UTF-8").replaceAll("\\+", "%20");
                    this.lblUser.setUrl(url);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    this.lblUser.setUrl(null);
                }
                this.lblUser.setDescription(user);
            }
            this.lblChangeset.setDescription(I18n.tr("none"));
            this.lblChangeset.setUrl(null);
        }
    }
}

