/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedPreference
implements PreferenceSetting {
    private Map<String, String> orig;
    private Map<String, String> defaults;
    private DefaultTableModel model;
    protected Map<String, String> data;
    protected JTextField txtFilter;

    public void addGui(final PreferenceTabbedPane gui) {
        JPanel p = gui.createPreferenceTab("advanced", I18n.tr("Advanced Preferences"), I18n.tr("Setting Preference entries directly. Use with caution!"), false);
        this.txtFilter = new JTextField();
        JLabel lbFilter = new JLabel(I18n.tr("Search: "));
        lbFilter.setLabelFor(this.txtFilter);
        p.add(lbFilter);
        p.add((Component)this.txtFilter, GBC.eol().fill(2));
        this.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.action();
            }

            public void insertUpdate(DocumentEvent e) {
                this.action();
            }

            public void removeUpdate(DocumentEvent e) {
                this.action();
            }

            private void action() {
                AdvancedPreference.this.dataToModel();
            }
        });
        this.model = new DefaultTableModel(new String[]{I18n.tr("Key"), I18n.tr("Value")}, 0){

            public boolean isCellEditable(int row, int column) {
                return column != 0;
            }

            public void fireTableCellUpdated(int row, int column) {
                super.fireTableCellUpdated(row, column);
                if (column == 1) {
                    AdvancedPreference.this.data.put((String)AdvancedPreference.this.model.getValueAt(row, 0), (String)AdvancedPreference.this.model.getValueAt(row, 1));
                }
            }
        };
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = new JLabel();
                String s = (String)AdvancedPreference.this.defaults.get(value);
                if (s != null) {
                    if (s.equals(AdvancedPreference.this.model.getValueAt(row, 1))) {
                        label.setToolTipText(I18n.tr("Current value is default."));
                    } else {
                        label.setToolTipText(I18n.tr("Default value is ''{0}''.", s));
                    }
                } else {
                    label.setToolTipText(I18n.tr("Default value currently unknown (setting has not been used yet)."));
                }
                label.setText((String)value);
                return label;
            }
        };
        final JTable list = new JTable(this.model);
        list.putClientProperty("terminateEditOnFocusLost", true);
        list.getColumn(I18n.tr("Key")).setCellRenderer(renderer);
        JScrollPane scroll = new JScrollPane(list);
        p.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(400, 200));
        this.orig = Main.pref.getAllPrefix("");
        this.defaults = Main.pref.getDefaults();
        this.orig.remove("osm-server.password");
        this.defaults.remove("osm-server.password");
        this.prepareData();
        this.dataToModel();
        JButton add = new JButton(I18n.tr("Add"));
        p.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        p.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedPreference.this.addPreference(gui);
            }
        });
        JButton edit = new JButton(I18n.tr("Edit"));
        p.add((Component)edit, GBC.std().insets(5, 5, 5, 0));
        edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedPreference.this.editPreference(gui, list);
            }
        });
        JButton delete = new JButton(I18n.tr("Delete"));
        p.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedPreference.this.removePreference(gui, list);
            }
        });
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AdvancedPreference.this.editPreference(gui, list);
                }
            }
        });
    }

    private void prepareData() {
        TreeSet<String> ts = new TreeSet<String>(this.orig.keySet());
        for (String s : this.defaults.keySet()) {
            if (ts.contains(s)) continue;
            ts.add(s);
        }
        this.data = new TreeMap<String, String>();
        for (String s : ts) {
            String val = Main.pref.get(s);
            if (val == null) {
                val = "";
            }
            this.data.put(s, val);
        }
    }

    private void dataToModel() {
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        for (String prefKey : this.data.keySet()) {
            String prefValue = this.data.get(prefKey);
            String[] input = this.txtFilter.getText().split("\\s+");
            boolean canHas = true;
            for (String bit : input) {
                if (prefKey.contains(bit) || prefValue.contains(bit)) continue;
                canHas = false;
            }
            if (!canHas) continue;
            this.model.addRow(new String[]{prefKey, prefValue});
        }
    }

    public boolean ok() {
        for (String string : this.data.keySet()) {
            String value = this.data.get(string);
            if (value.length() == 0) continue;
            String origValue = this.orig.get(string);
            if (origValue == null || !origValue.equals(value)) {
                Main.pref.put(string, value);
            }
            this.orig.remove(string);
        }
        for (Map.Entry entry : this.orig.entrySet()) {
            Main.pref.put((String)entry.getKey(), null);
        }
        return false;
    }

    private void removePreference(PreferenceTabbedPane gui, JTable list) {
        if (list.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(gui, I18n.tr("Please select the row to delete."), I18n.tr("Warning"), 2);
            return;
        }
        for (int row : list.getSelectedRows()) {
            this.data.put((String)this.model.getValueAt(row, 0), "");
            this.model.setValueAt("", row, 1);
        }
    }

    private void addPreference(PreferenceTabbedPane gui) {
        String[] s = this.showEditDialog(gui, I18n.tr("Enter a new key/value pair"), "", "");
        if (s != null && !s[0].isEmpty() && !s[1].isEmpty()) {
            this.data.put(s[0], s[1]);
            this.dataToModel();
        }
    }

    private void editPreference(PreferenceTabbedPane gui, JTable list) {
        String[] s;
        if (list.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(gui, I18n.tr("Please select the row to edit."), I18n.tr("Warning"), 2);
            return;
        }
        String key = (String)this.model.getValueAt(list.getSelectedRow(), 0);
        String value = this.data.get(key);
        if (value.isEmpty()) {
            value = this.defaults.get(key);
        }
        if ((s = this.showEditDialog(gui, I18n.tr("Change a key/value pair"), key, value)) != null && !s[0].isEmpty()) {
            this.data.put(s[0], s[1]);
            if (!s[0].equals(key)) {
                this.data.put(key, "");
            }
            this.dataToModel();
        }
    }

    private String[] showEditDialog(PreferenceTabbedPane gui, String title, String key, String value) {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Key")), GBC.std().insets(0, 0, 5, 0));
        JTextField tkey = new JTextField(key, 50);
        JTextField tvalue = new JTextField(value, 50);
        p.add((Component)tkey, GBC.eop().insets(5, 0, 0, 0).fill(2));
        PrefValueTableModel model = new PrefValueTableModel(value);
        p.add((Component)new JLabel(I18n.tr("Values")), GBC.std().insets(0, 0, 5, 0));
        JTable table = new JTable(model);
        table.putClientProperty("terminateEditOnFocusLost", true);
        table.getTableHeader().setVisible(false);
        JScrollPane pane = new JScrollPane(table);
        Dimension d = pane.getPreferredSize();
        d.height = d.height / 20 * (model.getRowCount() + 4);
        pane.setPreferredSize(d);
        p.add((Component)pane, GBC.eol().insets(5, 10, 0, 0).fill(2));
        ExtendedDialog ed = new ExtendedDialog(gui, title, new String[]{I18n.tr("OK"), I18n.tr("Cancel")});
        ed.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        ed.setContent(p);
        ed.showDialog();
        if (ed.getValue() == 1) {
            return new String[]{tkey.getText(), model.getText()};
        }
        return null;
    }

    class PrefValueTableModel
    extends DefaultTableModel {
        private final ArrayList<String> data = new ArrayList();

        public PrefValueTableModel(String val) {
            this.data.addAll(Arrays.asList(val.split("\u001e")));
            this.setColumnIdentifiers(new String[]{""});
        }

        public String getText() {
            String s = null;
            for (String a : this.data) {
                if (s == null) {
                    s = a;
                    continue;
                }
                s = s + "\u001e" + a;
            }
            return s == null ? "" : s;
        }

        public int getRowCount() {
            return this.data == null ? 1 : this.data.size() + 1;
        }

        public Object getValueAt(int row, int column) {
            return this.data.size() == row ? "" : this.data.get(row);
        }

        public void setValueAt(Object o, int row, int column) {
            String s = (String)o;
            if (row == this.data.size()) {
                this.data.add(s);
                this.fireTableRowsInserted(row + 1, row + 1);
            } else {
                this.data.set(row, s);
            }
            this.fireTableCellUpdated(row, column);
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new AdvancedPreference();
        }
    }
}

