/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.data.preferences.ParametrizedCollectionProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionPreference
implements PreferenceSetting {
    private static final StringProperty PROP_PROJECTION = new StringProperty("projection", Mercator.class.getName());
    private static final StringProperty PROP_COORDINATES = new StringProperty("coordinates", null);
    private static final CollectionProperty PROP_SUB_PROJECTION = new CollectionProperty("projection.sub", null);
    private static final ParametrizedCollectionProperty PROP_PROJECTION_SUBPROJECTION = new ParametrizedCollectionProperty(null){

        protected String getKey(String ... params) {
            String name = params[0];
            String sname = name.substring(name.lastIndexOf(".") + 1);
            return "projection.sub." + sname;
        }
    };
    public static final StringProperty PROP_SYSTEM_OF_MEASUREMENT = new StringProperty("system_of_measurement", "Metric");
    private static final String[] unitsValues = new ArrayList<String>(NavigatableComponent.SYSTEMS_OF_MEASUREMENT.keySet()).toArray(new String[0]);
    private static final String[] unitsValuesTr = new String[unitsValues.length];
    private static CopyOnWriteArrayList<ProjectionChangedListener> listeners;
    private JComboBox projectionCombo = new JComboBox<Projection>(Projection.allProjections);
    private JComboBox coordinatesCombo = new JComboBox<CoordinateFormat>(CoordinateFormat.values());
    private JComboBox unitsCombo = new JComboBox<String>(unitsValuesTr);
    private JPanel projSubPrefPanel;
    private JPanel projSubPrefPanelWrapper = new JPanel(new GridBagLayout());
    private JLabel projectionCode = new JLabel();
    private JLabel bounds = new JLabel();
    private JPanel projPanel = new JPanel(new GridBagLayout());
    private static GBC projSubPrefPanelGBC;

    public static void addProjectionChangedListener(ProjectionChangedListener listener) {
        listeners.addIfAbsent(listener);
    }

    public static void removeProjectionChangedListener(ProjectionChangedListener listener) {
        listeners.remove(listener);
    }

    private static void fireProjectionChanged() {
        for (ProjectionChangedListener listener : listeners) {
            listener.projectionChanged();
        }
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        int i;
        this.setupProjectionCombo();
        for (i = 0; i < this.coordinatesCombo.getItemCount(); ++i) {
            if (!((CoordinateFormat)((Object)this.coordinatesCombo.getItemAt(i))).name().equals(PROP_COORDINATES.get())) continue;
            this.coordinatesCombo.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < unitsValues.length; ++i) {
            if (!unitsValues[i].equals(PROP_SYSTEM_OF_MEASUREMENT.get())) continue;
            this.unitsCombo.setSelectedIndex(i);
            break;
        }
        this.projPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projPanel.setLayout(new GridBagLayout());
        this.projPanel.add((Component)new JLabel(I18n.tr("Projection method")), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Projection code")), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCode, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Bounds")), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.bounds, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projSubPrefPanelWrapper.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        this.projPanel.add((Component)this.projSubPrefPanelWrapper, GBC.eol().fill(2).insets(20, 5, 5, 5));
        this.projPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 10));
        this.projPanel.add((Component)new JLabel(I18n.tr("Display coordinates as")), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.coordinatesCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("System of measurement")), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.unitsCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add(GBC.glue(1, 1), GBC.std().fill(2).weight(1.0, 1.0));
        JScrollPane scrollpane = new JScrollPane(this.projPanel);
        gui.mapcontent.addTab(I18n.tr("Map Projection"), scrollpane);
        this.updateMeta(Main.proj);
    }

    private void updateMeta(Projection proj) {
        this.projectionCode.setText(proj.toCode());
        Bounds b = proj.getWorldBoundsLatLon();
        CoordinateFormat cf = CoordinateFormat.getDefaultFormat();
        this.bounds.setText(b.getMin().latToString(cf) + "; " + b.getMin().lonToString(cf) + " : " + b.getMax().latToString(cf) + "; " + b.getMax().lonToString(cf));
    }

    @Override
    public boolean ok() {
        Projection proj = (Projection)this.projectionCombo.getSelectedItem();
        String projname = proj.getClass().getName();
        Collection<String> prefs = null;
        if (proj instanceof ProjectionSubPrefs) {
            prefs = ((ProjectionSubPrefs)((Object)proj)).getPreferences(this.projSubPrefPanel);
        }
        PROP_PROJECTION.put(projname);
        ProjectionPreference.setProjection(projname, prefs);
        if (PROP_COORDINATES.put(((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem())).name())) {
            CoordinateFormat.setCoordinateFormat((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem()));
        }
        int i = this.unitsCombo.getSelectedIndex();
        PROP_SYSTEM_OF_MEASUREMENT.put(unitsValues[i]);
        return false;
    }

    public static void setProjection() {
        ProjectionPreference.setProjection(PROP_PROJECTION.get(), PROP_SUB_PROJECTION.get());
    }

    public static void setProjection(String name, Collection<String> coll) {
        Bounds b = Main.map != null && Main.map.mapView != null ? Main.map.mapView.getRealBounds() : null;
        Projection oldProj = Main.proj;
        try {
            Main.proj = (Projection)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The projection {0} could not be activated. Using Mercator", name), I18n.tr("Error"), 0);
            coll = null;
            Main.proj = new Mercator();
            name = Main.proj.getClass().getName();
        }
        PROP_SUB_PROJECTION.put(coll);
        PROP_PROJECTION_SUBPROJECTION.put(coll, name);
        if (Main.proj instanceof ProjectionSubPrefs) {
            ((ProjectionSubPrefs)((Object)Main.proj)).setPreferences(coll);
        }
        ProjectionPreference.fireProjectionChanged();
        if (!(b == null || Main.proj.getClass().getName().equals(oldProj.getClass().getName()) && Main.proj.hashCode() == oldProj.hashCode())) {
            Main.map.mapView.zoomTo(b);
        }
    }

    private void selectedProjectionChanged(Projection proj) {
        if (!(proj instanceof ProjectionSubPrefs)) {
            this.projSubPrefPanel = new JPanel();
        } else {
            ProjectionSubPrefs projPref = (ProjectionSubPrefs)((Object)proj);
            this.projSubPrefPanel = new SBPanel(proj);
            projPref.setupPreferencePanel(this.projSubPrefPanel);
        }
        int size = this.projPanel.getComponentCount();
        if (size < 1) {
            return;
        }
        this.projSubPrefPanelWrapper.removeAll();
        this.projSubPrefPanelWrapper.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        this.projPanel.revalidate();
        this.projSubPrefPanel.repaint();
        this.updateMeta(proj);
    }

    private void setupProjectionCombo() {
        for (int i = 0; i < this.projectionCombo.getItemCount(); ++i) {
            Projection proj = (Projection)this.projectionCombo.getItemAt(i);
            String name = proj.getClass().getName();
            if (proj instanceof ProjectionSubPrefs) {
                ((ProjectionSubPrefs)((Object)proj)).setPreferences(PROP_PROJECTION_SUBPROJECTION.get(name));
            }
            if (!name.equals(PROP_PROJECTION.get())) continue;
            this.projectionCombo.setSelectedIndex(i);
            this.selectedProjectionChanged(proj);
            break;
        }
        this.projectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                Projection proj = (Projection)cb.getSelectedItem();
                ProjectionPreference.this.selectedProjectionChanged(proj);
            }
        });
    }

    static {
        for (int i = 0; i < unitsValues.length; ++i) {
            ProjectionPreference.unitsValuesTr[i] = I18n.tr(unitsValues[i]);
        }
        listeners = new CopyOnWriteArrayList();
        projSubPrefPanelGBC = GBC.std().fill(1).weight(1.0, 1.0);
    }

    private class SBPanel
    extends JPanel {
        private Projection p;

        public SBPanel(Projection pr) {
            this.p = pr;
        }

        public void paint(Graphics g) {
            super.paint(g);
            ((ProjectionSubPrefs)((Object)this.p)).setPreferences(((ProjectionSubPrefs)((Object)this.p)).getPreferences(this));
            ProjectionPreference.this.updateMeta(this.p);
        }
    }

    public static interface ProjectionChangedListener {
        public void projectionChanged();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ProjectionPreference();
        }
    }
}

