/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.util.logging.Logger;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.CredentialsManagerException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OAuthAccessTokenHolder {
    private static final Logger logger = Logger.getLogger(OAuthAccessTokenHolder.class.getName());
    private static OAuthAccessTokenHolder instance;
    private boolean saveToPreferences;
    private String accessTokenKey;
    private String accessTokenSecret;

    public static OAuthAccessTokenHolder getInstance() {
        if (instance == null) {
            instance = new OAuthAccessTokenHolder();
        }
        return instance;
    }

    public boolean isSaveToPreferences() {
        return this.saveToPreferences;
    }

    public void setSaveToPreferences(boolean saveToPreferences) {
        this.saveToPreferences = saveToPreferences;
    }

    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public void setAccessTokenKey(String accessTokenKey) {
        this.accessTokenKey = accessTokenKey;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public OAuthToken getAccessToken() {
        if (!this.containsAccessToken()) {
            return null;
        }
        return new OAuthToken(this.accessTokenKey, this.accessTokenSecret);
    }

    public void setAccessToken(String accessTokenKey, String accessTokenSecret) {
        this.accessTokenKey = accessTokenKey;
        this.accessTokenSecret = accessTokenSecret;
    }

    public void setAccessToken(OAuthToken token) {
        if (token == null) {
            this.accessTokenKey = null;
            this.accessTokenSecret = null;
        } else {
            this.accessTokenKey = token.getKey();
            this.accessTokenSecret = token.getSecret();
        }
    }

    public boolean containsAccessToken() {
        return this.accessTokenKey != null && this.accessTokenSecret != null;
    }

    public void init(Preferences pref, CredentialsManager cm) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(pref, "pref");
        CheckParameterUtil.ensureParameterNotNull(cm, "cm");
        OAuthToken token = null;
        try {
            token = cm.lookupOAuthAccessToken();
        }
        catch (CredentialsManagerException e) {
            e.printStackTrace();
            System.err.println(I18n.tr("Warning: Failed to retrieve OAuth Access Token from credential manager"));
            System.err.println(I18n.tr("Current credential manager is of type ''{0}''", cm.getClass().getName()));
        }
        this.saveToPreferences = pref.getBoolean("oauth.access-token.save-to-preferences", true);
        if (token != null) {
            this.accessTokenKey = token.getKey();
            this.accessTokenSecret = token.getSecret();
        }
    }

    public void save(Preferences preferences, CredentialsManager cm) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(preferences, "preferences");
        CheckParameterUtil.ensureParameterNotNull(cm, "cm");
        preferences.put("oauth.access-token.save-to-preferences", this.saveToPreferences);
        try {
            if (!this.saveToPreferences) {
                cm.storeOAuthAccessToken(null);
            } else {
                cm.storeOAuthAccessToken(new OAuthToken(this.accessTokenKey, this.accessTokenSecret));
            }
        }
        catch (CredentialsManagerException e) {
            e.printStackTrace();
            System.err.println(I18n.tr("Warning: Failed to store OAuth Access Token to credentials manager"));
            System.err.println(I18n.tr("Current credential manager is of type ''{0}''", cm.getClass().getName()));
        }
    }

    public void clear() {
        this.accessTokenKey = null;
        this.accessTokenSecret = null;
    }
}

