/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.NmeaReader;
import org.openstreetmap.josm.tools.I18n;

public class NMEAImporter
extends FileImporter {
    public NMEAImporter() {
        super(new ExtensionFileFilter("nmea,nme,nma,log,txt", "nmea", I18n.tr("NMEA-0183 Files") + " (*.nmea *.nme *.nma *.log *.txt)"));
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        String fn = file.getName();
        NmeaReader r = new NmeaReader(new FileInputStream(file), file.getAbsoluteFile().getParentFile());
        if (r.getNumberOfCoordinates() > 0) {
            r.data.storageFile = file;
            GpxLayer gpxLayer = new GpxLayer(r.data, fn, true);
            Main.main.addLayer(gpxLayer);
            if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                MarkerLayer ml = new MarkerLayer(r.data, I18n.tr("Markers from {0}", fn), file, gpxLayer);
                if (ml.data.size() > 0) {
                    Main.main.addLayer(ml);
                }
            }
        }
        this.showNmeaInfobox(r.getNumberOfCoordinates() > 0, r);
    }

    private void showNmeaInfobox(boolean success, NmeaReader r) {
        StringBuilder msg = new StringBuilder().append("<html>");
        msg.append(I18n.tr("Coordinates imported: {0}", r.getNumberOfCoordinates()) + "<br>");
        msg.append(I18n.tr("Malformed sentences: {0}", r.getParserMalformed()) + "<br>");
        msg.append(I18n.tr("Checksum errors: {0}", r.getParserChecksumErrors()) + "<br>");
        if (!success) {
            msg.append(I18n.tr("Unknown sentences: {0}", r.getParserUnknown()) + "<br>");
        }
        msg.append(I18n.tr("Zero coordinates: {0}", r.getParserZeroCoordinates()));
        msg.append("</html>");
        if (success) {
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, msg.toString(), I18n.tr("NMEA import success"), 1, null);
        } else {
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, msg.toString(), I18n.tr("NMEA import failure!"), 0, null);
        }
    }
}

