/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiPreconditionCheckerHook
implements UploadHook {
    @Override
    public boolean checkUpload(APIDataSet apiData) {
        OsmApi api = OsmApi.getOsmApi();
        try {
            api.initialize(NullProgressMonitor.INSTANCE);
            long maxNodes = 0L;
            if (api.getCapabilities().isDefined("waynodes", "maximum")) {
                maxNodes = api.getCapabilities().getLong("waynodes", "maximum");
            }
            if (maxNodes > 0L) {
                if (!this.checkMaxNodes(apiData.getPrimitivesToAdd(), maxNodes)) {
                    return false;
                }
                if (!this.checkMaxNodes(apiData.getPrimitivesToUpdate(), maxNodes)) {
                    return false;
                }
                if (!this.checkMaxNodes(apiData.getPrimitivesToDelete(), maxNodes)) {
                    return false;
                }
            }
        }
        catch (OsmTransferCancelledException e) {
            return false;
        }
        catch (OsmApiInitializationException e) {
            ExceptionDialogUtil.explainOsmTransferException(e);
            return false;
        }
        return true;
    }

    private boolean checkMaxNodes(Collection<OsmPrimitive> primitives, long maxNodes) {
        for (OsmPrimitive osmPrimitive : primitives) {
            for (String key : osmPrimitive.keySet()) {
                String value = osmPrimitive.get(key);
                if (key.length() <= 255) continue;
                if (osmPrimitive.isDeleted()) {
                    System.out.println(I18n.tr("Warning: automatically truncating value of tag ''{0}'' on deleted object {1}", key, Long.toString(osmPrimitive.getId())));
                    osmPrimitive.put(key, value.substring(0, 255));
                    continue;
                }
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Length of value for tag ''{0}'' on object {1} exceeds the max. allowed length {2}. Values length is {3}.", key, Long.toString(osmPrimitive.getId()), 255, value.length()), I18n.tr("Precondition Violation"), 0);
                Main.main.getCurrentDataSet().setSelected(Collections.singleton(osmPrimitive));
                return false;
            }
            if (!(osmPrimitive instanceof Way) || (long)((Way)osmPrimitive).getNodesCount() <= maxNodes) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("{0} nodes in way {1} exceed the max. allowed number of nodes {2}", ((Way)osmPrimitive).getNodesCount(), Long.toString(osmPrimitive.getId()), maxNodes), I18n.tr("API Capabilities Violation"), 0);
            Main.main.getCurrentDataSet().setSelected(Collections.singleton(osmPrimitive));
            return false;
        }
        return true;
    }
}

