/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmServerWriter {
    private static final Logger logger = Logger.getLogger(OsmServerWriter.class.getName());
    private Collection<OsmPrimitive> processed;
    private OsmApi api = OsmApi.getOsmApi();
    private boolean canceled = false;
    private static final int MSECS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MSECS_PER_MINUTE = 60000;
    long uploadStartTime;

    public String timeLeft(int progress, int list_size) {
        long now = System.currentTimeMillis();
        long elapsed = now - this.uploadStartTime;
        if (elapsed == 0L) {
            elapsed = 1L;
        }
        float uploads_per_ms = (float)progress / (float)elapsed;
        float uploads_left = list_size - progress;
        int ms_left = (int)(uploads_left / uploads_per_ms);
        int minutes_left = ms_left / 60000;
        int seconds_left = ms_left / 1000 % 60;
        String time_left_str = Integer.toString(minutes_left) + ":";
        if (seconds_left < 10) {
            time_left_str = time_left_str + "0";
        }
        time_left_str = time_left_str + Integer.toString(seconds_left);
        return time_left_str;
    }

    protected void uploadChangesIndividually(Collection<OsmPrimitive> primitives, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload with one request per primitive ..."));
            progressMonitor.setTicksCount(primitives.size());
            this.uploadStartTime = System.currentTimeMillis();
            for (OsmPrimitive osm : primitives) {
                int progress = progressMonitor.getTicks();
                String time_left_str = this.timeLeft(progress, primitives.size());
                String msg = "";
                switch (OsmPrimitiveType.from(osm)) {
                    case NODE: {
                        msg = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading node ''{4}'' (id: {5})");
                        break;
                    }
                    case WAY: {
                        msg = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading way ''{4}'' (id: {5})");
                        break;
                    }
                    case RELATION: {
                        msg = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading relation ''{4}'' (id: {5})");
                    }
                }
                progressMonitor.subTask(I18n.tr(msg, Math.round(100.0 * (double)progress / (double)primitives.size()), progress, primitives.size(), time_left_str, osm.getName() == null ? Long.valueOf(osm.getId()) : osm.getName(), osm.getId()));
                this.makeApiRequest(osm, progressMonitor);
                this.processed.add(osm);
                progressMonitor.worked(1);
            }
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected void uploadChangesAsDiffUpload(Collection<OsmPrimitive> primitives, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload in one request ..."));
            this.processed.addAll(this.api.uploadDiff(primitives, progressMonitor.createSubTaskMonitor(-1, false)));
        }
        catch (OsmTransferException e) {
            throw e;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected void uploadChangesInChunks(Collection<OsmPrimitive> primitives, ProgressMonitor progressMonitor, int chunkSize) throws OsmTransferException, IllegalArgumentException {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException(I18n.tr("Value >0 expected for parameter ''{0}'', got {1}", "chunkSize", chunkSize));
        }
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload in chunks..."));
            ArrayList<OsmPrimitive> chunk = new ArrayList<OsmPrimitive>(chunkSize);
            Iterator<OsmPrimitive> it = primitives.iterator();
            int numChunks = (int)Math.ceil((double)primitives.size() / (double)chunkSize);
            int i = 0;
            while (it.hasNext()) {
                ++i;
                if (this.canceled) {
                    return;
                }
                chunk.clear();
                for (int j = 0; it.hasNext() && j < chunkSize; ++j) {
                    if (this.canceled) {
                        return;
                    }
                    chunk.add(it.next());
                }
                progressMonitor.setCustomText(I18n.trn("({0}/{1}) Uploading {2} object...", "({0}/{1}) Uploading {2} objects...", chunk.size(), i, numChunks, chunk.size()));
                this.processed.addAll(this.api.uploadDiff(chunk, progressMonitor.createSubTaskMonitor(-1, false)));
            }
        }
        catch (OsmTransferException e) {
            throw e;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uploadOsm(UploadStrategySpecification strategy, Collection<OsmPrimitive> primitives, Changeset changeset, ProgressMonitor monitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        this.processed = new LinkedList<OsmPrimitive>();
        monitor = monitor == null ? NullProgressMonitor.INSTANCE : monitor;
        monitor.beginTask(I18n.tr("Uploading data ..."));
        try {
            this.api.initialize(monitor);
            if (changeset.getId() == 0) {
                this.api.openChangeset(changeset, monitor.createSubTaskMonitor(0, false));
            } else {
                this.api.updateChangeset(changeset, monitor.createSubTaskMonitor(0, false));
            }
            this.api.setChangeset(changeset);
            switch (strategy.getStrategy()) {
                case SINGLE_REQUEST_STRATEGY: {
                    this.uploadChangesAsDiffUpload(primitives, monitor.createSubTaskMonitor(0, false));
                    return;
                }
                case INDIVIDUAL_OBJECTS_STRATEGY: {
                    this.uploadChangesIndividually(primitives, monitor.createSubTaskMonitor(0, false));
                    return;
                }
                case CHUNKED_DATASET_STRATEGY: {
                    this.uploadChangesInChunks(primitives, monitor.createSubTaskMonitor(0, false), strategy.getChunkSize());
                    return;
                }
            }
            return;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        finally {
            monitor.finishTask();
            this.api.setChangeset(null);
        }
    }

    void makeApiRequest(OsmPrimitive osm, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (osm.isDeleted()) {
            this.api.deletePrimitive(osm, progressMonitor);
        } else if (osm.isNew()) {
            this.api.createPrimitive(osm, progressMonitor);
        } else {
            this.api.modifyPrimitive(osm, progressMonitor);
        }
    }

    public void cancel() {
        this.canceled = true;
        if (this.api != null) {
            this.api.cancel();
        }
    }

    public Collection<OsmPrimitive> getProcessedPrimitives() {
        return this.processed;
    }
}

