/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.spi.LocaleNameProvider;
import sun.security.action.GetPropertyAction;
import sun.util.LocaleServiceProviderPool;
import sun.util.locale.AsciiUtil;
import sun.util.locale.BaseLocale;
import sun.util.locale.InternalLocaleBuilder;
import sun.util.locale.LanguageTag;
import sun.util.locale.LocaleExtensions;
import sun.util.locale.LocaleObjectCache;
import sun.util.locale.LocaleSyntaxException;
import sun.util.locale.ParseStatus;
import sun.util.locale.UnicodeLocaleExtension;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class Locale
implements Cloneable,
Serializable {
    private static final Cache LOCALECACHE = new Cache();
    public static final Locale ENGLISH = Locale.getInstance("en", "", "");
    public static final Locale FRENCH = Locale.getInstance("fr", "", "");
    public static final Locale GERMAN = Locale.getInstance("de", "", "");
    public static final Locale ITALIAN = Locale.getInstance("it", "", "");
    public static final Locale JAPANESE = Locale.getInstance("ja", "", "");
    public static final Locale KOREAN = Locale.getInstance("ko", "", "");
    public static final Locale CHINESE = Locale.getInstance("zh", "", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.getInstance("zh", "CN", "");
    public static final Locale TRADITIONAL_CHINESE = Locale.getInstance("zh", "TW", "");
    public static final Locale FRANCE = Locale.getInstance("fr", "FR", "");
    public static final Locale GERMANY = Locale.getInstance("de", "DE", "");
    public static final Locale ITALY = Locale.getInstance("it", "IT", "");
    public static final Locale JAPAN = Locale.getInstance("ja", "JP", "");
    public static final Locale KOREA = Locale.getInstance("ko", "KR", "");
    public static final Locale CHINA = SIMPLIFIED_CHINESE;
    public static final Locale PRC = SIMPLIFIED_CHINESE;
    public static final Locale TAIWAN = TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.getInstance("en", "GB", "");
    public static final Locale US = Locale.getInstance("en", "US", "");
    public static final Locale CANADA = Locale.getInstance("en", "CA", "");
    public static final Locale CANADA_FRENCH = Locale.getInstance("fr", "CA", "");
    public static final Locale ROOT = Locale.getInstance("", "", "");
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char UNICODE_LOCALE_EXTENSION = 'u';
    static final long serialVersionUID = 9149081749638150636L;
    private static final int DISPLAY_LANGUAGE = 0;
    private static final int DISPLAY_COUNTRY = 1;
    private static final int DISPLAY_VARIANT = 2;
    private static final int DISPLAY_SCRIPT = 3;
    private transient BaseLocale _baseLocale;
    private transient LocaleExtensions _extensions;
    private volatile transient int hashCodeValue = 0;
    private static Locale defaultLocale = null;
    private static Locale defaultDisplayLocale = null;
    private static Locale defaultFormatLocale = null;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("language", String.class), new ObjectStreamField("country", String.class), new ObjectStreamField("variant", String.class), new ObjectStreamField("hashcode", Integer.TYPE), new ObjectStreamField("script", String.class), new ObjectStreamField("extensions", String.class)};
    private static volatile String[] isoLanguages = null;
    private static volatile String[] isoCountries = null;

    private Locale(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        this._baseLocale = baseLocale;
        this._extensions = localeExtensions;
    }

    public Locale(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException();
        }
        this._baseLocale = BaseLocale.getInstance(Locale.convertOldISOCodes(string), "", string2, string3);
        this._extensions = Locale.getCompatibilityExtensions(string, "", string2, string3);
    }

    public Locale(String string, String string2) {
        this(string, string2, "");
    }

    public Locale(String string) {
        this(string, "", "");
    }

    static Locale getInstance(String string, String string2, String string3) {
        return Locale.getInstance(string, "", string2, string3, LocaleExtensions.EMPTY_EXTENSIONS);
    }

    static Locale getInstance(String string, String string2, String string3, String string4, LocaleExtensions localeExtensions) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new NullPointerException();
        }
        if (localeExtensions == null) {
            localeExtensions = LocaleExtensions.EMPTY_EXTENSIONS;
        }
        if (localeExtensions.equals(LocaleExtensions.EMPTY_EXTENSIONS)) {
            localeExtensions = Locale.getCompatibilityExtensions(string, string2, string3, string4);
        }
        BaseLocale baseLocale = BaseLocale.getInstance(string, string2, string3, string4);
        return Locale.getInstance(baseLocale, localeExtensions);
    }

    static Locale getInstance(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        LocaleKey localeKey = new LocaleKey(baseLocale, localeExtensions);
        return (Locale)LOCALECACHE.get(localeKey);
    }

    public static Locale getDefault() {
        if (defaultLocale == null) {
            Locale.initDefault();
        }
        return defaultLocale;
    }

    public static Locale getDefault(Category category) {
        switch (category) {
            case DISPLAY: {
                if (defaultDisplayLocale == null) {
                    Locale.initDefault(category);
                }
                return defaultDisplayLocale;
            }
            case FORMAT: {
                if (defaultFormatLocale == null) {
                    Locale.initDefault(category);
                }
                return defaultFormatLocale;
            }
        }
        assert (false) : "Unknown Category";
        return Locale.getDefault();
    }

    private static void initDefault() {
        String string;
        String string2;
        String string3;
        String string4 = AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
        String string5 = AccessController.doPrivileged(new GetPropertyAction("user.region"));
        if (string5 != null) {
            int n = string5.indexOf(95);
            if (n >= 0) {
                string3 = string5.substring(0, n);
                string2 = string5.substring(n + 1);
            } else {
                string3 = string5;
                string2 = "";
            }
            string = "";
        } else {
            string = AccessController.doPrivileged(new GetPropertyAction("user.script", ""));
            string3 = AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
            string2 = AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
        }
        defaultLocale = Locale.getInstance(string4, string, string3, string2, null);
    }

    private static void initDefault(Category category) {
        if (defaultLocale == null) {
            Locale.initDefault();
        }
        Locale locale = Locale.getInstance(AccessController.doPrivileged(new GetPropertyAction(category.languageKey, defaultLocale.getLanguage())), AccessController.doPrivileged(new GetPropertyAction(category.scriptKey, defaultLocale.getScript())), AccessController.doPrivileged(new GetPropertyAction(category.countryKey, defaultLocale.getCountry())), AccessController.doPrivileged(new GetPropertyAction(category.variantKey, defaultLocale.getVariant())), null);
        switch (category) {
            case DISPLAY: {
                defaultDisplayLocale = locale;
                break;
            }
            case FORMAT: {
                defaultFormatLocale = locale;
            }
        }
    }

    public static synchronized void setDefault(Locale locale) {
        Locale.setDefault(Category.DISPLAY, locale);
        Locale.setDefault(Category.FORMAT, locale);
        defaultLocale = locale;
    }

    public static synchronized void setDefault(Category category, Locale locale) {
        if (category == null) {
            throw new NullPointerException("Category cannot be NULL");
        }
        if (locale == null) {
            throw new NullPointerException("Can't set default locale to NULL");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission("user.language", "write"));
        }
        switch (category) {
            case DISPLAY: {
                defaultDisplayLocale = locale;
                break;
            }
            case FORMAT: {
                defaultFormatLocale = locale;
                break;
            }
            default: {
                assert (false) : "Unknown Category";
                break;
            }
        }
    }

    public static Locale[] getAvailableLocales() {
        return LocaleServiceProviderPool.getAllAvailableLocales();
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = Locale.getISO2Table("ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBLBLMBMBMUBNBRNBOBOLBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICUCUBCVCPVCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMFMAFMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSTSTPSVSLVSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        }
        String[] stringArray = new String[isoCountries.length];
        System.arraycopy(isoCountries, 0, stringArray, 0, isoCountries.length);
        return stringArray;
    }

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = Locale.getISO2Table("aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        }
        String[] stringArray = new String[isoLanguages.length];
        System.arraycopy(isoLanguages, 0, stringArray, 0, isoLanguages.length);
        return stringArray;
    }

    private static final String[] getISO2Table(String string) {
        int n = string.length() / 5;
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            stringArray[n2] = string.substring(n3, n3 + 2);
            ++n2;
            n3 += 5;
        }
        return stringArray;
    }

    public String getLanguage() {
        return this._baseLocale.getLanguage();
    }

    public String getScript() {
        return this._baseLocale.getScript();
    }

    public String getCountry() {
        return this._baseLocale.getRegion();
    }

    public String getVariant() {
        return this._baseLocale.getVariant();
    }

    public String getExtension(char c) {
        if (!LocaleExtensions.isValidKey(c)) {
            throw new IllegalArgumentException("Ill-formed extension key: " + c);
        }
        return this._extensions.getExtensionValue(Character.valueOf(c));
    }

    public Set<Character> getExtensionKeys() {
        return this._extensions.getKeys();
    }

    public Set<String> getUnicodeLocaleAttributes() {
        return this._extensions.getUnicodeLocaleAttributes();
    }

    public String getUnicodeLocaleType(String string) {
        if (!UnicodeLocaleExtension.isKey(string)) {
            throw new IllegalArgumentException("Ill-formed Unicode locale key: " + string);
        }
        return this._extensions.getUnicodeLocaleType(string);
    }

    public Set<String> getUnicodeLocaleKeys() {
        return this._extensions.getUnicodeLocaleKeys();
    }

    BaseLocale getBaseLocale() {
        return this._baseLocale;
    }

    LocaleExtensions getLocaleExtensions() {
        return this._extensions;
    }

    public final String toString() {
        boolean bl = this._baseLocale.getLanguage().length() != 0;
        boolean bl2 = this._baseLocale.getScript().length() != 0;
        boolean bl3 = this._baseLocale.getRegion().length() != 0;
        boolean bl4 = this._baseLocale.getVariant().length() != 0;
        boolean bl5 = this._extensions.getID().length() != 0;
        StringBuilder stringBuilder = new StringBuilder(this._baseLocale.getLanguage());
        if (bl3 || bl && bl4) {
            stringBuilder.append('_').append(this._baseLocale.getRegion());
        }
        if (bl4 && (bl || bl3)) {
            stringBuilder.append('_').append(this._baseLocale.getVariant());
        }
        if (bl2 && (bl || bl3)) {
            stringBuilder.append("_#").append(this._baseLocale.getScript());
        }
        if (bl5 && (bl || bl3)) {
            stringBuilder.append('_');
            if (!bl2) {
                stringBuilder.append('#');
            }
            stringBuilder.append(this._extensions.getID());
        }
        return stringBuilder.toString();
    }

    public String toLanguageTag() {
        LanguageTag languageTag = LanguageTag.parseLocale(this._baseLocale, this._extensions);
        StringBuilder stringBuilder = new StringBuilder();
        String string = languageTag.getLanguage();
        stringBuilder.append(LanguageTag.canonicalizeLanguage(string));
        string = languageTag.getScript();
        if (string.length() > 0) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeScript(string));
        }
        if ((string = languageTag.getRegion()).length() > 0) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeRegion(string));
        }
        List<String> list = languageTag.getVariants();
        for (String string2 : list) {
            stringBuilder.append("-");
            stringBuilder.append(string2);
        }
        list = languageTag.getExtensions();
        for (String string2 : list) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeExtension(string2));
        }
        string = languageTag.getPrivateuse();
        if (string.length() > 0) {
            stringBuilder.append("-").append("x").append("-");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static Locale forLanguageTag(String string) {
        LanguageTag languageTag = LanguageTag.parse(string, null);
        InternalLocaleBuilder internalLocaleBuilder = new InternalLocaleBuilder();
        internalLocaleBuilder.setLanguageTag(languageTag);
        return Locale.getInstance(internalLocaleBuilder.getBaseLocale(), internalLocaleBuilder.getLocaleExtensions());
    }

    public String getISO3Language() throws MissingResourceException {
        String string = Locale.getISO3Code(this._baseLocale.getLanguage(), "aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        if (string == null) {
            throw new MissingResourceException("Couldn't find 3-letter language code for " + this._baseLocale.getLanguage(), "FormatData_" + this.toString(), "ShortLanguage");
        }
        return string;
    }

    public String getISO3Country() throws MissingResourceException {
        String string = Locale.getISO3Code(this._baseLocale.getRegion(), "ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBLBLMBMBMUBNBRNBOBOLBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICUCUBCVCPVCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMFMAFMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSTSTPSVSLVSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        if (string == null) {
            throw new MissingResourceException("Couldn't find 3-letter country code for " + this._baseLocale.getRegion(), "FormatData_" + this.toString(), "ShortCountry");
        }
        return string;
    }

    private static final String getISO3Code(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return "";
        }
        int n3 = n = string2.length();
        if (n2 == 2) {
            char c = string.charAt(0);
            char c2 = string.charAt(1);
            for (n3 = 0; n3 < n && (string2.charAt(n3) != c || string2.charAt(n3 + 1) != c2); n3 += 5) {
            }
        }
        return n3 < n ? string2.substring(n3 + 2, n3 + 5) : null;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayLanguage(Locale locale) {
        return this.getDisplayString(this._baseLocale.getLanguage(), locale, 0);
    }

    public String getDisplayScript() {
        return this.getDisplayScript(Locale.getDefault());
    }

    public String getDisplayScript(Locale locale) {
        return this.getDisplayString(this._baseLocale.getScript(), locale, 3);
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayCountry(Locale locale) {
        return this.getDisplayString(this._baseLocale.getRegion(), locale, 1);
    }

    private String getDisplayString(String string, Locale locale, int n) {
        if (string.length() == 0) {
            return "";
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        try {
            OpenListResourceBundle openListResourceBundle = LocaleData.getLocaleNames(locale);
            String string2 = n == 2 ? "%%" + string : string;
            String string3 = null;
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(LocaleNameProvider.class);
            if (localeServiceProviderPool.hasProviders()) {
                string3 = localeServiceProviderPool.getLocalizedObject(LocaleNameGetter.INSTANCE, locale, openListResourceBundle, string2, n, string);
            }
            if (string3 == null) {
                string3 = openListResourceBundle.getString(string2);
            }
            if (string3 != null) {
                return string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayVariant(Locale locale) {
        if (this._baseLocale.getVariant().length() == 0) {
            return "";
        }
        OpenListResourceBundle openListResourceBundle = LocaleData.getLocaleNames(locale);
        String[] stringArray = this.getDisplayVariantArray(openListResourceBundle, locale);
        String string = null;
        String string2 = null;
        try {
            string = openListResourceBundle.getString("ListPattern");
            string2 = openListResourceBundle.getString("ListCompositionPattern");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return Locale.formatList(stringArray, string, string2);
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayName(Locale locale) {
        OpenListResourceBundle openListResourceBundle = LocaleData.getLocaleNames(locale);
        String string = this.getDisplayLanguage(locale);
        String string2 = this.getDisplayScript(locale);
        String string3 = this.getDisplayCountry(locale);
        String[] stringArray = this.getDisplayVariantArray(openListResourceBundle, locale);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        try {
            string4 = openListResourceBundle.getString("DisplayNamePattern");
            string5 = openListResourceBundle.getString("ListPattern");
            string6 = openListResourceBundle.getString("ListCompositionPattern");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        String string7 = null;
        String[] stringArray2 = null;
        if (string.length() == 0 && string2.length() == 0 && string3.length() == 0) {
            if (stringArray.length == 0) {
                return "";
            }
            return Locale.formatList(stringArray, string5, string6);
        }
        ArrayList<String> arrayList = new ArrayList<String>(4);
        if (string.length() != 0) {
            arrayList.add(string);
        }
        if (string2.length() != 0) {
            arrayList.add(string2);
        }
        if (string3.length() != 0) {
            arrayList.add(string3);
        }
        if (stringArray.length != 0) {
            for (String string8 : stringArray) {
                arrayList.add(string8);
            }
        }
        string7 = (String)arrayList.get(0);
        int n = arrayList.size();
        stringArray2 = n > 1 ? arrayList.subList(1, n).toArray(new String[n - 1]) : new String[]{};
        Object[] objectArray = new Object[]{new Integer(stringArray2.length != 0 ? 2 : 1), string7, stringArray2.length != 0 ? Locale.formatList(stringArray2, string5, string6) : null};
        if (string4 != null) {
            return new MessageFormat(string4).format(objectArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)objectArray[1]);
        if (objectArray.length > 2) {
            stringBuilder.append(" (");
            stringBuilder.append((String)objectArray[2]);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public Object clone() {
        try {
            Locale locale = (Locale)super.clone();
            return locale;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int n = this.hashCodeValue;
        if (n == 0) {
            this.hashCodeValue = n = this._baseLocale.hashCode() ^ this._extensions.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Locale)) {
            return false;
        }
        BaseLocale baseLocale = ((Locale)object)._baseLocale;
        LocaleExtensions localeExtensions = ((Locale)object)._extensions;
        return this._baseLocale.equals(baseLocale) && this._extensions.equals(localeExtensions);
    }

    private String[] getDisplayVariantArray(OpenListResourceBundle openListResourceBundle, Locale locale) {
        StringTokenizer stringTokenizer = new StringTokenizer(this._baseLocale.getVariant(), "_");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getDisplayString(stringTokenizer.nextToken(), locale, 2);
        }
        return stringArray;
    }

    private static String formatList(String[] stringArray, String string, String string2) {
        Object[] objectArray;
        if (string == null || string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[i]);
            }
            return stringBuffer.toString();
        }
        if (stringArray.length > 3) {
            objectArray = new MessageFormat(string2);
            stringArray = Locale.composeList((MessageFormat)objectArray, stringArray);
        }
        objectArray = new Object[stringArray.length + 1];
        System.arraycopy(stringArray, 0, objectArray, 1, stringArray.length);
        objectArray[0] = new Integer(stringArray.length);
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    private static String[] composeList(MessageFormat messageFormat, String[] stringArray) {
        if (stringArray.length <= 3) {
            return stringArray;
        }
        String[] stringArray2 = new String[]{stringArray[0], stringArray[1]};
        String string = messageFormat.format(stringArray2);
        String[] stringArray3 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 2, stringArray3, 1, stringArray3.length - 1);
        stringArray3[0] = string;
        return Locale.composeList(messageFormat, stringArray3);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("language", this._baseLocale.getLanguage());
        putField.put("script", this._baseLocale.getScript());
        putField.put("country", this._baseLocale.getRegion());
        putField.put("variant", this._baseLocale.getVariant());
        putField.put("extensions", this._extensions.getID());
        putField.put("hashcode", -1);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("language", "");
        String string2 = (String)getField.get("script", "");
        String string3 = (String)getField.get("country", "");
        String string4 = (String)getField.get("variant", "");
        String string5 = (String)getField.get("extensions", "");
        this._baseLocale = BaseLocale.getInstance(Locale.convertOldISOCodes(string), string2, string3, string4);
        try {
            InternalLocaleBuilder internalLocaleBuilder = new InternalLocaleBuilder();
            internalLocaleBuilder.setExtensions(string5);
            this._extensions = internalLocaleBuilder.getLocaleExtensions();
        }
        catch (LocaleSyntaxException localeSyntaxException) {
            throw new IllformedLocaleException(localeSyntaxException.getMessage());
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return Locale.getInstance(this._baseLocale.getLanguage(), this._baseLocale.getScript(), this._baseLocale.getRegion(), this._baseLocale.getVariant(), this._extensions);
    }

    private static String convertOldISOCodes(String string) {
        if ((string = AsciiUtil.toLowerString(string).intern()) == "he") {
            return "iw";
        }
        if (string == "yi") {
            return "ji";
        }
        if (string == "id") {
            return "in";
        }
        return string;
    }

    private static LocaleExtensions getCompatibilityExtensions(String string, String string2, String string3, String string4) {
        LocaleExtensions localeExtensions = LocaleExtensions.EMPTY_EXTENSIONS;
        if (AsciiUtil.caseIgnoreMatch(string, "ja") && string2.length() == 0 && AsciiUtil.caseIgnoreMatch(string3, "JP") && AsciiUtil.caseIgnoreMatch(string4, "JP")) {
            localeExtensions = LocaleExtensions.CALENDAR_JAPANESE;
        } else if (AsciiUtil.caseIgnoreMatch(string, "th") && string2.length() == 0 && AsciiUtil.caseIgnoreMatch(string3, "TH") && AsciiUtil.caseIgnoreMatch(string4, "TH")) {
            localeExtensions = LocaleExtensions.NUMBER_THAI;
        }
        return localeExtensions;
    }

    public static final class Builder {
        private InternalLocaleBuilder _locbld = new InternalLocaleBuilder();

        public Builder setLocale(Locale locale) {
            try {
                this._locbld.setLocale(locale._baseLocale, locale._extensions);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setLanguageTag(String string) {
            ParseStatus parseStatus = new ParseStatus();
            LanguageTag languageTag = LanguageTag.parse(string, parseStatus);
            if (parseStatus.isError()) {
                throw new IllformedLocaleException(parseStatus.getErrorMessage(), parseStatus.getErrorIndex());
            }
            this._locbld.setLanguageTag(languageTag);
            return this;
        }

        public Builder setLanguage(String string) {
            try {
                this._locbld.setLanguage(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setScript(String string) {
            try {
                this._locbld.setScript(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setRegion(String string) {
            try {
                this._locbld.setRegion(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setVariant(String string) {
            try {
                this._locbld.setVariant(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setExtension(char c, String string) {
            try {
                this._locbld.setExtension(c, string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setUnicodeLocaleKeyword(String string, String string2) {
            try {
                this._locbld.setUnicodeLocaleKeyword(string, string2);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder addUnicodeLocaleAttribute(String string) {
            try {
                this._locbld.addUnicodeLocaleAttribute(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder removeUnicodeLocaleAttribute(String string) {
            try {
                this._locbld.removeUnicodeLocaleAttribute(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder clear() {
            this._locbld.clear();
            return this;
        }

        public Builder clearExtensions() {
            this._locbld.clearExtensions();
            return this;
        }

        public Locale build() {
            BaseLocale baseLocale = this._locbld.getBaseLocale();
            LocaleExtensions localeExtensions = this._locbld.getLocaleExtensions();
            return Locale.getInstance(baseLocale, localeExtensions);
        }
    }

    public static enum Category {
        DISPLAY("user.language.display", "user.script.display", "user.country.display", "user.variant.display"),
        FORMAT("user.language.format", "user.script.format", "user.country.format", "user.variant.format");

        final String languageKey;
        final String scriptKey;
        final String countryKey;
        final String variantKey;

        private Category(String string2, String string3, String string4, String string5) {
            this.languageKey = string2;
            this.scriptKey = string3;
            this.countryKey = string4;
            this.variantKey = string5;
        }
    }

    private static class LocaleNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<LocaleNameProvider, String> {
        private static final LocaleNameGetter INSTANCE = new LocaleNameGetter();

        private LocaleNameGetter() {
        }

        @Override
        public String getObject(LocaleNameProvider localeNameProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 2);
            int n = (Integer)objectArray[0];
            String string2 = (String)objectArray[1];
            switch (n) {
                case 0: {
                    return localeNameProvider.getDisplayLanguage(string2, locale);
                }
                case 1: {
                    return localeNameProvider.getDisplayCountry(string2, locale);
                }
                case 2: {
                    return localeNameProvider.getDisplayVariant(string2, locale);
                }
                case 3: {
                    return localeNameProvider.getDisplayScript(string2, locale);
                }
            }
            assert (false);
            return null;
        }
    }

    private static class LocaleKey {
        private BaseLocale _base;
        private LocaleExtensions _exts;

        private LocaleKey(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
            this._base = baseLocale;
            this._exts = localeExtensions;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof LocaleKey)) {
                return false;
            }
            LocaleKey localeKey = (LocaleKey)object;
            return this._base.equals(localeKey._base) && this._exts.equals(localeKey._exts);
        }

        public int hashCode() {
            return this._base.hashCode() ^ this._exts.hashCode();
        }
    }

    private static class Cache
    extends LocaleObjectCache<LocaleKey, Locale> {
        @Override
        protected Locale createObject(LocaleKey localeKey) {
            return new Locale(localeKey._base, localeKey._exts);
        }
    }
}

