/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;

    private static int hash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    final Segment<K, V> segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    public ConcurrentHashMap(int n, float f, int n2) {
        int n3;
        int n4;
        int n5;
        if (!(f > 0.0f) || n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 > 65536) {
            n2 = 65536;
        }
        int n6 = 0;
        for (n5 = 1; n5 < n2; n5 <<= 1) {
            ++n6;
        }
        this.segmentShift = 32 - n6;
        this.segmentMask = n5 - 1;
        this.segments = Segment.newArray(n5);
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if ((n4 = n / n5) * n5 < n) {
            ++n4;
        }
        for (n3 = 1; n3 < n4; n3 <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(n3, f);
        }
    }

    public ConcurrentHashMap(int n, float f) {
        this(n, f, 16);
    }

    public ConcurrentHashMap(int n) {
        this(n, 0.75f, 16);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(map);
    }

    @Override
    public boolean isEmpty() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        int n2 = 0;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n].count != 0) {
                return false;
            }
            nArray[n] = segmentArray[n].modCount;
            n2 += nArray[n];
        }
        if (n2 != 0) {
            for (n = 0; n < segmentArray.length; ++n) {
                if (segmentArray[n].count == 0 && nArray[n] == segmentArray[n].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        long l = 0L;
        long l2 = 0L;
        int[] nArray = new int[segmentArray.length];
        for (n = 0; n < 2; ++n) {
            int n2;
            l2 = 0L;
            l = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                l += (long)segmentArray[n2].count;
                nArray[n2] = segmentArray[n2].modCount;
                n3 += nArray[n2];
            }
            if (n3 != 0) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    l2 += (long)segmentArray[n2].count;
                    if (nArray[n2] == segmentArray[n2].modCount) continue;
                    l2 = -1L;
                    break;
                }
            }
            if (l2 == l) break;
        }
        if (l2 != l) {
            l = 0L;
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].lock();
            }
            for (n = 0; n < segmentArray.length; ++n) {
                l += (long)segmentArray[n].count;
            }
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public V get(Object object) {
        int n = ConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).get(object, n);
    }

    @Override
    public boolean containsKey(Object object) {
        int n = ConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).containsKey(object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        int n;
        boolean bl;
        if (object == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        for (bl = false; bl < 2 != 0; bl += 1) {
            int n2;
            int n3;
            n = 0;
            int n4 = 0;
            for (n3 = 0; n3 < segmentArray.length; ++n3) {
                n2 = segmentArray[n3].count;
                nArray[n3] = segmentArray[n3].modCount;
                n4 += nArray[n3];
                if (!segmentArray[n3].containsValue(object)) continue;
                return true;
            }
            n3 = 1;
            if (n4 != 0) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    int n5 = segmentArray[n2].count;
                    if (nArray[n2] == segmentArray[n2].modCount) continue;
                    n3 = 0;
                    break;
                }
            }
            if (n3 == 0) continue;
            return false;
        }
        for (bl = false; bl < segmentArray.length; bl += 1) {
            segmentArray[bl].lock();
        }
        bl = false;
        try {
            for (n = 0; n < segmentArray.length; ++n) {
                if (!segmentArray[n].containsValue(object)) continue;
                bl = true;
                break;
            }
        }
        finally {
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        return bl;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentHashMap.hash(k.hashCode());
        return this.segmentFor(n).put(k, n, v, false);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentHashMap.hash(k.hashCode());
        return this.segmentFor(n).put(k, n, v, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n = ConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).remove(object, n, null);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        int n = ConcurrentHashMap.hash(object.hashCode());
        if (object2 == null) {
            return false;
        }
        return this.segmentFor(n).remove(object, n, object2) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (v == null || v2 == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentHashMap.hash(k.hashCode());
        return this.segmentFor(n).replace(k, n, v, v2);
    }

    @Override
    public V replace(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentHashMap.hash(k.hashCode());
        return this.segmentFor(n).replace(k, n, v);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.segments.length; ++i) {
            Segment<K, V> segment = this.segments[i];
            segment.lock();
            try {
                HashEntry<K, V>[] hashEntryArray = segment.table;
                for (int j = 0; j < hashEntryArray.length; ++j) {
                    HashEntry hashEntry = hashEntryArray[j];
                    while (hashEntry != null) {
                        objectOutputStream.writeObject(hashEntry.key);
                        objectOutputStream.writeObject(hashEntry.value);
                        hashEntry = hashEntry.next;
                    }
                }
                continue;
            }
            finally {
                segment.unlock();
            }
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].setTable(new HashEntry[1]);
        }
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put(object, object2);
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = ConcurrentHashMap.this.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ConcurrentHashMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry hashEntry = super.nextEntry();
            return new WriteThroughEntry(hashEntry.key, hashEntry.value);
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            Object v2 = super.setValue(v);
            ConcurrentHashMap.this.put(this.getKey(), v);
            return v2;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextEntry().value;
        }

        @Override
        public V nextElement() {
            return super.nextEntry().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return super.nextEntry().key;
        }

        @Override
        public K nextElement() {
            return super.nextEntry().key;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment segment = ConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (segment.count == 0) continue;
                this.currentTable = segment.table;
                for (int i = this.currentTable.length - 1; i >= 0; --i) {
                    this.nextEntry = this.currentTable[i];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = i - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry<K, V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry<K, V>[] table;
        final float loadFactor;

        Segment(int n, float f) {
            this.loadFactor = f;
            this.setTable(HashEntry.newArray(n));
        }

        static final <K, V> Segment<K, V>[] newArray(int n) {
            return new Segment[n];
        }

        void setTable(HashEntry<K, V>[] hashEntryArray) {
            this.threshold = (int)((float)hashEntryArray.length * this.loadFactor);
            this.table = hashEntryArray;
        }

        HashEntry<K, V> getFirst(int n) {
            HashEntry<K, V>[] hashEntryArray = this.table;
            return hashEntryArray[n & hashEntryArray.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V readValueUnderLock(HashEntry<K, V> hashEntry) {
            this.lock();
            try {
                Object v = hashEntry.value;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(Object object, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && object.equals(hashEntry.key)) {
                        Object v = hashEntry.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(hashEntry);
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return null;
        }

        boolean containsKey(Object object, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && object.equals(hashEntry.key)) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return false;
        }

        boolean containsValue(Object object) {
            if (this.count != 0) {
                for (HashEntry<K, V> hashEntry : this.table) {
                    while (hashEntry != null) {
                        Object v = hashEntry.value;
                        if (v == null) {
                            v = this.readValueUnderLock(hashEntry);
                        }
                        if (object.equals(v)) {
                            return true;
                        }
                        hashEntry = hashEntry.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K k, int n, V v, V v2) {
            this.lock();
            try {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (!(hashEntry == null || hashEntry.hash == n && k.equals(hashEntry.key))) {
                    hashEntry = hashEntry.next;
                }
                boolean bl = false;
                if (hashEntry != null && v.equals(hashEntry.value)) {
                    bl = true;
                    hashEntry.value = v2;
                }
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K k, int n, V v) {
            this.lock();
            try {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (!(hashEntry == null || hashEntry.hash == n && k.equals(hashEntry.key))) {
                    hashEntry = hashEntry.next;
                }
                V v2 = null;
                if (hashEntry != null) {
                    v2 = hashEntry.value;
                    hashEntry.value = v;
                }
                V v3 = v2;
                return v3;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K k, int n, V v, boolean bl) {
            this.lock();
            try {
                V v2;
                HashEntry<K, V> hashEntry;
                int n2 = this.count;
                if (n2++ > this.threshold) {
                    this.rehash();
                }
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n3 = n & hashEntryArray.length - 1;
                HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n3];
                while (!(hashEntry2 == null || hashEntry2.hash == n && k.equals(hashEntry2.key))) {
                    hashEntry2 = hashEntry2.next;
                }
                if (hashEntry2 != null) {
                    v2 = hashEntry2.value;
                    if (!bl) {
                        hashEntry2.value = v;
                    }
                } else {
                    v2 = null;
                    ++this.modCount;
                    hashEntryArray[n3] = new HashEntry<K, V>(k, n, hashEntry, v);
                    this.count = n2;
                }
                V v3 = v2;
                return v3;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            HashEntry<K, V>[] hashEntryArray = this.table;
            int n = hashEntryArray.length;
            if (n >= 0x40000000) {
                return;
            }
            HashEntry<K, V>[] hashEntryArray2 = HashEntry.newArray(n << 1);
            this.threshold = (int)((float)hashEntryArray2.length * this.loadFactor);
            int n2 = hashEntryArray2.length - 1;
            for (int i = 0; i < n; ++i) {
                int n3;
                HashEntry<K, V> hashEntry = hashEntryArray[i];
                if (hashEntry == null) continue;
                HashEntry hashEntry2 = hashEntry.next;
                int n4 = hashEntry.hash & n2;
                if (hashEntry2 == null) {
                    hashEntryArray2[n4] = hashEntry;
                    continue;
                }
                HashEntry<K, V> hashEntry3 = hashEntry;
                int n5 = n4;
                HashEntry hashEntry4 = hashEntry2;
                while (hashEntry4 != null) {
                    n3 = hashEntry4.hash & n2;
                    if (n3 != n5) {
                        n5 = n3;
                        hashEntry3 = hashEntry4;
                    }
                    hashEntry4 = hashEntry4.next;
                }
                hashEntryArray2[n5] = hashEntry3;
                hashEntry4 = hashEntry;
                while (hashEntry4 != hashEntry3) {
                    n3 = hashEntry4.hash & n2;
                    HashEntry hashEntry5 = hashEntryArray2[n3];
                    hashEntryArray2[n3] = new HashEntry(hashEntry4.key, hashEntry4.hash, hashEntry5, hashEntry4.value);
                    hashEntry4 = hashEntry4.next;
                }
            }
            this.table = hashEntryArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object object, int n, Object object2) {
            this.lock();
            try {
                V v;
                HashEntry<K, V> hashEntry;
                int n2 = this.count - 1;
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n3 = n & hashEntryArray.length - 1;
                HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n3];
                while (!(hashEntry2 == null || hashEntry2.hash == n && object.equals(hashEntry2.key))) {
                    hashEntry2 = hashEntry2.next;
                }
                V v2 = null;
                if (hashEntry2 != null) {
                    v = hashEntry2.value;
                    if (object2 == null || object2.equals(v)) {
                        v2 = v;
                        ++this.modCount;
                        HashEntry hashEntry3 = hashEntry2.next;
                        HashEntry<K, V> hashEntry4 = hashEntry;
                        while (hashEntry4 != hashEntry2) {
                            hashEntry3 = new HashEntry(hashEntry4.key, hashEntry4.hash, hashEntry3, hashEntry4.value);
                            hashEntry4 = hashEntry4.next;
                        }
                        hashEntryArray[n3] = hashEntry3;
                        this.count = n2;
                    }
                }
                v = v2;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<K, V>[] hashEntryArray = this.table;
                    for (int i = 0; i < hashEntryArray.length; ++i) {
                        hashEntryArray[i] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static final class HashEntry<K, V> {
        final K key;
        final int hash;
        volatile V value;
        final HashEntry<K, V> next;

        HashEntry(K k, int n, HashEntry<K, V> hashEntry, V v) {
            this.key = k;
            this.hash = n;
            this.next = hashEntry;
            this.value = v;
        }

        static final <K, V> HashEntry<K, V>[] newArray(int n) {
            return new HashEntry[n];
        }
    }
}

