/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import java.dyn.NoAccessException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sun.dyn.Access;
import sun.dyn.AdapterMethodHandle;
import sun.dyn.BoundMethodHandle;
import sun.dyn.DirectMethodHandle;
import sun.dyn.FilterGeneric;
import sun.dyn.FilterOneArgument;
import sun.dyn.FromGeneric;
import sun.dyn.JavaMethodHandle;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleNatives;
import sun.dyn.SpreadGeneric;
import sun.dyn.ToGeneric;
import sun.dyn.empty.Empty;
import sun.dyn.util.ValueConversions;
import sun.dyn.util.VerifyType;
import sun.dyn.util.Wrapper;
import sun.misc.Unsafe;

public abstract class MethodHandleImpl {
    private byte vmentry;
    protected Object vmtarget;
    static final int INT_FIELD = 0;
    static final long LONG_FIELD = 0L;
    private static MethodHandleFriend METHOD_HANDLE_FRIEND;
    private static final MemberName.Factory LOOKUP;
    private static MethodHandles.Lookup IMPL_LOOKUP_INIT;
    static final MethodHandles.Lookup IMPL_LOOKUP;
    static final MethodHandle THROW_EXCEPTION;

    public static void setMethodHandleFriend(Access access, MethodHandleFriend methodHandleFriend) {
        Access.check(access);
        if (METHOD_HANDLE_FRIEND != null) {
            throw new InternalError();
        }
        METHOD_HANDLE_FRIEND = methodHandleFriend;
    }

    static void initType(MethodHandle methodHandle, MethodType methodType) {
        METHOD_HANDLE_FRIEND.initType(methodHandle, methodType);
    }

    public MethodHandleImpl(Access access) {
        Access.check(access);
    }

    public static void init(Access access, MethodType methodType) {
        Access.check(access);
        if (MethodHandleNatives.JVM_SUPPORT) {
            MethodHandleNatives.init(methodType);
        }
    }

    public static void initLookup(Access access, MethodHandles.Lookup lookup) {
        Access.check(access);
        if (IMPL_LOOKUP_INIT != null) {
            throw new InternalError();
        }
        IMPL_LOOKUP_INIT = lookup;
    }

    public static MethodHandles.Lookup getLookup(Access access) {
        Access.check(access);
        return IMPL_LOOKUP;
    }

    public static void initStatics() {
    }

    public static MethodHandle findMethod(Access access, MemberName memberName, boolean bl, Class<?> clazz) throws NoAccessException {
        Object object;
        Access.check(access);
        MethodType methodType = memberName.getMethodType();
        if (!memberName.isStatic()) {
            object = memberName.getDeclaringClass();
            methodType = methodType.insertParameterTypes(0, new Class[]{object});
        }
        if (!((DirectMethodHandle)(object = new DirectMethodHandle(methodType, memberName, bl, clazz))).isValid()) {
            throw MemberName.newNoAccessException(memberName, clazz);
        }
        assert (((MethodHandle)object).type() == methodType);
        return object;
    }

    public static MethodHandle makeAllocator(Access access, MethodHandle methodHandle) {
        Access.check(access);
        MethodType methodType = methodHandle.type();
        MethodHandle methodHandle2 = AllocateObject.make(access, methodType.parameterType(0), methodHandle);
        assert (methodHandle2.type().equals((Object)methodType.dropParameterTypes(0, 1).changeReturnType(methodType.parameterType(0))));
        return methodHandle2;
    }

    public static MethodHandle accessField(Access access, MemberName memberName, boolean bl, Class<?> clazz) {
        Access.check(access);
        FieldAccessor fieldAccessor = new FieldAccessor(access, memberName, bl);
        return fieldAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodHandle accessArrayElement(Access access, Class<?> clazz, boolean bl) {
        Access.check(access);
        if (!clazz.isArray()) {
            throw MemberName.newIllegalArgumentException("not an array: " + clazz);
        }
        Class<?> clazz2 = clazz.getComponentType();
        MethodHandle[] methodHandleArray = FieldAccessor.ARRAY_CACHE.get(clazz2);
        if (methodHandleArray == null) {
            if (!FieldAccessor.doCache(clazz2)) {
                return FieldAccessor.ahandle(clazz, bl);
            }
            methodHandleArray = new MethodHandle[]{FieldAccessor.ahandle(clazz, false), FieldAccessor.ahandle(clazz, true)};
            if (methodHandleArray[0].type().parameterType(0) == Class.class) {
                methodHandleArray[0] = MethodHandles.insertArguments(methodHandleArray[0], 0, clazz2);
                methodHandleArray[1] = MethodHandles.insertArguments(methodHandleArray[1], 0, clazz2);
            }
            HashMap<Class<?>, MethodHandle[]> hashMap = FieldAccessor.ARRAY_CACHE;
            synchronized (hashMap) {
            }
            FieldAccessor.ARRAY_CACHE.put(clazz2, methodHandleArray);
        }
        return methodHandleArray[bl ? 1 : 0];
    }

    public static MethodHandle bindReceiver(Access access, MethodHandle methodHandle, Object object) {
        Object object2;
        Access.check(access);
        if (methodHandle instanceof AdapterMethodHandle && (object2 = MethodHandleNatives.getTargetInfo(methodHandle)) instanceof DirectMethodHandle) {
            DirectMethodHandle directMethodHandle = (DirectMethodHandle)object2;
            if (object == null || directMethodHandle.type().parameterType(0).isAssignableFrom(object.getClass())) {
                BoundMethodHandle boundMethodHandle = new BoundMethodHandle(directMethodHandle, object, 0);
                MethodType methodType = methodHandle.type().dropParameterTypes(0, 1);
                return MethodHandleImpl.convertArguments(access, boundMethodHandle, methodType, boundMethodHandle.type(), null);
            }
        }
        if (methodHandle instanceof DirectMethodHandle) {
            return new BoundMethodHandle((DirectMethodHandle)methodHandle, object, 0);
        }
        return null;
    }

    public static MethodHandle bindArgument(Access access, MethodHandle methodHandle, int n, Object object) {
        Access.check(access);
        return new BoundMethodHandle(methodHandle, object, n);
    }

    public static MethodHandle convertArguments(Access access, MethodHandle methodHandle, MethodType methodType, MethodType methodType2, int[] nArray) {
        Object object;
        Object object2;
        int n;
        Access.check(access);
        assert (methodType2.parameterCount() == methodHandle.type().parameterCount());
        if (nArray != null) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = methodType2.parameterCount();
            n = methodType.parameterCount();
            if (nArray.length != n6) {
                throw MemberName.newIllegalArgumentException("wrong number of arguments in permutation");
            }
            object2 = new Class[n6];
            for (int i = 0; i < n6; ++i) {
                object2[i] = methodType.parameterType(nArray[i]);
            }
            object = MethodType.methodType(methodType2.returnType(), object2);
            methodHandle = MethodHandleImpl.convertArguments(access, methodHandle, (MethodType)object, methodType2, null);
            assert (methodHandle != null);
            methodType2 = methodHandle.type();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            for (n5 = 0; n5 < n6; ++n5) {
                arrayList2.add(nArray[n5] * 10);
            }
            for (n5 = 0; n5 < n; ++n5) {
                if (arrayList2.contains(n5 * 10)) {
                    arrayList.add(n5 * 10);
                    continue;
                }
                arrayList3.add(n5);
            }
            while (arrayList2.size() > arrayList.size()) {
                for (n5 = 0; n5 < arrayList2.size(); ++n5) {
                    n4 = (Integer)arrayList2.get(n5);
                    n3 = arrayList2.indexOf(n4);
                    if (n3 == n5) continue;
                    n2 = n++ * 10;
                    arrayList2.set(n5, n2);
                    arrayList4.add(arrayList.indexOf(n4));
                    arrayList.add(n2);
                }
            }
            assert (arrayList2.size() == arrayList.size());
            n5 = arrayList.size();
            while (!arrayList2.equals(arrayList)) {
                int n7;
                int n8;
                int n9;
                int n10;
                n4 = -100;
                n3 = 0;
                n2 = -100;
                int n11 = 0;
                for (n10 = 0; n10 < n5; ++n10) {
                    n9 = (Integer)arrayList2.get(n10);
                    if (n9 == n2 + 10) {
                        n2 = n9;
                        if (n3 >= ++n11) continue;
                        n3 = n11;
                        n4 = n2;
                        continue;
                    }
                    n11 = 0;
                    n2 = -100;
                    n8 = (Integer)arrayList.get(n10);
                    if (n9 == n8 || n9 < n8 - 10 || n9 > n8 + 10) continue;
                    n2 = n9;
                    n11 = 1;
                }
                if (n3 >= 2) {
                    n10 = arrayList2.indexOf(n4);
                    n9 = arrayList.indexOf(n4);
                    n8 = n10 - n9;
                    n7 = n10 - (n3 - 1);
                    int n12 = n9 - (n3 - 1);
                    assert ((n10 | n7 | n9 | n12) >= 0);
                    int n13 = Math.min(n7, n12);
                    int n14 = Math.max(n10, n9);
                    int n15 = 0;
                    for (int i = n13; i <= n14; ++i) {
                        if (((Integer)arrayList2.get(i)).intValue() == ((Integer)arrayList.get(i)).intValue()) continue;
                        ++n15;
                    }
                    List list = arrayList2.subList(n13, n14 + 1);
                    Collections.rotate(list, -n8);
                    for (int i = n13; i <= n14; ++i) {
                        if (((Integer)arrayList2.get(i)).intValue() == ((Integer)arrayList.get(i)).intValue()) continue;
                        --n15;
                    }
                    if (n15 >= 2) {
                        List<Class<?>> list2 = Arrays.asList(methodType2.parameterArray());
                        Collections.rotate(list2.subList(n13, n14 + 1), -n8);
                        MethodType methodType3 = MethodType.methodType(methodType2.returnType(), list2);
                        MethodHandle methodHandle2 = AdapterMethodHandle.makeRotateArguments(access, methodType3, methodHandle, n13, list.size(), n8);
                        if (methodHandle2 != null) {
                            methodHandle = methodHandle2;
                            methodType2 = methodType3;
                            continue;
                        }
                    }
                    Collections.rotate(list, n8);
                }
                List<Class<?>> list = Arrays.asList(methodType2.parameterArray());
                for (n9 = 0; n9 < n5; ++n9) {
                    n8 = (Integer)arrayList.get(n9);
                    if (n8 == (Integer)arrayList2.get(n9)) continue;
                    n7 = arrayList2.indexOf(n8);
                    Collections.swap(list, n9, n7);
                    MethodType methodType4 = MethodType.methodType(methodType2.returnType(), list);
                    methodHandle = AdapterMethodHandle.makeSwapArguments(access, methodType4, methodHandle, n9, n7);
                    if (methodHandle == null) {
                        throw MemberName.newIllegalArgumentException("cannot swap");
                    }
                    assert (methodHandle.type() == methodType4);
                    methodType2 = methodType4;
                    Collections.swap(arrayList2, n9, n7);
                }
                assert (arrayList2.equals(arrayList));
            }
            while (!arrayList4.isEmpty()) {
                int n16;
                n4 = arrayList4.size() - 1;
                n3 = (Integer)arrayList4.get(n4);
                n2 = 1;
                while (n4 - 1 >= 0 && (n16 = ((Integer)arrayList4.get(n4 - 1)).intValue()) == n3 - 1) {
                    --n3;
                    ++n2;
                    --n4;
                }
                arrayList4.subList(n4, arrayList4.size()).clear();
                List<Class<?>> list = methodType2.parameterList();
                list = list.subList(0, list.size() - n2);
                MethodType methodType5 = MethodType.methodType(methodType2.returnType(), list);
                methodHandle = AdapterMethodHandle.makeDupArguments(access, methodType5, methodHandle, n3, n2);
                if (methodHandle == null) {
                    throw MemberName.newIllegalArgumentException("cannot dup");
                }
                methodType2 = methodHandle.type();
            }
            while (!arrayList3.isEmpty()) {
                int n17;
                n4 = (Integer)arrayList3.get(0);
                for (n3 = 1; n3 < arrayList3.size() && (n17 = ((Integer)arrayList3.get(n3)).intValue()) == n4 + n3; ++n3) {
                }
                arrayList3.subList(0, n3).clear();
                List<Class<?>> list = methodType.parameterList().subList(n4, n4 + n3);
                MethodType methodType6 = methodType2.insertParameterTypes(n4, list);
                methodHandle = AdapterMethodHandle.makeDropArguments(access, methodType6, methodHandle, n4, n3);
                if (methodHandle == null) {
                    throw MemberName.newIllegalArgumentException("cannot drop");
                }
                methodType2 = methodHandle.type();
            }
        }
        if (methodType == methodType2) {
            return methodHandle;
        }
        if (methodType2.parameterCount() != methodType.parameterCount()) {
            throw MemberName.newIllegalArgumentException("mismatched parameter count");
        }
        MethodHandle methodHandle3 = AdapterMethodHandle.makePairwiseConvert(access, methodType, methodHandle);
        if (methodHandle3 != null) {
            return methodHandle3;
        }
        n = methodType2.parameterCount();
        object2 = MethodType.genericMethodType(n);
        object = AdapterMethodHandle.makePairwiseConvert(access, (MethodType)object2, methodHandle);
        if (object == null) {
            object = FromGeneric.make(methodHandle);
        }
        if ((methodHandle3 = AdapterMethodHandle.makePairwiseConvert(access, methodType, (MethodHandle)object)) != null) {
            return methodHandle3;
        }
        return ToGeneric.make(methodType, (MethodHandle)object);
    }

    public static MethodHandle spreadArguments(Access access, MethodHandle methodHandle, MethodType methodType, int n) {
        Access.check(access);
        MethodType methodType2 = methodHandle.type();
        int n2 = methodType2.parameterCount() - n;
        Class<Object[]> clazz = Object[].class;
        MethodHandle methodHandle2 = AdapterMethodHandle.makeSpreadArguments(access, methodType, methodHandle, clazz, n, n2);
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        Class<?> clazz2 = null;
        if (n < 0 || n >= methodType.parameterCount() || !VerifyType.isSpreadArgType(clazz2 = methodType.parameterType(n))) {
            throw MemberName.newIllegalArgumentException("no restarg in " + methodType);
        }
        Class<?>[] classArray = methodType2.parameterArray();
        for (int i = 0; i < n2; ++i) {
            classArray[n + i] = VerifyType.spreadArgElementType(clazz2, i);
        }
        MethodType methodType3 = MethodType.methodType(methodType.returnType(), classArray);
        MethodHandle methodHandle3 = MethodHandleImpl.convertArguments(access, methodHandle, methodType3, methodType2, null);
        if (methodHandle3 == null) {
            throw new UnsupportedOperationException("NYI: convert " + methodType3 + " =calls=> " + methodType2);
        }
        methodHandle2 = AdapterMethodHandle.makeSpreadArguments(access, methodType, methodHandle3, clazz, n, n2);
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        methodHandle2 = SpreadGeneric.make(methodHandle3, n2);
        if (methodHandle2 != null) {
            methodHandle2 = MethodHandleImpl.convertArguments(access, methodHandle2, methodType, methodHandle2.type(), null);
        }
        return methodHandle2;
    }

    public static MethodHandle collectArguments(Access access, MethodHandle methodHandle, MethodType methodType, int n, MethodHandle methodHandle2) {
        MethodType methodType2 = methodHandle.type();
        if (methodHandle2 == null) {
            int n2 = methodType.parameterCount() - methodType2.parameterCount() + 1;
            methodHandle2 = ValueConversions.varargsArray(n2);
        }
        MethodType methodType3 = methodHandle2.type();
        assert (methodType.parameterCount() == n + methodType3.parameterCount());
        assert (methodType2.parameterCount() == n + 1);
        MethodHandle methodHandle3 = MethodHandleImpl.convertArguments(access, methodHandle, methodType2.generic(), methodType2, null);
        MethodHandle methodHandle4 = MethodHandleImpl.convertArguments(access, methodHandle2, methodType3.generic(), methodType3, null);
        if (methodHandle3 == null || methodHandle4 == null) {
            return null;
        }
        MethodHandle methodHandle5 = FilterGeneric.makeArgumentCollector(methodHandle4, methodHandle3);
        MethodHandle methodHandle6 = MethodHandleImpl.convertArguments(access, methodHandle5, methodType, methodHandle5.type(), null);
        return methodHandle6;
    }

    public static MethodHandle filterArgument(Access access, MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
        Access.check(access);
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodType.generic();
        if (methodType != methodType2) {
            methodHandle = MethodHandleImpl.convertArguments(access, methodHandle, methodType2, methodType, null);
            methodType = methodType2;
        }
        MethodType methodType3 = methodHandle2.type();
        MethodType methodType4 = methodType3.generic();
        if (methodType3.parameterCount() != 1) {
            throw new InternalError();
        }
        if (methodType3 != methodType4) {
            methodHandle2 = MethodHandleImpl.convertArguments(access, methodHandle2, methodType4, methodType3, null);
            methodType3 = methodType4;
        }
        if (methodType3 == methodType) {
            return FilterOneArgument.make(methodHandle2, methodHandle);
        }
        return FilterGeneric.makeArgumentFilter(n, methodHandle2, methodHandle);
    }

    public static MethodHandle foldArguments(Access access, MethodHandle methodHandle, MethodType methodType, MethodHandle methodHandle2) {
        Access.check(access);
        MethodType methodType2 = methodHandle.type();
        MethodType methodType3 = methodHandle2.type();
        MethodHandle methodHandle3 = MethodHandleImpl.convertArguments(access, methodHandle, methodType2.generic(), methodType2, null);
        MethodHandle methodHandle4 = MethodHandleImpl.convertArguments(access, methodHandle2, methodType3.generic(), methodType3, null);
        if (methodHandle3 == null || methodHandle4 == null) {
            return null;
        }
        MethodHandle methodHandle5 = FilterGeneric.makeArgumentFolder(methodHandle4, methodHandle3);
        MethodHandle methodHandle6 = MethodHandleImpl.convertArguments(access, methodHandle5, methodType, methodHandle5.type(), null);
        return methodHandle6;
    }

    public static MethodHandle dropArguments(Access access, MethodHandle methodHandle, MethodType methodType, int n) {
        Access.check(access);
        int n2 = methodType.parameterCount() - methodHandle.type().parameterCount();
        MethodHandle methodHandle2 = AdapterMethodHandle.makeDropArguments(access, methodType, methodHandle, n, n2);
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        throw new UnsupportedOperationException("NYI");
    }

    public static MethodHandle makeGuardWithTest(Access access, MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
        return GuardWithTest.make(access, methodHandle, methodHandle2, methodHandle3);
    }

    public static MethodHandle makeGuardWithCatch(Access access, MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2) {
        Access.check(access);
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        int n = methodType.parameterCount();
        if (n < GuardWithCatch.INVOKES.length) {
            MethodType methodType3 = methodType.generic();
            MethodType methodType4 = methodType3.insertParameterTypes(0, Throwable.class);
            MethodHandle methodHandle3 = MethodHandleImpl.convertArguments(access, methodHandle, methodType3, methodType, null);
            MethodHandle methodHandle4 = MethodHandleImpl.convertArguments(access, methodHandle2, methodType4, methodType2, null);
            GuardWithCatch guardWithCatch = new GuardWithCatch(methodHandle3, clazz, methodHandle4);
            if (methodHandle3 == null || methodHandle4 == null || guardWithCatch == null) {
                return null;
            }
            return MethodHandleImpl.convertArguments(access, guardWithCatch, methodType, methodType3, null);
        }
        MethodType methodType5 = MethodType.genericMethodType(0, true);
        MethodType methodType6 = methodType5.insertParameterTypes(0, Throwable.class);
        MethodHandle methodHandle5 = MethodHandleImpl.spreadArguments(access, methodHandle, methodType5, 0);
        MethodHandle methodHandle6 = MethodHandleImpl.spreadArguments(access, methodHandle2, methodType6, 1);
        GuardWithCatch guardWithCatch = new GuardWithCatch(GuardWithCatch.VARARGS_INVOKE, methodHandle5, clazz, methodHandle6);
        if (methodHandle5 == null || methodHandle6 == null || guardWithCatch == null) {
            return null;
        }
        return MethodHandleImpl.collectArguments(access, guardWithCatch, methodType, 0, null);
    }

    public static MethodHandle throwException(Access access, MethodType methodType) {
        Access.check(access);
        return AdapterMethodHandle.makeRetypeRaw(access, methodType, THROW_EXCEPTION);
    }

    static <T extends Throwable> Empty throwException(T t) throws T {
        throw t;
    }

    public static String getNameString(Access access, MethodHandle methodHandle) {
        Access.check(access);
        MemberName memberName = null;
        if (methodHandle != null) {
            memberName = MethodHandleNatives.getMethodName(methodHandle);
        }
        if (memberName == null) {
            return "<unknown>";
        }
        return memberName.getName();
    }

    public static String addTypeString(MethodHandle methodHandle) {
        if (methodHandle == null) {
            return "null";
        }
        return methodHandle.toString() + methodHandle.type();
    }

    public static void checkSpreadArgument(Object object, int n) {
        if (object == null ? n != 0 : ((Object[])object).length != n) {
            throw MemberName.newIllegalArgumentException("Array is not of length " + n);
        }
    }

    public static void raiseException(int n, Object clazz, Object object) {
        if (!(clazz instanceof Class) && !(clazz instanceof MethodType)) {
            clazz = clazz.getClass();
        }
        String string = clazz != null ? "required " + object + " but encountered " + clazz : "required " + object;
        switch (n) {
            case 192: {
                throw new ClassCastException(string);
            }
        }
        throw new InternalError("unexpected code " + n + ": " + string);
    }

    public static void registerBootstrap(Access access, Class<?> clazz, MethodHandle methodHandle) {
        Access.check(access);
        MethodHandleNatives.registerBootstrap(clazz, methodHandle);
    }

    public static MethodHandle getBootstrap(Access access, Class<?> clazz) {
        Access.check(access);
        return MethodHandleNatives.getBootstrap(clazz);
    }

    static {
        LOOKUP = MemberName.Factory.INSTANCE;
        MethodHandles.publicLookup();
        if (IMPL_LOOKUP_INIT == null) {
            throw new InternalError();
        }
        IMPL_LOOKUP = IMPL_LOOKUP_INIT;
        try {
            THROW_EXCEPTION = IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "throwException", MethodType.methodType(Empty.class, Throwable.class));
        }
        catch (NoAccessException noAccessException) {
            throw new RuntimeException(noAccessException);
        }
    }

    private static class GuardWithCatch
    extends JavaMethodHandle {
        private final MethodHandle target;
        private final Class<? extends Throwable> exType;
        private final MethodHandle catcher;
        static final MethodHandle[] INVOKES = GuardWithCatch.makeInvokes();
        static final MethodHandle VARARGS_INVOKE;

        public GuardWithCatch(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2) {
            this(INVOKES[methodHandle.type().parameterCount()], methodHandle, clazz, methodHandle2);
        }

        public GuardWithCatch(MethodHandle methodHandle, MethodHandle methodHandle2, Class<? extends Throwable> clazz, MethodHandle methodHandle3) {
            super(methodHandle);
            this.target = methodHandle2;
            this.exType = clazz;
            this.catcher = methodHandle3;
        }

        @Override
        public String toString() {
            return this.target.toString();
        }

        private Object invoke_V(Object ... objectArray) throws Throwable {
            try {
                return this.target.invokeExact(objectArray);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, objectArray);
            }
        }

        private Object invoke_L0() throws Throwable {
            try {
                return this.target.invokeExact();
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable);
            }
        }

        private Object invoke_L1(Object object) throws Throwable {
            try {
                return this.target.invokeExact(object);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object);
            }
        }

        private Object invoke_L2(Object object, Object object2) throws Throwable {
            try {
                return this.target.invokeExact(object, object2);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2);
            }
        }

        private Object invoke_L3(Object object, Object object2, Object object3) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3);
            }
        }

        private Object invoke_L4(Object object, Object object2, Object object3, Object object4) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3, object4);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3, object4);
            }
        }

        private Object invoke_L5(Object object, Object object2, Object object3, Object object4, Object object5) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3, object4, object5);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3, object4, object5);
            }
        }

        private Object invoke_L6(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3, object4, object5, object6);
            }
        }

        private Object invoke_L7(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6, object7);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3, object4, object5, object6, object7);
            }
        }

        private Object invoke_L8(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6, object7, object8);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3, object4, object5, object6, object7, object8);
            }
        }

        static MethodHandle[] makeInvokes() {
            ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
            MethodHandles.Lookup lookup = IMPL_LOOKUP;
            while (true) {
                int n = arrayList.size();
                String string = "invoke_L" + n;
                MethodHandle methodHandle = null;
                try {
                    methodHandle = lookup.findVirtual(GuardWithCatch.class, string, MethodType.genericMethodType(n));
                }
                catch (NoAccessException noAccessException) {
                    // empty catch block
                }
                if (methodHandle == null) break;
                arrayList.add(methodHandle);
            }
            assert (arrayList.size() == 9);
            return arrayList.toArray(new MethodHandle[0]);
        }

        static {
            try {
                VARARGS_INVOKE = IMPL_LOOKUP.findVirtual(GuardWithCatch.class, "invoke_V", MethodType.genericMethodType(0, true));
            }
            catch (NoAccessException noAccessException) {
                throw MemberName.uncaughtException(noAccessException);
            }
        }
    }

    private static class GuardWithTest
    extends JavaMethodHandle {
        private final MethodHandle test;
        private final MethodHandle target;
        private final MethodHandle fallback;
        static final MethodHandle[] INVOKES = GuardWithTest.makeInvokes();
        static final MethodHandle VARARGS_INVOKE;

        private GuardWithTest(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3, MethodHandle methodHandle4) {
            super(methodHandle);
            this.test = methodHandle2;
            this.target = methodHandle3;
            this.fallback = methodHandle4;
        }

        static MethodHandle make(Access access, MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            Access.check(access);
            MethodType methodType = methodHandle2.type();
            int n = methodType.parameterCount();
            if (n < INVOKES.length) {
                MethodHandle methodHandle4 = INVOKES[n];
                MethodType methodType2 = methodType.generic();
                assert (methodHandle4.type().dropParameterTypes(0, 1) == methodType2);
                MethodHandle methodHandle5 = GuardWithTest.convertArguments(access, methodHandle, methodType2.changeReturnType(Boolean.TYPE), methodHandle.type(), null);
                MethodHandle methodHandle6 = GuardWithTest.convertArguments(access, methodHandle2, methodType2, methodType, null);
                MethodHandle methodHandle7 = GuardWithTest.convertArguments(access, methodHandle3, methodType2, methodType, null);
                if (methodHandle5 == null || methodHandle6 == null || methodHandle7 == null) {
                    return null;
                }
                GuardWithTest guardWithTest = new GuardWithTest(methodHandle4, methodHandle5, methodHandle6, methodHandle7);
                return GuardWithTest.convertArguments(access, guardWithTest, methodType, methodType2, null);
            }
            MethodHandle methodHandle8 = VARARGS_INVOKE;
            MethodType methodType3 = MethodType.genericMethodType(1);
            assert (methodHandle8.type().dropParameterTypes(0, 1) == methodType3);
            MethodHandle methodHandle9 = GuardWithTest.spreadArguments(access, methodHandle, methodType3.changeReturnType(Boolean.TYPE), 0);
            MethodHandle methodHandle10 = GuardWithTest.spreadArguments(access, methodHandle2, methodType3, 0);
            MethodHandle methodHandle11 = GuardWithTest.spreadArguments(access, methodHandle3, methodType3, 0);
            GuardWithTest guardWithTest = new GuardWithTest(methodHandle8, methodHandle9, methodHandle10, methodHandle11);
            if (methodHandle9 == null || methodHandle10 == null || methodHandle11 == null) {
                return null;
            }
            return GuardWithTest.collectArguments(access, guardWithTest, methodType, 0, null);
        }

        @Override
        public String toString() {
            return this.target.toString();
        }

        private Object invoke_V(Object ... objectArray) throws Throwable {
            if (this.test.invokeExact(objectArray) != false) {
                return this.target.invokeExact(objectArray);
            }
            return this.fallback.invokeExact(objectArray);
        }

        private Object invoke_L0() throws Throwable {
            if (this.test.invokeExact()) {
                return this.target.invokeExact();
            }
            return this.fallback.invokeExact();
        }

        private Object invoke_L1(Object object) throws Throwable {
            if (this.test.invokeExact(object)) {
                return this.target.invokeExact(object);
            }
            return this.fallback.invokeExact(object);
        }

        private Object invoke_L2(Object object, Object object2) throws Throwable {
            if (this.test.invokeExact(object, object2)) {
                return this.target.invokeExact(object, object2);
            }
            return this.fallback.invokeExact(object, object2);
        }

        private Object invoke_L3(Object object, Object object2, Object object3) throws Throwable {
            if (this.test.invokeExact(object, object2, object3)) {
                return this.target.invokeExact(object, object2, object3);
            }
            return this.fallback.invokeExact(object, object2, object3);
        }

        private Object invoke_L4(Object object, Object object2, Object object3, Object object4) throws Throwable {
            if (this.test.invokeExact(object, object2, object3, object4)) {
                return this.target.invokeExact(object, object2, object3, object4);
            }
            return this.fallback.invokeExact(object, object2, object3, object4);
        }

        private Object invoke_L5(Object object, Object object2, Object object3, Object object4, Object object5) throws Throwable {
            if (this.test.invokeExact(object, object2, object3, object4, object5)) {
                return this.target.invokeExact(object, object2, object3, object4, object5);
            }
            return this.fallback.invokeExact(object, object2, object3, object4, object5);
        }

        private Object invoke_L6(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws Throwable {
            if (this.test.invokeExact(object, object2, object3, object4, object5, object6)) {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6);
            }
            return this.fallback.invokeExact(object, object2, object3, object4, object5, object6);
        }

        private Object invoke_L7(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws Throwable {
            if (this.test.invokeExact(object, object2, object3, object4, object5, object6, object7)) {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6, object7);
            }
            return this.fallback.invokeExact(object, object2, object3, object4, object5, object6, object7);
        }

        private Object invoke_L8(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws Throwable {
            if (this.test.invokeExact(object, object2, object3, object4, object5, object6, object7, object8)) {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6, object7, object8);
            }
            return this.fallback.invokeExact(object, object2, object3, object4, object5, object6, object7, object8);
        }

        static MethodHandle[] makeInvokes() {
            ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
            MethodHandles.Lookup lookup = IMPL_LOOKUP;
            while (true) {
                int n = arrayList.size();
                String string = "invoke_L" + n;
                MethodHandle methodHandle = null;
                try {
                    methodHandle = lookup.findVirtual(GuardWithTest.class, string, MethodType.genericMethodType(n));
                }
                catch (NoAccessException noAccessException) {
                    // empty catch block
                }
                if (methodHandle == null) break;
                arrayList.add(methodHandle);
            }
            assert (arrayList.size() == 9);
            return arrayList.toArray(new MethodHandle[0]);
        }

        static {
            try {
                VARARGS_INVOKE = IMPL_LOOKUP.findVirtual(GuardWithTest.class, "invoke_V", MethodType.genericMethodType(0, true));
            }
            catch (NoAccessException noAccessException) {
                throw MemberName.uncaughtException(noAccessException);
            }
        }
    }

    static final class FieldAccessor<C, V>
    extends JavaMethodHandle {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        final Object base;
        final long offset;
        final String name;
        static final HashMap<Class<?>, MethodHandle[]> ARRAY_CACHE = new HashMap();

        public FieldAccessor(Access access, MemberName memberName, boolean bl) {
            super(FieldAccessor.fhandle(memberName.getDeclaringClass(), memberName.getFieldType(), bl, memberName.isStatic()));
            this.offset = memberName.getVMIndex(access);
            this.name = memberName.getName();
            this.base = FieldAccessor.staticBase(memberName);
        }

        @Override
        public String toString() {
            return this.name;
        }

        int getFieldI(C c) {
            return unsafe.getInt(c, this.offset);
        }

        void setFieldI(C c, int n) {
            unsafe.putInt(c, this.offset, n);
        }

        long getFieldJ(C c) {
            return unsafe.getLong(c, this.offset);
        }

        void setFieldJ(C c, long l) {
            unsafe.putLong(c, this.offset, l);
        }

        float getFieldF(C c) {
            return unsafe.getFloat(c, this.offset);
        }

        void setFieldF(C c, float f) {
            unsafe.putFloat(c, this.offset, f);
        }

        double getFieldD(C c) {
            return unsafe.getDouble(c, this.offset);
        }

        void setFieldD(C c, double d) {
            unsafe.putDouble(c, this.offset, d);
        }

        boolean getFieldZ(C c) {
            return unsafe.getBoolean(c, this.offset);
        }

        void setFieldZ(C c, boolean bl) {
            unsafe.putBoolean(c, this.offset, bl);
        }

        byte getFieldB(C c) {
            return unsafe.getByte(c, this.offset);
        }

        void setFieldB(C c, byte by) {
            unsafe.putByte(c, this.offset, by);
        }

        short getFieldS(C c) {
            return unsafe.getShort(c, this.offset);
        }

        void setFieldS(C c, short s) {
            unsafe.putShort(c, this.offset, s);
        }

        char getFieldC(C c) {
            return unsafe.getChar(c, this.offset);
        }

        void setFieldC(C c, char c2) {
            unsafe.putChar(c, this.offset, c2);
        }

        V getFieldL(C c) {
            return (V)unsafe.getObject(c, this.offset);
        }

        void setFieldL(C c, V v) {
            unsafe.putObject(c, this.offset, v);
        }

        static Object staticBase(MemberName memberName) {
            if (!memberName.isStatic()) {
                return null;
            }
            Class<?> clazz = memberName.getDeclaringClass();
            try {
                Field field = clazz.getDeclaredField(memberName.getName());
                return unsafe.staticFieldBase(field);
            }
            catch (Exception exception) {
                throw MemberName.uncaughtException(exception);
            }
        }

        int getStaticI() {
            return unsafe.getInt(this.base, this.offset);
        }

        void setStaticI(int n) {
            unsafe.putInt(this.base, this.offset, n);
        }

        long getStaticJ() {
            return unsafe.getLong(this.base, this.offset);
        }

        void setStaticJ(long l) {
            unsafe.putLong(this.base, this.offset, l);
        }

        float getStaticF() {
            return unsafe.getFloat(this.base, this.offset);
        }

        void setStaticF(float f) {
            unsafe.putFloat(this.base, this.offset, f);
        }

        double getStaticD() {
            return unsafe.getDouble(this.base, this.offset);
        }

        void setStaticD(double d) {
            unsafe.putDouble(this.base, this.offset, d);
        }

        boolean getStaticZ() {
            return unsafe.getBoolean(this.base, this.offset);
        }

        void setStaticZ(boolean bl) {
            unsafe.putBoolean(this.base, this.offset, bl);
        }

        byte getStaticB() {
            return unsafe.getByte(this.base, this.offset);
        }

        void setStaticB(byte by) {
            unsafe.putByte(this.base, this.offset, by);
        }

        short getStaticS() {
            return unsafe.getShort(this.base, this.offset);
        }

        void setStaticS(short s) {
            unsafe.putShort(this.base, this.offset, s);
        }

        char getStaticC() {
            return unsafe.getChar(this.base, this.offset);
        }

        void setStaticC(char c) {
            unsafe.putChar(this.base, this.offset, c);
        }

        V getStaticL() {
            return (V)unsafe.getObject(this.base, this.offset);
        }

        void setStaticL(V v) {
            unsafe.putObject(this.base, this.offset, v);
        }

        static String fname(Class<?> clazz, boolean bl, boolean bl2) {
            String string = !bl2 ? (!bl ? "getField" : "setField") : (!bl ? "getStatic" : "setStatic");
            return string + Wrapper.basicTypeChar(clazz);
        }

        static MethodType ftype(Class<?> clazz, Class<?> clazz2, boolean bl, boolean bl2) {
            if (!bl2) {
                if (!bl) {
                    return MethodType.methodType(clazz2, clazz);
                }
                return MethodType.methodType(Void.TYPE, clazz, clazz2);
            }
            if (!bl) {
                return MethodType.methodType(clazz2);
            }
            return MethodType.methodType(Void.TYPE, clazz2);
        }

        static MethodHandle fhandle(Class<?> clazz, Class<?> clazz2, boolean bl, boolean bl2) {
            MethodHandle methodHandle;
            String string = FieldAccessor.fname(clazz2, bl, bl2);
            if (clazz.isPrimitive()) {
                throw MemberName.newIllegalArgumentException("primitive " + clazz);
            }
            Class<Object> clazz3 = Object.class;
            Class<Object> clazz4 = clazz2;
            if (!clazz4.isPrimitive()) {
                clazz4 = Object.class;
            }
            MethodType methodType = FieldAccessor.ftype(clazz3, clazz4, bl, bl2);
            try {
                methodHandle = IMPL_LOOKUP.findVirtual(FieldAccessor.class, string, methodType);
            }
            catch (NoAccessException noAccessException) {
                throw MemberName.uncaughtException(noAccessException);
            }
            if (clazz4 != clazz2 || !bl2 && clazz3 != clazz) {
                MethodType methodType2 = FieldAccessor.ftype(clazz, clazz2, bl, bl2);
                methodType2 = methodType2.insertParameterTypes(0, FieldAccessor.class);
                methodHandle = MethodHandles.convertArguments(methodHandle, methodType2);
            }
            return methodHandle;
        }

        static boolean doCache(Class<?> clazz) {
            if (clazz.isPrimitive()) {
                return true;
            }
            ClassLoader classLoader = clazz.getClassLoader();
            return classLoader == null || classLoader == ClassLoader.getSystemClassLoader();
        }

        static int getElementI(int[] nArray, int n) {
            return nArray[n];
        }

        static void setElementI(int[] nArray, int n, int n2) {
            nArray[n] = n2;
        }

        static long getElementJ(long[] lArray, int n) {
            return lArray[n];
        }

        static void setElementJ(long[] lArray, int n, long l) {
            lArray[n] = l;
        }

        static float getElementF(float[] fArray, int n) {
            return fArray[n];
        }

        static void setElementF(float[] fArray, int n, float f) {
            fArray[n] = f;
        }

        static double getElementD(double[] dArray, int n) {
            return dArray[n];
        }

        static void setElementD(double[] dArray, int n, double d) {
            dArray[n] = d;
        }

        static boolean getElementZ(boolean[] blArray, int n) {
            return blArray[n];
        }

        static void setElementZ(boolean[] blArray, int n, boolean bl) {
            blArray[n] = bl;
        }

        static byte getElementB(byte[] byArray, int n) {
            return byArray[n];
        }

        static void setElementB(byte[] byArray, int n, byte by) {
            byArray[n] = by;
        }

        static short getElementS(short[] sArray, int n) {
            return sArray[n];
        }

        static void setElementS(short[] sArray, int n, short s) {
            sArray[n] = s;
        }

        static char getElementC(char[] cArray, int n) {
            return cArray[n];
        }

        static void setElementC(char[] cArray, int n, char c) {
            cArray[n] = c;
        }

        static Object getElementL(Object[] objectArray, int n) {
            return objectArray[n];
        }

        static void setElementL(Object[] objectArray, int n, Object object) {
            objectArray[n] = object;
        }

        static <V> V getElementL(Class<V[]> clazz, V[] VArray, int n) {
            return clazz.cast(VArray)[n];
        }

        static <V> void setElementL(Class<V[]> clazz, V[] VArray, int n, V v) {
            clazz.cast(VArray)[n] = v;
        }

        static String aname(Class<?> clazz, boolean bl) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 == null) {
                throw new IllegalArgumentException();
            }
            return (!bl ? "getElement" : "setElement") + Wrapper.basicTypeChar(clazz2);
        }

        static MethodType atype(Class<?> clazz, boolean bl) {
            Class<?> clazz2 = clazz.getComponentType();
            if (!bl) {
                return MethodType.methodType(clazz2, clazz, Integer.TYPE);
            }
            return MethodType.methodType(Void.TYPE, clazz, Integer.TYPE, clazz2);
        }

        static MethodHandle ahandle(Class<?> clazz, boolean bl) {
            MethodHandle methodHandle;
            Class<Object> clazz2 = clazz.getComponentType();
            String string = FieldAccessor.aname(clazz, bl);
            Class<?> clazz3 = null;
            if (!clazz2.isPrimitive() && clazz2 != Object.class) {
                clazz3 = clazz;
                clazz = Object[].class;
                clazz2 = Object.class;
            }
            MethodType methodType = FieldAccessor.atype(clazz, bl);
            if (clazz3 != null) {
                methodType = methodType.insertParameterTypes(0, Class.class);
            }
            try {
                methodHandle = IMPL_LOOKUP.findStatic(FieldAccessor.class, string, methodType);
            }
            catch (NoAccessException noAccessException) {
                throw MemberName.uncaughtException(noAccessException);
            }
            if (clazz3 != null) {
                MethodType methodType2 = FieldAccessor.atype(clazz3, bl);
                methodHandle = MethodHandles.insertArguments(methodHandle, 0, clazz3);
                methodHandle = MethodHandles.convertArguments(methodHandle, methodType2);
            }
            return methodHandle;
        }
    }

    static final class AllocateObject<C>
    extends JavaMethodHandle {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final Class<C> allocateClass;
        private final MethodHandle rawConstructor;
        static final MethodHandle[] INVOKES = AllocateObject.makeInvokes();
        static final MethodHandle VARARGS_INVOKE;
        static final MethodType[] CON_TYPES;
        static final MethodType VARARGS_CON_TYPE;

        private AllocateObject(MethodHandle methodHandle, Class<C> clazz, MethodHandle methodHandle2) {
            super(methodHandle);
            this.allocateClass = clazz;
            this.rawConstructor = methodHandle2;
        }

        static MethodHandle make(Access access, Class<?> clazz, MethodHandle methodHandle) {
            Access.check(access);
            MethodType methodType = methodHandle.type();
            assert (methodType.parameterType(0) == clazz);
            MethodType methodType2 = methodType.dropParameterTypes(0, 1).changeReturnType(clazz);
            int n = methodType.parameterCount() - 1;
            if (n < INVOKES.length) {
                MethodHandle methodHandle2 = INVOKES[n];
                MethodType methodType3 = CON_TYPES[n];
                MethodHandle methodHandle3 = AllocateObject.convertArguments(access, methodHandle, methodType3, methodType, null);
                if (methodHandle3 == null) {
                    return null;
                }
                AllocateObject allocateObject = new AllocateObject(methodHandle2, clazz, methodHandle3);
                assert (allocateObject.type() == methodType2.generic());
                return AllocateObject.convertArguments(access, allocateObject, methodType2, allocateObject.type(), null);
            }
            MethodHandle methodHandle4 = VARARGS_INVOKE;
            MethodType methodType4 = CON_TYPES[n];
            MethodHandle methodHandle5 = AllocateObject.spreadArguments(access, methodHandle, methodType4, 1);
            if (methodHandle5 == null) {
                return null;
            }
            AllocateObject allocateObject = new AllocateObject(methodHandle4, clazz, methodHandle5);
            return AllocateObject.collectArguments(access, allocateObject, methodType2, 1, null);
        }

        @Override
        public String toString() {
            return this.allocateClass.getSimpleName();
        }

        private C allocate() throws InstantiationException {
            return (C)unsafe.allocateInstance(this.allocateClass);
        }

        private C invoke_V(Object ... objectArray) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, objectArray);
            return c;
        }

        private C invoke_L0() throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c);
            return c;
        }

        private C invoke_L1(Object object) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object);
            return c;
        }

        private C invoke_L2(Object object, Object object2) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2);
            return c;
        }

        private C invoke_L3(Object object, Object object2, Object object3) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3);
            return c;
        }

        private C invoke_L4(Object object, Object object2, Object object3, Object object4) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3, object4);
            return c;
        }

        private C invoke_L5(Object object, Object object2, Object object3, Object object4, Object object5) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3, object4, object5);
            return c;
        }

        private C invoke_L6(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3, object4, object5, object6);
            return c;
        }

        private C invoke_L7(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3, object4, object5, object6, object7);
            return c;
        }

        private C invoke_L8(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3, object4, object5, object6, object7, object8);
            return c;
        }

        static MethodHandle[] makeInvokes() {
            ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
            MethodHandles.Lookup lookup = IMPL_LOOKUP;
            while (true) {
                int n = arrayList.size();
                String string = "invoke_L" + n;
                MethodHandle methodHandle = null;
                try {
                    methodHandle = lookup.findVirtual(AllocateObject.class, string, MethodType.genericMethodType(n));
                }
                catch (NoAccessException noAccessException) {
                    // empty catch block
                }
                if (methodHandle == null) break;
                arrayList.add(methodHandle);
            }
            assert (arrayList.size() == 9);
            return arrayList.toArray(new MethodHandle[0]);
        }

        static MethodType makeConType(MethodHandle methodHandle) {
            MethodType methodType = methodHandle.type();
            return methodType.changeParameterType(0, Object.class).changeReturnType(Void.TYPE);
        }

        static {
            try {
                VARARGS_INVOKE = IMPL_LOOKUP.findVirtual(AllocateObject.class, "invoke_V", MethodType.genericMethodType(0, true));
            }
            catch (NoAccessException noAccessException) {
                throw MemberName.uncaughtException(noAccessException);
            }
            CON_TYPES = new MethodType[INVOKES.length];
            for (int i = 0; i < INVOKES.length; ++i) {
                AllocateObject.CON_TYPES[i] = AllocateObject.makeConType(INVOKES[i]);
            }
            VARARGS_CON_TYPE = AllocateObject.makeConType(VARARGS_INVOKE);
        }
    }

    public static interface MethodHandleFriend {
        public void initType(MethodHandle var1, MethodType var2);
    }
}

