/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.util.Debug;
import sun.security.x509.CertificatePoliciesExtension;
import sun.security.x509.CertificatePolicyMap;
import sun.security.x509.InhibitAnyPolicyExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.PolicyConstraintsExtension;
import sun.security.x509.PolicyInformation;
import sun.security.x509.PolicyMappingsExtension;
import sun.security.x509.X509CertImpl;

class PolicyChecker
extends PKIXCertPathChecker {
    private final Set<String> initPolicies;
    private final int certPathLen;
    private final boolean expPolicyRequired;
    private final boolean polMappingInhibited;
    private final boolean anyPolicyInhibited;
    private final boolean rejectPolicyQualifiers;
    private PolicyNodeImpl rootNode;
    private int explicitPolicy;
    private int policyMapping;
    private int inhibitAnyPolicy;
    private int certIndex;
    private Set<String> supportedExts;
    private static final Debug debug = Debug.getInstance("certpath");
    static final String ANY_POLICY = "2.5.29.32.0";

    PolicyChecker(Set<String> set, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, PolicyNodeImpl policyNodeImpl) throws CertPathValidatorException {
        if (set.isEmpty()) {
            this.initPolicies = new HashSet<String>(1);
            this.initPolicies.add(ANY_POLICY);
        } else {
            this.initPolicies = new HashSet<String>(set);
        }
        this.certPathLen = n;
        this.expPolicyRequired = bl;
        this.polMappingInhibited = bl2;
        this.anyPolicyInhibited = bl3;
        this.rejectPolicyQualifiers = bl4;
        this.rootNode = policyNodeImpl;
        this.init(false);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.certIndex = 1;
        this.explicitPolicy = this.expPolicyRequired ? 0 : this.certPathLen + 1;
        this.policyMapping = this.polMappingInhibited ? 0 : this.certPathLen + 1;
        this.inhibitAnyPolicy = this.anyPolicyInhibited ? 0 : this.certPathLen + 1;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        if (this.supportedExts == null) {
            this.supportedExts = new HashSet<String>();
            this.supportedExts.add(PKIXExtensions.CertificatePolicies_Id.toString());
            this.supportedExts.add(PKIXExtensions.PolicyMappings_Id.toString());
            this.supportedExts.add(PKIXExtensions.PolicyConstraints_Id.toString());
            this.supportedExts.add(PKIXExtensions.InhibitAnyPolicy_Id.toString());
            this.supportedExts = Collections.unmodifiableSet(this.supportedExts);
        }
        return this.supportedExts;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        this.checkPolicy((X509Certificate)certificate);
        if (collection != null && !collection.isEmpty()) {
            collection.remove(PKIXExtensions.CertificatePolicies_Id.toString());
            collection.remove(PKIXExtensions.PolicyMappings_Id.toString());
            collection.remove(PKIXExtensions.PolicyConstraints_Id.toString());
            collection.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
        }
    }

    private void checkPolicy(X509Certificate x509Certificate) throws CertPathValidatorException {
        String string = "certificate policies";
        if (debug != null) {
            debug.println("PolicyChecker.checkPolicy() ---checking " + string + "...");
            debug.println("PolicyChecker.checkPolicy() certIndex = " + this.certIndex);
            debug.println("PolicyChecker.checkPolicy() BEFORE PROCESSING: explicitPolicy = " + this.explicitPolicy);
            debug.println("PolicyChecker.checkPolicy() BEFORE PROCESSING: policyMapping = " + this.policyMapping);
            debug.println("PolicyChecker.checkPolicy() BEFORE PROCESSING: inhibitAnyPolicy = " + this.inhibitAnyPolicy);
            debug.println("PolicyChecker.checkPolicy() BEFORE PROCESSING: policyTree = " + this.rootNode);
        }
        X509CertImpl x509CertImpl = null;
        try {
            x509CertImpl = X509CertImpl.toImpl(x509Certificate);
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException);
        }
        boolean bl = this.certIndex == this.certPathLen;
        this.rootNode = PolicyChecker.processPolicies(this.certIndex, this.initPolicies, this.explicitPolicy, this.policyMapping, this.inhibitAnyPolicy, this.rejectPolicyQualifiers, this.rootNode, x509CertImpl, bl);
        if (!bl) {
            this.explicitPolicy = PolicyChecker.mergeExplicitPolicy(this.explicitPolicy, x509CertImpl, bl);
            this.policyMapping = PolicyChecker.mergePolicyMapping(this.policyMapping, x509CertImpl);
            this.inhibitAnyPolicy = PolicyChecker.mergeInhibitAnyPolicy(this.inhibitAnyPolicy, x509CertImpl);
        }
        ++this.certIndex;
        if (debug != null) {
            debug.println("PolicyChecker.checkPolicy() AFTER PROCESSING: explicitPolicy = " + this.explicitPolicy);
            debug.println("PolicyChecker.checkPolicy() AFTER PROCESSING: policyMapping = " + this.policyMapping);
            debug.println("PolicyChecker.checkPolicy() AFTER PROCESSING: inhibitAnyPolicy = " + this.inhibitAnyPolicy);
            debug.println("PolicyChecker.checkPolicy() AFTER PROCESSING: policyTree = " + this.rootNode);
            debug.println("PolicyChecker.checkPolicy() " + string + " verified");
        }
    }

    static int mergeExplicitPolicy(int n, X509CertImpl x509CertImpl, boolean bl) throws CertPathValidatorException {
        if (n > 0 && !X509CertImpl.isSelfIssued(x509CertImpl)) {
            --n;
        }
        try {
            PolicyConstraintsExtension policyConstraintsExtension = x509CertImpl.getPolicyConstraintsExtension();
            if (policyConstraintsExtension == null) {
                return n;
            }
            int n2 = (Integer)policyConstraintsExtension.get("require");
            if (debug != null) {
                debug.println("PolicyChecker.mergeExplicitPolicy() require Index from cert = " + n2);
            }
            if (!bl) {
                if (n2 != -1 && (n == -1 || n2 < n)) {
                    n = n2;
                }
            } else if (n2 == 0) {
                n = n2;
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("PolicyChecker.mergeExplicitPolicy unexpected exception");
                exception.printStackTrace();
            }
            throw new CertPathValidatorException(exception);
        }
        return n;
    }

    static int mergePolicyMapping(int n, X509CertImpl x509CertImpl) throws CertPathValidatorException {
        if (n > 0 && !X509CertImpl.isSelfIssued(x509CertImpl)) {
            --n;
        }
        try {
            PolicyConstraintsExtension policyConstraintsExtension = x509CertImpl.getPolicyConstraintsExtension();
            if (policyConstraintsExtension == null) {
                return n;
            }
            int n2 = (Integer)policyConstraintsExtension.get("inhibit");
            if (debug != null) {
                debug.println("PolicyChecker.mergePolicyMapping() inhibit Index from cert = " + n2);
            }
            if (n2 != -1 && (n == -1 || n2 < n)) {
                n = n2;
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("PolicyChecker.mergePolicyMapping unexpected exception");
                exception.printStackTrace();
            }
            throw new CertPathValidatorException(exception);
        }
        return n;
    }

    static int mergeInhibitAnyPolicy(int n, X509CertImpl x509CertImpl) throws CertPathValidatorException {
        if (n > 0 && !X509CertImpl.isSelfIssued(x509CertImpl)) {
            --n;
        }
        try {
            InhibitAnyPolicyExtension inhibitAnyPolicyExtension = (InhibitAnyPolicyExtension)x509CertImpl.getExtension(PKIXExtensions.InhibitAnyPolicy_Id);
            if (inhibitAnyPolicyExtension == null) {
                return n;
            }
            int n2 = (Integer)inhibitAnyPolicyExtension.get("skip_certs");
            if (debug != null) {
                debug.println("PolicyChecker.mergeInhibitAnyPolicy() skipCerts Index from cert = " + n2);
            }
            if (n2 != -1 && n2 < n) {
                n = n2;
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("PolicyChecker.mergeInhibitAnyPolicy unexpected exception");
                exception.printStackTrace();
            }
            throw new CertPathValidatorException(exception);
        }
        return n;
    }

    static PolicyNodeImpl processPolicies(int n, Set<String> set, int n2, int n3, int n4, boolean bl, PolicyNodeImpl policyNodeImpl, X509CertImpl x509CertImpl, boolean bl2) throws CertPathValidatorException {
        boolean bl3 = false;
        PolicyNodeImpl policyNodeImpl2 = null;
        Set<PolicyQualifierInfo> set2 = new HashSet<PolicyQualifierInfo>();
        policyNodeImpl2 = policyNodeImpl == null ? null : policyNodeImpl.copyTree();
        CertificatePoliciesExtension certificatePoliciesExtension = x509CertImpl.getCertificatePoliciesExtension();
        if (certificatePoliciesExtension != null && policyNodeImpl2 != null) {
            List list;
            bl3 = certificatePoliciesExtension.isCritical();
            if (debug != null) {
                debug.println("PolicyChecker.processPolicies() policiesCritical = " + bl3);
            }
            try {
                list = (List)certificatePoliciesExtension.get("policies");
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("Exception while retrieving policyOIDs", iOException);
            }
            if (debug != null) {
                debug.println("PolicyChecker.processPolicies() rejectPolicyQualifiers = " + bl);
            }
            boolean bl4 = false;
            for (PolicyInformation policyInformation : list) {
                Set<PolicyQualifierInfo> set3;
                String string = policyInformation.getPolicyIdentifier().getIdentifier().toString();
                if (string.equals(ANY_POLICY)) {
                    bl4 = true;
                    set2 = policyInformation.getPolicyQualifiers();
                    continue;
                }
                if (debug != null) {
                    debug.println("PolicyChecker.processPolicies() processing policy: " + string);
                }
                if (!(set3 = policyInformation.getPolicyQualifiers()).isEmpty() && bl && bl3) {
                    throw new CertPathValidatorException("critical policy qualifiers present in certificate", null, null, -1, PKIXReason.INVALID_POLICY);
                }
                boolean bl5 = PolicyChecker.processParents(n, bl3, bl, policyNodeImpl2, string, set3, false);
                if (bl5) continue;
                PolicyChecker.processParents(n, bl3, bl, policyNodeImpl2, string, set3, true);
            }
            if (bl4 && (n4 > 0 || !bl2 && X509CertImpl.isSelfIssued(x509CertImpl))) {
                if (debug != null) {
                    debug.println("PolicyChecker.processPolicies() processing policy: 2.5.29.32.0");
                }
                PolicyChecker.processParents(n, bl3, bl, policyNodeImpl2, ANY_POLICY, set2, true);
            }
            policyNodeImpl2.prune(n);
            if (!policyNodeImpl2.getChildren().hasNext()) {
                policyNodeImpl2 = null;
            }
        } else if (certificatePoliciesExtension == null) {
            if (debug != null) {
                debug.println("PolicyChecker.processPolicies() no policies present in cert");
            }
            policyNodeImpl2 = null;
        }
        if (policyNodeImpl2 != null && !bl2) {
            policyNodeImpl2 = PolicyChecker.processPolicyMappings(x509CertImpl, n, n3, policyNodeImpl2, bl3, set2);
        }
        if (policyNodeImpl2 != null && !set.contains(ANY_POLICY) && certificatePoliciesExtension != null && (policyNodeImpl2 = PolicyChecker.removeInvalidNodes(policyNodeImpl2, n, set, certificatePoliciesExtension)) != null && bl2) {
            policyNodeImpl2 = PolicyChecker.rewriteLeafNodes(n, set, policyNodeImpl2);
        }
        if (bl2) {
            n2 = PolicyChecker.mergeExplicitPolicy(n2, x509CertImpl, bl2);
        }
        if (n2 == 0 && policyNodeImpl2 == null) {
            throw new CertPathValidatorException("non-null policy tree required and policy tree is null", null, null, -1, PKIXReason.INVALID_POLICY);
        }
        return policyNodeImpl2;
    }

    private static PolicyNodeImpl rewriteLeafNodes(int n, Set<String> set, PolicyNodeImpl policyNodeImpl) {
        Set<PolicyNodeImpl> set2 = policyNodeImpl.getPolicyNodesValid(n, ANY_POLICY);
        if (set2.isEmpty()) {
            return policyNodeImpl;
        }
        PolicyNodeImpl policyNodeImpl2 = set2.iterator().next();
        PolicyNodeImpl policyNodeImpl3 = (PolicyNodeImpl)policyNodeImpl2.getParent();
        policyNodeImpl3.deleteChild(policyNodeImpl2);
        HashSet<String> hashSet = new HashSet<String>(set);
        for (PolicyNodeImpl object : policyNodeImpl.getPolicyNodes(n)) {
            hashSet.remove(object.getValidPolicy());
        }
        if (hashSet.isEmpty()) {
            policyNodeImpl.prune(n);
            if (!policyNodeImpl.getChildren().hasNext()) {
                policyNodeImpl = null;
            }
        } else {
            boolean bl = policyNodeImpl2.isCritical();
            Set<PolicyQualifierInfo> set3 = policyNodeImpl2.getPolicyQualifiers();
            for (String string : hashSet) {
                Set<String> set4 = Collections.singleton(string);
                PolicyNodeImpl policyNodeImpl4 = new PolicyNodeImpl(policyNodeImpl3, string, set3, bl, set4, false);
            }
        }
        return policyNodeImpl;
    }

    private static boolean processParents(int n, boolean bl, boolean bl2, PolicyNodeImpl policyNodeImpl, String string, Set<PolicyQualifierInfo> set, boolean bl3) throws CertPathValidatorException {
        boolean bl4 = false;
        if (debug != null) {
            debug.println("PolicyChecker.processParents(): matchAny = " + bl3);
        }
        Set<PolicyNodeImpl> set2 = policyNodeImpl.getPolicyNodesExpected(n - 1, string, bl3);
        for (PolicyNodeImpl policyNodeImpl2 : set2) {
            if (debug != null) {
                debug.println("PolicyChecker.processParents() found parent:\n" + policyNodeImpl2.asString());
            }
            bl4 = true;
            String string2 = policyNodeImpl2.getValidPolicy();
            PolicyNodeImpl policyNodeImpl3 = null;
            HashSet<String> hashSet = null;
            if (string.equals(ANY_POLICY)) {
                Set<String> set3 = policyNodeImpl2.getExpectedPolicies();
                block1: for (String string3 : set3) {
                    Object object;
                    Iterator<PolicyNodeImpl> iterator = policyNodeImpl2.getChildren();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        String string4 = ((PolicyNodeImpl)object).getValidPolicy();
                        if (!string3.equals(string4)) continue;
                        if (debug == null) continue block1;
                        debug.println(string4 + " in parent's " + "expected policy set already appears in " + "child node");
                        continue block1;
                    }
                    object = new HashSet();
                    object.add(string3);
                    policyNodeImpl3 = new PolicyNodeImpl(policyNodeImpl2, string3, set, bl, (Set<String>)object, false);
                }
                continue;
            }
            hashSet = new HashSet<String>();
            hashSet.add(string);
            policyNodeImpl3 = new PolicyNodeImpl(policyNodeImpl2, string, set, bl, hashSet, false);
        }
        return bl4;
    }

    private static PolicyNodeImpl processPolicyMappings(X509CertImpl x509CertImpl, int n, int n2, PolicyNodeImpl policyNodeImpl, boolean bl, Set<PolicyQualifierInfo> set) throws CertPathValidatorException {
        PolicyMappingsExtension policyMappingsExtension = x509CertImpl.getPolicyMappingsExtension();
        if (policyMappingsExtension == null) {
            return policyNodeImpl;
        }
        if (debug != null) {
            debug.println("PolicyChecker.processPolicyMappings() inside policyMapping check");
        }
        List list = null;
        try {
            list = (List)policyMappingsExtension.get("map");
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("PolicyChecker.processPolicyMappings() mapping exception");
                iOException.printStackTrace();
            }
            throw new CertPathValidatorException("Exception while checking mapping", iOException);
        }
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            PolicyNodeImpl policyNodeImpl2;
            CertificatePolicyMap certificatePolicyMap = (CertificatePolicyMap)list.get(i);
            String string = certificatePolicyMap.getIssuerIdentifier().getIdentifier().toString();
            String string2 = certificatePolicyMap.getSubjectIdentifier().getIdentifier().toString();
            if (debug != null) {
                debug.println("PolicyChecker.processPolicyMappings() issuerDomain = " + string);
                debug.println("PolicyChecker.processPolicyMappings() subjectDomain = " + string2);
            }
            if (string.equals(ANY_POLICY)) {
                throw new CertPathValidatorException("encountered an issuerDomainPolicy of ANY_POLICY", null, null, -1, PKIXReason.INVALID_POLICY);
            }
            if (string2.equals(ANY_POLICY)) {
                throw new CertPathValidatorException("encountered a subjectDomainPolicy of ANY_POLICY", null, null, -1, PKIXReason.INVALID_POLICY);
            }
            Set<PolicyNodeImpl> set2 = policyNodeImpl.getPolicyNodesValid(n, string);
            if (!set2.isEmpty()) {
                for (PolicyNodeImpl policyNodeImpl3 : set2) {
                    if (n2 > 0 || n2 == -1) {
                        policyNodeImpl3.addExpectedPolicy(string2);
                        continue;
                    }
                    if (n2 != 0) continue;
                    policyNodeImpl2 = (PolicyNodeImpl)policyNodeImpl3.getParent();
                    if (debug != null) {
                        debug.println("PolicyChecker.processPolicyMappings() before deleting: policy tree = " + policyNodeImpl);
                    }
                    policyNodeImpl2.deleteChild(policyNodeImpl3);
                    bl2 = true;
                    if (debug == null) continue;
                    debug.println("PolicyChecker.processPolicyMappings() after deleting: policy tree = " + policyNodeImpl);
                }
                continue;
            }
            if (n2 <= 0 && n2 != -1) continue;
            Set<PolicyNodeImpl> set3 = policyNodeImpl.getPolicyNodesValid(n, ANY_POLICY);
            Iterator iterator = set3.iterator();
            while (iterator.hasNext()) {
                policyNodeImpl2 = (PolicyNodeImpl)iterator.next();
                PolicyNodeImpl policyNodeImpl4 = (PolicyNodeImpl)policyNodeImpl2.getParent();
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(string2);
                PolicyNodeImpl policyNodeImpl5 = new PolicyNodeImpl(policyNodeImpl4, string, set, bl, hashSet, true);
            }
        }
        if (bl2) {
            policyNodeImpl.prune(n);
            if (!policyNodeImpl.getChildren().hasNext()) {
                if (debug != null) {
                    debug.println("setting rootNode to null");
                }
                policyNodeImpl = null;
            }
        }
        return policyNodeImpl;
    }

    private static PolicyNodeImpl removeInvalidNodes(PolicyNodeImpl policyNodeImpl, int n, Set<String> set, CertificatePoliciesExtension certificatePoliciesExtension) throws CertPathValidatorException {
        List list = null;
        try {
            list = (List)certificatePoliciesExtension.get("policies");
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Exception while retrieving policyOIDs", iOException);
        }
        boolean bl = false;
        for (PolicyInformation policyInformation : list) {
            String string = policyInformation.getPolicyIdentifier().getIdentifier().toString();
            if (debug != null) {
                debug.println("PolicyChecker.processPolicies() processing policy second time: " + string);
            }
            Set<PolicyNodeImpl> set2 = policyNodeImpl.getPolicyNodesValid(n, string);
            for (PolicyNodeImpl policyNodeImpl2 : set2) {
                PolicyNodeImpl policyNodeImpl3 = (PolicyNodeImpl)policyNodeImpl2.getParent();
                if (!policyNodeImpl3.getValidPolicy().equals(ANY_POLICY) || set.contains(string) || string.equals(ANY_POLICY)) continue;
                if (debug != null) {
                    debug.println("PolicyChecker.processPolicies() before deleting: policy tree = " + policyNodeImpl);
                }
                policyNodeImpl3.deleteChild(policyNodeImpl2);
                bl = true;
                if (debug == null) continue;
                debug.println("PolicyChecker.processPolicies() after deleting: policy tree = " + policyNodeImpl);
            }
        }
        if (bl) {
            policyNodeImpl.prune(n);
            if (!policyNodeImpl.getChildren().hasNext()) {
                policyNodeImpl = null;
            }
        }
        return policyNodeImpl;
    }

    PolicyNode getPolicyTree() {
        if (this.rootNode == null) {
            return null;
        }
        PolicyNodeImpl policyNodeImpl = this.rootNode.copyTree();
        policyNodeImpl.setImmutable();
        return policyNodeImpl;
    }
}

