/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.CompatVersion;
import org.jruby.Finalizable;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.util.IdUtil;
import org.jruby.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyBasicObject
implements Cloneable,
IRubyObject,
Serializable,
Comparable<IRubyObject>,
CoreObjectType,
InstanceVariables,
InternalVariables {
    private static final boolean DEBUG = false;
    protected transient RubyClass metaClass;
    protected int flags;
    private volatile Object[] varTable;
    protected static final String ERR_INSECURE_SET_INST_VAR = "Insecure: can't modify instance variable";
    public static final int ALL_F = -1;
    public static final int FALSE_F = 1;
    public static final int NIL_F = 2;
    public static final int FROZEN_F = 4;
    public static final int TAINTED_F = 8;
    public static final int UNTRUSTED_F = 16;
    public static final int FL_USHIFT = 5;
    public static final int USER0_F = 32;
    public static final int USER1_F = 64;
    public static final int USER2_F = 128;
    public static final int USER3_F = 256;
    public static final int USER4_F = 512;
    public static final int USER5_F = 1024;
    public static final int USER6_F = 2048;
    public static final int USER7_F = 4096;
    public static final int USER8_F = 8192;
    public static final int COMPARE_BY_IDENTITY_F = 8192;
    public static final IRubyObject NEVER = new RubyBasicObject();
    public static final IRubyObject UNDEF = new RubyBasicObject();
    public static final ObjectAllocator BASICOBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyBasicObject(runtime2, klass);
        }
    };
    private static final MethodsCollector methodsCollector = new MethodsCollector(){

        public RubyArray instanceMethods(RubyClass rubyClass, IRubyObject[] args2) {
            return rubyClass.instance_methods(args2);
        }
    };
    private static final MethodsCollector methodsCollector19 = new MethodsCollector(){

        public RubyArray instanceMethods(RubyClass rubyClass, IRubyObject[] args2) {
            return rubyClass.instance_methods19(args2);
        }
    };

    private RubyBasicObject() {
    }

    public static RubyClass createBasicObjectClass(Ruby runtime2, RubyClass objectClass) {
        objectClass.index = 14;
        objectClass.defineAnnotatedMethods(RubyBasicObject.class);
        runtime2.setDefaultMethodMissing(objectClass.searchMethod("method_missing"));
        return objectClass;
    }

    public IRubyObject initialize() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(IRubyObject arg0) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(IRubyObject arg0, IRubyObject arg1) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(IRubyObject[] args2) {
        return this.getRuntime().getNil();
    }

    public RubyBasicObject(Ruby runtime2, RubyClass metaClass) {
        assert (metaClass != null) : "NULL Metaclass!!?!?!";
        this.metaClass = metaClass;
        if (runtime2.isObjectSpaceEnabled()) {
            this.addToObjectSpace(runtime2);
        }
    }

    public RubyBasicObject(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    protected RubyBasicObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        this.metaClass = metaClass;
        if (useObjectSpace) {
            this.addToObjectSpace(runtime2);
        }
    }

    protected RubyBasicObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        this.metaClass = metaClass;
        if (useObjectSpace) {
            this.addToObjectSpace(runtime2);
        }
    }

    private void addToObjectSpace(Ruby runtime2) {
        assert (runtime2.isObjectSpaceEnabled());
        runtime2.getObjectSpace().add(this);
    }

    protected void taint(Ruby runtime2) {
        runtime2.secure(4);
        if (!this.isTaint()) {
            this.testFrozen();
            this.setTaint(true);
        }
    }

    protected final void testFrozen(String message2) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(message2);
        }
    }

    protected final void testFrozen() {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError("object");
        }
    }

    public final void setFlag(int flag, boolean set) {
        this.flags = set ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    @Deprecated
    public IRubyObject callSuper(ThreadContext context, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.invokeSuper(context, (IRubyObject)this, args2, block);
    }

    @Override
    public final IRubyObject checkCallMethod(ThreadContext context, String name2) {
        return RuntimeHelpers.invokeChecked(context, this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2) {
        return RuntimeHelpers.invoke(context, this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, arg2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, args2);
    }

    public final IRubyObject callMethod(String name2, IRubyObject ... args2) {
        return RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, name2, args2);
    }

    public final IRubyObject callMethod(String name2) {
        return RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, args2, block);
    }

    @Override
    @Deprecated
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2) {
        return RuntimeHelpers.invoke(context, this, name2);
    }

    @Override
    @Deprecated
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, arg2, Block.NULL_BLOCK);
    }

    @Override
    public final boolean isNil() {
        return (this.flags & 2) != 0;
    }

    @Override
    public final boolean isTrue() {
        return (this.flags & 1) == 0;
    }

    public final boolean isFalse() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isTaint() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void setTaint(boolean taint2) {
        if (this.isImmediate()) {
            return;
        }
        this.flags = taint2 ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    @Override
    public IRubyObject infectBy(IRubyObject obj) {
        if (obj.isTaint()) {
            this.setTaint(true);
        }
        if (obj.isUntrusted()) {
            this.setUntrusted(true);
        }
        return this;
    }

    final RubyBasicObject infectBy(RubyBasicObject obj) {
        this.flags |= obj.flags & 0x18;
        return this;
    }

    final RubyBasicObject infectBy(int tuFlags) {
        this.flags |= tuFlags & 0x18;
        return this;
    }

    @Override
    public boolean isFrozen() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.flags = frozen ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    @Override
    public boolean isUntrusted() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public void setUntrusted(boolean untrusted) {
        this.flags = untrusted ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    @Override
    public RubyClass getSingletonClass() {
        RubyClass klass = this.getMetaClass().isSingleton() && ((MetaClass)this.getMetaClass()).getAttached() == this ? this.getMetaClass() : this.makeMetaClass(this.getMetaClass());
        klass.setTaint(this.isTaint());
        if (this.isFrozen()) {
            klass.setFrozen(true);
        }
        return klass;
    }

    public RubyClass makeMetaClass(RubyClass superClass) {
        MetaClass klass = new MetaClass(this.getRuntime(), superClass, this);
        this.setMetaClass(klass);
        klass.setMetaClass(superClass.getRealClass().getMetaClass());
        superClass.addSubclass(klass);
        return klass;
    }

    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public RubyClass getType() {
        return this.getMetaClass().getRealClass();
    }

    @Override
    public final boolean respondsTo(String name2) {
        DynamicMethod method2 = this.getMetaClass().searchMethod("respond_to?");
        if (method2 == this.getRuntime().getRespondToMethod()) {
            return this.getMetaClass().isMethodBound(name2, false);
        }
        if (!method2.isUndefined()) {
            return method2.call(this.getRuntime().getCurrentContext(), (IRubyObject)this, (RubyModule)this.metaClass, "respond_to?", this.getRuntime().newSymbol(name2)).isTrue();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "respond_to?", (IRubyObject)this.getRuntime().newSymbol(name2)).isTrue();
    }

    @Override
    public final boolean respondsToMissing(String name2) {
        return this.respondsToMissing(name2, true);
    }

    @Override
    public final boolean respondsToMissing(String name2, boolean priv) {
        DynamicMethod method2 = this.getMetaClass().searchMethod("respond_to_missing?");
        if (method2.isUndefined()) {
            return false;
        }
        return method2.call(this.getRuntime().getCurrentContext(), (IRubyObject)this, (RubyModule)this.metaClass, "respond_to_missing?", (IRubyObject)this.getRuntime().newSymbol(name2), this.getRuntime().newBoolean(priv)).isTrue();
    }

    @Override
    public final Ruby getRuntime() {
        return this.getMetaClass().getClassRuntime();
    }

    @Override
    public Class getJavaClass() {
        Object obj = this.dataGetStruct();
        if (obj instanceof JavaObject) {
            return ((JavaObject)obj).getValue().getClass();
        }
        return this.getClass();
    }

    @Override
    public String asJavaString() {
        IRubyObject asString = this.checkStringType();
        if (!asString.isNil()) {
            return ((RubyString)asString).asJavaString();
        }
        throw this.getRuntime().newTypeError(this.inspect().toString() + " is not a string");
    }

    @Override
    public RubyString asString() {
        IRubyObject str = RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)this.anyToString();
        }
        if (this.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    @Override
    public RubyArray convertToArray() {
        return (RubyArray)TypeConverter.convertToType(this, this.getRuntime().getArray(), "to_ary");
    }

    @Override
    public RubyHash convertToHash() {
        return (RubyHash)TypeConverter.convertToType(this, this.getRuntime().getHash(), "to_hash");
    }

    @Override
    public RubyFloat convertToFloat() {
        return (RubyFloat)TypeConverter.convertToType(this, this.getRuntime().getFloat(), "to_f");
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.convertToInteger("to_int");
    }

    @Override
    @Deprecated
    public RubyInteger convertToInteger(int methodIndex, String convertMethod) {
        return this.convertToInteger(convertMethod);
    }

    @Override
    public RubyInteger convertToInteger(String convertMethod) {
        IRubyObject val = TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getInteger(), convertMethod, true);
        if (!(val instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(this.getMetaClass().getName() + "#" + convertMethod + " should return Integer");
        }
        return (RubyInteger)val;
    }

    @Override
    public RubyString convertToString() {
        return (RubyString)TypeConverter.convertToType(this, this.getRuntime().getString(), "to_str");
    }

    @Override
    public IRubyObject anyToString() {
        String cname = this.getMetaClass().getRealClass().getName();
        RubyString str = this.getRuntime().newString("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    @Override
    public IRubyObject checkStringType() {
        IRubyObject str = TypeConverter.convertToTypeWithCheck(this, this.getRuntime().getString(), "to_str");
        if (!str.isNil() && !(str instanceof RubyString)) {
            str = RubyString.newEmptyString(this.getRuntime());
        }
        return str;
    }

    @Override
    public IRubyObject checkStringType19() {
        IRubyObject str = TypeConverter.convertToTypeWithCheck19(this, this.getRuntime().getString(), "to_str");
        if (!str.isNil() && !(str instanceof RubyString)) {
            str = RubyString.newEmptyString(this.getRuntime());
        }
        return str;
    }

    @Override
    public IRubyObject checkArrayType() {
        return TypeConverter.convertToTypeWithCheck(this, this.getRuntime().getArray(), "to_ary");
    }

    IRubyObject checkIntegerType(Ruby runtime2, IRubyObject obj, String method2) {
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        IRubyObject conv2 = TypeConverter.convertToType(obj, this.getRuntime().getInteger(), method2, false);
        return conv2 instanceof RubyInteger ? conv2 : obj.getRuntime().getNil();
    }

    @Override
    public Object toJava(Class target) {
        if (target == Void.TYPE) {
            return null;
        }
        if (this.dataGetStruct() instanceof JavaObject) {
            JavaObject innerWrapper = (JavaObject)this.dataGetStruct();
            if (target.isAssignableFrom(innerWrapper.getValue().getClass())) {
                this.getRuntime().getJavaSupport().getObjectProxyCache().put(innerWrapper.getValue(), this);
                return innerWrapper.getValue();
            }
        } else if (JavaUtil.isDuckTypeConvertable(this.getClass(), target)) {
            if (!this.respondsTo("java_object")) {
                return JavaUtil.convertProcToInterface(this.getRuntime().getCurrentContext(), this, target);
            }
        } else if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        throw this.getRuntime().newTypeError("cannot convert instance of " + this.getClass() + " to " + target);
    }

    @Override
    public IRubyObject dup() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't dup " + this.getMetaClass().getName());
        }
        IRubyObject dup2 = this.getMetaClass().getRealClass().allocate();
        if (this.isTaint()) {
            dup2.setTaint(true);
        }
        if (this.isUntrusted()) {
            dup2.setUntrusted(true);
        }
        RubyBasicObject.initCopy(dup2, this);
        return dup2;
    }

    private static void initCopy(IRubyObject clone, IRubyObject original) {
        assert (!clone.isFrozen()) : "frozen object (" + clone.getMetaClass().getName() + ") allocated";
        original.copySpecialInstanceVariables(clone);
        if (original.hasVariables()) {
            clone.syncVariables(original);
        }
        if (original instanceof RubyModule) {
            RubyModule cloneMod = (RubyModule)clone;
            cloneMod.syncConstants((RubyModule)original);
            cloneMod.syncClassVariables((RubyModule)original);
        }
        clone.callMethod(clone.getRuntime().getCurrentContext(), "initialize_copy", original);
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone) {
    }

    static RubyString inspect(ThreadContext context, IRubyObject object) {
        return RubyString.objAsString(context, object.callMethod(context, "inspect"));
    }

    @Override
    public IRubyObject rbClone() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't clone " + this.getMetaClass().getName());
        }
        RubyBasicObject clone = (RubyBasicObject)this.getMetaClass().getRealClass().allocate();
        clone.setMetaClass(this.getSingletonClassClone());
        if (this.isTaint()) {
            clone.setTaint(true);
        }
        RubyBasicObject.initCopy(clone, this);
        if (this.isFrozen()) {
            clone.setFrozen(true);
        }
        if (this.isUntrusted()) {
            clone.setUntrusted(true);
        }
        return clone;
    }

    protected RubyClass getSingletonClassClone() {
        RubyClass klass = this.getMetaClass();
        if (!klass.isSingleton()) {
            return klass;
        }
        MetaClass clone = new MetaClass(this.getRuntime(), klass.getSuperClass(), ((MetaClass)klass).getAttached());
        clone.flags = this.flags;
        if (this instanceof RubyClass) {
            clone.setMetaClass(clone);
        } else {
            clone.setMetaClass(klass.getSingletonClassClone());
        }
        if (klass.hasVariables()) {
            clone.syncVariables(klass);
        }
        clone.syncConstants(klass);
        klass.cloneMethods(clone);
        ((MetaClass)clone.getMetaClass()).setAttached(clone);
        return clone;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public synchronized void dataWrapStruct(Object obj) {
        if (obj == null) {
            this.removeInternalVariable("__wrap_struct__");
        } else {
            this.fastSetInternalVariable("__wrap_struct__", obj);
        }
    }

    @Override
    public synchronized Object dataGetStruct() {
        return this.fastGetInternalVariable("__wrap_struct__");
    }

    @Override
    public synchronized Object dataGetStructChecked() {
        TypeConverter.checkData(this);
        return this.fastGetInternalVariable("__wrap_struct__");
    }

    @Override
    public IRubyObject id() {
        return this.getRuntime().newFixnum(this.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getObjectId() {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            RubyClass.VariableAccessor objectIdAccessor = this.getMetaClass().getRealClass().getObjectIdAccessorForWrite();
            Long id2 = (Long)objectIdAccessor.get(this);
            if (id2 == null) {
                return this.initObjectId(objectIdAccessor);
            }
            return id2;
        }
    }

    protected synchronized long initObjectId(RubyClass.VariableAccessor objectIdAccessor) {
        Ruby runtime2 = this.getRuntime();
        long id2 = runtime2.isObjectSpaceEnabled() ? runtime2.getObjectSpace().createAndRegisterObjectId(this) : ObjectSpace.calculateObjectId(this);
        this.setObjectId(objectIdAccessor.getIndex(), id2);
        return id2;
    }

    @Override
    public IRubyObject inspect() {
        Ruby runtime2 = this.getRuntime();
        if (!this.isImmediate() && !(this instanceof RubyModule) && this.hasVariables()) {
            return this.hashyInspect();
        }
        if (this.isNil()) {
            return RubyNil.inspect(this);
        }
        return RuntimeHelpers.invoke(runtime2.getCurrentContext(), this, "to_s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject hashyInspect() {
        Ruby runtime2 = this.getRuntime();
        StringBuilder part = new StringBuilder();
        String cname = this.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(":0x");
        part.append(Integer.toHexString(this.inspectHashCode()));
        if (runtime2.isInspecting(this)) {
            part.append(" ...>");
            return runtime2.newString(part.toString());
        }
        try {
            runtime2.registerInspecting(this);
            RubyString rubyString = runtime2.newString(this.inspectObj(part).toString());
            return rubyString;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    protected int inspectHashCode() {
        return System.identityHashCode(this);
    }

    private StringBuilder inspectObj(StringBuilder part) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        String sep = "";
        for (Variable<IRubyObject> ivar : this.getInstanceVariableList()) {
            part.append(sep).append(" ").append(ivar.getName()).append("=");
            part.append(ivar.getValue().callMethod(context, "inspect"));
            sep = ",";
        }
        part.append(">");
        return part;
    }

    @JRubyMethod(name={"!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_not(ThreadContext context) {
        return context.getRuntime().newBoolean(!this.isTrue());
    }

    @JRubyMethod(name={"!="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_not_equal(ThreadContext context, IRubyObject other) {
        return context.getRuntime().newBoolean(!RuntimeHelpers.invokedynamic(context, this, 1, other).isTrue());
    }

    @Override
    public int compareTo(IRubyObject other) {
        return (int)RuntimeHelpers.invokedynamic(this.getRuntime().getCurrentContext(), this, 4, other).convertToInteger().getLongValue();
    }

    @Override
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return this.op_equal_19(context, obj);
    }

    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal_19(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @Override
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"equal?"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject equal_p19(ThreadContext context, IRubyObject other) {
        return this.op_equal_19(context, other);
    }

    protected static boolean equalInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that == other || RuntimeHelpers.invokedynamic(context, that, 1, other).isTrue();
    }

    @Override
    public boolean eql(IRubyObject other) {
        return RuntimeHelpers.invokedynamic(this.getRuntime().getCurrentContext(), this, 2, other).isTrue();
    }

    @Override
    public void addFinalizer(IRubyObject f) {
        Finalizer finalizer = (Finalizer)this.fastGetInternalVariable("__finalizer__");
        if (finalizer == null) {
            long id2 = this.getObjectId();
            RubyFixnum fixnumId = (RubyFixnum)this.id();
            this.getRuntime().getObjectSpace().registerObjectId(id2, this);
            finalizer = new Finalizer(fixnumId);
            this.fastSetInternalVariable("__finalizer__", finalizer);
            this.getRuntime().addFinalizer(finalizer);
        }
        finalizer.addFinalizer(f);
    }

    @Override
    public void removeFinalizers() {
        Finalizer finalizer = (Finalizer)this.fastGetInternalVariable("__finalizer__");
        if (finalizer != null) {
            finalizer.removeFinalizers();
            this.removeInternalVariable("__finalizer__");
            this.getRuntime().removeFinalizer(finalizer);
        }
    }

    private Object[] getVariableTableForRead() {
        return this.varTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getVariableTableForWrite(int index2) {
        Object[] myVarTable = this.varTable;
        if (myVarTable == null) {
            RubyBasicObject rubyBasicObject = this;
            synchronized (rubyBasicObject) {
                myVarTable = this.varTable;
                if (myVarTable == null) {
                    myVarTable = new Object[this.getMetaClass().getRealClass().getVariableTableSizeWithObjectId()];
                    this.varTable = myVarTable;
                }
            }
        }
        if (myVarTable.length <= index2) {
            RubyBasicObject rubyBasicObject = this;
            synchronized (rubyBasicObject) {
                myVarTable = this.varTable;
                if (myVarTable.length <= index2) {
                    Object[] newTable = new Object[this.getMetaClass().getRealClass().getVariableTableSizeWithObjectId()];
                    System.arraycopy(myVarTable, 0, newTable, 0, myVarTable.length);
                    myVarTable = newTable;
                    this.varTable = newTable;
                }
            }
        }
        return myVarTable;
    }

    @Override
    public Object getVariable(int index2) {
        Object[] ivarTable;
        if (index2 < 0 || (ivarTable = this.getVariableTableForRead()) == null) {
            return null;
        }
        if (ivarTable.length > index2) {
            return ivarTable[index2];
        }
        return null;
    }

    @Override
    public void setVariable(int index2, Object value2) {
        this.ensureInstanceVariablesSettable();
        if (index2 < 0) {
            return;
        }
        Object[] ivarTable = this.getVariableTableForWrite(index2);
        ivarTable[index2] = value2;
    }

    private void setObjectId(int index2, long value2) {
        if (index2 < 0) {
            return;
        }
        Object[] ivarTable = this.getVariableTableForWrite(index2);
        ivarTable[index2] = value2;
    }

    @Override
    public boolean hasVariables() {
        return this.getMetaClass().getRealClass().getVariableTableSize() > 0 && this.varTable != null && this.varTable.length > 0;
    }

    @Override
    @Deprecated
    public int getVariableCount() {
        return this.varTable == null ? 0 : Math.min(this.varTable.length, this.getMetaClass().getRealClass().getVariableTableSize());
    }

    @Override
    public List<Variable<Object>> getVariableList() {
        Map<String, RubyClass.VariableAccessor> ivarAccessors = this.getMetaClass().getRealClass().getVariableAccessorsForRead();
        ArrayList<Variable<Object>> list2 = new ArrayList<Variable<Object>>();
        for (Map.Entry<String, RubyClass.VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null) continue;
            list2.add(new VariableEntry<Object>(entry.getKey(), value2));
        }
        return list2;
    }

    @Override
    public List<String> getVariableNameList() {
        Map<String, RubyClass.VariableAccessor> ivarAccessors = this.getMetaClass().getRealClass().getVariableAccessorsForRead();
        ArrayList<String> list2 = new ArrayList<String>();
        for (Map.Entry<String, RubyClass.VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null) continue;
            list2.add(entry.getKey());
        }
        return list2;
    }

    protected boolean variableTableContains(String name2) {
        return this.getMetaClass().getRealClass().getVariableAccessorForRead(name2).get(this) != null;
    }

    protected boolean variableTableFastContains(String internedName) {
        return this.variableTableContains(internedName);
    }

    protected Object variableTableFetch(String name2) {
        return this.getMetaClass().getRealClass().getVariableAccessorForRead(name2).get(this);
    }

    protected Object variableTableFastFetch(String internedName) {
        return this.variableTableFetch(internedName);
    }

    protected Object variableTableStore(String name2, Object value2) {
        this.getMetaClass().getRealClass().getVariableAccessorForWrite(name2).set(this, value2);
        return value2;
    }

    protected Object variableTableFastStore(String internedName, Object value2) {
        return this.variableTableStore(internedName, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object variableTableRemove(String name2) {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            Object value2 = this.getMetaClass().getRealClass().getVariableAccessorForRead(name2).get(this);
            this.getMetaClass().getRealClass().getVariableAccessorForWrite(name2).set(this, null);
            return value2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void variableTableSync(List<Variable<Object>> vars) {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            for (Variable<Object> var : vars) {
                this.variableTableStore(var.getName(), var.getValue());
            }
        }
    }

    @Override
    public InternalVariables getInternalVariables() {
        return this;
    }

    @Override
    public boolean hasInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public boolean fastHasInternalVariable(String internedName) {
        assert (!IdUtil.isRubyVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    @Override
    public Object getInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableFetch(name2);
    }

    @Override
    public Object fastGetInternalVariable(String internedName) {
        assert (!IdUtil.isRubyVariable(internedName));
        return this.variableTableFastFetch(internedName);
    }

    @Override
    public void setInternalVariable(String name2, Object value2) {
        assert (!IdUtil.isRubyVariable(name2));
        this.variableTableStore(name2, value2);
    }

    @Override
    public void fastSetInternalVariable(String internedName, Object value2) {
        assert (!IdUtil.isRubyVariable(internedName));
        this.variableTableFastStore(internedName, value2);
    }

    @Override
    public Object removeInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableRemove(name2);
    }

    @Override
    @Deprecated
    public void syncVariables(List<Variable<Object>> variables) {
        this.variableTableSync(variables);
    }

    @Override
    public void syncVariables(IRubyObject other) {
        RubyClass realClass = this.metaClass.getRealClass();
        RubyClass otherRealClass = other.getMetaClass().getRealClass();
        boolean sameTable = otherRealClass == realClass;
        for (Map.Entry<String, RubyClass.VariableAccessor> entry : otherRealClass.getVariableAccessorsForRead().entrySet()) {
            RubyClass.VariableAccessor accessor = entry.getValue();
            Object value2 = accessor.get(other);
            if (value2 == null) continue;
            if (sameTable) {
                accessor.set(this, value2);
                continue;
            }
            realClass.getVariableAccessorForWrite(accessor.getName()).set(this, value2);
        }
    }

    @Override
    public InstanceVariables getInstanceVariables() {
        return this;
    }

    @Override
    public boolean hasInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public boolean fastHasInstanceVariable(String internedName) {
        assert (IdUtil.isInstanceVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    @Override
    public IRubyObject getInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        return (IRubyObject)this.variableTableFetch(name2);
    }

    @Override
    public IRubyObject fastGetInstanceVariable(String internedName) {
        assert (IdUtil.isInstanceVariable(internedName));
        return (IRubyObject)this.variableTableFastFetch(internedName);
    }

    @Override
    public IRubyObject setInstanceVariable(String name2, IRubyObject value2) {
        assert (IdUtil.isInstanceVariable(name2) && value2 != null);
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableStore(name2, value2);
    }

    @Override
    public IRubyObject fastSetInstanceVariable(String internedName, IRubyObject value2) {
        assert (IdUtil.isInstanceVariable(internedName) && value2 != null);
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableFastStore(internedName, value2);
    }

    @Override
    public IRubyObject removeInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableRemove(name2);
    }

    @Override
    public List<Variable<IRubyObject>> getInstanceVariableList() {
        Map<String, RubyClass.VariableAccessor> ivarAccessors = this.getMetaClass().getVariableAccessorsForRead();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        for (Map.Entry<String, RubyClass.VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null || !(value2 instanceof IRubyObject) || !IdUtil.isInstanceVariable(entry.getKey())) continue;
            list2.add(new VariableEntry<IRubyObject>(entry.getKey(), (IRubyObject)value2));
        }
        return list2;
    }

    @Override
    public List<String> getInstanceVariableNameList() {
        Map<String, RubyClass.VariableAccessor> ivarAccessors = this.getMetaClass().getRealClass().getVariableAccessorsForRead();
        ArrayList<String> list2 = new ArrayList<String>();
        for (Map.Entry<String, RubyClass.VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null || !(value2 instanceof IRubyObject) || !IdUtil.isInstanceVariable(entry.getKey())) continue;
            list2.add(entry.getKey());
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyInstanceVariablesInto(InstanceVariables other) {
        for (Variable<IRubyObject> var : this.getInstanceVariableList()) {
            RubyBasicObject rubyBasicObject = this;
            synchronized (rubyBasicObject) {
                other.setInstanceVariable(var.getName(), var.getValue());
            }
        }
    }

    protected final void ensureInstanceVariablesSettable() {
        if (!this.isFrozen() && (this.getRuntime().getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_INST_VAR);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw this.getRuntime().newFrozenError("class/module ");
            }
            throw this.getRuntime().newFrozenError("");
        }
    }

    @Override
    public int getNativeTypeIndex() {
        return 38;
    }

    public boolean isBuiltin(String methodName) {
        DynamicMethod method2 = this.getMetaClass().searchMethodInner(methodName);
        return method2 != null && method2.isBuiltin();
    }

    @JRubyMethod(name={"singleton_method_added"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject singleton_method_added19(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_removed"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject singleton_method_removed19(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_undefined"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject singleton_method_undefined19(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_missing"}, rest=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject method_missing19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        if (args2.length == 0 || !(args2[0] instanceof RubySymbol)) {
            throw context.getRuntime().newArgumentError("no id given");
        }
        return RubyKernel.methodMissingDirect(context, recv2, (RubySymbol)args2[0], lastVis, lastCallType, args2, block);
    }

    @JRubyMethod(name={"__send__"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject send19(ThreadContext context, Block block) {
        throw context.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"__send__"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, block);
    }

    @JRubyMethod(name={"__send__"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, block);
    }

    @JRubyMethod(name={"__send__"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, arg2, block);
    }

    @JRubyMethod(name={"__send__"}, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject send19(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject[] newArgs;
        String name2 = args2[0].asJavaString();
        int newArgsLength = args2.length - 1;
        if (newArgsLength == 0) {
            newArgs = IRubyObject.NULL_ARRAY;
        } else {
            newArgs = new IRubyObject[newArgsLength];
            System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
        }
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, newArgs, block);
    }

    @JRubyMethod(name={"instance_eval"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject instance_eval19(ThreadContext context, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), block);
    }

    @JRubyMethod(name={"instance_eval"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject instance_eval19(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, block);
    }

    @JRubyMethod(name={"instance_eval"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject instance_eval19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, block);
    }

    @JRubyMethod(name={"instance_eval"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject instance_eval19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"instance_exec"}, optional=3, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject instance_exec19(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newLocalJumpErrorNoBlock();
        }
        RubyClass klazz = this.isImmediate() ? context.getRuntime().getDummy() : this.getSingletonClass();
        return this.yieldUnder(context, klazz, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject yieldUnder(ThreadContext context, RubyModule under, IRubyObject[] args2, Block block) {
        context.preExecuteUnder(under, block);
        Visibility savedVisibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            if (args2.length == 1) {
                IRubyObject valueInYield = args2[0];
                IRubyObject iRubyObject = this.setupBlock(block).yieldNonArray(context, valueInYield, this, context.getRubyClass());
                return iRubyObject;
            }
            RubyArray valueInYield = RubyArray.newArrayNoCopy(context.getRuntime(), args2);
            IRubyObject iRubyObject = block.yieldArray(context, valueInYield, this, context.getRubyClass());
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = (IRubyObject)bj.getValue();
            return iRubyObject;
        }
        finally {
            block.getBinding().setVisibility(savedVisibility);
            context.postExecuteUnder();
        }
    }

    private Block setupBlock(Block block) {
        block = block.cloneBlock();
        block.getBinding().setSelf(this);
        block.getBinding().getFrame().setSelf(this);
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject yieldUnder(ThreadContext context, RubyModule under, Block block) {
        context.preExecuteUnder(under, block);
        Visibility savedVisibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            IRubyObject iRubyObject = this.setupBlock(block).yieldNonArray(context, this, this, context.getRubyClass());
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = (IRubyObject)bj.getValue();
            return iRubyObject;
        }
        finally {
            block.getBinding().setVisibility(savedVisibility);
            context.postExecuteUnder();
        }
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, mod, block);
        }
        throw context.getRuntime().newArgumentError("block not supplied");
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            throw context.getRuntime().newArgumentError(1, 0);
        }
        RubyString evalStr = arg2 instanceof RubyString ? (RubyString)arg2 : arg2.convertToString();
        String file2 = "(eval)";
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (block.isGiven()) {
            throw context.getRuntime().newArgumentError(2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (RubyString)arg0 : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            throw context.getRuntime().newArgumentError(2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (RubyString)arg0 : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = (int)(arg2.convertToInteger().getLongValue() - 1L);
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    protected RubyModule getInstanceEvalClass() {
        if (this.isImmediate()) {
            return this.getRuntime().getDummy();
        }
        return this.getSingletonClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject evalUnder(ThreadContext context, RubyModule under, RubyString src, String file2, int line) {
        Visibility savedVisibility = context.getCurrentVisibility();
        context.setCurrentVisibility(Visibility.PUBLIC);
        context.preExecuteUnder(under, Block.NULL_BLOCK);
        try {
            IRubyObject iRubyObject = ASTInterpreter.evalSimple(context, this, src, file2, line);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
            context.setCurrentVisibility(savedVisibility);
        }
    }

    public IRubyObject equal_p(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    public IRubyObject eql_p(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (this == other || RuntimeHelpers.invokedynamic(context, this, 1, other).isTrue()) {
            return RubyFixnum.zero(runtime2);
        }
        return runtime2.getNil();
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != original.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("initialize_copy should take same class object");
        }
        return this;
    }

    protected void checkFrozen() {
        this.testFrozen();
    }

    public RubyBoolean respond_to_p(IRubyObject mname) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, true));
    }

    public IRubyObject respond_to_p19(IRubyObject mname) {
        String name2 = mname.asJavaString();
        IRubyObject respond = this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, true, true));
        if (!respond.isTrue()) {
            respond = RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "respond_to_missing?", mname, (IRubyObject)this.getRuntime().getFalse());
            respond = this.getRuntime().newBoolean(respond.isTrue());
        }
        return respond;
    }

    public RubyBoolean respond_to_p(IRubyObject mname, IRubyObject includePrivate) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, !includePrivate.isTrue()));
    }

    public IRubyObject respond_to_p19(IRubyObject mname, IRubyObject includePrivate) {
        String name2 = mname.asJavaString();
        IRubyObject respond = this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, !includePrivate.isTrue()));
        if (!respond.isTrue()) {
            respond = RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "respond_to_missing?", mname, includePrivate);
            respond = this.getRuntime().newBoolean(respond.isTrue());
        }
        return respond;
    }

    public IRubyObject id_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#id will be deprecated; use Object#object_id");
        return this.id();
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(super.hashCode());
    }

    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    public RubyClass type_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#type is deprecated; use Object#class");
        return this.type();
    }

    public IRubyObject display(ThreadContext context, IRubyObject[] args2) {
        IRubyObject port = args2.length == 0 ? context.getRuntime().getGlobalVariables().get("$>") : args2[0];
        port.callMethod(context, "write", this);
        return context.getRuntime().getNil();
    }

    public RubyBoolean tainted_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isTaint());
    }

    public IRubyObject taint(ThreadContext context) {
        this.taint(context.getRuntime());
        return this;
    }

    public IRubyObject untaint(ThreadContext context) {
        context.getRuntime().secure(3);
        if (this.isTaint()) {
            this.testFrozen();
            this.setTaint(false);
        }
        return this;
    }

    public IRubyObject freeze(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if ((this.flags & 4) == 0 && (runtime2.is1_9() || !this.isImmediate())) {
            if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
                throw runtime2.newSecurityError("Insecure: can't freeze object");
            }
            this.flags |= 4;
        }
        return this;
    }

    public RubyBoolean frozen_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isFrozen());
    }

    public RubyBoolean untrusted_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isUntrusted());
    }

    public IRubyObject untrust(ThreadContext context) {
        if (!this.isUntrusted() && !this.isImmediate()) {
            this.checkFrozen();
            this.flags |= 0x10;
        }
        return this;
    }

    public IRubyObject trust(ThreadContext context) {
        if (this.isUntrusted() && !this.isImmediate()) {
            this.checkFrozen();
            this.flags &= 0xFFFFFFEF;
        }
        return this;
    }

    public RubyBoolean instance_of_p(ThreadContext context, IRubyObject type2) {
        if (this.type() == type2) {
            return context.getRuntime().getTrue();
        }
        if (!(type2 instanceof RubyModule)) {
            throw context.getRuntime().newTypeError("class or module required");
        }
        return context.getRuntime().getFalse();
    }

    public RubyBoolean kind_of_p(ThreadContext context, IRubyObject type2) {
        if (!(type2 instanceof RubyModule)) {
            throw context.getRuntime().newTypeError("class or module required");
        }
        return context.getRuntime().newBoolean(((RubyModule)type2).isInstance(this));
    }

    public IRubyObject methods(ThreadContext context, IRubyObject[] args2) {
        return this.methods(context, args2, false);
    }

    public IRubyObject methods19(ThreadContext context, IRubyObject[] args2) {
        return this.methods(context, args2, true);
    }

    public IRubyObject methods(ThreadContext context, IRubyObject[] args2, boolean useSymbols) {
        boolean all = args2.length == 1 ? args2[0].isTrue() : true;
        Ruby runtime2 = this.getRuntime();
        RubyArray methods2 = runtime2.newArray();
        HashSet<String> seen = new HashSet<String>();
        if (this.getMetaClass().isSingleton()) {
            this.getMetaClass().populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, true, useSymbols, false);
            if (all) {
                this.getMetaClass().getSuperClass().populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, true, useSymbols, true);
            }
        } else if (all) {
            this.getMetaClass().populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, true, useSymbols, true);
        }
        return methods2;
    }

    public IRubyObject public_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().public_instance_methods(this.trueIfNoArgument(context, args2));
    }

    public IRubyObject public_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().public_instance_methods19(this.trueIfNoArgument(context, args2));
    }

    public IRubyObject protected_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().protected_instance_methods(this.trueIfNoArgument(context, args2));
    }

    public IRubyObject protected_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().protected_instance_methods19(this.trueIfNoArgument(context, args2));
    }

    public IRubyObject private_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().private_instance_methods(this.trueIfNoArgument(context, args2));
    }

    public IRubyObject private_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().private_instance_methods19(this.trueIfNoArgument(context, args2));
    }

    private IRubyObject[] trueIfNoArgument(ThreadContext context, IRubyObject[] args2) {
        IRubyObject[] iRubyObjectArray;
        if (args2.length == 0) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = context.getRuntime().getTrue();
        } else {
            iRubyObjectArray = args2;
        }
        return iRubyObjectArray;
    }

    public RubyArray singleton_methods(ThreadContext context, IRubyObject[] args2) {
        return this.singletonMethods(context, args2, methodsCollector);
    }

    public RubyArray singleton_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.singletonMethods(context, args2, methodsCollector19);
    }

    private RubyArray singletonMethods(ThreadContext context, IRubyObject[] args2, MethodsCollector collect2) {
        RubyArray singletonMethods;
        boolean all = true;
        if (args2.length == 1) {
            all = args2[0].isTrue();
        }
        if (this.getMetaClass().isSingleton()) {
            IRubyObject[] methodsArgs = new IRubyObject[]{context.getRuntime().getFalse()};
            singletonMethods = collect2.instanceMethods(this.getMetaClass(), methodsArgs);
            if (all) {
                RubyClass superClass = this.getMetaClass().getSuperClass();
                while (superClass.isSingleton() || superClass.isIncluded()) {
                    singletonMethods.concat(collect2.instanceMethods(superClass, methodsArgs));
                    superClass = superClass.getSuperClass();
                }
            }
        } else {
            singletonMethods = context.getRuntime().newEmptyArray();
        }
        return singletonMethods;
    }

    public IRubyObject method(IRubyObject symbol) {
        return this.getMetaClass().newMethod(this, symbol.asJavaString(), true, null);
    }

    public IRubyObject method19(IRubyObject symbol) {
        return this.getMetaClass().newMethod(this, symbol.asJavaString(), true, null, true);
    }

    public IRubyObject to_s() {
        return this.anyToString();
    }

    public RubyArray to_a() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "default 'to_a' will be obsolete");
        return this.getRuntime().newArray((IRubyObject)this);
    }

    public IRubyObject instance_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), block);
    }

    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, block);
    }

    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, block);
    }

    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, arg2, block);
    }

    public IRubyObject instance_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newArgumentError("block not supplied");
        }
        RubyClass klazz = this.isImmediate() ? context.getRuntime().getDummy() : this.getSingletonClass();
        return this.yieldUnder(context, klazz, args2, block);
    }

    public IRubyObject extend(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (args2[i2].isModule()) continue;
            throw runtime2.newTypeError(args2[i2], runtime2.getModule());
        }
        ThreadContext context = runtime2.getCurrentContext();
        for (int i3 = args2.length - 1; i3 >= 0; --i3) {
            args2[i3].callMethod(context, "extend_object", this);
            args2[i3].callMethod(context, "extended", this);
        }
        return this;
    }

    public IRubyObject send(ThreadContext context, Block block) {
        throw context.getRuntime().newArgumentError(0, 1);
    }

    public IRubyObject send(ThreadContext context, IRubyObject arg0, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, block);
    }

    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, block);
    }

    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, arg2, block);
    }

    public IRubyObject send(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject[] newArgs;
        String name2 = args2[0].asJavaString();
        int newArgsLength = args2.length - 1;
        if (newArgsLength == 0) {
            newArgs = IRubyObject.NULL_ARRAY;
        } else {
            newArgs = new IRubyObject[newArgsLength];
            System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
        }
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, newArgs, block);
    }

    public IRubyObject nil_p(ThreadContext context) {
        return context.getRuntime().getFalse();
    }

    public IRubyObject op_match(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().getFalse();
    }

    public IRubyObject op_match19(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().getNil();
    }

    public IRubyObject op_not_match(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().newBoolean(!this.callMethod(context, "=~", arg2).isTrue());
    }

    public IRubyObject instance_variable_defined_p(ThreadContext context, IRubyObject name2) {
        if (this.variableTableContains(this.validateInstanceVariable(name2.asJavaString()))) {
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    public IRubyObject instance_variable_get(ThreadContext context, IRubyObject name2) {
        Object value2 = this.variableTableFetch(this.validateInstanceVariable(name2.asJavaString()));
        if (value2 != null) {
            return (IRubyObject)value2;
        }
        return context.getRuntime().getNil();
    }

    public IRubyObject instance_variable_set(IRubyObject name2, IRubyObject value2) {
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableStore(this.validateInstanceVariable(name2.asJavaString()), value2);
    }

    public IRubyObject remove_instance_variable(ThreadContext context, IRubyObject name2, Block block) {
        this.ensureInstanceVariablesSettable();
        IRubyObject value2 = (IRubyObject)this.variableTableRemove(this.validateInstanceVariable(name2.asJavaString()));
        if (value2 != null) {
            return value2;
        }
        throw context.getRuntime().newNameError("instance variable " + name2.asJavaString() + " not defined", name2.asJavaString());
    }

    public RubyArray instance_variables(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        List<String> nameList = this.getInstanceVariableNameList();
        RubyArray array = runtime2.newArray(nameList.size());
        for (String name2 : nameList) {
            array.append(runtime2.newString(name2));
        }
        return array;
    }

    public RubyArray instance_variables19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        List<String> nameList = this.getInstanceVariableNameList();
        RubyArray array = runtime2.newArray(nameList.size());
        for (String name2 : nameList) {
            array.append(runtime2.newSymbol(name2));
        }
        return array;
    }

    protected String validateInstanceVariable(String name2) {
        if (IdUtil.isValidInstanceVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`" + name2 + "' is not allowable as an instance variable name", name2);
    }

    private static abstract class MethodsCollector {
        private MethodsCollector() {
        }

        public abstract RubyArray instanceMethods(RubyClass var1, IRubyObject[] var2);
    }

    public static class Finalizer
    implements Finalizable {
        private RubyFixnum id;
        private IRubyObject firstFinalizer;
        private List<IRubyObject> finalizers;
        private AtomicBoolean finalized;

        public Finalizer(RubyFixnum id2) {
            this.id = id2;
            this.finalized = new AtomicBoolean(false);
        }

        public void addFinalizer(IRubyObject finalizer) {
            if (this.firstFinalizer == null) {
                this.firstFinalizer = finalizer;
            } else {
                if (this.finalizers == null) {
                    this.finalizers = new ArrayList<IRubyObject>(4);
                }
                this.finalizers.add(finalizer);
            }
        }

        public void removeFinalizers() {
            this.firstFinalizer = null;
            this.finalizers = null;
        }

        public void finalize() {
            if (this.finalized.compareAndSet(false, true)) {
                if (this.firstFinalizer != null) {
                    this.callFinalizer(this.firstFinalizer);
                }
                if (this.finalizers != null) {
                    for (int i2 = 0; i2 < this.finalizers.size(); ++i2) {
                        this.callFinalizer(this.finalizers.get(i2));
                    }
                }
            }
        }

        private void callFinalizer(IRubyObject finalizer) {
            RuntimeHelpers.invoke(finalizer.getRuntime().getCurrentContext(), finalizer, "call", (IRubyObject)this.id);
        }
    }
}

