/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.Interp;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.operands.Attribute;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Instr {
    public final Operation operation;
    public final Variable result;
    private Attribute[] attributes;
    private boolean isDead;

    public Instr(Operation operation) {
        this.operation = operation;
        this.result = null;
    }

    public Instr(Operation operation, Variable result) {
        this.operation = operation;
        this.result = result;
    }

    public String toString() {
        return "\t" + (this.isDead() ? "[DEAD]" : "") + (this.result == null ? "" : this.result + " = ") + (Object)((Object)this.operation);
    }

    @Interp
    public Variable getResult() {
        return this.result;
    }

    @Interp
    public Operation getOperation() {
        return this.operation;
    }

    public boolean hasSideEffects() {
        return this.operation.hasSideEffects();
    }

    public boolean canRaiseException() {
        return this.operation.canRaiseException();
    }

    public void markDead() {
        this.isDead = true;
    }

    @Interp
    public boolean isDead() {
        return this.isDead;
    }

    @Interp
    public abstract Operand[] getOperands();

    public List<Variable> getUsedVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Operand o : this.getOperands()) {
            o.addUsedVariables(vars);
        }
        return vars;
    }

    public abstract Instr cloneForInlining(InlinerInfo var1);

    public abstract void simplifyOperands(Map<Operand, Operand> var1);

    public Operand simplifyAndGetResult(Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap);
        return null;
    }

    @Interp
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should not be directly interpreted");
    }
}

