/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lib.uno.helper.PropertySetMixin;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.report.meta.XFunctionCategory;
import com.sun.star.report.meta.XFunctionDescription;
import com.sun.star.sheet.FunctionArgument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.util.Locale;
import java.util.MissingResourceException;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;

public final class StarFunctionDescription
extends WeakBase
implements XFunctionDescription {
    private final XComponentContext m_xContext;
    private final PropertySetMixin m_prophlp;
    private final FunctionDescription functionDescription;
    private final XFunctionCategory category;
    private final Locale defaultLocale;

    public StarFunctionDescription(DefaultFormulaContext defaultFormulaContext, XComponentContext xComponentContext, XFunctionCategory xFunctionCategory, FunctionDescription functionDescription) {
        Locale locale;
        this.m_xContext = xComponentContext;
        this.category = xFunctionCategory;
        try {
            functionDescription.getDisplayName(defaultFormulaContext.getLocalizationContext().getLocale());
            locale = defaultFormulaContext.getLocalizationContext().getLocale();
        }
        catch (MissingResourceException missingResourceException) {
            locale = Locale.ENGLISH;
        }
        this.defaultLocale = locale;
        this.functionDescription = functionDescription;
        this.m_prophlp = new PropertySetMixin(this.m_xContext, (XInterface)this, new Type(XFunctionDescription.class), null);
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this.m_prophlp.getPropertySetInfo();
    }

    public void setPropertyValue(String string, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.m_prophlp.setPropertyValue(string, object);
    }

    public Object getPropertyValue(String string) throws UnknownPropertyException, WrappedTargetException {
        return this.m_prophlp.getPropertyValue(string);
    }

    public void addPropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.addPropertyChangeListener(string, xPropertyChangeListener);
    }

    public void removePropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.removePropertyChangeListener(string, xPropertyChangeListener);
    }

    public void addVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.addVetoableChangeListener(string, xVetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.removeVetoableChangeListener(string, xVetoableChangeListener);
    }

    public XFunctionCategory getCategory() {
        return this.category;
    }

    public String getName() {
        return this.functionDescription.getDisplayName(this.defaultLocale);
    }

    public String getDescription() {
        return this.functionDescription.getDescription(this.defaultLocale);
    }

    public String getSignature() {
        int n = this.functionDescription.getParameterCount();
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append('(');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.functionDescription.getParameterDisplayName(i, this.defaultLocale));
            if (i == n - 1) continue;
            stringBuffer.append(';');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public FunctionArgument[] getArguments() {
        int n = this.functionDescription.getParameterCount();
        boolean bl = this.functionDescription.isInfiniteParameterCount();
        if (bl) {
            n = 30;
        }
        FunctionArgument[] functionArgumentArray = new FunctionArgument[n];
        for (int i = 0; i < functionArgumentArray.length; ++i) {
            int n2 = bl ? 0 : i;
            functionArgumentArray[i] = new FunctionArgument();
            functionArgumentArray[i].Description = this.functionDescription.getParameterDescription(n2, this.defaultLocale);
            functionArgumentArray[i].Name = this.functionDescription.getParameterDisplayName(n2, this.defaultLocale);
            functionArgumentArray[i].IsOptional = !this.functionDescription.isParameterMandatory(n2);
        }
        return functionArgumentArray;
    }

    public String createFormula(String[] stringArray) throws DisposedException, IllegalArgumentException, Exception {
        boolean bl = this.functionDescription.isInfiniteParameterCount();
        int n = this.functionDescription.getParameterCount();
        if (!bl && stringArray.length > n) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append('(');
        for (int i = 0; i < stringArray.length && stringArray[i].length() != 0; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1 || stringArray[i + 1].length() == 0) continue;
            stringBuffer.append(';');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

