/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerListModel;
import msfgui.MsfException;
import msfgui.MsfguiApp;
import msfgui.OptionsDialog;
import msfgui.RpcConnection;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class DbConnectDialog
extends OptionsDialog {
    private RpcConnection rpcConn;
    private Frame myParent;
    private boolean success;
    private Map props;
    private JButton cancelButton;
    private JButton connectButton;
    private JTextField dbNameField;
    private JTextField hostField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JTextField passwordField;
    private JTextField portField;
    private JSpinner typeSpinner;
    private JTextField usernameField;

    public static boolean connect(Frame parent, RpcConnection rpcConn) {
        DbConnectDialog cd = new DbConnectDialog(parent, rpcConn, true);
        cd.setVisible(true);
        return cd.success;
    }

    public DbConnectDialog(Frame parent, RpcConnection rpcConn, boolean modal) {
        super(parent, "Database Connection Options", modal);
        this.initComponents();
        this.rpcConn = rpcConn;
        this.myParent = parent;
        this.success = false;
        this.props = MsfguiApp.getPropertiesNode();
        try {
            this.hostField.setText(this.props.get("dbhost").toString());
            this.portField.setText(this.props.get("dbport").toString());
            this.usernameField.setText(this.props.get("dbusername").toString());
            this.passwordField.setText(this.props.get("dbpassword").toString());
            this.dbNameField.setText(this.props.get("dbdatabase").toString());
        }
        catch (NullPointerException nex) {
            // empty catch block
        }
        Object driver = this.props.get("dbdriver");
        List<?> l = ((SpinnerListModel)this.typeSpinner.getModel()).getList();
        for (Object o : l) {
            if (!o.equals(driver)) continue;
            this.typeSpinner.setValue(driver);
        }
    }

    private void initComponents() {
        this.typeSpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.usernameField = new JTextField();
        this.passwordField = new JTextField();
        this.jLabel4 = new JLabel();
        this.dbNameField = new JTextField();
        this.connectButton = new JButton();
        this.cancelButton = new JButton();
        this.hostField = new JTextField();
        this.portField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.typeSpinner.setModel(new SpinnerListModel(new String[]{"postgresql", "mysql", "sqlite3"}));
        this.typeSpinner.setName("typeSpinner");
        ResourceMap resourceMap = Application.getInstance(MsfguiApp.class).getContext().getResourceMap(DbConnectDialog.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.usernameField.setText(resourceMap.getString("usernameField.text", new Object[0]));
        this.usernameField.setName("usernameField");
        this.passwordField.setText(resourceMap.getString("passwordField.text", new Object[0]));
        this.passwordField.setName("passwordField");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.dbNameField.setText(resourceMap.getString("dbNameField.text", new Object[0]));
        this.dbNameField.setName("dbNameField");
        this.connectButton.setText(resourceMap.getString("connectButton.text", new Object[0]));
        this.connectButton.setName("connectButton");
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbConnectDialog.this.connectButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(resourceMap.getString("cancelButton.text", new Object[0]));
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbConnectDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.hostField.setText(resourceMap.getString("hostField.text", new Object[0]));
        this.hostField.setName("hostField");
        this.portField.setText(resourceMap.getString("portField.text", new Object[0]));
        this.portField.setName("portField");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectButton)).addComponent(this.jLabel7).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usernameField, -1, 327, Short.MAX_VALUE).addComponent(this.typeSpinner, -1, 327, Short.MAX_VALUE).addComponent(this.passwordField, -1, 327, Short.MAX_VALUE).addComponent(this.dbNameField, -1, 327, Short.MAX_VALUE).addComponent(this.hostField, -1, 327, Short.MAX_VALUE).addComponent(this.portField, -1, 327, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeSpinner, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usernameField, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordField, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbNameField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostField, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portField, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connectButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void addNonempty(String key, JTextField text, HashMap opts) {
        String val = text.getText();
        if (val.length() > 0) {
            opts.put(key, val);
        }
        this.props.put("db" + key, val);
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        HashMap<String, String> opts = new HashMap<String, String>();
        this.addNonempty("host", this.hostField, opts);
        this.addNonempty("port", this.portField, opts);
        this.addNonempty("username", this.usernameField, opts);
        this.addNonempty("password", this.passwordField, opts);
        this.addNonempty("database", this.dbNameField, opts);
        opts.put("driver", this.typeSpinner.getValue().toString());
        this.props.put("dbdriver", this.typeSpinner.getValue().toString());
        try {
            Map res = (Map)this.rpcConn.execute("db.connect", opts);
            this.success = "success".equals(res.get("result"));
            if (!this.success) {
                JOptionPane.showMessageDialog(this.myParent, res);
            }
        }
        catch (MsfException mex) {
            JOptionPane.showMessageDialog(this.myParent, mex);
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

