/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ******************************************************************************
 *
 * Copyright (C) 1996-2005 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer
 *    unmodified other than the allowable addition of one or more
 *    copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 *
 * Version: Onyx 5.1.2
 *
 ******************************************************************************/

/* Opaque type. */
typedef struct cw_thd_s cw_thd_t;

/* Determine what mechanism to use for thread suspend/resume.  The generic
 * version relies on signals, which tends to be much slower than native
 * implementations of suspend/resume, so only use it as a last resort. */
#define CW_THD_GENERIC_SR

/* FreeBSD-specific extensions (pthread_{suspend,resume}_np()). */
#ifdef CW_FTHREADS
#undef CW_THD_GENERIC_SR
#endif

/* Mach threads. */
#ifdef CW_MTHREADS
#undef CW_THD_GENERIC_SR
#endif

/* Solaris threads. */
#ifdef CW_STHREADS
#undef CW_THD_GENERIC_SR
#endif

/* GNU pth. */
#ifdef CW_PTH
#undef CW_THD_GENERIC_SR
#endif

#ifdef CW_THD_GENERIC_SR
/* The generic suspend/resume mechanism uses signals (using pthread_kill()).
 * This is rather expensive, depending on the OS, but it does not violate
 * portability.  The only issue with this mechanism is that it requires two
 * signals that cannot otherwise be used by the thread being suspended/resumed.
 * On most OSs, SIGUSR1 and SIGUSR2 are the logical choices. */
#define CW_THD_SIGSUSPEND SIGUSR1
#define CW_THD_SIGRESUME SIGUSR2
#endif

/* Minimum thread stack size. */
#define CW_THD_MINSTACK 524288

cw_thd_t *
thd_new(void *(*a_start_func)(void *), void *a_arg, bool a_suspensible);

void
thd_delete(cw_thd_t *a_thd);

void *
thd_join(cw_thd_t *a_thd);

cw_thd_t *
thd_self(void);

#ifdef CW_PTH
#define thd_yield() pth_yield(NULL)
#else
#define thd_yield() sched_yield()
#endif

void
thd_sigmask(int a_how, const sigset_t *a_set, sigset_t *r_oset);

void
thd_crit_enter(void);

void
thd_crit_leave(void);

void
thd_single_enter(void);

void
thd_single_leave(void);

void
thd_suspend(cw_thd_t *a_thd);

bool
thd_trysuspend(cw_thd_t *a_thd);

void
thd_resume(cw_thd_t *a_thd);
